/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import co.aikar.util.Counter;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftShapelessRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ShapelessRecipes
implements RecipeCrafting {
    private final MinecraftKey a;
    final String b;
    final ItemStack c;
    final NonNullList<RecipeItemStack> d;

    public ShapelessRecipes(MinecraftKey id, String group, ItemStack output, NonNullList<RecipeItemStack> input) {
        this.a = id;
        this.b = group;
        this.c = output;
        this.d = input;
    }

    public ShapelessRecipe toBukkitRecipe() {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.c);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe(result, this);
        recipe.setGroup(this.b);
        for (RecipeItemStack list : this.d) {
            recipe.addIngredient(CraftRecipe.toBukkit(list));
        }
        return recipe;
    }

    @Override
    public MinecraftKey f() {
        return this.a;
    }

    @Override
    public RecipeSerializer<?> T_() {
        return RecipeSerializer.b;
    }

    @Override
    public String d() {
        return this.b;
    }

    @Override
    public ItemStack c() {
        return this.c;
    }

    @Override
    public NonNullList<RecipeItemStack> a() {
        return this.d;
    }

    @Override
    public boolean a(InventoryCrafting inventory, World world) {
        AutoRecipeStackManager autorecipestackmanager = new AutoRecipeStackManager();
        boolean i2 = false;
        ArrayList<ItemStack> providedItems = new ArrayList<ItemStack>();
        Counter matchedProvided = new Counter();
        Counter matchedIngredients = new Counter();
        for (int j2 = 0; j2 < inventory.b(); ++j2) {
            ItemStack itemstack = inventory.a(j2);
            if (itemstack.b()) continue;
            itemstack = itemstack.n();
            providedItems.add(itemstack);
            for (RecipeItemStack ingredient : this.d) {
                if (!ingredient.a(itemstack)) continue;
                matchedProvided.increment((Object)itemstack);
                matchedIngredients.increment((Object)ingredient);
            }
        }
        if (matchedProvided.isEmpty() || matchedIngredients.isEmpty()) {
            return false;
        }
        ArrayList<RecipeItemStack> ingredients = new ArrayList<RecipeItemStack>(this.d);
        providedItems.sort(Comparator.comparingInt(c2 -> (int)matchedProvided.getCount(c2)).reversed());
        ingredients.sort(Comparator.comparingInt(c2 -> (int)matchedIngredients.getCount(c2)));
        block2: for (ItemStack provided : providedItems) {
            Iterator itIngredient = ingredients.iterator();
            while (itIngredient.hasNext()) {
                RecipeItemStack ingredient = (RecipeItemStack)itIngredient.next();
                if (!ingredient.a(provided)) continue;
                itIngredient.remove();
                continue block2;
            }
            return false;
        }
        return ingredients.isEmpty();
    }

    @Override
    public ItemStack a(InventoryCrafting inventory) {
        return this.c.n();
    }

    @Override
    public boolean a(int width, int height) {
        return width * height >= this.d.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        public ShapelessRecipes b(MinecraftKey id, JsonObject json) {
            String s2 = ChatDeserializer.a(json, "group", "");
            NonNullList<RecipeItemStack> nonnulllist = net.minecraft.world.item.crafting.ShapelessRecipes$a.a(ChatDeserializer.u(json, "ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipes.a(ChatDeserializer.t(json, "result"));
            return new ShapelessRecipes(id, s2, itemstack, nonnulllist);
        }

        private static NonNullList<RecipeItemStack> a(JsonArray json) {
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a();
            for (int i2 = 0; i2 < json.size(); ++i2) {
                RecipeItemStack recipeitemstack = RecipeItemStack.a(json.get(i2));
                if (recipeitemstack.d()) continue;
                nonnulllist.add(recipeitemstack);
            }
            return nonnulllist;
        }

        public ShapelessRecipes b(MinecraftKey id, PacketDataSerializer buf) {
            String s2 = buf.p();
            int i2 = buf.j();
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2, RecipeItemStack.a);
            for (int j2 = 0; j2 < nonnulllist.size(); ++j2) {
                nonnulllist.set(j2, RecipeItemStack.b(buf));
            }
            ItemStack itemstack = buf.o();
            return new ShapelessRecipes(id, s2, itemstack, nonnulllist);
        }

        @Override
        public void a(PacketDataSerializer buf, ShapelessRecipes recipe) {
            buf.a(recipe.b);
            buf.d(recipe.d.size());
            for (RecipeItemStack recipeitemstack : recipe.d) {
                recipeitemstack.a(buf);
            }
            buf.a(recipe.c);
        }
    }
}

