/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ShapedRecipes
implements RecipeCrafting {
    final int a;
    final int b;
    final NonNullList<RecipeItemStack> c;
    final ItemStack d;
    private final MinecraftKey e;
    final String f;

    public ShapedRecipes(MinecraftKey id, String group, int width, int height, NonNullList<RecipeItemStack> input, ItemStack output) {
        this.e = id;
        this.f = group;
        this.a = width;
        this.b = height;
        this.c = input;
        this.d = output;
    }

    public ShapedRecipe toBukkitRecipe() {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.d);
        CraftShapedRecipe recipe = new CraftShapedRecipe(result, this);
        recipe.setGroup(this.f);
        block0 : switch (this.b) {
            case 1: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.a) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c2 = 'a';
        for (RecipeItemStack list : this.c) {
            RecipeChoice choice = CraftRecipe.toBukkit(list);
            if (choice != null) {
                recipe.setIngredient(c2, choice);
            }
            c2 = (char)(c2 + 1);
        }
        return recipe;
    }

    @Override
    public MinecraftKey f() {
        return this.e;
    }

    @Override
    public RecipeSerializer<?> T_() {
        return RecipeSerializer.a;
    }

    @Override
    public String d() {
        return this.f;
    }

    @Override
    public ItemStack c() {
        return this.d;
    }

    @Override
    public NonNullList<RecipeItemStack> a() {
        return this.c;
    }

    @Override
    public boolean a(int width, int height) {
        return width >= this.a && height >= this.b;
    }

    @Override
    public boolean a(InventoryCrafting inventory, World world) {
        for (int i2 = 0; i2 <= inventory.g() - this.a; ++i2) {
            for (int j2 = 0; j2 <= inventory.f() - this.b; ++j2) {
                if (this.a(inventory, i2, j2, true)) {
                    return true;
                }
                if (!this.a(inventory, i2, j2, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(InventoryCrafting inv, int offsetX, int offsetY, boolean flipped) {
        for (int k2 = 0; k2 < inv.g(); ++k2) {
            for (int l2 = 0; l2 < inv.f(); ++l2) {
                int i1 = k2 - offsetX;
                int j1 = l2 - offsetY;
                RecipeItemStack recipeitemstack = RecipeItemStack.a;
                if (i1 >= 0 && j1 >= 0 && i1 < this.a && j1 < this.b) {
                    recipeitemstack = flipped ? this.c.get(this.a - i1 - 1 + j1 * this.a) : this.c.get(i1 + j1 * this.a);
                }
                if (recipeitemstack.a(inv.a(k2 + l2 * inv.g()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack a(InventoryCrafting inventory) {
        return this.c().n();
    }

    public int j() {
        return this.a;
    }

    public int k() {
        return this.b;
    }

    static NonNullList<RecipeItemStack> a(String[] pattern, Map<String, RecipeItemStack> symbols, int width, int height) {
        NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(width * height, RecipeItemStack.a);
        HashSet set = Sets.newHashSet(symbols.keySet());
        set.remove(" ");
        for (int k2 = 0; k2 < pattern.length; ++k2) {
            for (int l2 = 0; l2 < pattern[k2].length(); ++l2) {
                String s2 = pattern[k2].substring(l2, l2 + 1);
                RecipeItemStack recipeitemstack = symbols.get(s2);
                if (recipeitemstack == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s2 + "' but it's not defined in the key");
                }
                set.remove(s2);
                nonnulllist.set(l2 + width * k2, recipeitemstack);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] a(String ... pattern) {
        int i2 = Integer.MAX_VALUE;
        int j2 = 0;
        int k2 = 0;
        int l2 = 0;
        for (int i1 = 0; i1 < pattern.length; ++i1) {
            String s2 = pattern[i1];
            i2 = Math.min(i2, ShapedRecipes.a(s2));
            int j1 = ShapedRecipes.b(s2);
            j2 = Math.max(j2, j1);
            if (j1 < 0) {
                if (k2 == i1) {
                    ++k2;
                }
                ++l2;
                continue;
            }
            l2 = 0;
        }
        if (pattern.length == l2) {
            return new String[0];
        }
        String[] astring1 = new String[pattern.length - l2 - k2];
        for (int k1 = 0; k1 < astring1.length; ++k1) {
            astring1[k1] = pattern[k1 + k2].substring(i2, j2 + 1);
        }
        return astring1;
    }

    @Override
    public boolean i() {
        NonNullList<RecipeItemStack> nonnulllist = this.a();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(recipeitemstack -> !recipeitemstack.d()).anyMatch(recipeitemstack -> recipeitemstack.a().length == 0);
    }

    private static int a(String line) {
        int i2;
        for (i2 = 0; i2 < line.length() && line.charAt(i2) == ' '; ++i2) {
        }
        return i2;
    }

    private static int b(String pattern) {
        int i2;
        for (i2 = pattern.length() - 1; i2 >= 0 && pattern.charAt(i2) == ' '; --i2) {
        }
        return i2;
    }

    static String[] a(JsonArray json) {
        String[] astring = new String[json.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s2 = ChatDeserializer.a(json.get(i2), "pattern[" + i2 + "]");
            if (s2.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i2 > 0 && astring[0].length() != s2.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i2] = s2;
        }
        return astring;
    }

    static Map<String, RecipeItemStack> c(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), RecipeItemStack.a((JsonElement)entry.getValue()));
        }
        map.put(" ", RecipeItemStack.a);
        return map;
    }

    public static ItemStack a(JsonObject json) {
        Item item = ShapedRecipes.b(json);
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i2 = ChatDeserializer.a(json, "count", 1);
        if (i2 < 1) {
            throw new JsonSyntaxException("Invalid output count: " + i2);
        }
        return new ItemStack(item, i2);
    }

    public static Item b(JsonObject json) {
        String s2 = ChatDeserializer.h(json, "item");
        Item item = IRegistry.X.b(new MinecraftKey(s2)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s2 + "'"));
        if (item == Items.a) {
            throw new JsonSyntaxException("Invalid item: " + s2);
        }
        return item;
    }

    public static class a
    implements RecipeSerializer<ShapedRecipes> {
        public ShapedRecipes b(MinecraftKey id, JsonObject json) {
            String s2 = ChatDeserializer.a(json, "group", "");
            Map<String, RecipeItemStack> map = ShapedRecipes.c(ChatDeserializer.t(json, "key"));
            String[] astring = ShapedRecipes.a(ShapedRecipes.a(ChatDeserializer.u(json, "pattern")));
            int i2 = astring[0].length();
            int j2 = astring.length;
            NonNullList<RecipeItemStack> nonnulllist = ShapedRecipes.a(astring, map, i2, j2);
            ItemStack itemstack = ShapedRecipes.a(ChatDeserializer.t(json, "result"));
            return new ShapedRecipes(id, s2, i2, j2, nonnulllist, itemstack);
        }

        public ShapedRecipes b(MinecraftKey id, PacketDataSerializer buf) {
            int i2 = buf.j();
            int j2 = buf.j();
            String s2 = buf.p();
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2 * j2, RecipeItemStack.a);
            for (int k2 = 0; k2 < nonnulllist.size(); ++k2) {
                nonnulllist.set(k2, RecipeItemStack.b(buf));
            }
            ItemStack itemstack = buf.o();
            return new ShapedRecipes(id, s2, i2, j2, nonnulllist, itemstack);
        }

        @Override
        public void a(PacketDataSerializer buf, ShapedRecipes recipe) {
            buf.d(recipe.a);
            buf.d(recipe.b);
            buf.a(recipe.f);
            for (RecipeItemStack recipeitemstack : recipe.c) {
                recipeitemstack.a(buf);
            }
            buf.a(recipe.d);
        }
    }
}

