/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final RecipeItemStack a = new RecipeItemStack(Stream.empty());
    private final Provider[] b;
    @Nullable
    public ItemStack[] c;
    @Nullable
    private IntList d;
    public boolean exact;

    public RecipeItemStack(Stream<? extends Provider> entries) {
        this.b = (Provider[])entries.toArray(Provider[]::new);
    }

    public ItemStack[] a() {
        this.f();
        return this.c;
    }

    public void f() {
        if (this.c == null) {
            this.c = (ItemStack[])Arrays.stream(this.b).flatMap(recipeitemstack_provider -> recipeitemstack_provider.a().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    public boolean a(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        this.f();
        if (this.c.length == 0) {
            return itemstack.b();
        }
        for (ItemStack itemstack1 : this.c) {
            if (!(this.exact ? itemstack1.c() == itemstack.c() && ItemStack.a(itemstack, itemstack1) : itemstack1.a(itemstack.c()))) continue;
            return true;
        }
        return false;
    }

    public IntList b() {
        if (this.d == null) {
            this.f();
            this.d = new IntArrayList(this.c.length);
            for (ItemStack itemstack : this.c) {
                this.d.add(AutoRecipeStackManager.c(itemstack));
            }
            this.d.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.d;
    }

    public void a(PacketDataSerializer buf) {
        this.f();
        buf.a(Arrays.asList(this.c), PacketDataSerializer::a);
    }

    public JsonElement c() {
        if (this.b.length == 1) {
            return this.b[0].b();
        }
        JsonArray jsonarray = new JsonArray();
        for (Provider recipeitemstack_provider : this.b) {
            jsonarray.add((JsonElement)recipeitemstack_provider.b());
        }
        return jsonarray;
    }

    public boolean d() {
        return !(this.b.length != 0 || this.c != null && this.c.length != 0 || this.d != null && !this.d.isEmpty());
    }

    private static RecipeItemStack b(Stream<? extends Provider> entries) {
        RecipeItemStack recipeitemstack = new RecipeItemStack(entries);
        return recipeitemstack.b.length == 0 ? a : recipeitemstack;
    }

    public static RecipeItemStack e() {
        return a;
    }

    public static RecipeItemStack a(IMaterial ... items) {
        return RecipeItemStack.a(Arrays.stream(items).map(ItemStack::new));
    }

    public static RecipeItemStack a(ItemStack ... stacks) {
        return RecipeItemStack.a(Arrays.stream(stacks));
    }

    public static RecipeItemStack a(Stream<ItemStack> stacks) {
        return RecipeItemStack.b(stacks.filter(itemstack -> !itemstack.b()).map(StackProvider::new));
    }

    public static RecipeItemStack a(TagKey<Item> tag) {
        return RecipeItemStack.b(Stream.of(new b(tag)));
    }

    public static RecipeItemStack b(PacketDataSerializer buf) {
        return RecipeItemStack.b(buf.a(PacketDataSerializer::o).stream().map(StackProvider::new));
    }

    public static RecipeItemStack a(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return RecipeItemStack.b(Stream.of(RecipeItemStack.a(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonarray = json.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return RecipeItemStack.b(StreamSupport.stream(jsonarray.spliterator(), false).map(jsonelement1 -> RecipeItemStack.a(ChatDeserializer.m(jsonelement1, "item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    private static Provider a(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            Item item = ShapedRecipes.b(json);
            return new StackProvider(new ItemStack(item));
        }
        if (json.has("tag")) {
            MinecraftKey minecraftkey = new MinecraftKey(ChatDeserializer.h(json, "tag"));
            TagKey<Item> tagkey = TagKey.a(IRegistry.k, minecraftkey);
            return new b(tagkey);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static interface Provider {
        public Collection<ItemStack> a();

        public JsonObject b();
    }

    private static class b
    implements Provider {
        private final TagKey<Item> a;

        b(TagKey<Item> tag) {
            this.a = tag;
        }

        @Override
        public Collection<ItemStack> a() {
            ArrayList list = Lists.newArrayList();
            for (Holder<Item> holder : IRegistry.X.d(this.a)) {
                list.add(new ItemStack(holder));
            }
            return list;
        }

        @Override
        public JsonObject b() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.a.b().toString());
            return jsonobject;
        }
    }

    public static class StackProvider
    implements Provider {
        private final ItemStack a;

        public StackProvider(ItemStack stack) {
            this.a = stack;
        }

        @Override
        public Collection<ItemStack> a() {
            return Collections.singleton(this.a);
        }

        @Override
        public JsonObject b() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", IRegistry.X.b(this.a.c()).toString());
            return jsonobject;
        }
    }
}

