/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson a = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger b = LogUtils.getLogger();
    public Map<Recipes<?>, Object2ObjectLinkedOpenHashMap<MinecraftKey, IRecipe<?>>> c = ImmutableMap.of();
    public Map<MinecraftKey, IRecipe<?>> d = ImmutableMap.of();
    private boolean e;

    public CraftingManager() {
        super(a, "recipes");
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        this.e = false;
        HashMap map1 = Maps.newHashMap();
        for (Recipes recipes2 : IRegistry.ah) {
            map1.put(recipes2, new Object2ObjectLinkedOpenHashMap());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<MinecraftKey, JsonElement> entry : prepared.entrySet()) {
            MinecraftKey minecraftkey = entry.getKey();
            try {
                IRecipe<?> irecipe = CraftingManager.a(minecraftkey, ChatDeserializer.m(entry.getValue(), "top element"));
                map1.computeIfAbsent(irecipe.g(), recipes -> new Object2ObjectLinkedOpenHashMap()).put((Object)minecraftkey, irecipe);
                builder.put((Object)minecraftkey, irecipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                b.error("Parsing error loading recipe {}", (Object)minecraftkey, (Object)jsonparseexception);
            }
        }
        this.c = (Map)map1.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry1 -> (Object2ObjectLinkedOpenHashMap)entry1.getValue()));
        this.d = Maps.newHashMap((Map)builder.build());
        b.info("Loaded {} recipes", (Object)map1.size());
    }

    public void addRecipe(IRecipe<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        Object2ObjectLinkedOpenHashMap<MinecraftKey, IRecipe<?>> map = this.c.get(irecipe.g());
        if (this.d.containsKey(irecipe.f()) || map.containsKey((Object)irecipe.f())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + irecipe.f());
        }
        map.putAndMoveToFirst((Object)irecipe.f(), irecipe);
        this.d.put(irecipe.f(), irecipe);
    }

    public boolean a() {
        return this.e;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> a(Recipes<T> type, C inventory, World world) {
        Optional recipe = this.b(type).values().stream().flatMap(irecipe -> type.a(irecipe, world, inventory).stream()).findFirst();
        inventory.setCurrentRecipe(recipe.orElse(null));
        return recipe;
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> a(Recipes<T> type) {
        return this.b(type).values().stream().map(irecipe -> irecipe).collect(Collectors.toList());
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> b(Recipes<T> type, C inventory, World world) {
        return this.b(type).values().stream().flatMap(irecipe -> type.a(irecipe, world, inventory).stream()).sorted(Comparator.comparing(irecipe -> irecipe.c().o())).collect(Collectors.toList());
    }

    private <C extends IInventory, T extends IRecipe<C>> Map<MinecraftKey, IRecipe<C>> b(Recipes<T> type) {
        return (Map)this.c.getOrDefault(type, new Object2ObjectLinkedOpenHashMap());
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> c(Recipes<T> type, C inventory, World world) {
        Optional<T> optional = this.a(type, inventory, world);
        if (optional.isPresent()) {
            return ((IRecipe)optional.get()).b(inventory);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.a(inventory.b(), ItemStack.b);
        for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
            nonnulllist.set(i2, inventory.a(i2));
        }
        return nonnulllist;
    }

    public Optional<? extends IRecipe<?>> a(MinecraftKey id) {
        return Optional.ofNullable(this.d.get(id));
    }

    public Collection<IRecipe<?>> b() {
        return this.c.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toSet());
    }

    public Stream<MinecraftKey> d() {
        return this.c.values().stream().flatMap(map -> map.keySet().stream());
    }

    public static IRecipe<?> a(MinecraftKey id, JsonObject json) {
        String s2 = ChatDeserializer.h(json, "type");
        return IRegistry.ai.b(new MinecraftKey(s2)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + s2 + "'")).a(id, json);
    }

    public void a(Iterable<IRecipe<?>> recipes) {
        this.e = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        recipes.forEach(irecipe -> {
            Map map1 = (Map)map.computeIfAbsent(irecipe.g(), recipes_ -> new Object2ObjectLinkedOpenHashMap());
            MinecraftKey minecraftkey = irecipe.f();
            IRecipe irecipe1 = map1.put(minecraftkey, irecipe);
            builder.put((Object)minecraftkey, irecipe);
            if (irecipe1 != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + minecraftkey);
            }
        });
        this.c = ImmutableMap.copyOf((Map)map);
        this.d = Maps.newHashMap((Map)builder.build());
    }

    public boolean removeRecipe(MinecraftKey mcKey) {
        for (Object2ObjectLinkedOpenHashMap<MinecraftKey, IRecipe<?>> recipes : this.c.values()) {
            recipes.remove((Object)mcKey);
        }
        return this.d.remove(mcKey) != null;
    }

    public void clearRecipes() {
        this.c = Maps.newHashMap();
        for (Recipes recipes : IRegistry.ah) {
            this.c.put(recipes, new Object2ObjectLinkedOpenHashMap());
        }
        this.d = Maps.newHashMap();
    }
}

