/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import io.papermc.paper.potion.PaperPotionMix;
import io.papermc.paper.potion.PotionMix;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IRegistry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import org.bukkit.NamespacedKey;

public class PotionBrewer {
    public static final int a = 20;
    private static final List<PredicatedCombination<PotionRegistry>> b = Lists.newArrayList();
    private static final List<PredicatedCombination<Item>> c = Lists.newArrayList();
    private static final Object2ObjectLinkedOpenHashMap<NamespacedKey, PaperPotionMix> CUSTOM_MIXES = new Object2ObjectLinkedOpenHashMap();
    private static final List<RecipeItemStack> d = Lists.newArrayList();
    private static final Predicate<ItemStack> e = stack -> {
        for (RecipeItemStack ingredient : d) {
            if (!ingredient.a((ItemStack)stack)) continue;
            return true;
        }
        return false;
    };

    public static boolean a(ItemStack stack) {
        return PotionBrewer.b(stack) || PotionBrewer.c(stack) || PotionBrewer.isCustomIngredient(stack);
    }

    protected static boolean b(ItemStack stack) {
        int j2 = c.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (!PotionBrewer.c.get((int)i2).b.a(stack)) continue;
            return true;
        }
        return false;
    }

    protected static boolean c(ItemStack stack) {
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (!PotionBrewer.b.get((int)i2).b.a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean a(PotionRegistry potion) {
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            if (PotionBrewer.b.get((int)i2).c != potion) continue;
            return true;
        }
        return false;
    }

    public static boolean a(ItemStack input, ItemStack ingredient) {
        if (PotionBrewer.hasCustomMix(input, ingredient)) {
            return true;
        }
        if (!e.test(input)) {
            return false;
        }
        return PotionBrewer.b(input, ingredient) || PotionBrewer.c(input, ingredient);
    }

    protected static boolean b(ItemStack input, ItemStack ingredient) {
        Item item = input.c();
        int j2 = c.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            PredicatedCombination<Item> mix = c.get(i2);
            if (mix.a != item || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    protected static boolean c(ItemStack input, ItemStack ingredient) {
        PotionRegistry potion = PotionUtil.d(input);
        int j2 = b.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            PredicatedCombination<PotionRegistry> mix = b.get(i2);
            if (mix.a != potion || !mix.b.a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack d(ItemStack ingredient, ItemStack input) {
        if (!input.b()) {
            int i2;
            for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
                if (!mix.input().a(input) || !mix.ingredient().a(ingredient)) continue;
                return mix.result().n();
            }
            PotionRegistry potion = PotionUtil.d(input);
            Item item = input.c();
            int j2 = c.size();
            for (i2 = 0; i2 < j2; ++i2) {
                PredicatedCombination<Item> mix = c.get(i2);
                if (mix.a != item || !mix.b.a(ingredient)) continue;
                return PotionUtil.a(new ItemStack((IMaterial)mix.c), potion);
            }
            int l2 = b.size();
            for (i2 = 0; i2 < l2; ++i2) {
                PredicatedCombination<PotionRegistry> mix2 = b.get(i2);
                if (mix2.a != potion || !mix2.b.a(ingredient)) continue;
                return PotionUtil.a(new ItemStack(item), (PotionRegistry)mix2.c);
            }
        }
        return input;
    }

    public static boolean isCustomIngredient(ItemStack stack) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.ingredient().a(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCustomInput(ItemStack stack) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.input().a(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCustomMix(ItemStack input, ItemStack ingredient) {
        for (PaperPotionMix mix : CUSTOM_MIXES.values()) {
            if (!mix.input().a(input) || !mix.ingredient().a(ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void addPotionMix(PotionMix mix) {
        if (CUSTOM_MIXES.containsKey((Object)mix.getKey())) {
            throw new IllegalArgumentException("Duplicate recipe ignored with ID " + mix.getKey());
        }
        CUSTOM_MIXES.putAndMoveToFirst((Object)mix.getKey(), (Object)new PaperPotionMix(mix));
    }

    public static boolean removePotionMix(NamespacedKey key) {
        return CUSTOM_MIXES.remove((Object)key) != null;
    }

    public static void reload() {
        b.clear();
        c.clear();
        d.clear();
        CUSTOM_MIXES.clear();
        PotionBrewer.a();
    }

    public static void a() {
        PotionBrewer.a(Items.pF);
        PotionBrewer.a(Items.sr);
        PotionBrewer.a(Items.su);
        PotionBrewer.a(Items.pF, Items.ng, Items.sr);
        PotionBrewer.a(Items.sr, Items.sq, Items.su);
        PotionBrewer.a(Potions.b, Items.pO, Potions.c);
        PotionBrewer.a(Potions.b, Items.pC, Potions.c);
        PotionBrewer.a(Potions.b, Items.rI, Potions.c);
        PotionBrewer.a(Potions.b, Items.pJ, Potions.c);
        PotionBrewer.a(Potions.b, Items.pH, Potions.c);
        PotionBrewer.a(Potions.b, Items.oW, Potions.c);
        PotionBrewer.a(Potions.b, Items.pK, Potions.c);
        PotionBrewer.a(Potions.b, Items.ou, Potions.d);
        PotionBrewer.a(Potions.b, Items.kn, Potions.c);
        PotionBrewer.a(Potions.b, Items.pE, Potions.e);
        PotionBrewer.a(Potions.e, Items.rq, Potions.f);
        PotionBrewer.a(Potions.f, Items.kn, Potions.g);
        PotionBrewer.a(Potions.f, Items.pI, Potions.h);
        PotionBrewer.a(Potions.g, Items.pI, Potions.i);
        PotionBrewer.a(Potions.h, Items.kn, Potions.i);
        PotionBrewer.a(Potions.e, Items.pK, Potions.m);
        PotionBrewer.a(Potions.m, Items.kn, Potions.n);
        PotionBrewer.a(Potions.e, Items.rI, Potions.j);
        PotionBrewer.a(Potions.j, Items.kn, Potions.k);
        PotionBrewer.a(Potions.j, Items.ou, Potions.l);
        PotionBrewer.a(Potions.j, Items.pI, Potions.r);
        PotionBrewer.a(Potions.k, Items.pI, Potions.s);
        PotionBrewer.a(Potions.r, Items.kn, Potions.s);
        PotionBrewer.a(Potions.r, Items.ou, Potions.t);
        PotionBrewer.a(Potions.e, Items.mc, Potions.u);
        PotionBrewer.a(Potions.u, Items.kn, Potions.v);
        PotionBrewer.a(Potions.u, Items.ou, Potions.w);
        PotionBrewer.a(Potions.o, Items.pI, Potions.r);
        PotionBrewer.a(Potions.p, Items.pI, Potions.s);
        PotionBrewer.a(Potions.e, Items.oW, Potions.o);
        PotionBrewer.a(Potions.o, Items.kn, Potions.p);
        PotionBrewer.a(Potions.o, Items.ou, Potions.q);
        PotionBrewer.a(Potions.e, Items.oy, Potions.x);
        PotionBrewer.a(Potions.x, Items.kn, Potions.y);
        PotionBrewer.a(Potions.e, Items.pO, Potions.z);
        PotionBrewer.a(Potions.z, Items.ou, Potions.A);
        PotionBrewer.a(Potions.z, Items.pI, Potions.B);
        PotionBrewer.a(Potions.A, Items.pI, Potions.C);
        PotionBrewer.a(Potions.B, Items.ou, Potions.C);
        PotionBrewer.a(Potions.D, Items.pI, Potions.B);
        PotionBrewer.a(Potions.E, Items.pI, Potions.B);
        PotionBrewer.a(Potions.F, Items.pI, Potions.C);
        PotionBrewer.a(Potions.e, Items.pH, Potions.D);
        PotionBrewer.a(Potions.D, Items.kn, Potions.E);
        PotionBrewer.a(Potions.D, Items.ou, Potions.F);
        PotionBrewer.a(Potions.e, Items.pC, Potions.G);
        PotionBrewer.a(Potions.G, Items.kn, Potions.H);
        PotionBrewer.a(Potions.G, Items.ou, Potions.I);
        PotionBrewer.a(Potions.e, Items.pJ, Potions.J);
        PotionBrewer.a(Potions.J, Items.kn, Potions.K);
        PotionBrewer.a(Potions.J, Items.ou, Potions.L);
        PotionBrewer.a(Potions.b, Items.pI, Potions.M);
        PotionBrewer.a(Potions.M, Items.kn, Potions.N);
        PotionBrewer.a(Potions.e, Items.sQ, Potions.P);
        PotionBrewer.a(Potions.P, Items.kn, Potions.Q);
    }

    private static void a(Item input, Item ingredient, Item output) {
        if (!(input instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + IRegistry.X.b(input));
        }
        if (!(output instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + IRegistry.X.b(output));
        }
        c.add(new PredicatedCombination<Item>(input, RecipeItemStack.a(ingredient), output));
    }

    private static void a(Item item) {
        if (!(item instanceof ItemPotion)) {
            throw new IllegalArgumentException("Expected a potion, got: " + IRegistry.X.b(item));
        }
        d.add(RecipeItemStack.a(item));
    }

    private static void a(PotionRegistry input, Item item, PotionRegistry output) {
        b.add(new PredicatedCombination<PotionRegistry>(input, RecipeItemStack.a(item), output));
    }

    static class PredicatedCombination<T> {
        final T a;
        final RecipeItemStack b;
        final T c;

        public PredicatedCombination(T input, RecipeItemStack ingredient, T output) {
            this.a = input;
            this.b = ingredient;
            this.c = output;
        }
    }
}

