/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModeCheck;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentDurability;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack {
    public static final Codec<ItemStack> a = RecordCodecBuilder.create(instance -> instance.group((App)IRegistry.X.o().fieldOf("id").forGetter(itemstack -> itemstack.t), (App)Codec.INT.fieldOf("Count").forGetter(itemstack -> itemstack.r), (App)NBTTagCompound.a.optionalFieldOf("tag").forGetter(itemstack -> Optional.ofNullable(itemstack.u))).apply((Applicative)instance, ItemStack::new));
    private static final Logger j = LogUtils.getLogger();
    public static final ItemStack b = new ItemStack((IMaterial)null);
    public static final DecimalFormat c = SystemUtils.a(new DecimalFormat("#.##"), (T decimalformat) -> decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final String d = "Enchantments";
    public static final String e = "display";
    public static final String f = "Name";
    public static final String g = "Lore";
    public static final String h = "Damage";
    public static final String i = "color";
    private static final String k = "Unbreakable";
    private static final String l = "RepairCost";
    private static final String m = "CanDestroy";
    private static final String n = "CanPlaceOn";
    private static final String o = "HideFlags";
    private static final int p = 0;
    private static final ChatModifier q = ChatModifier.a.a(EnumChatFormat.f).b(true);
    private int r;
    private int s;
    @Deprecated
    private Item t;
    @Nullable
    public NBTTagCompound u;
    private boolean v;
    @Nullable
    private net.minecraft.world.entity.Entity w;
    @Nullable
    private AdventureModeCheck x;
    @Nullable
    private AdventureModeCheck y;
    private static final Comparator<? super NBTTagCompound> enchantSorter = Comparator.comparing(o2 -> o2.l("id"));
    private CraftItemStack bukkitStack;

    public Optional<TooltipComponent> a() {
        return this.c().h(this);
    }

    private void processEnchantOrder(@Nullable NBTTagCompound tag) {
        if (tag == null || !tag.b(d, 9)) {
            return;
        }
        NBTTagList list = tag.c(d, 10);
        if (list.size() < 2) {
            return;
        }
        try {
            list.sort(enchantSorter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processText() {
        NBTTagCompound display = this.b(e);
        if (display != null) {
            String json;
            if (display.b(f, 8) && (json = display.l(f)) != null && json.contains("\u00a7")) {
                try {
                    display.a(f, this.convert(json));
                }
                catch (JsonParseException jsonparseexception) {
                    display.r(f);
                }
            }
            if (display.b(g, 9)) {
                NBTTagList list = display.c(g, 8);
                for (int index = 0; index < list.size(); ++index) {
                    String json2 = list.j(index);
                    if (json2 == null || !json2.contains("\u00a7")) continue;
                    try {
                        list.d(index, this.convert(json2));
                        continue;
                    }
                    catch (JsonParseException e2) {
                        list.d(index, NBTTagString.a(CraftChatMessage.toJSON(new ChatComponentText(""))));
                    }
                }
            }
        }
    }

    private NBTTagString convert(String json) {
        IChatBaseComponent component = IChatBaseComponent.ChatSerializer.a(json);
        if (component instanceof ChatComponentText && component.a().contains("\u00a7") && component.b().isEmpty()) {
            component = CraftChatMessage.fromString(component.a())[0];
        }
        return NBTTagString.a(CraftChatMessage.toJSON(component));
    }

    public ItemStack(IMaterial item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> entry) {
        this(entry.a(), 1);
    }

    private ItemStack(IMaterial item, int count, Optional<NBTTagCompound> nbt) {
        this(item, count);
        nbt.ifPresent(this::c);
    }

    public ItemStack(IMaterial item, int count) {
        this.t = item == null ? null : item.l();
        this.r = count;
        if (this.t != null && this.t.o()) {
            this.b(this.i());
        }
        this.O();
    }

    public void convertStack(int version) {
        if (0 < version && version < CraftMagicNumbers.INSTANCE.getDataVersion()) {
            NBTTagCompound savedStack = new NBTTagCompound();
            this.b(savedStack);
            savedStack = (NBTTagCompound)MinecraftServer.getServer().N.update(DataConverterTypes.m, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, savedStack), version, CraftMagicNumbers.INSTANCE.getDataVersion()).getValue();
            this.load(savedStack);
        }
    }

    private void O() {
        if (this.v && this == b) {
            throw new AssertionError((Object)"TRAP");
        }
        this.v = false;
        this.v = this.b();
    }

    private void load(NBTTagCompound nbttagcompound) {
        this.t = IRegistry.X.a(new MinecraftKey(nbttagcompound.l("id")));
        this.r = nbttagcompound.f("Count");
        if (nbttagcompound.b("tag", 10)) {
            this.u = nbttagcompound.p("tag").g();
            this.processEnchantOrder(this.u);
            this.processText();
            this.c().b(this.u);
        }
        if (this.c().o()) {
            this.b(this.i());
        }
    }

    private ItemStack(NBTTagCompound nbt) {
        this.load(nbt);
        this.O();
    }

    public static ItemStack a(NBTTagCompound nbt) {
        try {
            return new ItemStack(nbt);
        }
        catch (RuntimeException runtimeexception) {
            j.debug("Tried to load invalid item: {}", (Object)nbt, (Object)runtimeexception);
            return b;
        }
    }

    public boolean b() {
        return this == b || this.t == null || this.t == Items.a || this.r <= 0;
    }

    public ItemStack a(int amount) {
        int j2 = Math.min(amount, this.r);
        ItemStack itemstack = this.n();
        itemstack.e(j2);
        this.g(j2);
        return itemstack;
    }

    public Item c() {
        return this.v ? Items.a : this.t;
    }

    public boolean a(TagKey<Item> tag) {
        return this.c().k().a(tag);
    }

    public boolean a(Item item) {
        return this.c() == item;
    }

    public Stream<TagKey<Item>> d() {
        return this.c().k().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public EnumInteractionResult useOn(ItemActionContext itemactioncontext, EnumHand enumhand) {
        EntityHuman entityhuman = itemactioncontext.o();
        BlockPosition blockposition = itemactioncontext.a();
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(itemactioncontext.q(), blockposition, false);
        if (entityhuman != null && !entityhuman.fs().e && !this.a(itemactioncontext.q().s().d(IRegistry.h), shapedetectorblock)) {
            return EnumInteractionResult.d;
        }
        NBTTagCompound oldData = this.getTagClone();
        int oldCount = this.J();
        WorldServer world = (WorldServer)itemactioncontext.q();
        if (!(this.c() instanceof ItemBucket)) {
            world.captureBlockStates = true;
            if (this.c() == Items.oU) {
                world.captureTreeGeneration = true;
            }
        }
        Item item = this.c();
        EnumInteractionResult enuminteractionresult = item.a(itemactioncontext);
        NBTTagCompound newData = this.getTagClone();
        int newCount = this.J();
        this.e(oldCount);
        this.setTagClone(oldData);
        world.captureBlockStates = false;
        if (enuminteractionresult.a() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            void var16_22;
            world.captureTreeGeneration = false;
            Location location = new Location((World)world.getWorld(), (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            Object var16_20 = null;
            if (treeType != null) {
                boolean isBonemeal = this.c() == Items.oU;
                StructureGrowEvent structureGrowEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureGrowEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(var16_22 != null && var16_22.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.J() == oldCount && Objects.equals(this.u, oldData)) {
                    this.c(newData);
                    this.e(newCount);
                }
                for (BlockState blockState : blocks) {
                    blockState.update(true);
                }
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult.c()) {
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.u(), blockposition.v(), blockposition.w());
            } else if (blocks.size() == 1 && item != Items.nZ) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.u(), blockposition.v(), blockposition.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.e;
                placeEvent.getPlayer().updateInventory();
                world.capturedTileEntities.clear();
                world.preventPoiUpdated = true;
                for (BlockState blockState : blocks) {
                    blockState.update(true, false);
                }
                world.preventPoiUpdated = false;
                BlockPosition placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
                for (EnumDirection enumDirection : EnumDirection.values()) {
                    ((EntityPlayer)entityhuman).b.a(new PacketPlayOutBlockChange(world, placedPos.a(enumDirection)));
                }
                ItemSign.openSign = null;
            } else {
                if (this.J() == oldCount && Objects.equals(this.u, oldData)) {
                    this.c(newData);
                    this.e(newCount);
                }
                for (Map.Entry<BlockPosition, TileEntity> entry : world.capturedTileEntities.entrySet()) {
                    world.a(entry.getValue());
                }
                for (BlockState blockState : blocks) {
                    int updateFlag = ((CraftBlockState)blockState).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockState).getHandle();
                    BlockPosition blockPosition = ((CraftBlockState)blockState).getPosition();
                    IBlockData block = world.a_(blockPosition);
                    if (!(block.b() instanceof BlockTileEntity)) {
                        block.b().onPlace(block, world, blockPosition, oldBlock, true, itemactioncontext);
                    }
                    world.notifyAndUpdatePhysics(blockPosition, null, oldBlock, block, world.a_(blockPosition), updateFlag, 512);
                }
                if (this.t instanceof ItemRecord) {
                    ((BlockJukeBox)Blocks.cQ).a((GeneratorAccess)world, blockposition, world.a_(blockposition), this);
                    world.a((EntityHuman)null, 1010, blockposition, Item.a(this.t));
                    this.g(1);
                    entityhuman.a(StatisticList.al);
                }
                if (this.t == Items.rs) {
                    TileEntity tileEntity;
                    BlockPosition bp = blockposition;
                    if (!world.a_(blockposition).c().e()) {
                        bp = !world.a_(blockposition).c().b() ? null : bp.a(itemactioncontext.k());
                    }
                    if (bp != null && (tileEntity = world.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)world, bp, (TileEntitySkull)tileEntity);
                    }
                }
                if (this.t instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        entityhuman.a((TileEntitySign)world.c_(ItemSign.openSign));
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (this.t instanceof ItemBlock) {
                    SoundEffectType soundeffecttype = ((ItemBlock)this.t).e().m(null);
                    world.a(entityhuman, blockposition, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float a(IBlockData state) {
        return this.c().a(this, state);
    }

    public InteractionResultWrapper<ItemStack> a(net.minecraft.world.level.World world, EntityHuman user, EnumHand hand) {
        return this.c().a(world, user, hand);
    }

    public ItemStack a(net.minecraft.world.level.World world, EntityLiving user) {
        return this.c().a(this, world, user);
    }

    public NBTTagCompound b(NBTTagCompound nbt) {
        MinecraftKey minecraftkey = IRegistry.X.b(this.c());
        nbt.a("id", minecraftkey == null ? "minecraft:air" : minecraftkey.toString());
        nbt.a("Count", (byte)this.r);
        if (this.u != null) {
            nbt.a("tag", this.u.g());
        }
        return nbt;
    }

    public int e() {
        return this.c().m();
    }

    public boolean f() {
        return this.e() > 1 && (!this.g() || !this.h());
    }

    public boolean g() {
        if (!this.v && this.c().n() > 0) {
            NBTTagCompound nbttagcompound = this.t();
            return nbttagcompound == null || !nbttagcompound.q(k);
        }
        return false;
    }

    public boolean h() {
        return this.g() && this.i() > 0;
    }

    public int i() {
        return this.u == null ? 0 : this.u.h(h);
    }

    public void b(int damage) {
        this.u().a(h, Math.max(0, damage));
    }

    public int j() {
        return this.c().n();
    }

    public boolean hurt(int amount, Random random, @Nullable EntityLiving player) {
        int j2;
        if (!this.g()) {
            return false;
        }
        if (amount > 0) {
            j2 = EnchantmentManager.a(Enchantments.v, this);
            int k2 = 0;
            for (int l2 = 0; j2 > 0 && l2 < amount; ++l2) {
                if (!EnchantmentDurability.a(this, j2, random)) continue;
                ++k2;
            }
            amount -= k2;
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount);
                event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                if (amount != event.getDamage() || event.isCancelled()) {
                    event.getPlayer().updateInventory();
                }
                if (event.isCancelled()) {
                    return false;
                }
                amount = event.getDamage();
            } else if (player != null) {
                EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount);
                if (!event.callEvent()) {
                    return false;
                }
                amount = event.getDamage();
            }
            if (amount <= 0) {
                return false;
            }
        }
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            if (amount != 0) {
                CriterionTriggers.t.a(serverPlayer, this, this.i() + amount);
            }
        }
        j2 = this.i() + amount;
        this.b(j2);
        return j2 >= this.j();
    }

    public <T extends EntityLiving> void a(int amount, T entity, Consumer<T> breakCallback) {
        if (!(entity.s.x || entity instanceof EntityHuman && ((EntityHuman)entity).fs().d || !this.g() || !this.hurt(amount, entity.dL(), entity))) {
            breakCallback.accept(entity);
            Item item = this.c();
            if (this.r == 1 && entity instanceof EntityHuman) {
                CraftEventFactory.callPlayerItemBreakEvent((EntityHuman)entity, this);
            }
            this.g(1);
            if (entity instanceof EntityHuman) {
                ((EntityHuman)entity).b(StatisticList.d.b(item));
            }
            this.b(0);
        }
    }

    public boolean k() {
        return this.t.e(this);
    }

    public int l() {
        return this.t.f(this);
    }

    public int m() {
        return this.t.g(this);
    }

    public boolean a(Slot slot, ClickAction clickType, EntityHuman player) {
        return this.c().a(this, slot, clickType, player);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return this.c().a(this, stack, slot, clickType, player, cursorStackReference);
    }

    public void a(EntityLiving target, EntityHuman attacker) {
        Item item = this.c();
        if (item.a(this, target, (EntityLiving)attacker)) {
            attacker.b(StatisticList.c.b(item));
        }
    }

    public void a(net.minecraft.world.level.World world, IBlockData state, BlockPosition pos, EntityHuman miner) {
        Item item = this.c();
        if (item.a(this, world, state, pos, miner)) {
            miner.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData state) {
        return this.c().a_(state);
    }

    public EnumInteractionResult a(EntityHuman user, EntityLiving entity, EnumHand hand) {
        return this.c().a(this, user, entity, hand);
    }

    public ItemStack n() {
        return this.cloneItemStack(false);
    }

    public ItemStack cloneItemStack(boolean origItem) {
        if (!origItem && this.b()) {
            return b;
        }
        ItemStack itemstack = new ItemStack(origItem ? this.t : this.c(), this.r);
        itemstack.d(this.I());
        if (this.u != null) {
            itemstack.u = this.u.g();
        }
        return itemstack;
    }

    public static boolean a(ItemStack left, ItemStack right) {
        return left.b() && right.b() ? true : (!left.b() && !right.b() ? (left.u == null && right.u != null ? false : left.u == null || left.u.equals(right.u)) : false);
    }

    public static boolean b(ItemStack left, ItemStack right) {
        return left.b() && right.b() ? true : (!left.b() && !right.b() ? left.c(right) : false);
    }

    private boolean c(ItemStack stack) {
        return this.r != stack.r ? false : (!this.a(stack.c()) ? false : (this.u == null && stack.u != null ? false : this.u == null || this.u.equals(stack.u)));
    }

    public static boolean c(ItemStack left, ItemStack right) {
        return left == right ? true : (!left.b() && !right.b() ? left.a(right) : false);
    }

    public static boolean d(ItemStack left, ItemStack right) {
        return left == right ? true : (!left.b() && !right.b() ? left.b(right) : false);
    }

    public boolean a(ItemStack stack) {
        return !stack.b() && this.a(stack.c());
    }

    public boolean b(ItemStack stack) {
        return !this.g() ? this.a(stack) : !stack.b() && this.a(stack.c());
    }

    public static boolean e(ItemStack stack, ItemStack otherStack) {
        return stack.a(otherStack.c()) && ItemStack.a(stack, otherStack);
    }

    public String o() {
        return this.c().j(this);
    }

    public String toString() {
        return this.r + " " + this.c();
    }

    public void a(net.minecraft.world.level.World world, net.minecraft.world.entity.Entity entity, int slot, boolean selected) {
        if (this.s > 0) {
            --this.s;
        }
        if (this.c() != null) {
            this.c().a(this, world, entity, slot, selected);
        }
    }

    public void a(net.minecraft.world.level.World world, EntityHuman player, int amount) {
        player.a(StatisticList.b.b(this.c()), amount);
        this.c().b(this, world, player);
    }

    public int p() {
        return this.c().b(this);
    }

    public EnumAnimation q() {
        return this.c().c(this);
    }

    public void a(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        this.c().a(this, world, user, remainingUseTicks);
    }

    public boolean r() {
        return this.c().l(this);
    }

    public boolean s() {
        return !this.v && this.u != null && !this.u.f();
    }

    @Nullable
    public NBTTagCompound t() {
        return this.u;
    }

    @Nullable
    private NBTTagCompound getTagClone() {
        return this.u == null ? null : this.u.g();
    }

    private void setTagClone(@Nullable NBTTagCompound nbtttagcompound) {
        this.c(nbtttagcompound == null ? null : nbtttagcompound.g());
    }

    public NBTTagCompound u() {
        if (this.u == null) {
            this.c(new NBTTagCompound());
        }
        return this.u;
    }

    public NBTTagCompound a(String key) {
        if (this.u != null && this.u.b(key, 10)) {
            return this.u.p(key);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.a(key, nbttagcompound);
        return nbttagcompound;
    }

    @Nullable
    public NBTTagCompound b(String key) {
        return this.u != null && this.u.b(key, 10) ? this.u.p(key) : null;
    }

    public void c(String key) {
        if (this.u != null && this.u.e(key)) {
            this.u.r(key);
            if (this.u.f()) {
                this.u = null;
            }
        }
    }

    public NBTTagList v() {
        return this.u != null ? this.u.c(d, 10) : new NBTTagList();
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.n());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public void c(@Nullable NBTTagCompound nbt) {
        this.u = nbt;
        this.processEnchantOrder(this.u);
        if (this.c().o()) {
            this.b(this.i());
        }
        if (nbt != null) {
            this.c().b(nbt);
        }
    }

    public IChatBaseComponent w() {
        NBTTagCompound nbttagcompound = this.b(e);
        if (nbttagcompound != null && nbttagcompound.b(f, 8)) {
            try {
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.ChatSerializer.a(nbttagcompound.l(f));
                if (ichatmutablecomponent != null) {
                    return ichatmutablecomponent;
                }
                nbttagcompound.r(f);
            }
            catch (Exception exception) {
                nbttagcompound.r(f);
            }
        }
        return this.c().m(this);
    }

    public ItemStack a(@Nullable IChatBaseComponent name) {
        NBTTagCompound nbttagcompound = this.a(e);
        if (name != null) {
            nbttagcompound.a(f, IChatBaseComponent.ChatSerializer.a(name));
        } else {
            nbttagcompound.r(f);
        }
        return this;
    }

    public void x() {
        NBTTagCompound nbttagcompound = this.b(e);
        if (nbttagcompound != null) {
            nbttagcompound.r(f);
            if (nbttagcompound.f()) {
                this.c(e);
            }
        }
        if (this.u != null && this.u.f()) {
            this.u = null;
        }
    }

    public boolean y() {
        NBTTagCompound nbttagcompound = this.b(e);
        return nbttagcompound != null && nbttagcompound.b(f, 8);
    }

    public List<IChatBaseComponent> a(@Nullable EntityHuman player, TooltipFlag context) {
        int i2;
        Integer integer;
        ArrayList list = Lists.newArrayList();
        IChatMutableComponent ichatmutablecomponent = new ChatComponentText("").a(this.w()).a(this.A().e);
        if (this.y()) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        list.add(ichatmutablecomponent);
        if (!context.a() && !this.y() && this.a(Items.pp) && (integer = ItemWorldMap.d(this)) != null) {
            list.add(new ChatComponentText("#" + integer).a(EnumChatFormat.h));
        }
        if (ItemStack.a(i2 = this.P(), HideFlags.f)) {
            this.c().a(this, player == null ? null : player.s, list, context);
        }
        if (this.s()) {
            if (ItemStack.a(i2, HideFlags.a)) {
                ItemStack.a(list, this.v());
            }
            if (this.u.b(e, 10)) {
                NBTTagCompound nbttagcompound = this.u.p(e);
                if (ItemStack.a(i2, HideFlags.g) && nbttagcompound.b(i, 99)) {
                    if (context.a()) {
                        list.add(new ChatMessage("item.color", String.format("#%06X", nbttagcompound.h(i))).a(EnumChatFormat.h));
                    } else {
                        list.add(new ChatMessage("item.dyed").a(EnumChatFormat.h, EnumChatFormat.u));
                    }
                }
                if (nbttagcompound.d(g) == 9) {
                    NBTTagList nbttaglist = nbttagcompound.c(g, 8);
                    for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
                        String s2 = nbttaglist.j(j2);
                        try {
                            IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.ChatSerializer.a(s2);
                            if (ichatmutablecomponent1 == null) continue;
                            list.add(ChatComponentUtils.a(ichatmutablecomponent1, q));
                            continue;
                        }
                        catch (Exception exception) {
                            nbttagcompound.r(g);
                        }
                    }
                }
            }
        }
        if (ItemStack.a(i2, HideFlags.b)) {
            for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
                Multimap<AttributeBase, AttributeModifier> multimap = this.a(enumitemslot);
                if (multimap.isEmpty()) continue;
                list.add(ChatComponentText.d);
                list.add(new ChatMessage("item.modifiers." + enumitemslot.d()).a(EnumChatFormat.h));
                for (Map.Entry entry : multimap.entries()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    double d0 = attributemodifier.d();
                    boolean flag = false;
                    if (player != null) {
                        if (attributemodifier.a() == Item.l) {
                            d0 += player.c(GenericAttributes.f);
                            d0 += (double)EnchantmentManager.a(this, EnumMonsterType.a);
                            flag = true;
                        } else if (attributemodifier.a() == Item.m) {
                            d0 += player.c(GenericAttributes.h);
                            flag = true;
                        }
                    }
                    double d1 = attributemodifier.c() != AttributeModifier.Operation.b && attributemodifier.c() != AttributeModifier.Operation.c ? (((AttributeBase)entry.getKey()).equals(GenericAttributes.c) ? d0 * 10.0 : d0) : d0 * 100.0;
                    if (flag) {
                        list.add(new ChatComponentText(" ").a(new ChatMessage("attribute.modifier.equals." + attributemodifier.c().a(), c.format(d1), new ChatMessage(((AttributeBase)entry.getKey()).c()))).a(EnumChatFormat.c));
                        continue;
                    }
                    if (d0 > 0.0) {
                        list.add(new ChatMessage("attribute.modifier.plus." + attributemodifier.c().a(), c.format(d1), new ChatMessage(((AttributeBase)entry.getKey()).c())).a(EnumChatFormat.j));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add(new ChatMessage("attribute.modifier.take." + attributemodifier.c().a(), c.format(d1 *= -1.0), new ChatMessage(((AttributeBase)entry.getKey()).c())).a(EnumChatFormat.m));
                }
            }
        }
        if (this.s()) {
            NBTTagList nbttaglist1;
            if (ItemStack.a(i2, HideFlags.c) && this.u.q(k)) {
                list.add(new ChatMessage("item.unbreakable").a(EnumChatFormat.j));
            }
            if (ItemStack.a(i2, HideFlags.d) && this.u.b(m, 9) && !(nbttaglist1 = this.u.c(m, 8)).isEmpty()) {
                list.add(ChatComponentText.d);
                list.add(new ChatMessage("item.canBreak").a(EnumChatFormat.h));
                for (int k2 = 0; k2 < nbttaglist1.size(); ++k2) {
                    list.addAll(ItemStack.d(nbttaglist1.j(k2)));
                }
            }
            if (ItemStack.a(i2, HideFlags.e) && this.u.b(n, 9) && !(nbttaglist1 = this.u.c(n, 8)).isEmpty()) {
                list.add(ChatComponentText.d);
                list.add(new ChatMessage("item.canPlace").a(EnumChatFormat.h));
                for (int k3 = 0; k3 < nbttaglist1.size(); ++k3) {
                    list.addAll(ItemStack.d(nbttaglist1.j(k3)));
                }
            }
        }
        if (context.a()) {
            if (this.h()) {
                list.add(new ChatMessage("item.durability", this.j() - this.i(), this.j()));
            }
            list.add(new ChatComponentText(IRegistry.X.b(this.c()).toString()).a(EnumChatFormat.i));
            if (this.s()) {
                list.add(new ChatMessage("item.nbt_tags", this.u.d().size()).a(EnumChatFormat.i));
            }
        }
        return list;
    }

    private static boolean a(int flags, HideFlags tooltipSection) {
        return (flags & tooltipSection.a()) == 0;
    }

    private int P() {
        return this.s() && this.u.b(o, 99) ? this.u.h(o) : 0;
    }

    public void a(HideFlags tooltipSection) {
        NBTTagCompound nbttagcompound = this.u();
        nbttagcompound.a(o, nbttagcompound.h(o) | tooltipSection.a());
    }

    public static void a(List<IChatBaseComponent> tooltip, NBTTagList enchantments) {
        for (int i2 = 0; i2 < enchantments.size(); ++i2) {
            NBTTagCompound nbttagcompound = enchantments.a(i2);
            IRegistry.V.b(EnchantmentManager.b(nbttagcompound)).ifPresent(enchantment -> tooltip.add(enchantment.d(EnchantmentManager.a(nbttagcompound))));
        }
    }

    private static Collection<IChatBaseComponent> d(String tag) {
        try {
            List<IChatBaseComponent> list;
            boolean flag1;
            ArgumentBlock argumentblock = new ArgumentBlock(new StringReader(tag), true).a(true);
            IBlockData iblockdata = argumentblock.b();
            TagKey<Block> tagkey = argumentblock.d();
            boolean flag = iblockdata != null;
            boolean bl = flag1 = tagkey != null;
            if (flag) {
                return Lists.newArrayList((Object[])new IChatBaseComponent[]{iblockdata.b().g().a(EnumChatFormat.i)});
            }
            if (flag1 && !(list = Streams.stream(IRegistry.U.d(tagkey)).map(holder -> ((Block)holder.a()).g()).map(ichatmutablecomponent -> ichatmutablecomponent.a(EnumChatFormat.i)).collect(Collectors.toList())).isEmpty()) {
                return list;
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return Lists.newArrayList((Object[])new IChatBaseComponent[]{new ChatComponentText("missingno").a(EnumChatFormat.i)});
    }

    public boolean z() {
        return this.c().i(this);
    }

    public EnumItemRarity A() {
        return this.c().n(this);
    }

    public boolean B() {
        return !this.c().c_(this) ? false : !this.C();
    }

    public void a(Enchantment enchantment, int level) {
        this.u();
        if (!this.u.b(d, 9)) {
            this.u.a(d, new NBTTagList());
        }
        NBTTagList nbttaglist = this.u.c(d, 10);
        nbttaglist.add(EnchantmentManager.a(EnchantmentManager.a(enchantment), (int)((byte)level)));
        this.processEnchantOrder(this.u);
    }

    public boolean C() {
        return this.u != null && this.u.b(d, 9) ? !this.u.c(d, 10).isEmpty() : false;
    }

    public void a(String key, NBTBase element) {
        this.u().a(key, element);
    }

    public boolean D() {
        return this.w instanceof EntityItemFrame;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity holder) {
        this.w = holder;
    }

    @Nullable
    public EntityItemFrame E() {
        return this.w instanceof EntityItemFrame ? (EntityItemFrame)this.F() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity F() {
        return !this.v ? this.w : null;
    }

    public int G() {
        return this.s() && this.u.b(l, 3) ? this.u.h(l) : 0;
    }

    public void c(int repairCost) {
        if (repairCost == 0) {
            this.c(l);
            return;
        }
        this.u().a(l, repairCost);
    }

    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot slot) {
        HashMultimap object;
        if (this.s() && this.u.b("AttributeModifiers", 9)) {
            object = HashMultimap.create();
            NBTTagList nbttaglist = this.u.c("AttributeModifiers", 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                AttributeModifier attributemodifier;
                Optional<AttributeBase> optional;
                NBTTagCompound nbttagcompound = nbttaglist.a(i2);
                if (nbttagcompound.b("Slot", 8) && !nbttagcompound.l("Slot").equals(slot.d()) || !(optional = IRegistry.aj.b(MinecraftKey.a(nbttagcompound.l("AttributeName")))).isPresent() || (attributemodifier = AttributeModifier.a(nbttagcompound)) == null || attributemodifier.a().getLeastSignificantBits() == 0L || attributemodifier.a().getMostSignificantBits() == 0L) continue;
                ((Multimap)object).put((Object)optional.get(), (Object)attributemodifier);
            }
        } else {
            object = this.c().a(slot);
        }
        return object;
    }

    public void a(AttributeBase attribute, AttributeModifier modifier, @Nullable EnumItemSlot slot) {
        this.u();
        if (!this.u.b("AttributeModifiers", 9)) {
            this.u.a("AttributeModifiers", new NBTTagList());
        }
        NBTTagList nbttaglist = this.u.c("AttributeModifiers", 10);
        NBTTagCompound nbttagcompound = modifier.e();
        nbttagcompound.a("AttributeName", IRegistry.aj.b(attribute).toString());
        if (slot != null) {
            nbttagcompound.a("Slot", slot.d());
        }
        nbttaglist.add(nbttagcompound);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.t = item;
    }

    public IChatBaseComponent H() {
        IChatMutableComponent ichatmutablecomponent = new ChatComponentText("").a(this.w());
        if (this.y()) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(ichatmutablecomponent);
        if (!this.v) {
            ichatmutablecomponent1.a(this.A().e).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.b, new ChatHoverable.c(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean a(IRegistry<Block> blockRegistry, ShapeDetectorBlock pos) {
        if (this.y == null) {
            this.y = new AdventureModeCheck(n);
        }
        return this.y.a(this, blockRegistry, pos);
    }

    public boolean b(IRegistry<Block> blockRegistry, ShapeDetectorBlock pos) {
        if (this.x == null) {
            this.x = new AdventureModeCheck(m);
        }
        return this.x.a(this, blockRegistry, pos);
    }

    public int I() {
        return this.s;
    }

    public void d(int bobbingAnimationTime) {
        this.s = bobbingAnimationTime;
    }

    public int J() {
        return this.v ? 0 : this.r;
    }

    public void e(int count) {
        this.r = count;
        this.O();
    }

    public void f(int amount) {
        this.e(this.r + amount);
    }

    public void g(int amount) {
        this.f(-amount);
    }

    public void b(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        this.c().a(world, user, this, remainingUseTicks);
    }

    public void a(EntityItem entity) {
        this.c().a(entity);
    }

    public boolean K() {
        return this.c().v();
    }

    public SoundEffect L() {
        return this.c().Q_();
    }

    public SoundEffect M() {
        return this.c().h();
    }

    @Nullable
    public SoundEffect N() {
        return this.c().g();
    }

    public static enum HideFlags {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

        private final int h = 1 << this.ordinal();

        public int a() {
            return this.h;
        }
    }
}

