/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWaterLily;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.apache.logging.log4j.LogManager;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class ItemBlock
extends Item {
    private static final String b = "BlockEntityTag";
    public static final String a = "BlockStateTag";
    @Deprecated
    private final Block c;

    public ItemBlock(Block block, Item.Info settings) {
        super(settings);
        this.c = block;
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        EnumInteractionResult enuminteractionresult = this.a(new BlockActionContext(context));
        if (!enuminteractionresult.a() && this.v()) {
            EnumInteractionResult enuminteractionresult1 = this.a(context.q(), context.o(), context.p()).a();
            return enuminteractionresult1 == EnumInteractionResult.b ? EnumInteractionResult.c : enuminteractionresult1;
        }
        return enuminteractionresult;
    }

    public EnumInteractionResult a(BlockActionContext context) {
        CraftBlockState oldBlockstate;
        if (!context.b()) {
            return EnumInteractionResult.e;
        }
        BlockActionContext blockactioncontext1 = this.b(context);
        if (blockactioncontext1 == null) {
            return EnumInteractionResult.e;
        }
        IBlockData iblockdata = this.c(blockactioncontext1);
        CraftBlockState blockstate = null;
        if (this instanceof ItemWaterLily || this instanceof SolidBucketItem) {
            blockstate = CraftBlockStates.getBlockState(blockactioncontext1.q(), blockactioncontext1.a());
        }
        CraftBlockState craftBlockState = oldBlockstate = blockstate != null ? blockstate : CraftBlockStates.getBlockState(blockactioncontext1.q(), blockactioncontext1.a());
        if (iblockdata == null) {
            return EnumInteractionResult.e;
        }
        if (!this.a(blockactioncontext1, iblockdata)) {
            return EnumInteractionResult.e;
        }
        BlockPosition blockposition = blockactioncontext1.a();
        World world = blockactioncontext1.q();
        EntityHuman entityhuman = blockactioncontext1.o();
        ItemStack itemstack = blockactioncontext1.n();
        IBlockData iblockdata1 = world.a_(blockposition);
        if (iblockdata1.a(iblockdata.b())) {
            BlockPlaceEvent placeEvent;
            iblockdata1 = this.a(blockposition, world, itemstack, iblockdata1);
            try {
                this.a(blockposition, world, entityhuman, itemstack, iblockdata1);
            }
            catch (Exception e2) {
                oldBlockstate.update(true, false);
                if (entityhuman instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entityhuman;
                    LogManager.getLogger().error("Player {} tried placing invalid block", (Object)player.co(), (Object)e2);
                    player.getBukkitEntity().kickPlayer("Packet processing error");
                    return EnumInteractionResult.e;
                }
                throw e2;
            }
            iblockdata1.b().a(world, blockposition, iblockdata1, entityhuman, itemstack);
            if (blockstate != null && (placeEvent = CraftEventFactory.callBlockPlaceEvent((WorldServer)world, entityhuman, blockactioncontext1.p(), blockstate, blockposition.u(), blockposition.v(), blockposition.w())) != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                blockstate.update(true, false);
                if (this instanceof SolidBucketItem) {
                    ((EntityPlayer)entityhuman).b.a(new PacketPlayOutBlockChange(world, blockposition.c()));
                    ((EntityPlayer)entityhuman).getBukkitEntity().updateInventory();
                }
                return EnumInteractionResult.e;
            }
            if (entityhuman instanceof EntityPlayer) {
                CriterionTriggers.y.a((EntityPlayer)entityhuman, blockposition, itemstack);
            }
        }
        SoundEffectType soundeffecttype = iblockdata1.q();
        world.a((Entity)entityhuman, GameEvent.g, blockposition);
        if (!(entityhuman != null && entityhuman.fs().d || itemstack == ItemStack.b)) {
            itemstack.g(1);
        }
        return EnumInteractionResult.a(world.x);
    }

    protected SoundEffect a(IBlockData state) {
        return state.q().e();
    }

    @Nullable
    public BlockActionContext b(BlockActionContext context) {
        return context;
    }

    protected boolean a(BlockPosition pos, World world, @Nullable EntityHuman player, ItemStack stack, IBlockData state) {
        return ItemBlock.a(world, player, pos, stack);
    }

    @Nullable
    protected IBlockData c(BlockActionContext context) {
        IBlockData iblockdata = this.e().a(context);
        return iblockdata != null && this.b(context, iblockdata) ? iblockdata : null;
    }

    private IBlockData a(BlockPosition pos, World world, ItemStack stack, IBlockData state) {
        IBlockData iblockdata1 = state;
        NBTTagCompound nbttagcompound = stack.t();
        if (nbttagcompound != null) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.p(a);
            iblockdata1 = ItemBlock.getBlockState(iblockdata1, nbttagcompound1);
        }
        if (iblockdata1 != state) {
            world.a(pos, iblockdata1, 2);
        }
        return iblockdata1;
    }

    public static IBlockData getBlockState(IBlockData iblockdata, NBTTagCompound nbttagcompound1) {
        IBlockData iblockdata1 = iblockdata;
        BlockStateList<Block, IBlockData> blockstatelist = iblockdata.b().m();
        for (String s2 : nbttagcompound1.d()) {
            IBlockState<?> iblockstate = blockstatelist.a(s2);
            if (iblockstate == null) continue;
            String s1 = nbttagcompound1.c(s2).e_();
            iblockdata1 = ItemBlock.a(iblockdata1, iblockstate, s1);
        }
        return iblockdata1;
    }

    private static <T extends Comparable<T>> IBlockData a(IBlockData state, IBlockState<T> property, String name) {
        return property.b(name).map(comparable -> (IBlockData)state.a(property, comparable)).orElse(state);
    }

    protected boolean b(BlockActionContext context, IBlockData state) {
        EntityHuman entityhuman = context.o();
        VoxelShapeCollision voxelshapecollision = entityhuman == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entityhuman);
        World world = context.q();
        boolean defaultReturn = (!this.d() || state.a((IWorldReader)context.q(), context.a())) && world.checkEntityCollision(state, entityhuman, voxelshapecollision, context.a(), true);
        Player player = context.o() instanceof EntityPlayer ? (Player)context.o().getBukkitEntity() : null;
        BlockCanBuildEvent event = new BlockCanBuildEvent((org.bukkit.block.Block)CraftBlock.at(context.q(), context.a()), player, (BlockData)CraftBlockData.fromData(state), defaultReturn);
        context.q().getCraftServer().getPluginManager().callEvent((Event)event);
        return event.isBuildable();
    }

    protected boolean d() {
        return true;
    }

    protected boolean a(BlockActionContext context, IBlockData state) {
        return context.q().a(context.a(), state, 11);
    }

    public static boolean a(World world, @Nullable EntityHuman player, BlockPosition pos, ItemStack stack) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = world.n();
        if (minecraftserver == null) {
            return false;
        }
        NBTTagCompound nbttagcompound = ItemBlock.a(stack);
        if (nbttagcompound != null && (tileentity = world.c_(pos)) != null) {
            if (!(world.x || !tileentity.t() || player != null && (player.fN() || player.fs().d && player.getBukkitEntity().hasPermission("minecraft.nbt.place")))) {
                return false;
            }
            NBTTagCompound nbttagcompound1 = tileentity.o();
            NBTTagCompound nbttagcompound2 = nbttagcompound1.g();
            nbttagcompound1.a(nbttagcompound);
            if (!nbttagcompound1.equals(nbttagcompound2)) {
                tileentity.a(nbttagcompound1);
                tileentity.e();
                return true;
            }
        }
        return false;
    }

    @Override
    public String a() {
        return this.e().h();
    }

    @Override
    public void a(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.a(group)) {
            this.e().a(group, stacks);
        }
    }

    @Override
    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
        super.a(stack, world, tooltip, context);
        this.e().a(stack, (IBlockAccess)world, tooltip, context);
    }

    public Block e() {
        return this.c;
    }

    public void a(Map<Block, Item> map, Item item) {
        map.put(this.e(), item);
    }

    @Override
    public boolean R_() {
        return !(this.c instanceof BlockShulkerBox);
    }

    @Override
    public void a(EntityItem entity) {
        ItemStack itemstack;
        NBTTagCompound nbttagcompound;
        if (this.c instanceof BlockShulkerBox && (nbttagcompound = ItemBlock.a(itemstack = entity.h())) != null && nbttagcompound.b("Items", 9)) {
            NBTTagList nbttaglist = nbttagcompound.c("Items", 10);
            Stream stream = nbttaglist.stream();
            Objects.requireNonNull(NBTTagCompound.class);
            ItemLiquidUtil.a(entity, stream.map(NBTTagCompound.class::cast).map(ItemStack::a));
        }
    }

    @Nullable
    public static NBTTagCompound a(ItemStack stack) {
        return stack.b(b);
    }

    public static void a(ItemStack stack, TileEntityTypes<?> blockEntityType, NBTTagCompound tag) {
        if (tag.f()) {
            stack.c(b);
        } else {
            TileEntity.a(tag, blockEntityType);
            stack.a(b, tag);
        }
    }
}

