/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.ISourceBlock;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWearable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;

public class ItemArmor
extends Item
implements ItemWearable {
    private static final UUID[] e = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static final IDispenseBehavior a = new DispenseBehaviorItem(){

        @Override
        protected ItemStack a(ISourceBlock pointer, ItemStack stack) {
            return ItemArmor.a(pointer, stack) ? stack : super.a(pointer, stack);
        }
    };
    protected final EnumItemSlot b;
    private final int f;
    private final float g;
    protected final float c;
    protected final ArmorMaterial d;
    private final Multimap<AttributeBase, AttributeModifier> h;

    public static boolean a(ISourceBlock pointer, ItemStack armor) {
        BlockPosition blockposition = pointer.d().a(pointer.e().c(BlockDispenser.a));
        List<Entity> list = pointer.g().a(EntityLiving.class, new AxisAlignedBB(blockposition), IEntitySelector.f.and(new IEntitySelector.EntitySelectorEquipable(armor)));
        if (list.isEmpty()) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)list.get(0);
        EnumItemSlot enumitemslot = EntityInsentient.i(armor);
        ItemStack itemstack1 = armor.a(1);
        WorldServer world = pointer.g();
        Block block = world.getWorld().getBlockAt(pointer.d().u(), pointer.d().v(), pointer.d().w());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (org.bukkit.inventory.ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityliving.getBukkitEntity()));
        if (!BlockDispenser.eventFired) {
            world.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            armor.f(1);
            return false;
        }
        if (!event.getItem().equals((Object)craftItem)) {
            armor.f(1);
            ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior idispensebehavior = BlockDispenser.c.get(eventStack.c());
            if (idispensebehavior != IDispenseBehavior.b && idispensebehavior != a) {
                idispensebehavior.dispense(pointer, eventStack);
                return true;
            }
        }
        entityliving.a(enumitemslot, CraftItemStack.asNMSCopy(event.getItem()));
        if (entityliving instanceof EntityInsentient) {
            ((EntityInsentient)entityliving).a(enumitemslot, 2.0f);
            ((EntityInsentient)entityliving).fh();
        }
        return true;
    }

    public ItemArmor(ArmorMaterial material, EnumItemSlot slot, Item.Info settings) {
        super(settings.b(material.a(slot)));
        this.d = material;
        this.b = slot;
        this.f = material.b(slot);
        this.g = material.e();
        this.c = material.f();
        BlockDispenser.a(this, a);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = e[slot.b()];
        builder.put((Object)GenericAttributes.i, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.f, AttributeModifier.Operation.a));
        builder.put((Object)GenericAttributes.j, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.g, AttributeModifier.Operation.a));
        if (material == EnumArmorMaterial.g) {
            builder.put((Object)GenericAttributes.c, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.c, AttributeModifier.Operation.a));
        }
        this.h = builder.build();
    }

    public EnumItemSlot b() {
        return this.b;
    }

    @Override
    public int c() {
        return this.d.a();
    }

    public ArmorMaterial d() {
        return this.d;
    }

    @Override
    public boolean a(ItemStack stack, ItemStack ingredient) {
        return this.d.c().a(ingredient) || super.a(stack, ingredient);
    }

    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemstack = user.b(hand);
        EnumItemSlot enumitemslot = EntityInsentient.i(itemstack);
        ItemStack itemstack1 = user.b(enumitemslot);
        if (itemstack1.b()) {
            user.a(enumitemslot, itemstack.n());
            if (!world.k_()) {
                user.b(StatisticList.c.b(this));
            }
            itemstack.e(0);
            return InteractionResultWrapper.a(itemstack, world.k_());
        }
        return InteractionResultWrapper.d(itemstack);
    }

    @Override
    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot slot) {
        return slot == this.b ? this.h : super.a(slot);
    }

    public int e() {
        return this.f;
    }

    public float f() {
        return this.g;
    }

    @Override
    @Nullable
    public SoundEffect g() {
        return this.d().b();
    }
}

