/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements IMaterial {
    private static final Logger a = LogUtils.getLogger();
    public static final Map<Block, Item> k = Maps.newHashMap();
    protected static final UUID l = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID m = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    public static final int n = 64;
    public static final int o = 32;
    public static final int p = 13;
    private final Holder.c<Item> b = IRegistry.X.e(this);
    @Nullable
    protected final CreativeModeTab q;
    public final EnumItemRarity c;
    private final int d;
    private final int e;
    private final boolean f;
    @Nullable
    private final Item g;
    @Nullable
    private String h;
    @Nullable
    private final FoodInfo i;

    public static int a(Item item) {
        return item == null ? 0 : IRegistry.X.a(item);
    }

    public static Item b(int id) {
        return IRegistry.X.a(id);
    }

    @Deprecated
    public static Item a(Block block) {
        return k.getOrDefault(block, Items.a);
    }

    public Item(Info settings) {
        String string;
        this.q = settings.d;
        this.c = settings.e;
        this.g = settings.c;
        this.e = settings.b;
        this.d = settings.a;
        this.i = settings.f;
        this.f = settings.g;
        if (SharedConstants.aI && !(string = this.getClass().getSimpleName()).endsWith("Item")) {
            a.error("Item classes should end with Item and {} doesn't.", (Object)string);
        }
    }

    @Deprecated
    public Holder.c<Item> k() {
        return this.b;
    }

    public void a(World world, EntityLiving user, ItemStack stack, int remainingUseTicks) {
    }

    public void a(EntityItem entity) {
    }

    public void b(NBTTagCompound nbt) {
    }

    public boolean a(IBlockData state, World world, BlockPosition pos, EntityHuman miner) {
        return true;
    }

    @Override
    @Override
    public Item l() {
        return this;
    }

    public EnumInteractionResult a(ItemActionContext context) {
        return EnumInteractionResult.d;
    }

    public float a(ItemStack stack, IBlockData state) {
        return 1.0f;
    }

    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        if (this.v()) {
            ItemStack itemStack = user.b(hand);
            if (user.s(this.w().d())) {
                user.c(hand);
                return InteractionResultWrapper.b(itemStack);
            }
            return InteractionResultWrapper.d(itemStack);
        }
        return InteractionResultWrapper.c(user.b(hand));
    }

    public ItemStack a(ItemStack stack, World world, EntityLiving user) {
        if (this.v()) {
            return user.a(world, stack);
        }
        return stack;
    }

    public final int m() {
        return this.d;
    }

    public final int n() {
        return this.e;
    }

    public boolean o() {
        return this.e > 0;
    }

    public boolean e(ItemStack stack) {
        return stack.h();
    }

    public int f(ItemStack stack) {
        return Math.round(13.0f - (float)stack.i() * 13.0f / (float)this.e);
    }

    public int g(ItemStack stack) {
        float f2 = Math.max(0.0f, ((float)this.e - (float)stack.i()) / (float)this.e);
        return MathHelper.h(f2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player) {
        return false;
    }

    public boolean a(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return false;
    }

    public boolean a(ItemStack stack, EntityLiving target, EntityLiving attacker) {
        return false;
    }

    public boolean a(ItemStack stack, World world, IBlockData state, BlockPosition pos, EntityLiving miner) {
        return false;
    }

    public boolean a_(IBlockData state) {
        return false;
    }

    public EnumInteractionResult a(ItemStack stack, EntityHuman user, EntityLiving entity, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public IChatBaseComponent p() {
        return new ChatMessage(this.a());
    }

    @Override
    public String toString() {
        return IRegistry.X.b(this).a();
    }

    protected String q() {
        if (this.h == null) {
            this.h = SystemUtils.a("item", IRegistry.X.b(this));
        }
        return this.h;
    }

    public String a() {
        return this.q();
    }

    public String j(ItemStack stack) {
        return this.a();
    }

    public boolean r() {
        return true;
    }

    @Nullable
    public final Item s() {
        return this.g;
    }

    public boolean t() {
        return this.g != null;
    }

    public void a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
    }

    public void b(ItemStack stack, World world, EntityHuman player) {
    }

    public boolean O_() {
        return false;
    }

    public EnumAnimation c(ItemStack stack) {
        return stack.c().v() ? EnumAnimation.b : EnumAnimation.a;
    }

    public int b(ItemStack stack) {
        if (stack.c().v()) {
            return this.w().e() ? 16 : 32;
        }
        return 0;
    }

    public void a(ItemStack stack, World world, EntityLiving user, int remainingUseTicks) {
    }

    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
    }

    public Optional<TooltipComponent> h(ItemStack stack) {
        return Optional.empty();
    }

    public IChatBaseComponent m(ItemStack stack) {
        return new ChatMessage(this.j(stack));
    }

    public boolean i(ItemStack stack) {
        return stack.C();
    }

    public EnumItemRarity n(ItemStack stack) {
        if (!stack.C()) {
            return this.c;
        }
        switch (this.c) {
            case a: 
            case b: {
                return EnumItemRarity.c;
            }
            case c: {
                return EnumItemRarity.d;
            }
        }
        return this.c;
    }

    public boolean c_(ItemStack stack) {
        return this.m() == 1 && this.o();
    }

    protected static MovingObjectPositionBlock a(World world, EntityHuman player, RayTrace.FluidCollisionOption fluidHandling) {
        float f2 = player.do();
        float g2 = player.dn();
        Vec3D vec3 = player.bg();
        float h2 = MathHelper.b(-g2 * ((float)Math.PI / 180) - (float)Math.PI);
        float i2 = MathHelper.a(-g2 * ((float)Math.PI / 180) - (float)Math.PI);
        float j2 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float k2 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        float l2 = i2 * j2;
        float m2 = k2;
        float n2 = h2 * j2;
        double d2 = 5.0;
        Vec3D vec32 = vec3.b((double)l2 * 5.0, (double)m2 * 5.0, (double)n2 * 5.0);
        return world.a(new RayTrace(vec3, vec32, RayTrace.BlockCollisionOption.b, fluidHandling, player));
    }

    public int c() {
        return 0;
    }

    public void a(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.a(group)) {
            stacks.add(new ItemStack(this));
        }
    }

    protected boolean a(CreativeModeTab group) {
        CreativeModeTab creativeModeTab = this.u();
        return creativeModeTab != null && (group == CreativeModeTab.g || group == creativeModeTab);
    }

    @Nullable
    public final CreativeModeTab u() {
        return this.q;
    }

    public boolean a(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot slot) {
        return ImmutableMultimap.of();
    }

    public boolean l(ItemStack stack) {
        return false;
    }

    public ItemStack P_() {
        return new ItemStack(this);
    }

    public boolean v() {
        return this.i != null;
    }

    @Nullable
    public FoodInfo w() {
        return this.i;
    }

    public SoundEffect Q_() {
        return SoundEffects.gK;
    }

    public SoundEffect h() {
        return SoundEffects.gL;
    }

    public boolean x() {
        return this.f;
    }

    public boolean a(DamageSource source) {
        return !this.f || !source.s();
    }

    @Nullable
    public SoundEffect g() {
        return null;
    }

    public boolean R_() {
        return true;
    }

    public static class Info {
        int a = 64;
        int b;
        @Nullable
        Item c;
        @Nullable
        CreativeModeTab d;
        EnumItemRarity e = EnumItemRarity.a;
        @Nullable
        FoodInfo f;
        boolean g;

        public Info a(FoodInfo foodComponent) {
            this.f = foodComponent;
            return this;
        }

        public Info a(int maxCount) {
            if (this.b > 0) {
                throw new RuntimeException("Unable to have damage AND stack.");
            }
            this.a = maxCount;
            return this;
        }

        public Info b(int maxDamage) {
            return this.b == 0 ? this.c(maxDamage) : this;
        }

        public Info c(int maxDamage) {
            this.b = maxDamage;
            this.a = 1;
            return this;
        }

        public Info a(Item recipeRemainder) {
            this.c = recipeRemainder;
            return this;
        }

        public Info a(CreativeModeTab group) {
            this.d = group;
            return this;
        }

        public Info a(EnumItemRarity rarity) {
            this.e = rarity;
            return this;
        }

        public Info a() {
            this.g = true;
            return this;
        }
    }
}

