/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;

public class BundleItem
extends Item {
    private static final String b = "Items";
    public static final int a = 64;
    private static final int c = 4;
    private static final int d = MathHelper.f(0.4f, 0.4f, 1.0f);

    public BundleItem(Item.Info settings) {
        super(settings);
    }

    public static float d(ItemStack stack) {
        return (float)BundleItem.o(stack) / 64.0f;
    }

    @Override
    @Override
    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player) {
        if (clickType != ClickAction.b) {
            return false;
        }
        ItemStack itemStack = slot.e();
        if (itemStack.b()) {
            this.a(player);
            BundleItem.p(stack).ifPresent(removedStack -> BundleItem.b(stack, slot.e((ItemStack)removedStack)));
        } else if (itemStack.c().R_()) {
            int i2 = (64 - BundleItem.o(stack)) / BundleItem.k(itemStack);
            int j2 = BundleItem.b(stack, slot.b(itemStack.J(), i2, player));
            if (j2 > 0) {
                this.b(player);
            }
        }
        return true;
    }

    @Override
    @Override
    public boolean a(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        if (clickType != ClickAction.b || !slot.b(player)) {
            return false;
        }
        if (otherStack.b()) {
            BundleItem.p(stack).ifPresent(itemStack -> {
                this.a(player);
                cursorStackReference.a((ItemStack)itemStack);
            });
        } else {
            int i2 = BundleItem.b(stack, otherStack);
            if (i2 > 0) {
                this.b(player);
                otherStack.g(i2);
            }
        }
        return true;
    }

    @Override
    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemStack = user.b(hand);
        if (BundleItem.a(itemStack, user)) {
            this.c(user);
            user.b(StatisticList.c.b(this));
            return InteractionResultWrapper.a(itemStack, world.k_());
        }
        return InteractionResultWrapper.d(itemStack);
    }

    @Override
    @Override
    public boolean e(ItemStack stack) {
        return BundleItem.o(stack) > 0;
    }

    @Override
    @Override
    public int f(ItemStack stack) {
        return Math.min(1 + 12 * BundleItem.o(stack) / 64, 13);
    }

    @Override
    @Override
    public int g(ItemStack stack) {
        return d;
    }

    private static int b(ItemStack bundle, ItemStack stack) {
        if (stack.b() || !stack.c().R_()) {
            return 0;
        }
        NBTTagCompound compoundTag = bundle.u();
        if (!compoundTag.e(b)) {
            compoundTag.a(b, new NBTTagList());
        }
        int i2 = BundleItem.o(bundle);
        int j2 = BundleItem.k(stack);
        int k2 = Math.min(stack.J(), (64 - i2) / j2);
        if (k2 == 0) {
            return 0;
        }
        NBTTagList listTag = compoundTag.c(b, 10);
        Optional<NBTTagCompound> optional = BundleItem.a(stack, listTag);
        if (optional.isPresent()) {
            NBTTagCompound compoundTag2 = optional.get();
            ItemStack itemStack = ItemStack.a(compoundTag2);
            itemStack.f(k2);
            itemStack.b(compoundTag2);
            listTag.remove(compoundTag2);
            listTag.c(0, compoundTag2);
        } else {
            ItemStack itemStack2 = stack.n();
            itemStack2.e(k2);
            NBTTagCompound compoundTag3 = new NBTTagCompound();
            itemStack2.b(compoundTag3);
            listTag.c(0, compoundTag3);
        }
        return k2;
    }

    private static Optional<NBTTagCompound> a(ItemStack stack, NBTTagList items) {
        if (stack.a(Items.oq)) {
            return Optional.empty();
        }
        return items.stream().filter(NBTTagCompound.class::isInstance).map(NBTTagCompound.class::cast).filter(item -> ItemStack.e(ItemStack.a(item), stack)).findFirst();
    }

    private static int k(ItemStack stack) {
        NBTTagCompound compoundTag;
        if (stack.a(Items.oq)) {
            return 4 + BundleItem.o(stack);
        }
        if ((stack.a(Items.tv) || stack.a(Items.tu)) && stack.s() && (compoundTag = ItemBlock.a(stack)) != null && !compoundTag.c("Bees", 10).isEmpty()) {
            return 64;
        }
        return 64 / stack.e();
    }

    private static int o(ItemStack stack) {
        return BundleItem.q(stack).mapToInt(itemStack -> BundleItem.k(itemStack) * itemStack.J()).sum();
    }

    private static Optional<ItemStack> p(ItemStack stack) {
        NBTTagCompound compoundTag = stack.u();
        if (!compoundTag.e(b)) {
            return Optional.empty();
        }
        NBTTagList listTag = compoundTag.c(b, 10);
        if (listTag.isEmpty()) {
            return Optional.empty();
        }
        boolean i2 = false;
        NBTTagCompound compoundTag2 = listTag.a(0);
        ItemStack itemStack = ItemStack.a(compoundTag2);
        listTag.c(0);
        if (listTag.isEmpty()) {
            stack.c(b);
        }
        return Optional.of(itemStack);
    }

    private static boolean a(ItemStack stack, EntityHuman player) {
        NBTTagCompound compoundTag = stack.u();
        if (!compoundTag.e(b)) {
            return false;
        }
        if (player instanceof EntityPlayer) {
            NBTTagList listTag = compoundTag.c(b, 10);
            for (int i2 = 0; i2 < listTag.size(); ++i2) {
                NBTTagCompound compoundTag2 = listTag.a(i2);
                ItemStack itemStack = ItemStack.a(compoundTag2);
                player.a(itemStack, true);
            }
        }
        stack.c(b);
        return true;
    }

    private static Stream<ItemStack> q(ItemStack stack) {
        NBTTagCompound compoundTag = stack.t();
        if (compoundTag == null) {
            return Stream.empty();
        }
        NBTTagList listTag = compoundTag.c(b, 10);
        return listTag.stream().map(NBTTagCompound.class::cast).map(ItemStack::a);
    }

    @Override
    @Override
    public Optional<TooltipComponent> h(ItemStack stack) {
        NonNullList<ItemStack> nonNullList = NonNullList.a();
        BundleItem.q(stack).forEach(nonNullList::add);
        return Optional.of(new BundleTooltip(nonNullList, BundleItem.o(stack)));
    }

    @Override
    @Override
    public void a(ItemStack stack, World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
        tooltip.add(new ChatMessage("item.minecraft.bundle.fullness", BundleItem.o(stack), 64).a(EnumChatFormat.h));
    }

    @Override
    @Override
    public void a(EntityItem entity) {
        ItemLiquidUtil.a(entity, BundleItem.q(entity.h()));
    }

    private void a(Entity entity) {
        entity.a(SoundEffects.cf, 0.8f, 0.8f + entity.W().r_().nextFloat() * 0.4f);
    }

    private void b(Entity entity) {
        entity.a(SoundEffects.ce, 0.8f, 0.8f + entity.W().r_().nextFloat() * 0.4f);
    }

    private void c(Entity entity) {
        entity.a(SoundEffects.cd, 0.8f, 0.8f + entity.W().r_().nextFloat() * 0.4f);
    }
}

