/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public abstract class Container {
    private static Logger k = LogUtils.getLogger();
    public static final int a = -999;
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 0;
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = Integer.MAX_VALUE;
    public NonNullList<net.minecraft.world.item.ItemStack> l = NonNullList.a();
    public NonNullList<Slot> i = NonNullList.a();
    public List<ContainerProperty> m = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack n = net.minecraft.world.item.ItemStack.b;
    public NonNullList<net.minecraft.world.item.ItemStack> o = NonNullList.a();
    public IntList p = new IntArrayList();
    private net.minecraft.world.item.ItemStack q = net.minecraft.world.item.ItemStack.b;
    private int r;
    @Nullable
    private final Containers<?> s;
    public final int j;
    private int t = -1;
    private int u;
    private final Set<Slot> v = Sets.newHashSet();
    private final List<ICrafting> w = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer x;
    private boolean y;
    public boolean checkReachable = true;
    private IChatBaseComponent title;

    public abstract InventoryView getBukkitView();

    public void transferTo(Container other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final IChatBaseComponent getTitle() {
        if (this.title == null) {
            return new ChatComponentText("");
        }
        return this.title;
    }

    public final void setTitle(IChatBaseComponent title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    protected Container(@Nullable Containers<?> type, int syncId) {
        this.s = type;
        this.j = syncId;
    }

    protected static boolean a(ContainerAccess context, EntityHuman player, Block block) {
        return context.a((World world, BlockPosition blockposition) -> !world.a_((BlockPosition)blockposition).a(block) ? false : player.h((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5) <= 64.0, true);
    }

    public Containers<?> a() {
        if (this.s == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.s;
    }

    protected static void a(IInventory inventory, int expectedSize) {
        int j2 = inventory.b();
        if (j2 < expectedSize) {
            throw new IllegalArgumentException("Container size " + j2 + " is smaller than expected " + expectedSize);
        }
    }

    protected static void a(IContainerProperties data, int expectedCount) {
        int j2 = data.a();
        if (j2 < expectedCount) {
            throw new IllegalArgumentException("Container data count " + j2 + " is smaller than expected " + expectedCount);
        }
    }

    public boolean a(int slot) {
        return slot == -1 || slot == -999 || slot < this.i.size();
    }

    protected Slot a(Slot slot) {
        slot.d = this.i.size();
        this.i.add(slot);
        this.l.add(net.minecraft.world.item.ItemStack.b);
        this.o.add(net.minecraft.world.item.ItemStack.b);
        return slot;
    }

    protected ContainerProperty a(ContainerProperty property) {
        this.m.add(property);
        this.p.add(0);
        return property;
    }

    protected void a(IContainerProperties propertyDelegate) {
        for (int i2 = 0; i2 < propertyDelegate.a(); ++i2) {
            this.a(ContainerProperty.a(propertyDelegate, i2));
        }
    }

    public void a(ICrafting listener) {
        if (!this.w.contains(listener)) {
            this.w.add(listener);
            this.d();
        }
    }

    public void a(ContainerSynchronizer handler) {
        this.x = handler;
        this.b();
    }

    public void b() {
        int i2;
        int j2 = this.i.size();
        for (i2 = 0; i2 < j2; ++i2) {
            this.o.set(i2, this.i.get(i2).e().n());
        }
        this.q = this.g().n();
        j2 = this.m.size();
        for (i2 = 0; i2 < j2; ++i2) {
            this.p.set(i2, this.m.get(i2).b());
        }
        if (this.x != null) {
            this.x.a(this, this.o, this.q, this.p.toIntArray());
        }
    }

    public void broadcastCarriedItem() {
        this.q = this.g().n();
        if (this.x != null) {
            this.x.a(this, this.q);
        }
    }

    public void b(ICrafting listener) {
        this.w.remove(listener);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> c() {
        NonNullList<net.minecraft.world.item.ItemStack> nonnulllist = NonNullList.a();
        for (Slot slot : this.i) {
            nonnulllist.add(slot.e());
        }
        return nonnulllist;
    }

    public void d() {
        int i2;
        for (i2 = 0; i2 < this.i.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.i.get(i2).e();
            Objects.requireNonNull(itemstack);
            com.google.common.base.Supplier supplier = Suppliers.memoize(itemstack::n);
            this.a(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.b(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
        }
        this.l();
        for (i2 = 0; i2 < this.m.size(); ++i2) {
            ContainerProperty containerproperty = this.m.get(i2);
            int j2 = containerproperty.b();
            if (containerproperty.c()) {
                this.c(i2, j2);
            }
            this.d(i2, j2);
        }
    }

    public void e() {
        int i2;
        for (i2 = 0; i2 < this.i.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.i.get(i2).e();
            Objects.requireNonNull(itemstack);
            this.a(i2, itemstack, itemstack::n);
        }
        for (i2 = 0; i2 < this.m.size(); ++i2) {
            ContainerProperty containerproperty = this.m.get(i2);
            if (!containerproperty.c()) continue;
            this.c(i2, containerproperty.b());
        }
        this.b();
    }

    private void c(int index, int value) {
        for (ICrafting icrafting : this.w) {
            icrafting.a(this, index, value);
        }
    }

    private void a(int slot, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> copySupplier) {
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(slot);
        if (!net.minecraft.world.item.ItemStack.b(itemstack1, stack)) {
            net.minecraft.world.item.ItemStack itemstack2 = copySupplier.get();
            this.l.set(slot, itemstack2);
            for (ICrafting icrafting : this.w) {
                icrafting.a(this, slot, itemstack2);
            }
        }
    }

    private void b(int slot, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> copySupplier) {
        net.minecraft.world.item.ItemStack itemstack1;
        if (!this.y && !net.minecraft.world.item.ItemStack.b(itemstack1 = this.o.get(slot), stack)) {
            net.minecraft.world.item.ItemStack itemstack2 = copySupplier.get();
            this.o.set(slot, itemstack2);
            if (this.x != null) {
                this.x.a(this, slot, itemstack2);
            }
        }
    }

    private void d(int id, int value) {
        int k2;
        if (!this.y && (k2 = this.p.getInt(id)) != value) {
            this.p.set(id, value);
            if (this.x != null) {
                this.x.a(this, id, value);
            }
        }
    }

    private void l() {
        if (!this.y && !net.minecraft.world.item.ItemStack.b(this.g(), this.q)) {
            this.q = this.g().n();
            if (this.x != null) {
                this.x.a(this, this.q);
            }
        }
    }

    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        this.o.set(slot, stack.n());
    }

    public void b(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot >= 0 && slot < this.o.size()) {
            this.o.set(slot, stack);
        } else {
            k.debug("Incorrect slot index: {} available slots: {}", (Object)slot, (Object)this.o.size());
        }
    }

    public void a(net.minecraft.world.item.ItemStack stack) {
        this.q = stack.n();
    }

    public boolean a(EntityHuman player, int id) {
        return false;
    }

    public Slot b(int index) {
        return this.i.get(index);
    }

    public net.minecraft.world.item.ItemStack b(EntityHuman player, int index) {
        return this.i.get(index).e();
    }

    public void a(int slotIndex, int button, InventoryClickType actionType, EntityHuman player) {
        try {
            this.b(slotIndex, button, actionType, player);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.a(exception, "Container click");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Click info");
            crashreportsystemdetails.a("Menu Type", () -> this.s != null ? IRegistry.ag.b(this.s).toString() : "<no type>");
            crashreportsystemdetails.a("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportsystemdetails.a("Slot Count", this.i.size());
            crashreportsystemdetails.a("Slot", slotIndex);
            crashreportsystemdetails.a("Button", button);
            crashreportsystemdetails.a("Type", (Object)actionType);
            throw new ReportedException(crashreport);
        }
    }

    private void b(int slotIndex, int button, InventoryClickType actionType, EntityHuman player) {
        block43: {
            block55: {
                block51: {
                    net.minecraft.world.item.ItemStack itemstack;
                    net.minecraft.world.item.ItemStack itemstack1;
                    Slot slot2;
                    PlayerInventory playerinventory;
                    block54: {
                        block53: {
                            block52: {
                                block48: {
                                    ClickAction clickaction;
                                    block50: {
                                        block49: {
                                            block47: {
                                                block41: {
                                                    block46: {
                                                        net.minecraft.world.item.ItemStack itemstack2;
                                                        block45: {
                                                            block44: {
                                                                block42: {
                                                                    playerinventory = player.fr();
                                                                    if (actionType != InventoryClickType.f) break block41;
                                                                    int i1 = this.u;
                                                                    this.u = Container.d(button);
                                                                    if (i1 == 1 && this.u == 2 || i1 == this.u) break block42;
                                                                    this.f();
                                                                    break block43;
                                                                }
                                                                if (!this.g().b()) break block44;
                                                                this.f();
                                                                break block43;
                                                            }
                                                            if (this.u != 0) break block45;
                                                            this.t = Container.c(button);
                                                            if (Container.a(this.t, player)) {
                                                                this.u = 1;
                                                                this.v.clear();
                                                            } else {
                                                                this.f();
                                                            }
                                                            break block43;
                                                        }
                                                        if (this.u != 1) break block46;
                                                        Slot slot = slotIndex < this.i.size() ? this.i.get(slotIndex) : null;
                                                        if (!Container.a(slot, itemstack2 = this.g(), true) || !slot.a(itemstack2) || this.t != 2 && itemstack2.J() <= this.v.size() || !this.b(slot)) break block43;
                                                        this.v.add(slot);
                                                        break block43;
                                                    }
                                                    if (this.u == 2) {
                                                        if (!this.v.isEmpty()) {
                                                            boolean needsUpdate;
                                                            net.minecraft.world.item.ItemStack itemstack12 = this.g().n();
                                                            int l2 = this.g().J();
                                                            Iterator<Slot> iterator = this.v.iterator();
                                                            HashMap<Integer, net.minecraft.world.item.ItemStack> draggedSlots = new HashMap<Integer, net.minecraft.world.item.ItemStack>();
                                                            while (iterator.hasNext()) {
                                                                Slot slot1 = iterator.next();
                                                                net.minecraft.world.item.ItemStack itemstack2 = this.g();
                                                                if (slot1 == null || !Container.a(slot1, itemstack2, true) || !slot1.a(itemstack2) || this.t != 2 && itemstack2.J() < this.v.size() || !this.b(slot1)) continue;
                                                                net.minecraft.world.item.ItemStack itemstack3 = itemstack12.n();
                                                                int j1 = slot1.f() ? slot1.e().J() : 0;
                                                                Container.a(this.v, this.t, itemstack3, j1);
                                                                int k1 = Math.min(itemstack3.e(), slot1.a_(itemstack3));
                                                                if (itemstack3.J() > k1) {
                                                                    itemstack3.e(k1);
                                                                }
                                                                l2 -= itemstack3.J() - j1;
                                                                draggedSlots.put(slot1.d, itemstack3);
                                                            }
                                                            InventoryView view = this.getBukkitView();
                                                            CraftItemStack newcursor = CraftItemStack.asCraftMirror(itemstack12);
                                                            newcursor.setAmount(l2);
                                                            HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                                                            for (Map.Entry ditem : draggedSlots.entrySet()) {
                                                                eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ditem.getValue()));
                                                            }
                                                            net.minecraft.world.item.ItemStack oldCursor = this.g();
                                                            this.b(CraftItemStack.asNMSCopy(newcursor));
                                                            InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy(oldCursor), this.t == 1, eventmap);
                                                            player.s.getCraftServer().getPluginManager().callEvent((Event)event);
                                                            boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                                                            if (event.getResult() != Event.Result.DENY) {
                                                                for (Map.Entry dslot : draggedSlots.entrySet()) {
                                                                    view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)dslot.getValue()));
                                                                }
                                                                if (this.g() != null) {
                                                                    this.b(CraftItemStack.asNMSCopy(event.getCursor()));
                                                                    needsUpdate = true;
                                                                }
                                                            } else {
                                                                this.b(oldCursor);
                                                            }
                                                            if (needsUpdate && player instanceof EntityPlayer) {
                                                                this.b();
                                                            }
                                                        }
                                                        this.f();
                                                    } else {
                                                        this.f();
                                                    }
                                                    break block43;
                                                }
                                                if (this.u == 0) break block47;
                                                this.f();
                                                break block43;
                                            }
                                            if (actionType != InventoryClickType.a && actionType != InventoryClickType.b || button != 0 && button != 1) break block48;
                                            ClickAction clickAction = clickaction = button == 0 ? ClickAction.a : ClickAction.b;
                                            if (slotIndex != -999) break block49;
                                            if (this.g().b()) break block43;
                                            if (clickaction == ClickAction.a) {
                                                net.minecraft.world.item.ItemStack carried = this.g();
                                                this.b(net.minecraft.world.item.ItemStack.b);
                                                player.a(carried, true);
                                            } else {
                                                player.a(this.g().a(1), true);
                                            }
                                            break block43;
                                        }
                                        if (actionType != InventoryClickType.b) break block50;
                                        if (slotIndex < 0) {
                                            return;
                                        }
                                        Slot slot = this.i.get(slotIndex);
                                        if (!slot.a(player)) {
                                            return;
                                        }
                                        net.minecraft.world.item.ItemStack itemstack3 = this.b(player, slotIndex);
                                        while (!itemstack3.b() && net.minecraft.world.item.ItemStack.c(slot.e(), itemstack3)) {
                                            itemstack3 = this.b(player, slotIndex);
                                        }
                                        break block43;
                                    }
                                    if (slotIndex < 0) {
                                        return;
                                    }
                                    Slot slot = this.i.get(slotIndex);
                                    net.minecraft.world.item.ItemStack itemstack4 = slot.e();
                                    net.minecraft.world.item.ItemStack itemstack42 = this.g();
                                    player.a(itemstack42, slot.e(), clickaction);
                                    if (!itemstack42.a(slot, clickaction, player) && !itemstack4.a(itemstack42, slot, clickaction, player, this.m())) {
                                        if (itemstack4.b()) {
                                            if (!itemstack42.b()) {
                                                int l1 = clickaction == ClickAction.a ? itemstack42.J() : 1;
                                                this.b(slot.b(itemstack42, l1));
                                            }
                                        } else if (slot.a(player)) {
                                            if (itemstack42.b()) {
                                                int l1 = clickaction == ClickAction.a ? itemstack4.J() : (itemstack4.J() + 1) / 2;
                                                Optional<net.minecraft.world.item.ItemStack> optional = slot.a(l1, Integer.MAX_VALUE, player);
                                                optional.ifPresent(itemstack5 -> {
                                                    this.b((net.minecraft.world.item.ItemStack)itemstack5);
                                                    slot.a(player, (net.minecraft.world.item.ItemStack)itemstack5);
                                                });
                                            } else if (slot.a(itemstack42)) {
                                                if (net.minecraft.world.item.ItemStack.e(itemstack4, itemstack42)) {
                                                    int l1 = clickaction == ClickAction.a ? itemstack42.J() : 1;
                                                    this.b(slot.b(itemstack42, l1));
                                                } else if (itemstack42.J() <= slot.a_(itemstack42)) {
                                                    slot.d(itemstack42);
                                                    this.b(itemstack4);
                                                }
                                            } else if (net.minecraft.world.item.ItemStack.e(itemstack4, itemstack42)) {
                                                Optional<net.minecraft.world.item.ItemStack> optional1 = slot.a(itemstack4.J(), itemstack42.e() - itemstack42.J(), player);
                                                optional1.ifPresent(itemstack5 -> {
                                                    itemstack42.f(itemstack5.J());
                                                    slot.a(player, (net.minecraft.world.item.ItemStack)itemstack5);
                                                });
                                            }
                                        }
                                    }
                                    slot.d();
                                    if (!(player instanceof EntityPlayer) || slot.a() == 64) break block43;
                                    ((EntityPlayer)player).b.a(new PacketPlayOutSetSlot(this.j, this.k(), slot.d, slot.e()));
                                    if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                        ((EntityPlayer)player).b.a(new PacketPlayOutSetSlot(this.j, this.k(), 0, this.b(0).e()));
                                    }
                                    break block43;
                                }
                                if (actionType != InventoryClickType.c) break block51;
                                slot2 = this.i.get(slotIndex);
                                itemstack1 = playerinventory.a(button);
                                itemstack = slot2.e();
                                if (itemstack1.b() && itemstack.b()) break block43;
                                if (!itemstack1.b()) break block52;
                                if (!slot2.a(player)) break block43;
                                playerinventory.a(button, itemstack);
                                slot2.b(itemstack.J());
                                slot2.d(net.minecraft.world.item.ItemStack.b);
                                slot2.a(player, itemstack);
                                break block43;
                            }
                            if (!itemstack.b()) break block53;
                            if (!slot2.a(itemstack1)) break block43;
                            int i2 = slot2.a_(itemstack1);
                            if (itemstack1.J() > i2) {
                                slot2.d(itemstack1.a(i2));
                            } else {
                                playerinventory.a(button, net.minecraft.world.item.ItemStack.b);
                                slot2.d(itemstack1);
                            }
                            break block43;
                        }
                        if (!slot2.a(player) || !slot2.a(itemstack1)) break block43;
                        int i2 = slot2.a_(itemstack1);
                        if (itemstack1.J() <= i2) break block54;
                        slot2.d(itemstack1.a(i2));
                        slot2.a(player, itemstack);
                        if (playerinventory.e(itemstack)) break block43;
                        player.a(itemstack, true);
                        break block43;
                    }
                    playerinventory.a(button, itemstack);
                    slot2.d(itemstack1);
                    slot2.a(player, itemstack);
                    break block43;
                }
                if (actionType != InventoryClickType.d || !player.fs().d || !this.g().b() || slotIndex < 0) break block55;
                Slot slot2 = this.i.get(slotIndex);
                if (!slot2.f()) break block43;
                net.minecraft.world.item.ItemStack itemstack1 = slot2.e().n();
                itemstack1.e(itemstack1.e());
                this.b(itemstack1);
                break block43;
            }
            if (actionType == InventoryClickType.e && this.g().b() && slotIndex >= 0) {
                Slot slot2 = this.i.get(slotIndex);
                int k2 = button == 0 ? 1 : slot2.e().J();
                net.minecraft.world.item.ItemStack itemstack = slot2.b(k2, Integer.MAX_VALUE, player);
                player.a(itemstack, true);
            } else if (actionType == InventoryClickType.g && slotIndex >= 0) {
                Slot slot2 = this.i.get(slotIndex);
                net.minecraft.world.item.ItemStack itemstack1 = this.g();
                if (!(itemstack1.b() || slot2.f() && slot2.a(player))) {
                    int l3 = button == 0 ? 0 : this.i.size() - 1;
                    int i2 = button == 0 ? 1 : -1;
                    for (int l1 = 0; l1 < 2; ++l1) {
                        for (int j2 = l3; j2 >= 0 && j2 < this.i.size() && itemstack1.J() < itemstack1.e(); j2 += i2) {
                            Slot slot3 = this.i.get(j2);
                            if (!slot3.f() || !Container.a(slot3, itemstack1, true) || !slot3.a(player) || !this.a(itemstack1, slot3)) continue;
                            net.minecraft.world.item.ItemStack itemstack52 = slot3.e();
                            if (l1 == 0 && itemstack52.J() == itemstack52.e()) continue;
                            net.minecraft.world.item.ItemStack itemstack6 = slot3.b(itemstack52.J(), itemstack1.e() - itemstack1.J(), player);
                            itemstack1.f(itemstack6.J());
                        }
                    }
                }
            }
        }
    }

    private SlotAccess m() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack a() {
                return Container.this.g();
            }

            @Override
            public boolean a(net.minecraft.world.item.ItemStack stack) {
                Container.this.b(stack);
                return true;
            }
        };
    }

    public boolean a(net.minecraft.world.item.ItemStack stack, Slot slot) {
        return true;
    }

    public void b(EntityHuman player) {
        net.minecraft.world.item.ItemStack itemstack;
        if (player instanceof EntityPlayer && !(itemstack = this.g()).b()) {
            this.b(net.minecraft.world.item.ItemStack.b);
            if (player.bl() && !((EntityPlayer)player).t()) {
                player.fr().f(itemstack);
            } else {
                player.a(itemstack, false);
            }
        }
    }

    protected void a(EntityHuman player, IInventory inventory) {
        if (!(!player.bl() || player instanceof EntityPlayer && ((EntityPlayer)player).t())) {
            for (int i2 = 0; i2 < inventory.b(); ++i2) {
                PlayerInventory playerinventory = player.fr();
                if (!(playerinventory.l instanceof EntityPlayer)) continue;
                playerinventory.f(inventory.b(i2));
            }
        } else {
            for (int i3 = 0; i3 < inventory.b(); ++i3) {
                player.a(inventory.b(i3), false);
            }
        }
    }

    public void a(IInventory inventory) {
        this.d();
    }

    public void a(int slot, int revision, net.minecraft.world.item.ItemStack stack) {
        this.b(slot).d(stack);
        this.r = revision;
    }

    public void a(int revision, List<net.minecraft.world.item.ItemStack> stacks, net.minecraft.world.item.ItemStack cursorStack) {
        for (int j2 = 0; j2 < stacks.size(); ++j2) {
            this.b(j2).d(stacks.get(j2));
        }
        this.n = cursorStack;
        this.r = revision;
    }

    public void a(int id, int value) {
        this.m.get(id).a(value);
    }

    public abstract boolean a(EntityHuman var1);

    protected boolean a(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        return this.moveItemStackTo(stack, startIndex, endIndex, fromLast, false);
    }

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean fromLast, boolean isCheck) {
        net.minecraft.world.item.ItemStack itemstack1;
        Slot slot;
        if (isCheck) {
            stack = stack.n();
        }
        boolean flag1 = false;
        int k2 = startIndex;
        if (fromLast) {
            k2 = endIndex - 1;
        }
        if (stack.f()) {
            while (!stack.b() && !(fromLast ? k2 < startIndex : k2 >= endIndex)) {
                slot = this.i.get(k2);
                itemstack1 = slot.e();
                if (isCheck) {
                    itemstack1 = itemstack1.n();
                }
                if (!itemstack1.b() && net.minecraft.world.item.ItemStack.e(stack, itemstack1)) {
                    int l2 = itemstack1.J() + stack.J();
                    if (l2 <= stack.e()) {
                        stack.e(0);
                        itemstack1.e(l2);
                        if (!isCheck) {
                            slot.d();
                        }
                        flag1 = true;
                    } else if (itemstack1.J() < stack.e()) {
                        stack.g(stack.e() - itemstack1.J());
                        itemstack1.e(stack.e());
                        if (!isCheck) {
                            slot.d();
                        }
                        flag1 = true;
                    }
                }
                if (fromLast) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        if (!stack.b()) {
            k2 = fromLast ? endIndex - 1 : startIndex;
            while (!(fromLast ? k2 < startIndex : k2 >= endIndex)) {
                slot = this.i.get(k2);
                itemstack1 = slot.e();
                if (isCheck) {
                    itemstack1 = itemstack1.n();
                }
                if (itemstack1.b() && slot.a(stack)) {
                    if (stack.J() > slot.a()) {
                        if (isCheck) {
                            stack.g(slot.a());
                        } else {
                            slot.d(stack.a(slot.a()));
                        }
                    } else if (isCheck) {
                        stack.g(stack.J());
                    } else {
                        slot.d(stack.a(stack.J()));
                    }
                    if (!isCheck) {
                        slot.d();
                    }
                    flag1 = true;
                    break;
                }
                if (fromLast) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        return flag1;
    }

    public static int c(int quickCraftData) {
        return quickCraftData >> 2 & 3;
    }

    public static int d(int quickCraftData) {
        return quickCraftData & 3;
    }

    public static int b(int quickCraftStage, int buttonId) {
        return quickCraftStage & 3 | (buttonId & 3) << 2;
    }

    public static boolean a(int stage, EntityHuman player) {
        return stage == 0 ? true : (stage == 1 ? true : stage == 2 && player.fs().d);
    }

    protected void f() {
        this.u = 0;
        this.v.clear();
    }

    public static boolean a(@Nullable Slot slot, net.minecraft.world.item.ItemStack stack, boolean allowOverflow) {
        boolean flag1;
        boolean bl = flag1 = slot == null || !slot.f();
        return !flag1 && net.minecraft.world.item.ItemStack.e(stack, slot.e()) ? slot.e().J() + (allowOverflow ? 0 : stack.J()) <= stack.e() : flag1;
    }

    public static void a(Set<Slot> slots, int mode, net.minecraft.world.item.ItemStack stack, int stackSize) {
        switch (mode) {
            case 0: {
                stack.e(MathHelper.d((float)stack.J() / (float)slots.size()));
                break;
            }
            case 1: {
                stack.e(1);
                break;
            }
            case 2: {
                stack.e(stack.c().m());
            }
        }
        stack.f(stackSize);
    }

    public boolean b(Slot slot) {
        return true;
    }

    public static int a(@Nullable TileEntity entity) {
        return entity instanceof IInventory ? Container.b((IInventory)((Object)entity)) : 0;
    }

    public static int b(@Nullable IInventory inventory) {
        if (inventory == null) {
            return 0;
        }
        int i2 = 0;
        float f2 = 0.0f;
        for (int j2 = 0; j2 < inventory.b(); ++j2) {
            net.minecraft.world.item.ItemStack itemstack = inventory.a(j2);
            if (itemstack.b()) continue;
            f2 += (float)itemstack.J() / (float)Math.min(inventory.N_(), itemstack.e());
            ++i2;
        }
        return MathHelper.d((f2 /= (float)inventory.b()) * 14.0f) + (i2 > 0 ? 1 : 0);
    }

    public void b(net.minecraft.world.item.ItemStack stack) {
        this.n = stack;
    }

    public net.minecraft.world.item.ItemStack g() {
        if (this.n.b()) {
            this.b(net.minecraft.world.item.ItemStack.b);
        }
        return this.n;
    }

    public void h() {
        this.y = true;
    }

    public void i() {
        this.y = false;
    }

    public void a(Container handler) {
        Slot slot;
        int i2;
        HashBasedTable table = HashBasedTable.create();
        for (i2 = 0; i2 < handler.i.size(); ++i2) {
            slot = handler.i.get(i2);
            table.put((Object)slot.c, (Object)slot.g(), (Object)i2);
        }
        for (i2 = 0; i2 < this.i.size(); ++i2) {
            slot = this.i.get(i2);
            Integer integer = (Integer)table.get((Object)slot.c, (Object)slot.g());
            if (integer == null) continue;
            this.l.set(i2, handler.l.get(integer));
            this.o.set(i2, handler.o.get(integer));
        }
    }

    public OptionalInt b(IInventory inventory, int index) {
        for (int j2 = 0; j2 < this.i.size(); ++j2) {
            Slot slot = this.i.get(j2);
            if (slot.c != inventory || index != slot.g()) continue;
            return OptionalInt.of(j2);
        }
        return OptionalInt.empty();
    }

    public int j() {
        return this.r;
    }

    public int k() {
        this.r = this.r + 1 & Short.MAX_VALUE;
        return this.r;
    }
}

