/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class IProjectile
extends Entity {
    @Nullable
    public UUID b;
    @Nullable
    public Entity c;
    private boolean d;
    private boolean e;
    protected boolean hitCancelled = false;

    IProjectile(EntityTypes<? extends IProjectile> type, World world) {
        super(type, world);
    }

    public void b(@Nullable Entity entity) {
        if (entity != null) {
            this.b = entity.cm();
            this.c = entity;
        }
        this.projectileSource = entity != null && entity.getBukkitEntity() instanceof ProjectileSource ? (ProjectileSource)entity.getBukkitEntity() : null;
    }

    @Nullable
    public Entity x() {
        if (this.c != null && !this.c.dp()) {
            return this.c;
        }
        if (this.b != null && this.s instanceof WorldServer) {
            this.c = ((WorldServer)this.s).a(this.b);
            if (this.c == null) {
                for (WorldServer level : this.s.n().F()) {
                    Entity entity;
                    if (level == this.s || (entity = level.a(this.b)) == null) continue;
                    this.c = entity;
                    break;
                }
            }
            return this.c;
        }
        return null;
    }

    public Entity y() {
        return (Entity)MoreObjects.firstNonNull((Object)this.x(), (Object)this);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.b != null) {
            nbt.a("Owner", this.b);
        }
        if (this.d) {
            nbt.a("LeftOwner", true);
        }
        nbt.a("HasBeenShot", this.e);
    }

    protected boolean d(Entity entity) {
        return entity.cm().equals(this.b);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("Owner")) {
            this.b = nbt.a("Owner");
            if (this instanceof EntityEnderPearl && this.s != null && this.s.paperConfig.disableEnderpearlExploit) {
                this.b = null;
            }
        }
        this.d = nbt.q("LeftOwner");
        this.e = nbt.q("HasBeenShot");
    }

    @Override
    public void k() {
        if (!this.e) {
            this.a(GameEvent.J, this.x(), this.cW());
            this.e = true;
        }
        if (!this.d) {
            this.d = this.i();
        }
        super.k();
    }

    @Override
    private boolean i() {
        Entity entity = this.x();
        if (entity != null) {
            for (Entity entity12 : this.s.a((Entity)this, this.cw().b(this.da()).g(1.0), (? super Entity entity1) -> !entity1.B_() && entity1.bh())) {
                if (entity12.cL() != entity.cL()) continue;
                return false;
            }
        }
        return true;
    }

    public void c(double x2, double y2, double z2, float speed, float divergence) {
        Vec3D vec3d = new Vec3D(x2, y2, z2).d().b(this.R.nextGaussian() * (double)0.0075f * (double)divergence, this.R.nextGaussian() * (double)0.0075f * (double)divergence, this.R.nextGaussian() * (double)0.0075f * (double)divergence).a((double)speed);
        this.g(vec3d);
        double d3 = vec3d.h();
        this.o((float)(MathHelper.d(vec3d.b, vec3d.d) * 57.2957763671875));
        this.p((float)(MathHelper.d(vec3d.c, d3) * 57.2957763671875));
        this.w = this.dn();
        this.x = this.do();
    }

    public void a(Entity shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f5 = -MathHelper.a(yaw * ((float)Math.PI / 180)) * MathHelper.b(pitch * ((float)Math.PI / 180));
        float f6 = -MathHelper.a((pitch + roll) * ((float)Math.PI / 180));
        float f7 = MathHelper.b(yaw * ((float)Math.PI / 180)) * MathHelper.b(pitch * ((float)Math.PI / 180));
        this.c(f5, f6, f7, speed, divergence);
        Vec3D vec3d = shooter.da();
        if (!shooter.s.paperConfig.disableRelativeProjectileVelocity) {
            this.g(this.da().b(vec3d.b, shooter.aw() ? 0.0 : vec3d.c, vec3d.d));
        }
    }

    protected void preOnHit(MovingObjectPosition movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.c() == MovingObjectPosition.EnumMovingObjectType.b || !this.hitCancelled) {
            this.a(movingobjectposition);
        }
    }

    protected void a(MovingObjectPosition hitResult) {
        MovingObjectPosition.EnumMovingObjectType movingobjectposition_enummovingobjecttype = hitResult.c();
        if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.c) {
            this.a((MovingObjectPositionEntity)hitResult);
        } else if (movingobjectposition_enummovingobjecttype == MovingObjectPosition.EnumMovingObjectType.b) {
            this.a((MovingObjectPositionBlock)hitResult);
        }
        if (movingobjectposition_enummovingobjecttype != MovingObjectPosition.EnumMovingObjectType.a) {
            this.a(GameEvent.I, this.x());
        }
    }

    protected void a(MovingObjectPositionEntity entityHitResult) {
    }

    protected void a(MovingObjectPositionBlock blockHitResult) {
        if (this.hitCancelled) {
            return;
        }
        IBlockData iblockdata = this.s.a_(blockHitResult.a());
        iblockdata.a(this.s, iblockdata, blockHitResult, this);
    }

    @Override
    public void k(double x2, double y2, double z2) {
        this.n(x2, y2, z2);
        if (this.x == 0.0f && this.w == 0.0f) {
            double d3 = Math.sqrt(x2 * x2 + z2 * z2);
            this.p((float)(MathHelper.d(y2, d3) * 57.2957763671875));
            this.o((float)(MathHelper.d(x2, z2) * 57.2957763671875));
            this.x = this.do();
            this.w = this.dn();
            this.b(this.dc(), this.de(), this.di(), this.dn(), this.do());
        }
    }

    protected boolean a(Entity entity) {
        if (!entity.B_() && entity.bl() && entity.bh()) {
            Entity entity1 = this.x();
            if (entity1 instanceof EntityPlayer && entity instanceof EntityPlayer) {
                Player collided = (Player)entity.getBukkitEntity();
                Player shooter = (Player)entity1.getBukkitEntity();
                if (!shooter.canSee(collided)) {
                    return false;
                }
            }
            return entity1 == null || this.d || !entity1.v(entity);
        }
        return false;
    }

    protected void z() {
        Vec3D vec3d = this.da();
        double d0 = vec3d.h();
        this.p(IProjectile.d(this.x, (float)(MathHelper.d(vec3d.c, d0) * 57.2957763671875)));
        this.o(IProjectile.d(this.w, (float)(MathHelper.d(vec3d.b, vec3d.d) * 57.2957763671875)));
    }

    protected static float d(float prevRot, float newRot) {
        while (newRot - prevRot < -180.0f) {
            prevRot -= 360.0f;
        }
        while (newRot - prevRot >= 180.0f) {
            prevRot += 360.0f;
        }
        return MathHelper.i(0.2f, prevRot, newRot);
    }

    @Override
    public Packet<?> S() {
        Entity entity = this.x();
        return new PacketPlayOutSpawnEntity(this, entity == null ? 0 : entity.ae());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        Entity entity = this.s.a(packet.m());
        if (entity != null) {
            this.b(entity);
        }
    }

    @Override
    public boolean a(World world, BlockPosition pos) {
        Entity entity = this.x();
        return entity instanceof EntityHuman ? entity.a(world, pos) : entity == null || world.W().b(GameRules.c);
    }
}

