/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class EntityShulkerBullet
extends IProjectile {
    private static final double b = 0.15;
    @Nullable
    private Entity c;
    @Nullable
    private EnumDirection d;
    private int e;
    private double f;
    private double ao;
    private double ap;
    @Nullable
    private UUID aq;

    public EntityShulkerBullet(EntityTypes<? extends EntityShulkerBullet> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
        this.Q = true;
    }

    public EntityShulkerBullet(World world, EntityLiving owner, Entity target, EnumDirection.EnumAxis axis) {
        this((EntityTypes<? extends EntityShulkerBullet>)EntityTypes.az, world);
        this.b((Entity)owner);
        BlockPosition blockposition = owner.cW();
        double d0 = (double)blockposition.u() + 0.5;
        double d1 = (double)blockposition.v() + 0.5;
        double d2 = (double)blockposition.w() + 0.5;
        this.b(d0, d1, d2, this.dn(), this.do());
        this.c = target;
        this.d = EnumDirection.b;
        this.a(axis);
        this.projectileSource = (LivingEntity)owner.getBukkitEntity();
    }

    public Entity getTarget() {
        return this.c;
    }

    public void setTarget(Entity e2) {
        this.c = e2;
        this.d = EnumDirection.b;
        this.a(EnumDirection.EnumAxis.a);
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.f;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.c != null) {
            nbt.a("Target", this.c.cm());
        }
        if (this.d != null) {
            nbt.a("Dir", this.d.b());
        }
        nbt.a("Steps", this.e);
        nbt.a("TXD", this.f);
        nbt.a("TYD", this.ao);
        nbt.a("TZD", this.ap);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.e = nbt.h("Steps");
        this.f = nbt.k("TXD");
        this.ao = nbt.k("TYD");
        this.ap = nbt.k("TZD");
        if (nbt.b("Dir", 99)) {
            this.d = EnumDirection.a(nbt.h("Dir"));
        }
        if (nbt.b("Target")) {
            this.aq = nbt.a("Target");
        }
    }

    @Override
    protected void a_() {
    }

    @Nullable
    private EnumDirection h() {
        return this.d;
    }

    private void a(@Nullable EnumDirection direction) {
        this.d = direction;
    }

    private void a(@Nullable EnumDirection.EnumAxis axis) {
        BlockPosition blockposition;
        double d0 = 0.5;
        if (this.c == null) {
            blockposition = this.cW().c();
        } else {
            d0 = (double)this.c.cU() * 0.5;
            blockposition = new BlockPosition(this.c.dc(), this.c.de() + d0, this.c.di());
        }
        double d1 = (double)blockposition.u() + 0.5;
        double d2 = (double)blockposition.v() + d0;
        double d3 = (double)blockposition.w() + 0.5;
        EnumDirection enumdirection = null;
        if (!blockposition.a(this.cV(), 2.0)) {
            BlockPosition blockposition1 = this.cW();
            ArrayList list = Lists.newArrayList();
            if (axis != EnumDirection.EnumAxis.a) {
                if (blockposition1.u() < blockposition.u() && this.s.w(blockposition1.g())) {
                    list.add(EnumDirection.f);
                } else if (blockposition1.u() > blockposition.u() && this.s.w(blockposition1.f())) {
                    list.add(EnumDirection.e);
                }
            }
            if (axis != EnumDirection.EnumAxis.b) {
                if (blockposition1.v() < blockposition.v() && this.s.w(blockposition1.b())) {
                    list.add(EnumDirection.b);
                } else if (blockposition1.v() > blockposition.v() && this.s.w(blockposition1.c())) {
                    list.add(EnumDirection.a);
                }
            }
            if (axis != EnumDirection.EnumAxis.c) {
                if (blockposition1.w() < blockposition.w() && this.s.w(blockposition1.e())) {
                    list.add(EnumDirection.d);
                } else if (blockposition1.w() > blockposition.w() && this.s.w(blockposition1.d())) {
                    list.add(EnumDirection.c);
                }
            }
            enumdirection = EnumDirection.a(this.R);
            if (list.isEmpty()) {
                for (int i2 = 5; !this.s.w(blockposition1.a(enumdirection)) && i2 > 0; --i2) {
                    enumdirection = EnumDirection.a(this.R);
                }
            } else {
                enumdirection = (EnumDirection)list.get(this.R.nextInt(list.size()));
            }
            d1 = this.dc() + (double)enumdirection.i();
            d2 = this.de() + (double)enumdirection.j();
            d3 = this.di() + (double)enumdirection.k();
        }
        this.a(enumdirection);
        double d4 = d1 - this.dc();
        double d5 = d2 - this.de();
        double d6 = d3 - this.di();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 == 0.0) {
            this.f = 0.0;
            this.ao = 0.0;
            this.ap = 0.0;
        } else {
            this.f = d4 / d7 * 0.15;
            this.ao = d5 / d7 * 0.15;
            this.ap = d6 / d7 * 0.15;
        }
        this.af = true;
        this.e = 10 + this.R.nextInt(5) * 10;
    }

    @Override
    public void dj() {
        if (this.s.af() == EnumDifficulty.a) {
            this.ah();
        }
    }

    @Override
    public void k() {
        Vec3D vec3d;
        super.k();
        if (!this.s.x) {
            if (this.c == null && this.aq != null) {
                this.c = ((WorldServer)this.s).a(this.aq);
                if (this.c == null) {
                    this.aq = null;
                }
            }
            if (!(this.c == null || !this.c.bl() || this.c instanceof EntityHuman && this.c.B_())) {
                this.f = MathHelper.a(this.f * 1.025, -1.0, 1.0);
                this.ao = MathHelper.a(this.ao * 1.025, -1.0, 1.0);
                this.ap = MathHelper.a(this.ap * 1.025, -1.0, 1.0);
                vec3d = this.da();
                this.g(vec3d.b((this.f - vec3d.b) * 0.2, (this.ao - vec3d.c) * 0.2, (this.ap - vec3d.d) * 0.2));
            } else if (!this.aM()) {
                this.g(this.da().b(0.0, -0.04, 0.0));
            }
            MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::a);
            if (movingobjectposition.c() != MovingObjectPosition.EnumMovingObjectType.a) {
                this.preOnHit(movingobjectposition);
            }
        }
        this.aI();
        vec3d = this.da();
        this.e(this.dc() + vec3d.b, this.de() + vec3d.c, this.di() + vec3d.d);
        ProjectileHelper.a((Entity)this, 0.5f);
        if (this.s.x) {
            this.s.a(Particles.u, this.dc() - vec3d.b, this.de() - vec3d.c + 0.15, this.di() - vec3d.d, 0.0, 0.0, 0.0);
        } else if (this.c != null && !this.c.dp()) {
            if (this.e > 0) {
                --this.e;
                if (this.e == 0) {
                    this.a(this.d == null ? null : this.d.n());
                }
            }
            if (this.d != null) {
                BlockPosition blockposition = this.cW();
                EnumDirection.EnumAxis enumdirection_enumaxis = this.d.n();
                if (this.s.a(blockposition.a(this.d), (Entity)this)) {
                    this.a(enumdirection_enumaxis);
                } else {
                    BlockPosition blockposition1 = this.c.cW();
                    if (enumdirection_enumaxis == EnumDirection.EnumAxis.a && blockposition.u() == blockposition1.u() || enumdirection_enumaxis == EnumDirection.EnumAxis.c && blockposition.w() == blockposition1.w() || enumdirection_enumaxis == EnumDirection.EnumAxis.b && blockposition.v() == blockposition1.v()) {
                        this.a(enumdirection_enumaxis);
                    }
                }
            }
        }
    }

    @Override
    protected boolean a(Entity entity) {
        return super.a(entity) && !entity.Q;
    }

    @Override
    public boolean bE() {
        return false;
    }

    @Override
    public boolean a(double distance) {
        return distance < 16384.0;
    }

    @Override
    public float bd() {
        return 1.0f;
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        Entity entity = entityHitResult.a();
        Entity entity1 = this.x();
        EntityLiving entityliving = entity1 instanceof EntityLiving ? (EntityLiving)entity1 : null;
        boolean flag = entity.a(DamageSource.a((Entity)this, entityliving).c(), 4.0f);
        if (flag) {
            this.a(entityliving, entity);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).addEffect(new MobEffect(MobEffects.y, 200), (Entity)MoreObjects.firstNonNull((Object)entity1, (Object)this), EntityPotionEffectEvent.Cause.ATTACK);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        super.a(blockHitResult);
        ((WorldServer)this.s).a(Particles.x, this.dc(), this.de(), this.di(), 2, 0.2, 0.2, 0.2, 0.0);
        this.a(SoundEffects.qK, 1.0f, 1.0f);
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        this.ah();
    }

    @Override
    public boolean bh() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
            return false;
        }
        if (!this.s.x) {
            this.a(SoundEffects.qL, 1.0f, 1.0f);
            ((WorldServer)this.s).a(Particles.g, this.dc(), this.de(), this.di(), 15, 0.2, 0.2, 0.2, 0.0);
            this.ah();
        }
        return true;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        double d0 = packet.g();
        double d1 = packet.h();
        double d2 = packet.i();
        this.n(d0, d1, d2);
    }
}

