/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public abstract class EntityProjectile
extends IProjectile {
    protected EntityProjectile(EntityTypes<? extends EntityProjectile> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    protected EntityProjectile(EntityTypes<? extends EntityProjectile> type, double x2, double y2, double z2, World world) {
        this(type, world);
        this.e(x2, y2, z2);
    }

    protected EntityProjectile(EntityTypes<? extends EntityProjectile> type, EntityLiving owner, World world) {
        this(type, owner.dc(), owner.dg() - (double)0.1f, owner.di(), world);
        this.b((Entity)owner);
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cw().a() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    @Override
    public void k() {
        float f2;
        super.k();
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::a);
        boolean flag = false;
        if (movingobjectposition.c() == MovingObjectPosition.EnumMovingObjectType.b) {
            BlockPosition blockposition = ((MovingObjectPositionBlock)movingobjectposition).a();
            IBlockData iblockdata = this.s.a_(blockposition);
            if (iblockdata.a(Blocks.db)) {
                this.d(blockposition);
                flag = true;
            } else if (iblockdata.a(Blocks.iT)) {
                TileEntity tileentity = this.s.c_(blockposition);
                if (tileentity instanceof TileEntityEndGateway && TileEntityEndGateway.a(this)) {
                    TileEntityEndGateway.a(this.s, blockposition, iblockdata, this, (TileEntityEndGateway)tileentity);
                }
                flag = true;
            }
        }
        if (movingobjectposition.c() != MovingObjectPosition.EnumMovingObjectType.a && !flag) {
            ProjectileCollideEvent event;
            if (movingobjectposition instanceof MovingObjectPositionEntity && (event = CraftEventFactory.callProjectileCollideEvent(this, (MovingObjectPositionEntity)movingobjectposition)).isCancelled()) {
                movingobjectposition = null;
            }
            if (movingobjectposition != null) {
                this.preOnHit(movingobjectposition);
            }
        }
        this.aI();
        Vec3D vec3d = this.da();
        double d0 = this.dc() + vec3d.b;
        double d1 = this.de() + vec3d.c;
        double d2 = this.di() + vec3d.d;
        this.z();
        if (this.aQ()) {
            for (int i2 = 0; i2 < 4; ++i2) {
                float f1 = 0.25f;
                this.s.a(Particles.e, d0 - vec3d.b * 0.25, d1 - vec3d.c * 0.25, d2 - vec3d.d * 0.25, vec3d.b, vec3d.c, vec3d.d);
            }
            f2 = 0.8f;
        } else {
            f2 = 0.99f;
        }
        this.g(vec3d.a((double)f2));
        if (!this.aM()) {
            Vec3D vec3d1 = this.da();
            this.n(vec3d1.b, vec3d1.c - (double)this.l(), vec3d1.d);
        }
        this.e(d0, d1, d2);
    }

    protected float l() {
        return 0.03f;
    }
}

