/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftItem;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double f = 2.0;
    private static final DataWatcherObject<Byte> ao = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> ap = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final int aq = 1;
    private static final int ar = 2;
    private static final int as = 4;
    @Nullable
    private IBlockData at;
    public boolean b;
    protected int c;
    public PickupStatus d = PickupStatus.a;
    public int e;
    public int au;
    private double av = 2.0;
    public int aw;
    private SoundEffect ax = this.i();
    @Nullable
    private IntOpenHashSet ay;
    @Nullable
    private List<Entity> az;

    @Override
    public void inactiveTick() {
        if (this.b) {
            ++this.au;
        }
        super.inactiveTick();
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, double x2, double y2, double z2, World world) {
        this(type, world);
        this.e(x2, y2, z2);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, EntityLiving owner, World world) {
        this(type, owner.dc(), owner.dg() - (double)0.1f, owner.di(), world);
        this.b((Entity)owner);
        if (owner instanceof EntityHuman) {
            this.d = PickupStatus.b;
        }
    }

    public void a(SoundEffect sound) {
        this.ax = sound;
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cw().a() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * EntityArrow.cq()) * d1;
    }

    @Override
    protected void a_() {
        this.Y.a(ao, (byte)0);
        this.Y.a(ap, (byte)0);
    }

    @Override
    public void c(double x2, double y2, double z2, float speed, float divergence) {
        super.c(x2, y2, z2, speed, divergence);
        this.au = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.e(x2, y2, z2);
        this.a(yaw, pitch);
    }

    @Override
    public void k(double x2, double y2, double z2) {
        super.k(x2, y2, z2);
        this.au = 0;
    }

    @Override
    public void k() {
        Vec3D vec3d1;
        VoxelShape voxelshape;
        BlockPosition blockposition;
        IBlockData iblockdata;
        super.k();
        boolean flag = this.u();
        Vec3D vec3d = this.da();
        if (this.x == 0.0f && this.w == 0.0f) {
            double d0 = vec3d.h();
            this.o((float)(MathHelper.d(vec3d.b, vec3d.d) * 57.2957763671875));
            this.p((float)(MathHelper.d(vec3d.c, d0) * 57.2957763671875));
            this.w = this.dn();
            this.x = this.do();
        }
        if (!((iblockdata = this.s.a_(blockposition = this.cW())).g() || flag || (voxelshape = iblockdata.k(this.s, blockposition)).b())) {
            vec3d1 = this.cV();
            for (AxisAlignedBB axisalignedbb : voxelshape.d()) {
                if (!axisalignedbb.a(blockposition).d(vec3d1)) continue;
                this.b = true;
                break;
            }
        }
        if (this.e > 0) {
            --this.e;
        }
        if (this.aR() || iblockdata.a(Blocks.oO)) {
            this.au();
        }
        if (this.b && !flag) {
            if (this.at != iblockdata && this.w()) {
                this.A();
            } else if (!this.s.x) {
                this.h();
            }
            ++this.c;
        } else {
            if (this.S > 200) {
                this.h();
            }
            this.c = 0;
            Vec3D vec3d2 = this.cV();
            MovingObjectPosition object = this.s.a(new RayTrace(vec3d2, vec3d1 = vec3d2.e(vec3d), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
            if (((MovingObjectPosition)object).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                vec3d1 = ((MovingObjectPosition)object).e();
            }
            while (!this.dp()) {
                ProjectileCollideEvent event;
                MovingObjectPositionEntity movingobjectpositionentity = this.a(vec3d2, vec3d1);
                if (movingobjectpositionentity != null) {
                    object = movingobjectpositionentity;
                }
                if (object != null && ((MovingObjectPosition)object).c() == MovingObjectPosition.EnumMovingObjectType.c) {
                    Entity entity = ((MovingObjectPositionEntity)object).a();
                    Entity entity1 = this.x();
                    if (entity instanceof EntityHuman && entity1 instanceof EntityHuman && !((EntityHuman)entity1).a((EntityHuman)entity)) {
                        object = null;
                        movingobjectpositionentity = null;
                    }
                }
                if (object instanceof MovingObjectPositionEntity && (event = CraftEventFactory.callProjectileCollideEvent(this, (MovingObjectPositionEntity)object)).isCancelled()) {
                    object = null;
                    movingobjectpositionentity = null;
                }
                if (object != null && !flag) {
                    this.preOnHit(object);
                    this.af = true;
                }
                if (movingobjectpositionentity == null || this.s() <= 0) break;
                object = null;
            }
            vec3d = this.da();
            double d1 = vec3d.b;
            double d2 = vec3d.c;
            double d3 = vec3d.d;
            if (this.q()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.s.a(Particles.g, this.dc() + d1 * (double)i2 / 4.0, this.de() + d2 * (double)i2 / 4.0, this.di() + d3 * (double)i2 / 4.0, -d1, -d2 + 0.2, -d3);
                }
            }
            double d4 = this.dc() + d1;
            double d5 = this.de() + d2;
            double d6 = this.di() + d3;
            double d7 = vec3d.h();
            if (flag) {
                this.o((float)(MathHelper.d(-d1, -d3) * 57.2957763671875));
            } else {
                this.o((float)(MathHelper.d(d1, d3) * 57.2957763671875));
            }
            this.p((float)(MathHelper.d(d2, d7) * 57.2957763671875));
            this.p(EntityArrow.d(this.x, this.do()));
            this.o(EntityArrow.d(this.w, this.dn()));
            float f2 = 0.99f;
            float f1 = 0.05f;
            if (this.aQ()) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    float f22 = 0.25f;
                    this.s.a(Particles.e, d4 - d1 * 0.25, d5 - d2 * 0.25, d6 - d3 * 0.25, d1, d2, d3);
                }
                f2 = this.t();
            }
            this.g(vec3d.a((double)f2));
            if (!this.aM() && !flag) {
                Vec3D vec3d3 = this.da();
                this.n(vec3d3.b, vec3d3.c - (double)0.05f, vec3d3.d);
            }
            this.e(d4, d5, d6);
            this.aI();
        }
    }

    @Override
    protected void preOnHit(MovingObjectPosition hitResult) {
        super.preOnHit(hitResult);
        if (hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            if (this.hitCancelled && this.s() > 0) {
                if (this.ay == null) {
                    this.ay = new IntOpenHashSet(5);
                }
                this.ay.add(entityHitResult.a().ae());
            }
        }
    }

    private boolean w() {
        return this.b && this.s.b(new AxisAlignedBB(this.cV(), this.cV()).g(0.06));
    }

    private void A() {
        this.b = false;
        Vec3D vec3d = this.da();
        this.g(vec3d.d(this.R.nextFloat() * 0.2f, this.R.nextFloat() * 0.2f, this.R.nextFloat() * 0.2f));
        this.au = 0;
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        super.a(movementType, movement);
        if (movementType != EnumMoveType.a && this.w()) {
            this.A();
        }
    }

    protected void h() {
        ++this.au;
        if (this.au >= (this.d == PickupStatus.c ? this.s.paperConfig.creativeArrowDespawnRate : (this.d == PickupStatus.a ? this.s.paperConfig.nonPlayerArrowDespawnRate : (this instanceof EntityThrownTrident ? this.s.spigotConfig.tridentDespawnRate : this.s.spigotConfig.arrowDespawnRate)))) {
            this.ah();
        }
    }

    private void C() {
        if (this.az != null) {
            this.az.clear();
        }
        if (this.ay != null) {
            this.ay.clear();
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        DamageSource damagesource;
        Entity entity1;
        super.a(entityHitResult);
        Entity entity = entityHitResult.a();
        float f2 = (float)this.da().f();
        int i2 = MathHelper.e(MathHelper.a((double)f2 * this.av, 0.0, 2.147483647E9));
        if (this.s() > 0) {
            if (this.ay == null) {
                this.ay = new IntOpenHashSet(5);
            }
            if (this.az == null) {
                this.az = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.ay.size() >= this.s() + 1) {
                this.ah();
                return;
            }
            this.ay.add(entity.ae());
        }
        if (this.q()) {
            long j2 = this.R.nextInt(i2 / 2 + 2);
            i2 = (int)Math.min(j2 + (long)i2, Integer.MAX_VALUE);
        }
        if ((entity1 = this.x()) == null) {
            damagesource = DamageSource.a(this, (Entity)this);
        } else {
            damagesource = DamageSource.a(this, entity1);
            if (entity1 instanceof EntityLiving) {
                ((EntityLiving)entity1).x(entity);
            }
        }
        if (this.q()) {
            damagesource = damagesource.critical();
        }
        boolean flag = entity.ad() == EntityTypes.w;
        int k2 = entity.at();
        if (this.bE() && !flag) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.setSecondsOnFire(combustEvent.getDuration(), false);
            }
        }
        if (entity.a(damagesource, (float)i2)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                Vec3D vec3d;
                EntityLiving entityliving = (EntityLiving)entity;
                if (!this.s.x && this.s() <= 0) {
                    entityliving.p(entityliving.en() + 1);
                }
                if (this.aw > 0 && (vec3d = this.da().d(1.0, 0.0, 1.0).d().a((double)this.aw * 0.6)).g() > 0.0) {
                    entityliving.i(vec3d.b, 0.1, vec3d.d);
                }
                if (!this.s.x && entity1 instanceof EntityLiving) {
                    EnchantmentManager.a(entityliving, entity1);
                    EnchantmentManager.b((EntityLiving)entity1, (Entity)entityliving);
                }
                this.a(entityliving);
                if (entity1 != null && entityliving != entity1 && entityliving instanceof EntityHuman && entity1 instanceof EntityPlayer && !this.aL()) {
                    ((EntityPlayer)entity1).b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.g, 0.0f));
                }
                if (!entity.bl() && this.az != null) {
                    this.az.add(entityliving);
                }
                if (!this.s.x && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity1;
                    if (this.az != null && this.r()) {
                        CriterionTriggers.G.a(entityplayer, this.az);
                    } else if (!entity.bl() && this.r()) {
                        CriterionTriggers.G.a(entityplayer, Arrays.asList(entity));
                    }
                }
            }
            this.a(this.ax, 1.0f, 1.2f / (this.R.nextFloat() * 0.2f + 0.9f));
            if (this.s() <= 0) {
                this.ah();
            }
        } else {
            entity.g(k2);
            this.g(this.da().a(-0.1));
            this.o(this.dn() + 180.0f);
            this.w += 180.0f;
            if (!this.s.x && this.da().g() < 1.0E-7) {
                if (this.d == PickupStatus.b) {
                    this.a(this.l(), 0.1f);
                }
                this.ah();
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        this.at = this.s.a_(blockHitResult.a());
        super.a(blockHitResult);
        Vec3D vec3d = blockHitResult.e().a(this.dc(), this.de(), this.di());
        this.g(vec3d);
        Vec3D vec3d1 = vec3d.d().a((double)0.05f);
        this.o(this.dc() - vec3d1.b, this.de() - vec3d1.c, this.di() - vec3d1.d);
        this.a(this.j(), 1.0f, 1.2f / (this.R.nextFloat() * 0.2f + 0.9f));
        this.b = true;
        this.e = 7;
        this.a(false);
        this.b((byte)0);
        this.a(SoundEffects.ah);
        this.q(false);
        this.C();
    }

    protected SoundEffect i() {
        return SoundEffects.ah;
    }

    protected final SoundEffect j() {
        return this.ax;
    }

    protected void a(EntityLiving target) {
    }

    @Nullable
    protected MovingObjectPositionEntity a(Vec3D currentPosition, Vec3D nextPosition) {
        return ProjectileHelper.a(this.s, this, currentPosition, nextPosition, this.cw().b(this.da()).g(1.0), this::a);
    }

    @Override
    protected boolean a(Entity entity) {
        return super.a(entity) && (this.ay == null || !this.ay.contains(entity.ae()));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("life", (short)this.au);
        if (this.at != null) {
            nbt.a("inBlockState", GameProfileSerializer.a(this.at));
        }
        nbt.a("shake", (byte)this.e);
        nbt.a("inGround", this.b);
        nbt.a("pickup", (byte)this.d.ordinal());
        nbt.a("damage", this.av);
        nbt.a("crit", this.q());
        nbt.a("PierceLevel", this.s());
        nbt.a("SoundEvent", IRegistry.R.b(this.ax).toString());
        nbt.a("ShotFromCrossbow", this.r());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.au = nbt.g("life");
        if (nbt.b("inBlockState", 10)) {
            this.at = GameProfileSerializer.c(nbt.p("inBlockState"));
        }
        this.e = nbt.f("shake") & 0xFF;
        this.b = nbt.q("inGround");
        if (nbt.b("damage", 99)) {
            this.av = nbt.k("damage");
        }
        this.d = PickupStatus.a(nbt.f("pickup"));
        this.a(nbt.q("crit"));
        this.b(nbt.f("PierceLevel"));
        if (nbt.b("SoundEvent", 8)) {
            this.ax = IRegistry.R.b(new MinecraftKey(nbt.l("SoundEvent"))).orElse(this.i());
        }
        this.q(nbt.q("ShotFromCrossbow"));
    }

    @Override
    public void b(@Nullable Entity entity) {
        super.b(entity);
        if (entity instanceof EntityHuman) {
            this.d = ((EntityHuman)entity).fs().d ? PickupStatus.c : PickupStatus.b;
        }
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.s.x && (this.b || this.u()) && this.e <= 0) {
            ItemStack itemstack = this.l();
            if (this.d == PickupStatus.b && !itemstack.b() && player.fr().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.s, this.dc(), this.de(), this.di(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)player.getBukkitEntity(), (Item)new CraftItem(this.s.getCraftServer(), this, item), (AbstractArrow)this.getBukkitEntity());
                this.s.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.h();
            }
            if (this.d == PickupStatus.b && player.fr().e(itemstack) || this.d == PickupStatus.c && player.fs().d) {
                player.a((Entity)this, 1);
                this.ah();
            }
        }
    }

    protected boolean a(EntityHuman player) {
        switch (this.d) {
            case b: {
                return player.fr().e(this.l());
            }
            case c: {
                return player.fs().d;
            }
        }
        return false;
    }

    public abstract ItemStack l();

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    public void h(double damage) {
        this.av = damage;
    }

    public double n() {
        return this.av;
    }

    public void a(int punch) {
        this.aw = punch;
    }

    public int o() {
        return this.aw;
    }

    @Override
    public boolean cf() {
        return false;
    }

    @Override
    protected float a(EntityPose pose, EntitySize dimensions) {
        return 0.13f;
    }

    public void a(boolean critical) {
        this.a(1, critical);
    }

    public void b(byte level) {
        this.Y.b(ap, level);
    }

    private void a(int index, boolean flag) {
        byte b0 = this.Y.a(ao);
        if (flag) {
            this.Y.b(ao, (byte)(b0 | index));
        } else {
            this.Y.b(ao, (byte)(b0 & ~index));
        }
    }

    public boolean q() {
        byte b0 = this.Y.a(ao);
        return (b0 & 1) != 0;
    }

    public boolean r() {
        byte b0 = this.Y.a(ao);
        return (b0 & 4) != 0;
    }

    public byte s() {
        return this.Y.a(ap);
    }

    public void a(EntityLiving entity, float damageModifier) {
        int i2 = EnchantmentManager.a(Enchantments.x, entity);
        int j2 = EnchantmentManager.a(Enchantments.y, entity);
        this.h((double)(damageModifier * 2.0f) + this.R.nextGaussian() * 0.25 + (double)((float)this.s.af().a() * 0.11f));
        if (i2 > 0) {
            this.h(this.n() + (double)i2 * 0.5 + 0.5);
        }
        if (j2 > 0) {
            this.a(j2);
        }
        if (EnchantmentManager.a(Enchantments.z, entity) > 0) {
            this.f(100);
        }
    }

    protected float t() {
        return 0.6f;
    }

    public void p(boolean noClip) {
        this.Q = noClip;
        this.a(2, noClip);
    }

    public boolean u() {
        return !this.s.x ? this.Q : (this.Y.a(ao) & 2) != 0;
    }

    public void q(boolean shotFromCrossbow) {
        this.a(4, shotFromCrossbow);
    }

    public static enum PickupStatus {
        a,
        b,
        c;


        public static PickupStatus a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

