/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.IDyeable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmorColorable;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class VillagerTrades {
    private static final int c = 12;
    private static final int d = 16;
    private static final int e = 3;
    private static final int f = 1;
    private static final int g = 2;
    private static final int h = 5;
    private static final int i = 10;
    private static final int j = 10;
    private static final int k = 20;
    private static final int l = 15;
    private static final int m = 30;
    private static final int n = 30;
    private static final float o = 0.05f;
    private static final float p = 0.2f;
    public static final Map<VillagerProfession, Int2ObjectMap<IMerchantRecipeOption[]>> a = SystemUtils.a(Maps.newHashMap(), map -> {
        map.put(VillagerProfession.f, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.ni, 20, 16, 2), new b(Items.rm, 26, 16, 2), new b(Items.rl, 22, 16, 2), new b(Items.sn, 15, 16, 2), new h(Items.nj, 1, 6, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Blocks.cS, 6, 12, 10), new h(Items.ry, 1, 4, 5), new h(Items.mf, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new h(Items.po, 3, 18, 10), new b(Blocks.dS, 4, 12, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new h(Blocks.de, 1, 1, 12, 15), new i(MobEffects.p, 100, 15), new i(MobEffects.h, 160, 15), new i(MobEffects.r, 140, 15), new i(MobEffects.o, 120, 15), new i(MobEffects.s, 280, 15), new i(MobEffects.w, 7, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.rq, 3, 3, 30), new h(Items.pO, 4, 3, 30)})));
        map.put(VillagerProfession.g, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.ne, 20, 16, 2), new b(Items.mi, 10, 16, 2), new g(Items.ov, 6, Items.oz, 6, 16, 1), new h(Items.of, 3, 1, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.ov, 15, 16, 10), new g(Items.ow, 6, Items.oA, 6, 16, 5), new h(Items.tq, 2, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.ow, 13, 16, 20), new e(Items.or, 3, 3, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.ox, 6, 12, 30)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.oy, 4, 12, 30), new c(1, 12, 30, (Map<VillagerType, Item>)ImmutableMap.builder().put((Object)VillagerType.c, (Object)Items.lU).put((Object)VillagerType.g, (Object)Items.lV).put((Object)VillagerType.e, (Object)Items.lV).put((Object)VillagerType.a, (Object)Items.lX).put((Object)VillagerType.b, (Object)Items.lX).put((Object)VillagerType.d, (Object)Items.lY).put((Object)VillagerType.f, (Object)Items.lZ).build())})));
        map.put(VillagerProfession.m, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Blocks.be, 18, 16, 2), new b(Blocks.bq, 18, 16, 2), new b(Blocks.bt, 18, 16, 2), new b(Blocks.bl, 18, 16, 2), new h(Items.pq, 2, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.oE, 12, 16, 10), new b(Items.oL, 12, 16, 10), new b(Items.oT, 12, 16, 10), new b(Items.oH, 12, 16, 10), new b(Items.oJ, 12, 16, 10), new h(Blocks.be, 1, 1, 16, 5), new h(Blocks.bf, 1, 1, 16, 5), new h(Blocks.bg, 1, 1, 16, 5), new h(Blocks.bh, 1, 1, 16, 5), new h(Blocks.bi, 1, 1, 16, 5), new h(Blocks.bj, 1, 1, 16, 5), new h(Blocks.bk, 1, 1, 16, 5), new h(Blocks.bl, 1, 1, 16, 5), new h(Blocks.bm, 1, 1, 16, 5), new h(Blocks.bn, 1, 1, 16, 5), new h(Blocks.bo, 1, 1, 16, 5), new h(Blocks.bp, 1, 1, 16, 5), new h(Blocks.bq, 1, 1, 16, 5), new h(Blocks.br, 1, 1, 16, 5), new h(Blocks.bs, 1, 1, 16, 5), new h(Blocks.bt, 1, 1, 16, 5), new h(Blocks.gP, 1, 4, 16, 5), new h(Blocks.gQ, 1, 4, 16, 5), new h(Blocks.gR, 1, 4, 16, 5), new h(Blocks.gS, 1, 4, 16, 5), new h(Blocks.gT, 1, 4, 16, 5), new h(Blocks.gU, 1, 4, 16, 5), new h(Blocks.gV, 1, 4, 16, 5), new h(Blocks.gW, 1, 4, 16, 5), new h(Blocks.gX, 1, 4, 16, 5), new h(Blocks.gY, 1, 4, 16, 5), new h(Blocks.gZ, 1, 4, 16, 5), new h(Blocks.ha, 1, 4, 16, 5), new h(Blocks.hb, 1, 4, 16, 5), new h(Blocks.hc, 1, 4, 16, 5), new h(Blocks.hd, 1, 4, 16, 5), new h(Blocks.he, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.oI, 12, 16, 20), new b(Items.oM, 12, 16, 20), new b(Items.oF, 12, 16, 20), new b(Items.oS, 12, 16, 20), new b(Items.oK, 12, 16, 20), new h(Blocks.aD, 3, 1, 12, 10), new h(Blocks.aH, 3, 1, 12, 10), new h(Blocks.aR, 3, 1, 12, 10), new h(Blocks.aS, 3, 1, 12, 10), new h(Blocks.aO, 3, 1, 12, 10), new h(Blocks.aP, 3, 1, 12, 10), new h(Blocks.aM, 3, 1, 12, 10), new h(Blocks.aK, 3, 1, 12, 10), new h(Blocks.aQ, 3, 1, 12, 10), new h(Blocks.aG, 3, 1, 12, 10), new h(Blocks.aL, 3, 1, 12, 10), new h(Blocks.aI, 3, 1, 12, 10), new h(Blocks.aF, 3, 1, 12, 10), new h(Blocks.aE, 3, 1, 12, 10), new h(Blocks.aJ, 3, 1, 12, 10), new h(Blocks.aN, 3, 1, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.oQ, 12, 16, 30), new b(Items.oO, 12, 16, 30), new b(Items.oP, 12, 16, 30), new b(Items.oR, 12, 16, 30), new b(Items.oG, 12, 16, 30), new b(Items.oN, 12, 16, 30), new h(Items.rU, 3, 1, 12, 15), new h(Items.sf, 3, 1, 12, 15), new h(Items.rX, 3, 1, 12, 15), new h(Items.si, 3, 1, 12, 15), new h(Items.sa, 3, 1, 12, 15), new h(Items.sh, 3, 1, 12, 15), new h(Items.rZ, 3, 1, 12, 15), new h(Items.sb, 3, 1, 12, 15), new h(Items.sj, 3, 1, 12, 15), new h(Items.se, 3, 1, 12, 15), new h(Items.rW, 3, 1, 12, 15), new h(Items.sd, 3, 1, 12, 15), new h(Items.sg, 3, 1, 12, 15), new h(Items.rY, 3, 1, 12, 15), new h(Items.rV, 3, 1, 12, 15), new h(Items.sc, 3, 1, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.nL, 2, 3, 30)})));
        map.put(VillagerProfession.h, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.nb, 32, 16, 2), new h(Items.mh, 1, 16, 1), new g(Blocks.E, 10, Items.nI, 10, 12, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.nI, 26, 12, 10), new h(Items.mg, 2, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.ne, 14, 16, 20), new h(Items.sT, 3, 1, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.nf, 24, 16, 30), new e(Items.mg, 2, 3, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.kG, 8, 12, 30), new e(Items.sT, 3, 3, 15), new j(Items.mh, 5, Items.st, 5, 2, 12, 30)})));
        map.put(VillagerProfession.j, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.builder().put((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.ol, 24, 16, 2), new d(1), new h(Blocks.bO, 9, 1, 12, 1)}).put((Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.om, 4, 12, 10), new d(5), new h(Items.tm, 1, 1, 5)}).put((Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.oB, 5, 12, 20), new d(10), new h(Items.bN, 1, 4, 10)}).put((Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.rg, 2, 12, 30), new d(15), new h(Items.os, 5, 1, 15), new h(Items.op, 4, 1, 15)}).put((Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.rQ, 20, 1, 30)}).build()));
        map.put(VillagerProfession.d, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.ol, 24, 16, 2), new h(Items.rp, 7, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.eL, 11, 16, 10), new k(13, ConfiguredStructureTags.d, "filled_map.monument", MapIcon.Type.j, 12, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.op, 1, 12, 20), new k(14, ConfiguredStructureTags.c, "filled_map.mansion", MapIcon.Type.i, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new h(Items.ri, 7, 1, 15), new h(Items.rU, 3, 1, 15), new h(Items.sf, 3, 1, 15), new h(Items.rX, 3, 1, 15), new h(Items.si, 3, 1, 15), new h(Items.sa, 3, 1, 15), new h(Items.sh, 3, 1, 15), new h(Items.rZ, 3, 1, 15), new h(Items.sb, 3, 1, 15), new h(Items.sj, 3, 1, 15), new h(Items.se, 3, 1, 15), new h(Items.rW, 3, 1, 15), new h(Items.sd, 3, 1, 15), new h(Items.sg, 3, 1, 15), new h(Items.rY, 3, 1, 15), new h(Items.rV, 3, 1, 15), new h(Items.sc, 3, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Items.ta, 8, 1, 30)})));
        map.put(VillagerProfession.e, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.pz, 32, 16, 2), new h(Items.kn, 1, 2, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.mu, 3, 12, 10), new h(Items.mm, 1, 1, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.rI, 2, 12, 20), new h(Blocks.da, 4, 1, 12, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.md, 4, 12, 30), new b(Items.pG, 9, 12, 30), new h(Items.pA, 5, 1, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.pE, 22, 12, 30), new h(Items.re, 3, 1, 30)})));
        map.put(VillagerProfession.b, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.mi, 15, 16, 2), new h(new ItemStack(Items.nu), 7, 1, 12, 1, 0.2f), new h(new ItemStack(Items.nv), 4, 1, 12, 1, 0.2f), new h(new ItemStack(Items.ns), 5, 1, 12, 1, 0.2f), new h(new ItemStack(Items.nt), 9, 1, 12, 1, 0.2f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.mq, 4, 12, 10), new h(new ItemStack(Items.tl), 36, 1, 12, 5, 0.2f), new h(new ItemStack(Items.nr), 1, 1, 12, 5, 0.2f), new h(new ItemStack(Items.nq), 3, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.nY, 1, 12, 20), new b(Items.mk, 1, 12, 20), new h(new ItemStack(Items.no), 1, 1, 12, 10, 0.2f), new h(new ItemStack(Items.np), 4, 1, 12, 10, 0.2f), new h(new ItemStack(Items.sv), 5, 1, 12, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new e(Items.ny, 14, 3, 15, 0.2f), new e(Items.nz, 8, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.nw, 8, 3, 30, 0.2f), new e(Items.nx, 16, 3, 30, 0.2f)})));
        map.put(VillagerProfession.o, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.mi, 15, 16, 2), new h(new ItemStack(Items.mP), 3, 1, 12, 1, 0.2f), new e(Items.mM, 2, 3, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.mq, 4, 12, 10), new h(new ItemStack(Items.tl), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.nI, 24, 12, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.mk, 1, 12, 30), new e(Items.mU, 12, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.mR, 8, 3, 30, 0.2f)})));
        map.put(VillagerProfession.n, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.mi, 15, 16, 2), new h(new ItemStack(Items.mF), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.mD), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.mE), 1, 1, 12, 1, 0.2f), new h(new ItemStack(Items.mG), 1, 1, 12, 1, 0.2f)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.mq, 4, 12, 10), new h(new ItemStack(Items.tl), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.nI, 30, 12, 20), new e(Items.mP, 1, 3, 10, 0.2f), new e(Items.mN, 2, 3, 10, 0.2f), new e(Items.mO, 3, 3, 10, 0.2f), new h(new ItemStack(Items.mV), 4, 1, 3, 10, 0.2f)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.mk, 1, 12, 30), new e(Items.mU, 12, 3, 15, 0.2f), new e(Items.mS, 5, 3, 15, 0.2f)}, (Object)5, (Object)new IMerchantRecipeOption[]{new e(Items.mT, 13, 3, 30, 0.2f)})));
        map.put(VillagerProfession.c, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.px, 14, 16, 2), new b(Items.nJ, 7, 16, 2), new b(Items.rF, 4, 16, 2), new h(Items.rH, 1, 1, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.mi, 15, 16, 2), new h(Items.nK, 1, 5, 16, 5), new h(Items.py, 1, 8, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.rS, 7, 16, 20), new b(Items.pv, 10, 16, 20)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.ok, 10, 12, 30)}, (Object)5, (Object)new IMerchantRecipeOption[]{new b(Items.to, 10, 12, 30)})));
        map.put(VillagerProfession.i, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.ob, 6, 16, 2), new a(Items.nm, 3), new a(Items.nl, 7)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Items.nI, 26, 12, 10), new a(Items.nk, 5, 12, 5), new a(Items.nn, 4, 12, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Items.rJ, 9, 12, 20), new a(Items.nl, 7)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.md, 4, 12, 30), new a(Items.rO, 6, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(new ItemStack(Items.lL), 6, 1, 12, 30, 0.2f), new a(Items.nk, 5, 12, 30)})));
        map.put(VillagerProfession.k, VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new b(Items.oj, 10, 16, 2), new h(Items.oi, 1, 10, 16, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new b(Blocks.b, 20, 16, 10), new h(Blocks.dF, 1, 4, 16, 5)}, (Object)3, (Object)new IMerchantRecipeOption[]{new b(Blocks.c, 16, 16, 20), new b(Blocks.g, 16, 16, 20), new b(Blocks.e, 16, 16, 20), new h(Blocks.pA, 1, 4, 16, 10), new h(Blocks.h, 1, 4, 16, 10), new h(Blocks.f, 1, 4, 16, 10), new h(Blocks.d, 1, 4, 16, 10)}, (Object)4, (Object)new IMerchantRecipeOption[]{new b(Items.mn, 12, 12, 30), new h(Blocks.fT, 1, 1, 12, 15), new h(Blocks.fS, 1, 1, 12, 15), new h(Blocks.gd, 1, 1, 12, 15), new h(Blocks.fV, 1, 1, 12, 15), new h(Blocks.fZ, 1, 1, 12, 15), new h(Blocks.ga, 1, 1, 12, 15), new h(Blocks.gh, 1, 1, 12, 15), new h(Blocks.gg, 1, 1, 12, 15), new h(Blocks.fY, 1, 1, 12, 15), new h(Blocks.fU, 1, 1, 12, 15), new h(Blocks.fX, 1, 1, 12, 15), new h(Blocks.gf, 1, 1, 12, 15), new h(Blocks.gb, 1, 1, 12, 15), new h(Blocks.gc, 1, 1, 12, 15), new h(Blocks.fW, 1, 1, 12, 15), new h(Blocks.ge, 1, 1, 12, 15), new h(Blocks.jv, 1, 1, 12, 15), new h(Blocks.ju, 1, 1, 12, 15), new h(Blocks.jF, 1, 1, 12, 15), new h(Blocks.jx, 1, 1, 12, 15), new h(Blocks.jB, 1, 1, 12, 15), new h(Blocks.jC, 1, 1, 12, 15), new h(Blocks.jJ, 1, 1, 12, 15), new h(Blocks.jI, 1, 1, 12, 15), new h(Blocks.jA, 1, 1, 12, 15), new h(Blocks.jw, 1, 1, 12, 15), new h(Blocks.jz, 1, 1, 12, 15), new h(Blocks.jH, 1, 1, 12, 15), new h(Blocks.jD, 1, 1, 12, 15), new h(Blocks.jE, 1, 1, 12, 15), new h(Blocks.jy, 1, 1, 12, 15), new h(Blocks.jG, 1, 1, 12, 15)}, (Object)5, (Object)new IMerchantRecipeOption[]{new h(Blocks.fO, 1, 1, 12, 30), new h(Blocks.fM, 1, 1, 12, 30)})));
    });
    public static final Int2ObjectMap<IMerchantRecipeOption[]> b = VillagerTrades.a((ImmutableMap<Integer, IMerchantRecipeOption[]>)ImmutableMap.of((Object)1, (Object)new IMerchantRecipeOption[]{new h(Items.ca, 2, 1, 5, 1), new h(Items.on, 4, 1, 5, 1), new h(Items.ep, 2, 1, 5, 1), new h(Items.sR, 5, 1, 5, 1), new h(Items.bV, 1, 1, 12, 1), new h(Items.cO, 1, 1, 8, 1), new h(Items.ef, 1, 1, 4, 1), new h(Items.cP, 3, 1, 12, 1), new h(Items.dU, 3, 1, 8, 1), new h(Items.cr, 1, 1, 12, 1), new h(Items.cs, 1, 1, 12, 1), new h(Items.ct, 1, 1, 8, 1), new h(Items.cu, 1, 1, 12, 1), new h(Items.cv, 1, 1, 12, 1), new h(Items.cw, 1, 1, 12, 1), new h(Items.cx, 1, 1, 12, 1), new h(Items.cy, 1, 1, 12, 1), new h(Items.cz, 1, 1, 12, 1), new h(Items.cA, 1, 1, 12, 1), new h(Items.cB, 1, 1, 12, 1), new h(Items.cC, 1, 1, 7, 1), new h(Items.nh, 1, 1, 12, 1), new h(Items.so, 1, 1, 12, 1), new h(Items.pt, 1, 1, 12, 1), new h(Items.pu, 1, 1, 12, 1), new h(Items.I, 5, 1, 8, 1), new h(Items.G, 5, 1, 8, 1), new h(Items.J, 5, 1, 8, 1), new h(Items.H, 5, 1, 8, 1), new h(Items.E, 5, 1, 8, 1), new h(Items.F, 5, 1, 8, 1), new h(Items.oS, 1, 3, 12, 1), new h(Items.oE, 1, 3, 12, 1), new h(Items.oP, 1, 3, 12, 1), new h(Items.oK, 1, 3, 12, 1), new h(Items.oT, 1, 3, 12, 1), new h(Items.oR, 1, 3, 12, 1), new h(Items.oM, 1, 3, 12, 1), new h(Items.oG, 1, 3, 12, 1), new h(Items.oI, 1, 3, 12, 1), new h(Items.oL, 1, 3, 12, 1), new h(Items.oO, 1, 3, 12, 1), new h(Items.oH, 1, 3, 12, 1), new h(Items.oJ, 1, 3, 12, 1), new h(Items.oF, 1, 3, 12, 1), new h(Items.oQ, 1, 3, 12, 1), new h(Items.oN, 1, 3, 12, 1), new h(Items.jd, 3, 1, 8, 1), new h(Items.je, 3, 1, 8, 1), new h(Items.jf, 3, 1, 8, 1), new h(Items.jg, 3, 1, 8, 1), new h(Items.jc, 3, 1, 8, 1), new h(Items.eN, 1, 1, 12, 1), new h(Items.cF, 1, 1, 12, 1), new h(Items.cG, 1, 1, 12, 1), new h(Items.eS, 1, 2, 5, 1), new h(Items.cU, 1, 2, 5, 1), new h(Items.L, 1, 8, 8, 1), new h(Items.M, 1, 4, 6, 1), new h(Items.ui, 1, 2, 5, 1), new h(Items.s, 1, 2, 5, 1), new h(Items.cR, 1, 2, 5, 1)}, (Object)2, (Object)new IMerchantRecipeOption[]{new h(Items.og, 5, 1, 4, 1), new h(Items.od, 5, 1, 4, 1), new h(Items.gA, 3, 1, 6, 1), new h(Items.jB, 6, 1, 6, 1), new h(Items.ng, 1, 1, 8, 1), new h(Items.r, 3, 3, 6, 1)}));

    private static Int2ObjectMap<IMerchantRecipeOption[]> a(ImmutableMap<Integer, IMerchantRecipeOption[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    public static interface IMerchantRecipeOption {
        @Nullable
        public MerchantRecipe a(Entity var1, Random var2);
    }

    static class b
    implements IMerchantRecipeOption {
        private final Item a;
        private final int b;
        private final int c;
        private final int d;
        private final float e;

        public b(IMaterial item, int price, int maxUses, int experience) {
            this.a = item.l();
            this.b = price;
            this.c = maxUses;
            this.d = experience;
            this.e = 0.05f;
        }

        @Override
        public MerchantRecipe a(Entity entity, Random random) {
            ItemStack itemStack = new ItemStack(this.a, this.b);
            return new MerchantRecipe(itemStack, new ItemStack(Items.ml), this.c, this.d, this.e);
        }
    }

    static class h
    implements IMerchantRecipeOption {
        private final ItemStack a;
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final float f;

        public h(Block block, int price, int count, int maxUses, int experience) {
            this(new ItemStack(block), price, count, maxUses, experience);
        }

        public h(Item item, int price, int count, int experience) {
            this(new ItemStack(item), price, count, 12, experience);
        }

        public h(Item item, int price, int count, int maxUses, int experience) {
            this(new ItemStack(item), price, count, maxUses, experience);
        }

        public h(ItemStack stack, int price, int count, int maxUses, int experience) {
            this(stack, price, count, maxUses, experience, 0.05f);
        }

        public h(ItemStack stack, int price, int count, int maxUses, int experience, float multiplier) {
            this.a = stack;
            this.b = price;
            this.c = count;
            this.d = maxUses;
            this.e = experience;
            this.f = multiplier;
        }

        @Override
        public MerchantRecipe a(Entity entity, Random random) {
            return new MerchantRecipe(new ItemStack(Items.ml, this.b), new ItemStack(this.a.c(), this.c), this.d, this.e, this.f);
        }
    }

    static class i
    implements IMerchantRecipeOption {
        final MobEffectList a;
        final int b;
        final int c;
        private final float d;

        public i(MobEffectList effect, int duration, int experience) {
            this.a = effect;
            this.b = duration;
            this.c = experience;
            this.d = 0.05f;
        }

        @Override
        @Nullable
        public MerchantRecipe a(Entity entity, Random random) {
            ItemStack itemStack = new ItemStack(Items.sU, 1);
            ItemSuspiciousStew.a(itemStack, this.a, this.b);
            return new MerchantRecipe(new ItemStack(Items.ml, 1), itemStack, 12, this.c, this.d);
        }
    }

    static class g
    implements IMerchantRecipeOption {
        private final ItemStack a;
        private final int b;
        private final int c;
        private final ItemStack d;
        private final int e;
        private final int f;
        private final int g;
        private final float h;

        public g(IMaterial item, int secondCount, Item sellItem, int sellCount, int maxUses, int experience) {
            this(item, secondCount, 1, sellItem, sellCount, maxUses, experience);
        }

        public g(IMaterial item, int secondCount, int price, Item sellItem, int sellCount, int maxUses, int experience) {
            this.a = new ItemStack(item);
            this.b = secondCount;
            this.c = price;
            this.d = new ItemStack(sellItem);
            this.e = sellCount;
            this.f = maxUses;
            this.g = experience;
            this.h = 0.05f;
        }

        @Override
        @Nullable
        public MerchantRecipe a(Entity entity, Random random) {
            return new MerchantRecipe(new ItemStack(Items.ml, this.c), new ItemStack(this.a.c(), this.b), new ItemStack(this.d.c(), this.e), this.f, this.g, this.h);
        }
    }

    static class e
    implements IMerchantRecipeOption {
        private final ItemStack a;
        private final int b;
        private final int c;
        private final int d;
        private final float e;

        public e(Item item, int basePrice, int maxUses, int experience) {
            this(item, basePrice, maxUses, experience, 0.05f);
        }

        public e(Item item, int basePrice, int maxUses, int experience, float multiplier) {
            this.a = new ItemStack(item);
            this.b = basePrice;
            this.c = maxUses;
            this.d = experience;
            this.e = multiplier;
        }

        @Override
        public MerchantRecipe a(Entity entity, Random random) {
            int i2 = 5 + random.nextInt(15);
            ItemStack itemStack = EnchantmentManager.a(random, new ItemStack(this.a.c()), i2, false);
            int j2 = Math.min(this.b + i2, 64);
            ItemStack itemStack2 = new ItemStack(Items.ml, j2);
            return new MerchantRecipe(itemStack2, itemStack, this.c, this.d, this.e);
        }
    }

    static class c
    implements IMerchantRecipeOption {
        private final Map<VillagerType, Item> a;
        private final int b;
        private final int c;
        private final int d;

        public c(int count, int maxUses, int experience, Map<VillagerType, Item> map) {
            IRegistry.am.q().filter(villagerType -> !map.containsKey(villagerType)).findAny().ifPresent(villagerType -> {
                throw new IllegalStateException("Missing trade for villager type: " + IRegistry.am.b((VillagerType)villagerType));
            });
            this.a = map;
            this.b = count;
            this.c = maxUses;
            this.d = experience;
        }

        @Override
        @Nullable
        public MerchantRecipe a(Entity entity, Random random) {
            if (entity instanceof VillagerDataHolder) {
                ItemStack itemStack = new ItemStack(this.a.get(((VillagerDataHolder)((Object)entity)).fK().a()), this.b);
                return new MerchantRecipe(itemStack, new ItemStack(Items.ml), this.c, this.d, 0.05f);
            }
            return null;
        }
    }

    static class j
    implements IMerchantRecipeOption {
        private final ItemStack a;
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final Item f;
        private final int g;
        private final float h;

        public j(Item arrow, int secondCount, Item tippedArrow, int sellCount, int price, int maxUses, int experience) {
            this.a = new ItemStack(tippedArrow);
            this.c = price;
            this.d = maxUses;
            this.e = experience;
            this.f = arrow;
            this.g = secondCount;
            this.b = sellCount;
            this.h = 0.05f;
        }

        @Override
        public MerchantRecipe a(Entity entity, Random random) {
            ItemStack itemStack = new ItemStack(Items.ml, this.c);
            List list = IRegistry.Y.q().filter(potionx -> !potionx.a().isEmpty() && PotionBrewer.a(potionx)).collect(Collectors.toList());
            PotionRegistry potion = (PotionRegistry)list.get(random.nextInt(list.size()));
            ItemStack itemStack2 = PotionUtil.a(new ItemStack(this.a.c(), this.b), potion);
            return new MerchantRecipe(itemStack, new ItemStack(this.f, this.g), itemStack2, this.d, this.e, this.h);
        }
    }

    static class d
    implements IMerchantRecipeOption {
        private final int a;

        public d(int experience) {
            this.a = experience;
        }

        @Override
        public MerchantRecipe a(Entity entity, Random random) {
            List list = IRegistry.V.q().filter(Enchantment::h).collect(Collectors.toList());
            Enchantment enchantment = (Enchantment)list.get(random.nextInt(list.size()));
            int i2 = MathHelper.a(random, enchantment.e(), enchantment.a());
            ItemStack itemStack = ItemEnchantedBook.a(new WeightedRandomEnchant(enchantment, i2));
            int j2 = 2 + random.nextInt(5 + i2 * 10) + 3 * i2;
            if (enchantment.b()) {
                j2 *= 2;
            }
            if (j2 > 64) {
                j2 = 64;
            }
            return new MerchantRecipe(new ItemStack(Items.ml, j2), new ItemStack(Items.om), itemStack, 12, this.a, 0.2f);
        }
    }

    static class k
    implements IMerchantRecipeOption {
        private final int a;
        private final TagKey<StructureFeature<?, ?>> b;
        private final String c;
        private final MapIcon.Type d;
        private final int e;
        private final int f;

        public k(int price, TagKey<StructureFeature<?, ?>> structure, String nameKey, MapIcon.Type iconType, int maxUses, int experience) {
            this.a = price;
            this.b = structure;
            this.c = nameKey;
            this.d = iconType;
            this.e = maxUses;
            this.f = experience;
        }

        @Override
        @Nullable
        public MerchantRecipe a(Entity entity, Random random) {
            if (!(entity.s instanceof WorldServer)) {
                return null;
            }
            WorldServer serverLevel = (WorldServer)entity.s;
            if (!serverLevel.paperConfig.enableTreasureMaps) {
                return null;
            }
            BlockPosition blockPos = serverLevel.a(this.b, entity.cW(), 100, !serverLevel.paperConfig.treasureMapsAlreadyDiscovered);
            if (blockPos != null) {
                ItemStack itemStack = ItemWorldMap.a(serverLevel, blockPos.u(), blockPos.w(), (byte)2, true, true);
                ItemWorldMap.a(serverLevel, itemStack);
                WorldMap.a(itemStack, blockPos, "+", this.d);
                itemStack.a(new ChatMessage(this.c));
                return new MerchantRecipe(new ItemStack(Items.ml, this.a), new ItemStack(Items.op), itemStack, this.e, this.f, 0.2f);
            }
            return null;
        }
    }

    static class a
    implements IMerchantRecipeOption {
        private final Item a;
        private final int b;
        private final int c;
        private final int d;

        public a(Item item, int price) {
            this(item, price, 12, 1);
        }

        public a(Item item, int price, int maxUses, int experience) {
            this.a = item;
            this.b = price;
            this.c = maxUses;
            this.d = experience;
        }

        @Override
        public MerchantRecipe a(Entity entity, Random random) {
            ItemStack itemStack = new ItemStack(Items.ml, this.b);
            ItemStack itemStack2 = new ItemStack(this.a);
            if (this.a instanceof ItemArmorColorable) {
                ArrayList list = Lists.newArrayList();
                list.add(net.minecraft.world.entity.npc.VillagerTrades$a.a(random));
                if (random.nextFloat() > 0.7f) {
                    list.add(net.minecraft.world.entity.npc.VillagerTrades$a.a(random));
                }
                if (random.nextFloat() > 0.8f) {
                    list.add(net.minecraft.world.entity.npc.VillagerTrades$a.a(random));
                }
                itemStack2 = IDyeable.a(itemStack2, list);
            }
            return new MerchantRecipe(itemStack, itemStack2, this.c, this.d, 0.2f);
        }

        private static ItemDye a(Random random) {
            return ItemDye.a(EnumColor.a(random.nextInt(16)));
        }
    }
}

