/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Sets;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private CraftMerchant craftMerchant;
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int bV = 300;
    private static final int bY = 8;
    @Nullable
    private EntityHuman bZ;
    @Nullable
    protected MerchantRecipeList bW;
    private final InventorySubcontainer ca = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());

    @Override
    public CraftMerchant getCraftMerchant() {
        return this.craftMerchant == null ? (this.craftMerchant = new CraftMerchant(this)) : this.craftMerchant;
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(false);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public int q() {
        return this.Y.a(bX);
    }

    public void r(int ticks) {
        this.Y.b(bX, ticks);
    }

    @Override
    public int t() {
        return 0;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? 0.81f : 1.62f;
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bX, 0);
    }

    @Override
    public void f(@Nullable EntityHuman customer) {
        this.bZ = customer;
    }

    @Override
    @Nullable
    public EntityHuman fz() {
        return this.bZ;
    }

    public boolean fA() {
        return this.bZ != null;
    }

    public void resetOffers() {
        this.bW = new MerchantRecipeList();
        this.fH();
    }

    @Override
    public MerchantRecipeList fB() {
        if (this.bW == null) {
            this.bW = new MerchantRecipeList();
            this.fH();
        }
        return this.bW;
    }

    @Override
    public void a(@Nullable MerchantRecipeList offers) {
    }

    @Override
    public void s(int experience) {
    }

    @Override
    public void processTrade(MerchantRecipe recipe, @Nullable PlayerPurchaseEvent event) {
        if (event == null || event.willIncreaseTradeUses()) {
            recipe.j();
        }
        if (event == null || event.isRewardingExp()) {
            this.b(recipe);
        }
        this.a(recipe);
    }

    @Override
    public void a(MerchantRecipe offer) {
        this.bK = -this.J();
        if (this.bZ instanceof EntityPlayer) {
            CriterionTriggers.s.a((EntityPlayer)this.bZ, this, offer.d());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean fC() {
        return true;
    }

    @Override
    public void m(ItemStack stack) {
        if (!this.s.x && this.bK > -this.J() + 20) {
            this.bK = -this.J();
            this.a(this.v(!stack.b()), this.ev(), this.ew());
        }
    }

    @Override
    public SoundEffect fD() {
        return SoundEffects.tX;
    }

    protected SoundEffect v(boolean sold) {
        return sold ? SoundEffects.tX : SoundEffects.tV;
    }

    public void fE() {
        this.a(SoundEffects.tS, this.ev(), this.ew());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        MerchantRecipeList merchantrecipelist = this.fB();
        if (!merchantrecipelist.isEmpty()) {
            nbt.a("Offers", merchantrecipelist.a());
        }
        nbt.a("Inventory", this.ca.g());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("Offers", 10)) {
            this.bW = new MerchantRecipeList(nbt.p("Offers"));
        }
        this.ca.a(nbt.c("Inventory", 10));
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        this.fF();
        return super.b(destination);
    }

    protected void fF() {
        this.f((EntityHuman)null);
    }

    @Override
    public void a(DamageSource source) {
        super.a(source);
        this.fF();
    }

    protected void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.R.nextGaussian() * 0.02;
            double d1 = this.R.nextGaussian() * 0.02;
            double d2 = this.R.nextGaussian() * 0.02;
            this.s.a(parameters, this.d(1.0), this.df() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return false;
    }

    public InventorySubcontainer fG() {
        return this.ca;
    }

    @Override
    public SlotAccess k(int mappedIndex) {
        int j2 = mappedIndex - 300;
        return j2 >= 0 && j2 < this.ca.b() ? SlotAccess.a(this.ca, j2) : super.k(mappedIndex);
    }

    protected abstract void fH();

    protected void a(MerchantRecipeList recipeList, VillagerTrades.IMerchantRecipeOption[] pool, int count) {
        HashSet set = Sets.newHashSet();
        if (pool.length > count) {
            while (set.size() < count) {
                set.add(this.R.nextInt(pool.length));
            }
        } else {
            for (int j2 = 0; j2 < pool.length; ++j2) {
                set.add(j2);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.IMerchantRecipeOption villagertrades_imerchantrecipeoption = pool[integer];
            MerchantRecipe merchantrecipe = villagertrades_imerchantrecipeoption.a(this, this.R);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) continue;
            CraftMerchantRecipe craftMerchantRecipe = CraftMerchantRecipe.fromBukkit(event.getRecipe());
            if (craftMerchantRecipe.getIngredients().isEmpty()) {
                return;
            }
            recipeList.add(craftMerchantRecipe.toMinecraft());
        }
    }

    @Override
    public Vec3D n(float delta) {
        float f1 = MathHelper.i(delta, this.aY, this.aX) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cw().c() - 1.0, 0.2);
        return this.k(delta).e(vec3d.b(-f1));
    }

    @Override
    public boolean fI() {
        return this.s.x;
    }
}

