/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> bX = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.i);
    private static final UUID bZ = UUID.fromString("766bfa64-11f3-11ea-8d71-362b9e155667");
    private static final AttributeModifier ca = new AttributeModifier(bZ, "Baby speed boost", (double)0.2f, AttributeModifier.Operation.b);
    private static final int cb = 16;
    private static final float cc = 0.35f;
    private static final int cd = 5;
    private static final float ce = 1.6f;
    private static final float cf = 0.1f;
    private static final int cg = 3;
    private static final float ch = 0.2f;
    private static final float ci = 0.81f;
    private static final double cj = 0.5;
    public final InventorySubcontainer ck = new InventorySubcontainer(8);
    public boolean cl;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> e = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.k);
    protected static final ImmutableList<MemoryModuleType<?>> bV = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.v, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.ai, MemoryModuleType.ah, MemoryModuleType.K, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.m, (Object[])new MemoryModuleType[]{MemoryModuleType.E, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.t, MemoryModuleType.V, MemoryModuleType.W, MemoryModuleType.z, MemoryModuleType.X, MemoryModuleType.Y, MemoryModuleType.aa, MemoryModuleType.Z, MemoryModuleType.ac, MemoryModuleType.ad, MemoryModuleType.ab, MemoryModuleType.af, MemoryModuleType.L, MemoryModuleType.al, MemoryModuleType.s, MemoryModuleType.am, MemoryModuleType.an, MemoryModuleType.ae, MemoryModuleType.ag, MemoryModuleType.ao, MemoryModuleType.ap, MemoryModuleType.aq});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> type, World world) {
        super(type, world);
        this.bL = 5;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.y_()) {
            nbt.a("IsBaby", true);
        }
        if (this.cl) {
            nbt.a("CannotHunt", true);
        }
        nbt.a("Inventory", this.ck.g());
        NBTTagList barterList = new NBTTagList();
        this.allowedBarterItems.stream().map(IRegistry.X::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(barterList::add);
        nbt.a("Bukkit.BarterList", barterList);
        NBTTagList interestList = new NBTTagList();
        this.interestItems.stream().map(IRegistry.X::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(interestList::add);
        nbt.a("Bukkit.InterestList", interestList);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.x(nbt.q("CannotHunt"));
        this.ck.a(nbt.c("Inventory", 10));
        this.allowedBarterItems = nbt.c("Bukkit.BarterList", 8).stream().map(NBTBase::e_).map(MinecraftKey::a).map(IRegistry.X::a).collect(Collectors.toCollection(HashSet::new));
        this.interestItems = nbt.c("Bukkit.InterestList", 8).stream().map(NBTBase::e_).map(MinecraftKey::a).map(IRegistry.X::a).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    @VisibleForDebug
    public IInventory fJ() {
        return this.ck;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        this.ck.f().forEach(this::b);
    }

    protected ItemStack m(ItemStack stack) {
        return this.ck.a(stack);
    }

    protected boolean n(ItemStack stack) {
        return this.ck.b(stack);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bW, false);
        this.Y.a(bX, false);
        this.Y.a(bY, false);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (bW.equals(data)) {
            this.z_();
        }
    }

    public static AttributeProvider.Builder fF() {
        return EntityMonster.fE().a(GenericAttributes.a, 16.0).a(GenericAttributes.d, 0.35f).a(GenericAttributes.f, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return !world.a_(pos.c()).a(Blocks.iY);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (spawnReason != EnumMobSpawn.d) {
            if (world.r_().nextFloat() < 0.2f) {
                this.a(true);
            } else if (this.fz()) {
                this.a(EnumItemSlot.a, this.fH());
            }
        }
        PiglinAI.a(this);
        this.a(difficulty);
        this.b(difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean P() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return true;
    }

    @Override
    protected void a(DifficultyDamageScaler difficulty) {
        if (this.fz()) {
            this.c(EnumItemSlot.f, new ItemStack(Items.nA));
            this.c(EnumItemSlot.e, new ItemStack(Items.nB));
            this.c(EnumItemSlot.d, new ItemStack(Items.nC));
            this.c(EnumItemSlot.c, new ItemStack(Items.nD));
        }
    }

    private void c(EnumItemSlot slot, ItemStack stack) {
        if (this.s.v.nextFloat() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> dv() {
        return BehaviorController.a(bV, e);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.dv().a(dynamic));
    }

    public BehaviorController<EntityPiglin> du() {
        return super.du();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        if (!this.s.x) {
            return PiglinAI.a(this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.fA() != EntityPiglinArmPose.d;
        return flag ? EnumInteractionResult.a : EnumInteractionResult.d;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? 0.93f : 1.74f;
    }

    @Override
    public double bq() {
        return (double)this.cU() * 0.92;
    }

    @Override
    public void a(boolean baby) {
        this.ai().b(bW, baby);
        if (!this.s.x) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            attributemodifiable.d(ca);
            if (baby) {
                attributemodifiable.b(ca);
            }
        }
    }

    @Override
    public boolean y_() {
        return this.ai().a(bW);
    }

    private void x(boolean cannotHunt) {
        this.cl = cannotHunt;
    }

    @Override
    protected boolean n() {
        return !this.cl;
    }

    @Override
    protected void R() {
        this.s.ab().a("piglinBrain");
        this.du().a((WorldServer)this.s, this);
        this.s.ab().c();
        PiglinAI.b(this);
        super.R();
    }

    @Override
    protected int d(EntityHuman player) {
        return this.bL;
    }

    @Override
    protected void c(WorldServer world) {
        PiglinAI.c(this);
        this.forceDrops = true;
        this.ck.f().forEach(this::b);
        this.forceDrops = false;
        super.c(world);
    }

    private ItemStack fH() {
        return (double)this.R.nextFloat() < 0.5 ? new ItemStack(Items.sT) : new ItemStack(Items.mH);
    }

    public boolean fI() {
        return this.Y.a(bX);
    }

    @Override
    public void b(boolean charging) {
        this.Y.b(bX, charging);
    }

    @Override
    public void a() {
        this.bf = 0;
    }

    @Override
    public EntityPiglinArmPose fA() {
        return this.fG() ? EntityPiglinArmPose.e : (PiglinAI.a(this.et()) ? EntityPiglinArmPose.d : (this.fu() && this.fB() ? EntityPiglinArmPose.a : (this.fI() ? EntityPiglinArmPose.c : (this.fu() && this.b(Items.sT) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f))));
    }

    public boolean fG() {
        return this.Y.a(bY);
    }

    public void w(boolean dancing) {
        this.Y.b(bY, dancing);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (this.s.x) {
            return false;
        }
        if (flag && source.l() instanceof EntityLiving) {
            PiglinAI.a(this, (EntityLiving)source.l());
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b(this, 1.6f);
    }

    @Override
    public void a(EntityLiving target, ItemStack crossbow, IProjectile projectile, float multiShotSpray) {
        this.a(this, target, projectile, multiShotSpray, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.sT;
    }

    protected void o(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void p(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.c())) {
            this.a(EnumItemSlot.b, stack);
            this.d(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean l(ItemStack stack) {
        return this.s.W().b(GameRules.c) && this.fi() && PiglinAI.a(this, stack);
    }

    protected boolean q(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.i(stack);
        ItemStack itemstack1 = this.b(enumitemslot);
        return this.a(stack, itemstack1);
    }

    @Override
    protected boolean a(ItemStack newStack, ItemStack oldStack) {
        boolean flag1;
        if (EnchantmentManager.d(oldStack)) {
            return false;
        }
        boolean flag = PiglinAI.isLovedItem(newStack, this) || newStack.a(Items.sT);
        boolean bl = flag1 = PiglinAI.isLovedItem(oldStack, this) || oldStack.a(Items.sT);
        return flag && !flag1 ? true : (!flag && flag1 ? false : (this.fz() && !newStack.a(Items.sT) && oldStack.a(Items.sT) ? false : super.a(newStack, oldStack)));
    }

    @Override
    protected void b(EntityItem item) {
        this.a(item);
        PiglinAI.a(this, item);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.y_() && entity.ad() == EntityTypes.L) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, force);
    }

    private Entity b(Entity entity, int maxLevel) {
        List<Entity> list = entity.cF();
        return maxLevel != 1 && !list.isEmpty() ? this.b(list.get(0), maxLevel - 1) : entity;
    }

    @Override
    protected SoundEffect r() {
        return this.s.x ? null : (SoundEffect)PiglinAI.d(this).orElse(null);
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.og;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.oe;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.oi, 0.15f, 1.0f);
    }

    protected void a(SoundEffect sound) {
        this.a(sound, this.ev(), this.ew());
    }

    @Override
    protected void fC() {
        this.a(SoundEffects.oj);
    }
}

