/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.i);
    private static final float bZ = 0.2f;
    private static final int ca = 40;
    private static final float cb = 0.3f;
    private static final int cc = 1;
    private static final float cd = 0.6f;
    private static final int ce = 6;
    private static final float cf = 0.5f;
    private static final int cg = 300;
    private int ch;
    public int ci;
    public boolean cj;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> bV = ImmutableList.of(SensorType.c, SensorType.d, SensorType.n, SensorType.m);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bW = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.ak, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.am, MemoryModuleType.an, MemoryModuleType.aj, MemoryModuleType.J, MemoryModuleType.aq, MemoryModuleType.ar});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bL = 5;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.fq();
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fE().a(GenericAttributes.a, 40.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.c, 0.6f).a(GenericAttributes.g, 1.0).a(GenericAttributes.f, 6.0);
    }

    @Override
    public boolean z(Entity target) {
        if (!(target instanceof EntityLiving)) {
            return false;
        }
        this.ch = 10;
        this.s.a((Entity)this, (byte)4);
        this.a(SoundEffects.il, 1.0f, this.ew());
        HoglinAI.a(this, (EntityLiving)target);
        return IOglin.a(this, (EntityLiving)target);
    }

    @Override
    protected void e(EntityLiving target) {
        if (this.t()) {
            IOglin.b(this, target);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean bl = super.a(source, amount);
        if (this.s.x) {
            return false;
        }
        if (bl && source.l() instanceof EntityLiving) {
            HoglinAI.b(this, (EntityLiving)source.l());
        }
        return bl;
    }

    protected BehaviorController.b<EntityHoglin> dv() {
        return BehaviorController.a(bW, bV);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.dv().a(dynamic));
    }

    public BehaviorController<EntityHoglin> du() {
        return super.du();
    }

    @Override
    protected void R() {
        this.s.ab().a("hoglinBrain");
        this.du().a((WorldServer)this.s, this);
        this.s.ab().c();
        HoglinAI.a(this);
        if (this.fA()) {
            ++this.ci;
            if (this.ci > 300) {
                this.a(SoundEffects.im);
                this.c((WorldServer)this.s);
            }
        } else {
            this.ci = 0;
        }
    }

    @Override
    public void w_() {
        if (this.ch > 0) {
            --this.ch;
        }
        super.w_();
    }

    @Override
    protected void n() {
        if (this.y_()) {
            this.bL = 3;
            this.a(GenericAttributes.f).a(0.5);
        } else {
            this.bL = 5;
            this.a(GenericAttributes.f).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return !world.a_(pos.c()).a(Blocks.iY);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (world.r_().nextFloat() < 0.2f) {
            this.a(true);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean h(double distanceSquared) {
        return true;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        if (HoglinAI.a(this, pos)) {
            return -1.0f;
        }
        return world.a_(pos.c()).a(Blocks.mI) ? 10.0f : 0.0f;
    }

    @Override
    public double bq() {
        return (double)this.cU() - (this.y_() ? 0.2 : 0.15);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            this.fh();
        }
        return interactionResult;
    }

    @Override
    public void a(byte status) {
        if (status == 4) {
            this.ch = 10;
            this.a(SoundEffects.il, 1.0f, this.ew());
        } else {
            super.a(status);
        }
    }

    @Override
    public int fz() {
        return this.ch;
    }

    @Override
    protected boolean dI() {
        return true;
    }

    @Override
    protected int d(EntityHuman player) {
        return this.bL;
    }

    private void c(WorldServer word) {
        EntityZoglin zoglin = this.a(EntityTypes.bd, true);
        if (zoglin != null) {
            zoglin.b(new MobEffect(MobEffects.i, 200, 0));
        }
    }

    @Override
    public boolean n(ItemStack stack) {
        return stack.a(Items.cH);
    }

    public boolean t() {
        return !this.y_();
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bY, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.fH()) {
            nbt.a("IsImmuneToZombification", true);
        }
        nbt.a("TimeInOverworld", this.ci);
        if (this.cj) {
            nbt.a("CannotBeHunted", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.v(nbt.q("IsImmuneToZombification"));
        this.ci = nbt.h("TimeInOverworld");
        this.w(nbt.q("CannotBeHunted"));
    }

    public void v(boolean immuneToZombification) {
        this.ai().b(bY, immuneToZombification);
    }

    public boolean fH() {
        return this.ai().a(bY);
    }

    public boolean fA() {
        return !this.s.q_().f() && !this.fH() && !this.fs();
    }

    private void w(boolean cannotBeHunted) {
        this.cj = cannotBeHunted;
    }

    public boolean fB() {
        return this.t() && !this.cj;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        EntityHoglin hoglin = EntityTypes.L.a(world);
        if (hoglin != null) {
            hoglin.fh();
        }
        return hoglin;
    }

    @Override
    public boolean fC() {
        return !HoglinAI.c(this) && super.fC();
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect r() {
        return this.s.x ? null : HoglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.io;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.in;
    }

    @Override
    protected SoundEffect aF() {
        return SoundEffects.iR;
    }

    @Override
    protected SoundEffect aG() {
        return SoundEffects.iQ;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.iq, 0.15f, 1.0f);
    }

    protected void a(SoundEffect sound) {
        this.a(sound, this.ev(), this.ew());
    }

    @Override
    protected void Q() {
        super.Q();
        PacketDebug.a(this);
    }
}

