/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchReadyPotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.ItemStack;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final UUID b = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier e = new AttributeModifier(b, "Drinking speed penalty", -0.25, AttributeModifier.Operation.a);
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(EntityWitch.class, DataWatcherRegistry.i);
    public int bW;
    private PathfinderGoalNearestHealableRaider<EntityRaider> bX;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> bY;

    public EntityWitch(EntityTypes<? extends EntityWitch> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
    }

    @Override
    protected void u() {
        super.u();
        this.bX = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, entityliving -> entityliving != null && this.fO() && entityliving.ad() != EntityTypes.aY);
        this.bY = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, (Predicate<EntityLiving>)null);
        this.bQ.a(1, new PathfinderGoalFloat(this));
        this.bQ.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.bQ.a(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bQ.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bQ.a(3, new PathfinderGoalRandomLookaround(this));
        this.bR.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.bR.a(2, this.bX);
        this.bR.a(3, this.bY);
    }

    @Override
    protected void a_() {
        super.a_();
        this.ai().a(bV, false);
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.uN;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.uR;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.uP;
    }

    public void x(boolean drinking) {
        this.ai().b(bV, drinking);
    }

    public boolean n() {
        return this.ai().a(bV);
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fE().a(GenericAttributes.a, 26.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    public void w_() {
        if (!this.s.x && this.bl()) {
            this.bX.k();
            if (this.bX.i() <= 0) {
                this.bY.a(true);
            } else {
                this.bY.a(false);
            }
            if (this.n()) {
                if (this.bW-- <= 0) {
                    this.x(false);
                    net.minecraft.world.item.ItemStack itemstack = this.es();
                    this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.b);
                    if (itemstack.a(Items.pF)) {
                        List<MobEffect> list;
                        WitchConsumePotionEvent event = new WitchConsumePotionEvent((Witch)this.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemstack));
                        List<MobEffect> list2 = list = event.callEvent() ? PotionUtil.a(CraftItemStack.asNMSCopy(event.getPotion())) : null;
                        if (list != null) {
                            for (MobEffect mobeffect : list) {
                                this.addEffect(new MobEffect(mobeffect), EntityPotionEffectEvent.Cause.ATTACK);
                            }
                        }
                    }
                    this.a(GenericAttributes.d).d(e);
                }
            } else {
                PotionRegistry potionregistry = null;
                if (this.R.nextFloat() < 0.15f && ((Entity)this).a(TagsFluid.a) && !this.a(MobEffects.m)) {
                    potionregistry = Potions.x;
                } else if (this.R.nextFloat() < 0.15f && (this.bE() || this.ec() != null && this.ec().s()) && !this.a(MobEffects.l)) {
                    potionregistry = Potions.m;
                } else if (this.R.nextFloat() < 0.05f && this.ea() < this.em()) {
                    potionregistry = Potions.z;
                } else if (this.R.nextFloat() < 0.5f && this.G() != null && !this.a(MobEffects.a) && this.G().f((Entity)this) > 121.0) {
                    potionregistry = Potions.o;
                }
                if (potionregistry != null) {
                    net.minecraft.world.item.ItemStack potion = PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.pF), potionregistry);
                    this.setDrinkingPotion(potion);
                }
            }
            if (this.R.nextFloat() < 7.5E-4f) {
                this.s.a((Entity)this, (byte)15);
            }
        }
        super.w_();
    }

    public void setDrinkingPotion(net.minecraft.world.item.ItemStack potion) {
        ItemStack bukkitStack = WitchReadyPotionEvent.process((Witch)((Witch)this.getBukkitEntity()), (ItemStack)CraftItemStack.asCraftMirror(potion));
        this.a(EnumItemSlot.a, CraftItemStack.asNMSCopy(bukkitStack));
        this.bW = this.es().p();
        this.x(true);
        if (!this.aL()) {
            this.s.a((EntityHuman)null, this.dc(), this.de(), this.di(), SoundEffects.uQ, this.cO(), 1.0f, 0.8f + this.R.nextFloat() * 0.4f);
        }
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        attributemodifiable.d(e);
        attributemodifiable.b(e);
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.uO;
    }

    @Override
    public void a(byte status) {
        if (status == 15) {
            for (int i2 = 0; i2 < this.R.nextInt(35) + 10; ++i2) {
                this.s.a(Particles.ac, this.dc() + this.R.nextGaussian() * (double)0.13f, this.cw().e + 0.5 + this.R.nextGaussian() * (double)0.13f, this.di() + this.R.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.a(status);
        }
    }

    @Override
    protected float e(DamageSource source, float amount) {
        amount = super.e(source, amount);
        if (source.l() == this) {
            amount = 0.0f;
        }
        if (source.x()) {
            amount *= 0.15f;
        }
        return amount;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        if (!this.n()) {
            Vec3D vec3d = target.da();
            double d0 = target.dc() + vec3d.b - this.dc();
            double d1 = target.dg() - (double)1.1f - this.de();
            double d2 = target.di() + vec3d.d - this.di();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            PotionRegistry potionregistry = Potions.B;
            if (target instanceof EntityRaider) {
                potionregistry = target.ea() <= 4.0f ? Potions.z : Potions.G;
                this.h((EntityLiving)null);
            } else if (d3 >= 8.0 && !target.a(MobEffects.b)) {
                potionregistry = Potions.r;
            } else if (target.ea() >= 8.0f && !target.a(MobEffects.s)) {
                potionregistry = Potions.D;
            } else if (d3 <= 3.0 && !target.a(MobEffects.r) && this.R.nextFloat() < 0.25f) {
                potionregistry = Potions.M;
            }
            net.minecraft.world.item.ItemStack potion = PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.sr), potionregistry);
            WitchThrowPotionEvent event = new WitchThrowPotionEvent((Witch)this.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(potion));
            if (!event.callEvent()) {
                return;
            }
            potion = CraftItemStack.asNMSCopy(event.getPotion());
            EntityPotion entitypotion = new EntityPotion(this.s, this);
            entitypotion.a(potion);
            entitypotion.p(entitypotion.do() - -20.0f);
            entitypotion.c(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
            if (!this.aL()) {
                this.s.a((EntityHuman)null, this.dc(), this.de(), this.di(), SoundEffects.uS, this.cO(), 1.0f, 0.8f + this.R.nextFloat() * 0.4f);
            }
            this.s.b(entitypotion);
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 1.62f;
    }

    @Override
    public void a(int wave, boolean unused) {
    }

    @Override
    public boolean fA() {
        return false;
    }
}

