/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public class EntityStrider
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final float bV = 0.23f;
    private static final float bW = 0.66f;
    private static final float bY = 0.55f;
    private static final RecipeItemStack bZ = RecipeItemStack.a(Items.cI);
    private static final RecipeItemStack ca = RecipeItemStack.a(Items.cI, Items.lS);
    private static final DataWatcherObject<Integer> cb = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(EntityStrider.class, DataWatcherRegistry.i);
    public final SaddleStorage ce;
    @Nullable
    private PathfinderGoalTempt cf;
    @Nullable
    private PathfinderGoalPanic cg;

    public EntityStrider(EntityTypes<? extends EntityStrider> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.ce = new SaddleStorage(this.Y, cb, cd);
        this.q = true;
        this.a(PathType.j, -1.0f);
        this.a(PathType.i, 0.0f);
        this.a(PathType.n, 0.0f);
        this.a(PathType.o, 0.0f);
    }

    public static boolean c(EntityTypes<EntityStrider> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.i();
        do {
            blockposition_mutableblockposition.c(EnumDirection.b);
        } while (world.b_(blockposition_mutableblockposition).a(TagsFluid.b));
        return world.a_(blockposition_mutableblockposition).g();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (cb.equals(data) && this.s.x) {
            this.ce.a();
        }
        super.a(data);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(cb, 0);
        this.Y.a(cc, false);
        this.Y.a(cd, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.ce.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.ce.b(nbt);
    }

    @Override
    public boolean d() {
        return this.ce.b();
    }

    @Override
    public boolean c() {
        return this.bl() && !this.y_();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.ce.a(true);
        if (sound != null) {
            this.s.a((EntityHuman)null, this, SoundEffects.sa, sound, 0.5f, 1.0f);
        }
    }

    @Override
    protected void u() {
        this.cg = new PathfinderGoalPanic(this, 1.65);
        this.bQ.a(1, this.cg);
        this.bQ.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cf = new PathfinderGoalTempt(this, 1.4, ca, false);
        this.bQ.a(3, this.cf);
        this.bQ.a(4, new a(this, 1.5));
        this.bQ.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.bQ.a(7, new PathfinderGoalRandomStroll(this, 1.0, 60));
        this.bQ.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bQ.a(8, new PathfinderGoalRandomLookaround(this));
        this.bQ.a(9, new PathfinderGoalLookAtPlayer(this, EntityStrider.class, 8.0f));
    }

    public void v(boolean cold) {
        this.Y.b(cc, cold);
    }

    public boolean q() {
        return this.cN() instanceof EntityStrider ? ((EntityStrider)this.cN()).q() : this.Y.a(cc).booleanValue();
    }

    @Override
    public boolean a(Fluid fluid) {
        return fluid.a(TagsFluid.b);
    }

    @Override
    public double bq() {
        float f2 = Math.min(0.25f, this.aS);
        float f1 = this.aT;
        return (double)this.cU() - 0.19 + (double)(0.12f * MathHelper.b(f1 * 1.5f) * 2.0f * f2);
    }

    @Override
    public boolean fg() {
        Entity entity = this.cE();
        if (!(entity instanceof EntityHuman)) {
            return false;
        }
        EntityHuman entityhuman = (EntityHuman)entity;
        return entityhuman.es().a(Items.lS) || entityhuman.et().a(Items.lS);
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    @Nullable
    public Entity cE() {
        return this.cG();
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D[] avec3d = new Vec3D[]{EntityStrider.a(this.cT(), (double)passenger.cT(), passenger.dn()), EntityStrider.a(this.cT(), (double)passenger.cT(), passenger.dn() - 22.5f), EntityStrider.a(this.cT(), (double)passenger.cT(), passenger.dn() + 22.5f), EntityStrider.a(this.cT(), (double)passenger.cT(), passenger.dn() - 45.0f), EntityStrider.a(this.cT(), (double)passenger.cT(), passenger.dn() + 45.0f)};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.cw().e;
        double d1 = this.cw().b - 0.5;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        Vec3D[] avec3d1 = avec3d;
        int i2 = avec3d.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3d = avec3d1[j2];
            blockposition_mutableblockposition.c(this.dc() + vec3d.b, d0, this.di() + vec3d.d);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockposition_mutableblockposition.h());
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
        for (BlockPosition blockposition : set) {
            double d3;
            if (this.s.b_(blockposition).a(TagsFluid.b) || !DismountUtil.a(d3 = this.s.i(blockposition))) continue;
            Vec3D vec3d1 = Vec3D.a(blockposition, d3);
            for (EntityPose entitypose : passenger.eZ()) {
                AxisAlignedBB axisalignedbb = passenger.f(entitypose);
                if (!DismountUtil.a(this.s, passenger, axisalignedbb.c(vec3d1))) continue;
                passenger.b(entitypose);
                return vec3d1;
            }
        }
        return new Vec3D(this.dc(), this.cw().e, this.di());
    }

    @Override
    public void h(Vec3D movementInput) {
        this.r(this.t());
        this.a(this, this.ce, movementInput);
    }

    public float t() {
        return (float)this.b(GenericAttributes.d) * (this.q() ? 0.66f : 1.0f);
    }

    @Override
    public float b() {
        return (float)this.b(GenericAttributes.d) * (this.q() ? 0.23f : 0.55f);
    }

    @Override
    public void a(Vec3D movementInput) {
        super.h(movementInput);
    }

    @Override
    protected float aE() {
        return this.J + 0.6f;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.bc() ? SoundEffects.rY : SoundEffects.rX, 1.0f, 1.0f);
    }

    @Override
    public boolean a() {
        return this.ce.a(this.dL());
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData landedState, BlockPosition landedPosition) {
        this.aI();
        if (this.bc()) {
            this.m();
        } else {
            super.a(heightDifference, onGround, landedState, landedPosition);
        }
    }

    @Override
    public void k() {
        if (this.fB() && this.R.nextInt(140) == 0) {
            this.a(SoundEffects.rT, 1.0f, this.ew());
        } else if (this.fA() && this.R.nextInt(60) == 0) {
            this.a(SoundEffects.rU, 1.0f, this.ew());
        }
        IBlockData iblockdata = this.s.a_(this.cW());
        IBlockData iblockdata1 = this.aZ();
        boolean flag = iblockdata.a(TagsBlock.aH) || iblockdata1.a(TagsBlock.aH) || this.b(TagsFluid.b) > 0.0;
        if (!flag ^ this.q() && CraftEventFactory.callStriderTemperatureChangeEvent(this, !flag)) {
            this.v(!flag);
        }
        super.k();
        this.fH();
        this.aI();
    }

    private boolean fA() {
        return this.cg != null && this.cg.k();
    }

    private boolean fB() {
        return this.cf != null && this.cf.i();
    }

    @Override
    protected boolean x() {
        return true;
    }

    private void fH() {
        if (this.bc()) {
            VoxelShapeCollision voxelshapecollision = VoxelShapeCollision.a(this);
            if (voxelshapecollision.a(BlockFluids.c, this.cW(), true) && !this.s.b_(this.cW().b()).a(TagsFluid.b)) {
                this.y = true;
            } else {
                this.g(this.da().a(0.5).b(0.0, 0.05, 0.0));
            }
        }
    }

    public static AttributeProvider.Builder fz() {
        return EntityInsentient.w().a(GenericAttributes.d, 0.175f).a(GenericAttributes.b, 16.0);
    }

    @Override
    protected SoundEffect r() {
        return !this.fA() && !this.fB() ? SoundEffects.rS : null;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.rW;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.rV;
    }

    @Override
    protected boolean o(Entity passenger) {
        return !this.bG() && !((Entity)this).a(TagsFluid.b);
    }

    @Override
    public boolean eE() {
        return true;
    }

    @Override
    public boolean bE() {
        return false;
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new b(this, world);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).o().a(TagsFluid.b) ? 10.0f : (this.bc() ? Float.NEGATIVE_INFINITY : 0.0f);
    }

    public EntityStrider b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aL.a(world);
    }

    @Override
    public boolean n(ItemStack stack) {
        return bZ.a(stack);
    }

    @Override
    protected void ed() {
        super.ed();
        if (this.d()) {
            this.a((IMaterial)Items.lL);
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.n(player.b(hand));
        if (!flag && this.d() && !this.bG() && !player.fg()) {
            if (!this.s.x) {
                player.k(this);
            }
            return EnumInteractionResult.a(this.s.x);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.lL) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.d;
        }
        if (flag && !this.aL()) {
            this.s.a((EntityHuman)null, this.dc(), this.de(), this.di(), SoundEffects.rZ, this.cO(), 1.0f, 1.0f + (this.R.nextFloat() - this.R.nextFloat()) * 0.2f);
        }
        return enuminteractionresult;
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.6f * this.cy(), this.cT() * 0.4f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        GroupDataEntity object;
        if (this.y_()) {
            return super.a(world, difficulty, spawnReason, entityData, entityNbt);
        }
        if (this.R.nextInt(30) == 0) {
            EntityInsentient entityinsentient = EntityTypes.bh.a(world.F());
            object = this.a(world, difficulty, entityinsentient, new EntityZombie.GroupDataZombie(EntityZombie.a(this.R), false));
            entityinsentient.a(EnumItemSlot.a, new ItemStack(Items.lS));
            this.a((SoundCategory)null);
        } else if (this.R.nextInt(10) == 0) {
            EntityAgeable entityageable = EntityTypes.aL.a(world.F());
            entityageable.b_(-24000);
            object = this.a(world, difficulty, entityageable, (GroupDataEntity)null);
        } else {
            object = new EntityAgeable.a(0.5f);
        }
        return super.a(world, difficulty, spawnReason, object, entityNbt);
    }

    private GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EntityInsentient rider, @Nullable GroupDataEntity entityData) {
        rider.b(this.dc(), this.de(), this.di(), this.dn(), 0.0f);
        rider.a(world, difficulty, EnumMobSpawn.g, entityData, null);
        rider.a((Entity)this, true);
        return new EntityAgeable.a(0.0f);
    }

    private static class a
    extends PathfinderGoalGotoTarget {
        private final EntityStrider g;

        a(EntityStrider strider, double speed) {
            super(strider, speed, 8, 2);
            this.g = strider;
        }

        @Override
        public BlockPosition k() {
            return this.e;
        }

        @Override
        public boolean b() {
            return !this.g.bc() && this.a(this.g.s, this.e);
        }

        @Override
        public boolean a() {
            return !this.g.bc() && super.a();
        }

        @Override
        public boolean l() {
            return this.d % 20 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            return world.a_(pos).a(Blocks.B) && world.a_(pos.b()).a((IBlockAccess)world, pos, PathMode.a);
        }
    }

    private static class b
    extends Navigation {
        b(EntityStrider entity, World world) {
            super(entity, world);
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new PathfinderNormal();
            return new Pathfinder(this.o, range);
        }

        @Override
        protected boolean a(PathType pathType) {
            return pathType != PathType.i && pathType != PathType.o && pathType != PathType.n ? super.a(pathType) : true;
        }

        @Override
        public boolean a(BlockPosition pos) {
            return this.b.a_(pos).a(Blocks.B) || super.a(pos);
        }
    }
}

