/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> bV = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int b = 1;
    public static final int c = 127;
    public float d;
    public float e;
    public float bU;
    private boolean bW;
    private boolean canWander = true;

    public EntitySlime(EntityTypes<? extends EntitySlime> type, World world) {
        super((EntityTypes<? extends EntityInsentient>)type, world);
        this.bN = new ControllerMoveSlime(this);
    }

    @Override
    protected void u() {
        this.bQ.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bQ.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bQ.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bQ.a(5, new PathfinderGoalSlimeIdle(this));
        this.bR.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, entityliving -> Math.abs(entityliving.de() - this.de()) <= 4.0));
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bV, 1);
    }

    public void a(int size, boolean heal) {
        int j2 = MathHelper.a(size, 1, 127);
        this.Y.b(bV, j2);
        this.am();
        this.z_();
        this.a(GenericAttributes.a).a(j2 * j2);
        this.a(GenericAttributes.d).a(0.2f + 0.1f * (float)j2);
        this.a(GenericAttributes.f).a(j2);
        if (heal) {
            this.c(this.em());
        }
        this.bL = j2;
    }

    public int fC() {
        return this.Y.a(bV);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Paper.canWander", this.canWander);
        nbt.a("Size", this.fC() - 1);
        nbt.a("wasOnGround", this.bW);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.a(nbt.h("Size") + 1, false);
        super.a(nbt);
        if (nbt.e("Paper.canWander")) {
            this.canWander = nbt.q("Paper.canWander");
        }
        this.bW = nbt.q("wasOnGround");
    }

    public boolean fD() {
        return this.fC() <= 1;
    }

    protected ParticleParam q() {
        return Particles.L;
    }

    @Override
    protected boolean P() {
        return this.fC() > 0;
    }

    @Override
    public void k() {
        this.e += (this.d - this.e) * 0.5f;
        this.bU = this.e;
        super.k();
        if (this.y && !this.bW) {
            int i2 = this.fC();
            for (int j2 = 0; j2 < i2 * 8; ++j2) {
                float f2 = this.R.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.R.nextFloat() * 0.5f + 0.5f;
                float f22 = MathHelper.a(f2) * (float)i2 * 0.5f * f1;
                float f3 = MathHelper.b(f2) * (float)i2 * 0.5f * f1;
                this.s.a(this.q(), this.dc() + (double)f22, this.de(), this.di() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.a(this.fA(), this.ev(), ((this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.y && this.bW) {
            this.d = 1.0f;
        }
        this.bW = this.y;
        this.fx();
    }

    protected void fx() {
        this.d *= 0.6f;
    }

    protected int t() {
        return this.R.nextInt(20) + 10;
    }

    @Override
    public void z_() {
        double d0 = this.dc();
        double d1 = this.de();
        double d2 = this.di();
        super.z_();
        this.e(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bV.equals(data)) {
            this.z_();
            this.o(this.aZ);
            this.aX = this.aZ;
            if (this.aQ() && this.R.nextInt(20) == 0) {
                this.aY();
            }
        }
        super.a(data);
    }

    public EntityTypes<? extends EntitySlime> ad() {
        return super.ad();
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        int i2 = this.fC();
        if (!this.s.x && i2 > 1 && this.eb()) {
            IChatBaseComponent ichatbasecomponent = this.Z();
            boolean flag = this.fs();
            float f2 = (float)i2 / 4.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.R.nextInt(3);
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.a(reason);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f1 = ((float)(l2 % 2) - 0.5f) * f2;
                float f22 = ((float)(l2 / 2) - 0.5f) * f2;
                EntitySlime entityslime = this.ad().a(this.s);
                if (this.fj()) {
                    entityslime.fh();
                }
                entityslime.aware = this.aware;
                entityslime.a(ichatbasecomponent);
                entityslime.s(flag);
                entityslime.m(this.cg());
                entityslime.a(j2, true);
                entityslime.b(this.dc() + (double)f1, this.de() + 0.5, this.di() + (double)f22, this.R.nextFloat() * 360.0f, 0.0f);
                slimes.add(entityslime);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.a(reason);
                return;
            }
            for (EntityLiving living : slimes) {
                this.s.addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.a(reason);
    }

    @Override
    public void g(Entity entity) {
        super.g(entity);
        if (entity instanceof EntityIronGolem && this.fy()) {
            this.j((EntityLiving)entity);
        }
    }

    @Override
    public void b(EntityHuman player) {
        if (this.fy()) {
            this.j(player);
        }
    }

    protected void j(EntityLiving target) {
        if (this.bl()) {
            int i2 = this.fC();
            if (this.f((Entity)target) < 0.6 * (double)i2 * 0.6 * (double)i2 && this.B(target) && target.a(DamageSource.c(this), this.fz())) {
                this.a(SoundEffects.rl, 1.0f, (this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f);
                this.a((EntityLiving)this, (Entity)target);
            }
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.625f * dimensions.b;
    }

    protected boolean fy() {
        return !this.fD() && this.eI();
    }

    protected float fz() {
        return (float)this.b(GenericAttributes.f);
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return this.fD() ? SoundEffects.sc : SoundEffects.rn;
    }

    @Override
    public SoundEffect x_() {
        return this.fD() ? SoundEffects.sb : SoundEffects.rm;
    }

    protected SoundEffect fA() {
        return this.fD() ? SoundEffects.se : SoundEffects.rp;
    }

    @Override
    public MinecraftKey N() {
        return this.fC() == 1 ? this.ad().j() : LootTables.a;
    }

    public static boolean c(EntityTypes<EntitySlime> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        if (world.af() != EnumDifficulty.a) {
            double maxHeightSwamp = world.getMinecraftWorld().paperConfig.slimeMaxSpawnHeightInSwamp;
            double minHeightSwamp = world.getMinecraftWorld().paperConfig.slimeMinSpawnHeightInSwamp;
            if (world.v(pos).a(Biomes.g) && (double)pos.v() > minHeightSwamp && (double)pos.v() < maxHeightSwamp && random.nextFloat() < 0.5f && random.nextFloat() < world.ak() && world.B(pos) <= random.nextInt(8)) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
            if (!(world instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(pos);
            boolean flag = world.getMinecraftWorld().paperConfig.allChunksAreSlimeChunks || SeededRandom.a(chunkcoordintpair.c, chunkcoordintpair.d, ((GeneratorAccessSeed)world).D(), world.getMinecraftWorld().spigotConfig.slimeSeed).nextInt(10) == 0;
            double maxHeightSlimeChunk = world.getMinecraftWorld().paperConfig.slimeMaxSpawnHeightInSlimeChunks;
            if (random.nextInt(10) == 0 && flag && (double)pos.v() < maxHeightSlimeChunk) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float ev() {
        return 0.4f * (float)this.fC();
    }

    @Override
    public int T() {
        return 0;
    }

    protected boolean fE() {
        return this.fC() > 0;
    }

    @Override
    protected void eA() {
        Vec3D vec3d = this.da();
        this.n(vec3d.b, this.ey(), vec3d.d);
        this.af = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        int i2 = this.R.nextInt(3);
        if (i2 < 2 && this.R.nextFloat() < 0.5f * difficulty.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    float n() {
        float f2 = this.fD() ? 1.4f : 0.8f;
        return ((this.R.nextFloat() - this.R.nextFloat()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect fB() {
        return this.fD() ? SoundEffects.sd : SoundEffects.ro;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return super.a(pose).a(0.255f * (float)this.fC());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime slime) {
            super(slime);
            this.n = slime;
            this.l = 180.0f * slime.dn() / (float)Math.PI;
        }

        public void a(float targetYaw, boolean jumpOften) {
            this.l = targetYaw;
            this.o = jumpOften;
        }

        public void a(double speed) {
            this.h = speed;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.o(this.a(this.d.dn(), this.l, 90.0f));
            this.d.aZ = this.d.dn();
            this.d.aX = this.d.dn();
            if (this.k != ControllerMove.Operation.b) {
                this.d.u(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aw()) {
                    this.d.r((float)(this.h * this.d.b(GenericAttributes.d)));
                    if (this.m-- <= 0) {
                        this.m = this.n.t();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.C().a();
                        if (this.n.fE()) {
                            this.n.a(this.n.fB(), this.n.ev(), this.n.n());
                        }
                    } else {
                        this.n.bo = 0.0f;
                        this.n.bq = 0.0f;
                        this.d.r(0.0f);
                    }
                } else {
                    this.d.r((float)(this.h * this.d.b(GenericAttributes.d)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            slime.D().d(true);
        }

        @Override
        public boolean a() {
            return (this.a.aQ() || this.a.bc()) && this.a.A() instanceof ControllerMoveSlime && this.a.canWander && new SlimeSwimEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean E_() {
            return true;
        }

        @Override
        public void e() {
            if (this.a.dL().nextFloat() < 0.8f) {
                this.a.C().a();
            }
            ((ControllerMoveSlime)this.a.A()).a(1.2);
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = this.a.G();
            if (entityliving == null || !entityliving.bl()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return this.a.A() instanceof ControllerMoveSlime && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public void c() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.c();
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.G();
            if (entityliving == null || !entityliving.bl()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return --this.b > 0 && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean E_() {
            return true;
        }

        @Override
        public void e() {
            EntityLiving entityliving = this.a.G();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            ((ControllerMoveSlime)this.a.A()).a(this.a.dn(), this.a.fy());
        }

        @Override
        public void d() {
            this.b = 0;
            this.a.h((EntityLiving)null);
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return this.a.G() == null && (this.a.y || this.a.aQ() || this.a.bc() || this.a.a(MobEffects.y)) && this.a.A() instanceof ControllerMoveSlime && this.a.canWander;
        }

        @Override
        public void e() {
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.dL().nextInt(60));
                this.b = this.a.dL().nextInt(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((Slime)this.a.getBukkitEntity(), this.b);
                if (!this.a.canWander || !event.callEvent()) {
                    return;
                }
                this.b = event.getNewYaw();
            }
            ((ControllerMoveSlime)this.a.A()).a(this.b, false);
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return !this.a.bF() && this.a.canWander && new SlimeWanderEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void e() {
            ((ControllerMoveSlime)this.a.A()).a(1.0);
        }
    }
}

