/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> b = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack c = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.u(false);
        }

        @Override
        public void c() {
            super.c();
            EntitySkeletonAbstract.this.u(true);
        }
    };
    private boolean shouldBurnInDay = true;

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.t();
    }

    @Override
    protected void u() {
        this.bQ.a(2, new PathfinderGoalRestrictSun(this));
        this.bQ.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.bQ.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.bQ.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bQ.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bQ.a(6, new PathfinderGoalRandomLookaround(this));
        this.bR.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bR.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bW));
    }

    public static AttributeProvider.Builder n() {
        return EntityMonster.fE().a(GenericAttributes.d, 0.25);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.q(), 0.15f, 1.0f);
    }

    abstract SoundEffect q();

    @Override
    public EnumMonsterType er() {
        return EnumMonsterType.b;
    }

    public boolean shouldBurnInDay() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public void w_() {
        boolean flag;
        boolean bl = flag = this.shouldBurnInDay && this.fv();
        if (flag) {
            ItemStack itemstack = this.b(EnumItemSlot.f);
            if (!itemstack.b()) {
                if (itemstack.g()) {
                    itemstack.b(itemstack.i() + this.R.nextInt(2));
                    if (itemstack.i() >= itemstack.j()) {
                        this.c(EnumItemSlot.f);
                        this.a(EnumItemSlot.f, ItemStack.b);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.f(8);
            }
        }
        super.w_();
    }

    @Override
    public void bo() {
        super.bo();
        if (this.cN() instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)this.cN();
            this.aX = entitycreature.aX;
        }
    }

    @Override
    protected void a(DifficultyDamageScaler difficulty) {
        super.a(difficulty);
        this.a(EnumItemSlot.a, new ItemStack(Items.mg));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        entityData = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        this.a(difficulty);
        this.b(difficulty);
        this.t();
        this.r(this.s.paperConfig.skeletonsAlwaysCanPickUpLoot || this.R.nextFloat() < 0.55f * difficulty.d());
        if (this.b(EnumItemSlot.f).b()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && this.R.nextFloat() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(this.R.nextFloat() < 0.1f ? Blocks.dd : Blocks.dc));
                this.bT[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        return entityData;
    }

    public void t() {
        if (this.s != null && !this.s.x) {
            this.bQ.a(this.c);
            this.bQ.a(this.b);
            ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.mg));
            if (itemstack.a(Items.mg)) {
                int b0 = 20;
                if (this.s.af() != EnumDifficulty.d) {
                    b0 = 40;
                }
                this.b.c(b0);
                this.bQ.a(4, this.b);
            } else {
                this.bQ.a(4, this.c);
            }
        }
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        ItemStack itemstack = this.h(this.b(ProjectileHelper.a(this, Items.mg)));
        EntityArrow entityarrow = this.b(itemstack, pullProgress);
        double d0 = target.dc() - this.dc();
        double d1 = target.e(0.3333333333333333) - entityarrow.de();
        double d2 = target.di() - this.di();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        entityarrow.c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.s.af().a() * 4);
        EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.es(), entityarrow.l(), entityarrow, EnumHand.a, 0.8f, true);
        if (event.isCancelled()) {
            event.getProjectile().remove();
            return;
        }
        if (event.getProjectile() == entityarrow.getBukkitEntity()) {
            this.s.b(entityarrow);
        }
        this.a(SoundEffects.rj, 1.0f, 1.0f / (this.dL().nextFloat() * 0.4f + 0.8f));
    }

    protected EntityArrow b(ItemStack arrow, float damageModifier) {
        return ProjectileHelper.a(this, arrow, damageModifier);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.mg;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.t();
        if (nbt.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = nbt.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void a(EnumItemSlot slot, ItemStack stack) {
        super.a(slot, stack);
        if (!this.s.x) {
            this.t();
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 1.74f;
    }

    @Override
    public double bp() {
        return -0.6;
    }

    public boolean fz() {
        return this.cb();
    }
}

