/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMonsterEggs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public class EntitySilverfish
extends EntityMonster {
    @Nullable
    private PathfinderGoalSilverfishWakeOthers b;

    public EntitySilverfish(EntityTypes<? extends EntitySilverfish> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
    }

    @Override
    protected void u() {
        this.b = new PathfinderGoalSilverfishWakeOthers(this);
        this.bQ.a(1, new PathfinderGoalFloat(this));
        this.bQ.a(1, new ClimbOnTopOfPowderSnowGoal(this, this.s));
        this.bQ.a(3, this.b);
        this.bQ.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bQ.a(5, new PathfinderGoalSilverfishHideInBlock(this));
        this.bR.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bR.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    @Override
    public double bp() {
        return 0.1;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.13f;
    }

    public static AttributeProvider.Builder n() {
        return EntityMonster.fE().a(GenericAttributes.a, 8.0).a(GenericAttributes.d, 0.25).a(GenericAttributes.f, 1.0);
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.c;
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.qT;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.qV;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.qU;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.qW, 0.15f, 1.0f);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if ((source instanceof EntityDamageSource || source == DamageSource.o) && this.b != null) {
            this.b.h();
        }
        return super.a(source, amount);
    }

    @Override
    public void k() {
        this.aX = this.dn();
        super.k();
    }

    @Override
    public void m(float bodyYaw) {
        this.o(bodyYaw);
        super.m(bodyYaw);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return BlockMonsterEggs.h(world.a_(pos.c())) ? 10.0f : super.a(pos, world);
    }

    public static boolean b(EntityTypes<EntitySilverfish> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        if (EntitySilverfish.c(type, world, spawnReason, pos, random)) {
            EntityHuman entityhuman = world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, 5.0, true);
            return (entityhuman == null || entityhuman.affectsSpawning) && entityhuman == null;
        }
        return false;
    }

    @Override
    public EnumMonsterType er() {
        return EnumMonsterType.c;
    }

    private static class PathfinderGoalSilverfishWakeOthers
    extends PathfinderGoal {
        private final EntitySilverfish a;
        private int b;

        public PathfinderGoalSilverfishWakeOthers(EntitySilverfish silverfish) {
            this.a = silverfish;
        }

        public void h() {
            if (this.b == 0) {
                this.b = this.a(20);
            }
        }

        @Override
        public boolean a() {
            return this.b > 0;
        }

        @Override
        public void e() {
            --this.b;
            if (this.b <= 0) {
                World world = this.a.s;
                Random random = this.a.dL();
                BlockPosition blockposition = this.a.cW();
                int i2 = 0;
                while (i2 <= 5 && i2 >= -5) {
                    int j2 = 0;
                    while (j2 <= 10 && j2 >= -10) {
                        int k2 = 0;
                        while (k2 <= 10 && k2 >= -10) {
                            BlockPosition blockposition1 = blockposition.b(j2, i2, k2);
                            IBlockData iblockdata = world.a_(blockposition1);
                            Block block = iblockdata.b();
                            if (block instanceof BlockMonsterEggs && !CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition1, Blocks.a.n()).isCancelled()) {
                                if (world.W().b(GameRules.c)) {
                                    world.a(blockposition1, true, (Entity)this.a);
                                } else {
                                    world.a(blockposition1, ((BlockMonsterEggs)block).o(world.a_(blockposition1)), 3);
                                }
                                if (random.nextBoolean()) {
                                    return;
                                }
                            }
                            k2 = (k2 <= 0 ? 1 : 0) - k2;
                        }
                        j2 = (j2 <= 0 ? 1 : 0) - j2;
                    }
                    i2 = (i2 <= 0 ? 1 : 0) - i2;
                }
            }
        }
    }

    private static class PathfinderGoalSilverfishHideInBlock
    extends PathfinderGoalRandomStroll {
        @Nullable
        private EnumDirection i;
        private boolean j;

        public PathfinderGoalSilverfishHideInBlock(EntitySilverfish silverfish) {
            super(silverfish, 1.0, 10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (this.b.G() != null) {
                return false;
            }
            if (!this.b.D().l()) {
                return false;
            }
            Random random = this.b.dL();
            if (this.b.s.W().b(GameRules.c) && random.nextInt(PathfinderGoalSilverfishHideInBlock.b(10)) == 0) {
                this.i = EnumDirection.a(random);
                BlockPosition blockposition = new BlockPosition(this.b.dc(), this.b.de() + 0.5, this.b.di()).a(this.i);
                IBlockData iblockdata = this.b.s.a_(blockposition);
                if (BlockMonsterEggs.h(iblockdata)) {
                    this.j = true;
                    return true;
                }
            }
            this.j = false;
            return super.a();
        }

        @Override
        public boolean b() {
            return this.j ? false : super.b();
        }

        @Override
        public void c() {
            if (!this.j) {
                super.c();
            } else {
                World world = this.b.s;
                BlockPosition blockposition = new BlockPosition(this.b.dc(), this.b.de() + 0.5, this.b.di()).a(this.i);
                IBlockData iblockdata = world.a_(blockposition);
                if (BlockMonsterEggs.h(iblockdata)) {
                    if (CraftEventFactory.callEntityChangeBlockEvent(this.b, blockposition, BlockMonsterEggs.n(iblockdata)).isCancelled()) {
                        return;
                    }
                    world.a(blockposition, BlockMonsterEggs.n(iblockdata), 3);
                    this.b.L();
                    this.b.ah();
                }
            }
        }
    }
}

