/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.math.Vector3fa;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;

public class EntityShulker
extends EntityGolem
implements IMonster {
    private static final UUID e = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier bV = new AttributeModifier(e, "Covered armor bonus", 20.0, AttributeModifier.Operation.a);
    protected static final DataWatcherObject<EnumDirection> b = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.n);
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Byte> d = DataWatcher.a(EntityShulker.class, DataWatcherRegistry.a);
    private static final int bW = 6;
    private static final byte bX = 16;
    private static final byte bY = 16;
    private static final int bZ = 8;
    private static final int ca = 8;
    private static final int cb = 5;
    private static final float cc = 0.05f;
    static final Vector3fa cd = SystemUtils.a(() -> {
        BaseBlockPosition baseblockposition = EnumDirection.d.p();
        return new Vector3fa(baseblockposition.u(), baseblockposition.v(), baseblockposition.w());
    });
    private float ce;
    private float cf;
    @Nullable
    private BlockPosition cg;
    private int ch;
    private static final float ci = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
        this.bL = 5;
        this.bM = new d(this);
    }

    @Override
    protected void u() {
        this.bQ.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.bQ.a(4, new a());
        this.bQ.a(7, new f());
        this.bQ.a(8, new PathfinderGoalRandomLookaround(this));
        this.bR.a(1, new PathfinderGoalHurtByTarget(this, this.getClass()).a(new Class[0]));
        this.bR.a(2, new e(this));
        this.bR.a(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.qH;
    }

    @Override
    public void K() {
        if (!this.fD()) {
            super.K();
        }
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.qN;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return this.fD() ? SoundEffects.qP : SoundEffects.qO;
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(b, EnumDirection.a);
        this.Y.a(c, (byte)0);
        this.Y.a(d, (byte)16);
    }

    public static AttributeProvider.Builder n() {
        return EntityInsentient.w().a(GenericAttributes.a, 30.0);
    }

    @Override
    protected EntityAIBodyControl y() {
        return new b(this);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(EnumDirection.a(nbt.f("AttachFace")));
        this.Y.b(c, nbt.f("Peek"));
        if (nbt.b("Color", 99)) {
            this.Y.b(d, nbt.f("Color"));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AttachFace", (byte)this.t().b());
        nbt.a("Peek", this.Y.a(c));
        nbt.a("Color", this.Y.a(d));
    }

    @Override
    public void k() {
        super.k();
        if (!(this.s.x || this.bF() || this.a(this.cW(), this.t()))) {
            this.fA();
        }
        if (this.fB()) {
            this.fC();
        }
        if (this.s.x) {
            if (this.ch > 0) {
                --this.ch;
            } else {
                this.cg = null;
            }
        }
    }

    private void fA() {
        EnumDirection enumdirection = this.g(this.cW());
        if (enumdirection != null) {
            this.a(enumdirection);
        } else {
            this.q();
        }
    }

    @Override
    protected AxisAlignedBB al() {
        float f2 = EntityShulker.B(this.cf);
        EnumDirection enumdirection = this.t().f();
        float f1 = this.ad().k() / 2.0f;
        return EntityShulker.a(enumdirection, f2).d(this.dc() - (double)f1, this.de(), this.di() - (double)f1);
    }

    private static float B(float openProgress) {
        return 0.5f - MathHelper.a((0.5f + openProgress) * (float)Math.PI) * 0.5f;
    }

    private boolean fB() {
        this.ce = this.cf;
        float f2 = (float)this.fF() * 0.01f;
        if (this.cf == f2) {
            return false;
        }
        this.cf = this.cf > f2 ? MathHelper.a(this.cf - 0.05f, f2, 1.0f) : MathHelper.a(this.cf + 0.05f, 0.0f, f2);
        return true;
    }

    private void fC() {
        this.am();
        float f2 = EntityShulker.B(this.cf);
        float f1 = EntityShulker.B(this.ce);
        EnumDirection enumdirection = this.t().f();
        float f22 = f2 - f1;
        if (f22 > 0.0f) {
            List<Entity> list = this.s.a((Entity)this, EntityShulker.a(enumdirection, f1, f2).d(this.dc() - 0.5, this.de(), this.di() - 0.5), IEntitySelector.f.and(entity -> !entity.v(this)));
            for (Entity entity2 : list) {
                if (entity2 instanceof EntityShulker || entity2.Q) continue;
                entity2.a(EnumMoveType.e, new Vec3D(f22 * (float)enumdirection.i(), f22 * (float)enumdirection.j(), f22 * (float)enumdirection.k()));
            }
        }
    }

    public static AxisAlignedBB a(EnumDirection direction, float extraLength) {
        return EntityShulker.a(direction, -1.0f, extraLength);
    }

    public static AxisAlignedBB a(EnumDirection direction, float prevExtraLength, float extraLength) {
        double d0 = Math.max(prevExtraLength, extraLength);
        double d1 = Math.min(prevExtraLength, extraLength);
        return new AxisAlignedBB(BlockPosition.b).b((double)direction.i() * d0, (double)direction.j() * d0, (double)direction.k() * d0).a((double)(-direction.i()) * (1.0 + d1), (double)(-direction.j()) * (1.0 + d1), (double)(-direction.k()) * (1.0 + d1));
    }

    @Override
    public double bp() {
        EntityTypes<?> entitytypes = this.cN().ad();
        return entitytypes != EntityTypes.i && entitytypes != EntityTypes.Z ? super.bp() : 0.1875 - this.cN().bq();
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.s.k_()) {
            this.cg = null;
            this.ch = 0;
        }
        this.a(EnumDirection.a);
        return super.a(entity, force);
    }

    @Override
    public void p() {
        super.p();
        if (this.s.x) {
            this.cg = this.cW();
        }
        this.aY = 0.0f;
        this.aX = 0.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.o(0.0f);
        this.aZ = this.dn();
        this.be();
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (movementType == EnumMoveType.d) {
            this.q();
        } else {
            super.a(movementType, movement);
        }
    }

    @Override
    public Vec3D da() {
        return Vec3D.a;
    }

    @Override
    public void g(Vec3D velocity) {
    }

    @Override
    public void e(double x2, double y2, double z2) {
        BlockPosition blockposition1;
        BlockPosition blockposition = this.cW();
        if (this.bF()) {
            super.e(x2, y2, z2);
        } else {
            super.e((double)MathHelper.b(x2) + 0.5, MathHelper.b(y2 + 0.5), (double)MathHelper.b(z2) + 0.5);
        }
        if (this.S != 0 && !(blockposition1 = this.cW()).equals(blockposition)) {
            this.Y.b(c, (byte)0);
            this.af = true;
            if (this.s.x && !this.bF() && !blockposition1.equals(this.cg)) {
                this.cg = blockposition;
                this.ch = 6;
                this.M = this.dc();
                this.N = this.de();
                this.O = this.di();
            }
        }
    }

    @Nullable
    protected EnumDirection g(BlockPosition pos) {
        for (EnumDirection enumdirection : EnumDirection.values()) {
            if (!this.a(pos, enumdirection)) continue;
            return enumdirection;
        }
        return null;
    }

    boolean a(BlockPosition pos, EnumDirection direction) {
        if (this.h(pos)) {
            return false;
        }
        EnumDirection enumdirection1 = direction.f();
        if (!this.s.a(pos.a(direction), (Entity)this, enumdirection1)) {
            return false;
        }
        AxisAlignedBB axisalignedbb = EntityShulker.a(enumdirection1, 1.0f).a(pos).h(1.0E-6);
        return this.s.a((Entity)this, axisalignedbb);
    }

    private boolean h(BlockPosition pos) {
        IBlockData iblockdata = this.s.a_(pos);
        if (iblockdata.g()) {
            return false;
        }
        boolean flag = iblockdata.a(Blocks.bu) && pos.equals(this.cW());
        return !flag;
    }

    protected boolean q() {
        if (!this.fs() && this.bl()) {
            BlockPosition blockposition = this.cW();
            for (int i2 = 0; i2 < 5; ++i2) {
                EnumDirection enumdirection;
                BlockPosition blockposition1 = blockposition.b(MathHelper.b(this.R, -8, 8), MathHelper.b(this.R, -8, 8), MathHelper.b(this.R, -8, 8));
                if (blockposition1.v() <= this.s.u_() || !this.s.w(blockposition1) || !this.s.p_().a(blockposition1) || !this.s.a((Entity)this, new AxisAlignedBB(blockposition1).h(1.0E-6)) || (enumdirection = this.g(blockposition1)) == null) continue;
                EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), this.getBukkitEntity().getLocation(), new Location((org.bukkit.World)this.s.getWorld(), (double)blockposition1.u(), (double)blockposition1.v(), (double)blockposition1.w()));
                this.s.getCraftServer().getPluginManager().callEvent((Event)teleport);
                if (teleport.isCancelled()) {
                    return false;
                }
                Location to = teleport.getTo();
                blockposition1 = new BlockPosition(to.getX(), to.getY(), to.getZ());
                this.ab();
                this.a(enumdirection);
                this.a(SoundEffects.qS, 1.0f, 1.0f);
                this.e((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5);
                this.Y.b(c, (byte)0);
                this.h((EntityLiving)null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.br = 0;
        this.e(x2, y2, z2);
        this.a(yaw, pitch);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        Entity entity;
        if (this.fD() && (entity = source.k()) instanceof EntityArrow) {
            return false;
        }
        if (!super.a(source, amount)) {
            return false;
        }
        if ((double)this.ea() < (double)this.em() * 0.5 && this.R.nextInt(4) == 0) {
            this.q();
        } else if (source.b() && (entity = source.k()) != null && entity.ad() == EntityTypes.az) {
            this.fE();
        }
        return true;
    }

    private boolean fD() {
        return this.fF() == 0;
    }

    private void fE() {
        Vec3D vec3d = this.cV();
        AxisAlignedBB axisalignedbb = this.cw();
        if (!this.fD() && this.q()) {
            int i2 = this.s.a(EntityTypes.ay, axisalignedbb.g(8.0), Entity::bl).size();
            float f2 = (float)(i2 - 1) / 5.0f;
            if (this.s.v.nextFloat() >= f2) {
                EntityShulker entityshulker = EntityTypes.ay.a(this.s);
                EnumColor enumcolor = this.fz();
                if (enumcolor != null) {
                    entityshulker.a(enumcolor);
                }
                entityshulker.e(vec3d);
                this.s.addFreshEntity(entityshulker, CreatureSpawnEvent.SpawnReason.BREEDING);
            }
        }
    }

    @Override
    public boolean bn() {
        return this.bl();
    }

    public EnumDirection t() {
        return this.Y.a(b);
    }

    public void a(EnumDirection face) {
        this.Y.b(b, face);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (b.equals(data)) {
            this.a(this.al());
        }
        super.a(data);
    }

    public int fF() {
        return this.Y.a(c).byteValue();
    }

    public void a(int peekAmount) {
        if (!this.s.x) {
            this.a(GenericAttributes.i).d(bV);
            if (peekAmount == 0) {
                this.a(GenericAttributes.i).c(bV);
                this.a(SoundEffects.qM, 1.0f, 1.0f);
                this.a(GameEvent.N);
            } else {
                this.a(SoundEffects.qQ, 1.0f, 1.0f);
                this.a(GameEvent.O);
            }
        }
        this.Y.b(c, (byte)peekAmount);
    }

    public float z(float delta) {
        return MathHelper.i(delta, this.ce, this.cf);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.5f;
    }

    @Override
    public void a(PacketPlayOutSpawnEntityLiving packet) {
        super.a(packet);
        this.aX = 0.0f;
        this.aY = 0.0f;
    }

    @Override
    public int T() {
        return 180;
    }

    @Override
    public int U() {
        return 180;
    }

    @Override
    public void g(Entity entity) {
    }

    @Override
    public float bu() {
        return 0.0f;
    }

    public Optional<Vec3D> A(float f2) {
        if (this.cg != null && this.ch > 0) {
            double d0 = (double)((float)this.ch - f2) / 6.0;
            d0 *= d0;
            BlockPosition blockposition = this.cW();
            double d1 = (double)(blockposition.u() - this.cg.u()) * d0;
            double d2 = (double)(blockposition.v() - this.cg.v()) * d0;
            double d3 = (double)(blockposition.w() - this.cg.w()) * d0;
            return Optional.of(new Vec3D(-d1, -d2, -d3));
        }
        return Optional.empty();
    }

    private void a(EnumColor color) {
        this.Y.b(d, (byte)color.a());
    }

    @Nullable
    public EnumColor fz() {
        byte b0 = this.Y.a(d);
        return b0 != 16 && b0 <= 15 ? EnumColor.a(b0) : null;
    }

    private class d
    extends ControllerLook {
        public d(EntityInsentient entity) {
            super(entity);
        }

        @Override
        protected void b() {
        }

        @Override
        protected Optional<Float> i() {
            EnumDirection enumdirection = EntityShulker.this.t().f();
            Vector3fa vector3fa = cd.e();
            vector3fa.a(enumdirection.a());
            BaseBlockPosition baseblockposition = enumdirection.p();
            Vector3fa vector3fa1 = new Vector3fa(baseblockposition.u(), baseblockposition.v(), baseblockposition.w());
            vector3fa1.e(vector3fa);
            double d0 = this.e - this.a.dc();
            double d1 = this.f - this.a.dg();
            double d2 = this.g - this.a.di();
            Vector3fa vector3fa2 = new Vector3fa((float)d0, (float)d1, (float)d2);
            float f2 = vector3fa1.d(vector3fa2);
            float f1 = vector3fa.d(vector3fa2);
            return Math.abs(f2) <= 1.0E-5f && Math.abs(f1) <= 1.0E-5f ? Optional.empty() : Optional.of(Float.valueOf((float)(MathHelper.d((double)(-f2), (double)f1) * 57.2957763671875)));
        }

        @Override
        protected Optional<Float> h() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    private class a
    extends PathfinderGoal {
        private int b;

        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = EntityShulker.this.G();
            return entityliving != null && entityliving.bl() ? EntityShulker.this.s.af() != EnumDifficulty.a : false;
        }

        @Override
        public void c() {
            this.b = 20;
            EntityShulker.this.a(100);
        }

        @Override
        public void d() {
            EntityShulker.this.a(0);
        }

        @Override
        public boolean E_() {
            return true;
        }

        @Override
        public void e() {
            if (EntityShulker.this.s.af() != EnumDifficulty.a) {
                --this.b;
                EntityLiving entityliving = EntityShulker.this.G();
                if (entityliving != null) {
                    EntityShulker.this.z().a(entityliving, 180.0f, 180.0f);
                    double d0 = EntityShulker.this.f((Entity)entityliving);
                    if (d0 < 400.0) {
                        if (this.b <= 0) {
                            this.b = 20 + EntityShulker.this.R.nextInt(10) * 20 / 2;
                            EntityShulker.this.s.b(new EntityShulkerBullet(EntityShulker.this.s, EntityShulker.this, entityliving, EntityShulker.this.t().n()));
                            EntityShulker.this.a(SoundEffects.qR, 2.0f, (EntityShulker.this.R.nextFloat() - EntityShulker.this.R.nextFloat()) * 0.2f + 1.0f);
                        }
                    } else {
                        EntityShulker.this.h((EntityLiving)null);
                    }
                    super.e();
                }
            }
        }
    }

    private class f
    extends PathfinderGoal {
        private int b;

        f() {
        }

        @Override
        public boolean a() {
            return EntityShulker.this.G() == null && EntityShulker.this.R.nextInt(net.minecraft.world.entity.monster.EntityShulker$f.b(40)) == 0 && EntityShulker.this.a(EntityShulker.this.cW(), EntityShulker.this.t());
        }

        @Override
        public boolean b() {
            return EntityShulker.this.G() == null && this.b > 0;
        }

        @Override
        public void c() {
            this.b = this.a(20 * (1 + EntityShulker.this.R.nextInt(3)));
            EntityShulker.this.a(30);
        }

        @Override
        public void d() {
            if (EntityShulker.this.G() == null) {
                EntityShulker.this.a(0);
            }
        }

        @Override
        public void e() {
            --this.b;
        }
    }

    private class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker entityshulker) {
            super((EntityInsentient)entityshulker, EntityHuman.class, true);
        }

        @Override
        public boolean a() {
            return EntityShulker.this.s.af() == EnumDifficulty.a ? false : super.a();
        }

        @Override
        protected AxisAlignedBB a(double distance) {
            EnumDirection enumdirection = ((EntityShulker)this.e).t();
            return enumdirection.n() == EnumDirection.EnumAxis.a ? this.e.cw().c(4.0, distance, distance) : (enumdirection.n() == EnumDirection.EnumAxis.c ? this.e.cw().c(distance, distance, 4.0) : this.e.cw().c(distance, 4.0, distance));
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker shulker) {
            super(shulker, EntityLiving.class, 10, true, false, entityliving -> entityliving instanceof IMonster);
        }

        @Override
        public boolean a() {
            return this.e.bW() == null ? false : super.a();
        }

        @Override
        protected AxisAlignedBB a(double distance) {
            EnumDirection enumdirection = ((EntityShulker)this.e).t();
            return enumdirection.n() == EnumDirection.EnumAxis.a ? this.e.cw().c(4.0, distance, distance) : (enumdirection.n() == EnumDirection.EnumAxis.c ? this.e.cw().c(distance, distance, 4.0) : this.e.cw().c(distance, 4.0, distance));
        }
    }

    private static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
        }
    }
}

