/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMonster;

public abstract class EntityMonster
extends EntityCreature
implements IMonster {
    public CraftMonster getBukkitMonster() {
        return (CraftMonster)super.getBukkitEntity();
    }

    protected EntityMonster(EntityTypes<? extends EntityMonster> type, World world) {
        super((EntityTypes<? extends EntityCreature>)type, world);
        this.bL = 5;
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.f;
    }

    @Override
    public void w_() {
        this.ep();
        this.fD();
        super.w_();
    }

    protected void fD() {
        float f2 = this.bd();
        if (f2 > 0.5f) {
            this.bf += 2;
        }
    }

    @Override
    protected boolean P() {
        return true;
    }

    @Override
    protected SoundEffect aF() {
        return SoundEffects.iR;
    }

    @Override
    protected SoundEffect aG() {
        return SoundEffects.iQ;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.iO;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.iN;
    }

    @Override
    public EntityLiving.a eg() {
        return new EntityLiving.a(SoundEffects.iP, SoundEffects.iM);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.5f - world.y(pos);
    }

    public static boolean a(WorldAccess world, BlockPosition pos, Random random) {
        if (world.a(EnumSkyBlock.a, pos) > random.nextInt(32)) {
            return false;
        }
        if (world.a(EnumSkyBlock.b, pos) > (world.F().paperConfig.maxBlockLightForMonsterSpawning >= 0 ? world.F().paperConfig.maxBlockLightForMonsterSpawning : 0)) {
            return false;
        }
        int i2 = world.F().X() ? world.c(pos, 10) : world.B(pos);
        return i2 <= random.nextInt(8);
    }

    public static boolean b(EntityTypes<? extends EntityMonster> type, WorldAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.af() != EnumDifficulty.a && EntityMonster.a(world, pos, random) && EntityMonster.a(type, world, spawnReason, pos, random);
    }

    public static boolean c(EntityTypes<? extends EntityMonster> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.af() != EnumDifficulty.a && EntityMonster.a(type, world, spawnReason, pos, random);
    }

    public static AttributeProvider.Builder fE() {
        return EntityInsentient.w().a(GenericAttributes.f);
    }

    @Override
    protected boolean dI() {
        return true;
    }

    @Override
    protected boolean dJ() {
        return true;
    }

    public boolean f(EntityHuman player) {
        return true;
    }

    @Override
    public ItemStack h(ItemStack stack) {
        if (stack.c() instanceof ItemProjectileWeapon) {
            Predicate<ItemStack> predicate = ((ItemProjectileWeapon)stack.c()).e();
            ItemStack itemStack = ItemProjectileWeapon.a(this, predicate);
            return itemStack.b() ? new ItemStack(Items.mh) : itemStack;
        }
        return ItemStack.b;
    }
}

