/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;

public class EntityIllagerIllusioner
extends EntityIllagerWizard
implements IRangedEntity {
    private static final int e = 4;
    private static final int bV = 3;
    private static final int bW = 3;
    private int bX;
    private final Vec3D[][] bY;

    public EntityIllagerIllusioner(EntityTypes<? extends EntityIllagerIllusioner> type, World world) {
        super((EntityTypes<? extends EntityIllagerWizard>)type, world);
        this.bL = 5;
        this.bY = new Vec3D[2][4];
        for (int i2 = 0; i2 < 4; ++i2) {
            this.bY[0][i2] = Vec3D.a;
            this.bY[1][i2] = Vec3D.a;
        }
    }

    @Override
    protected void u() {
        super.u();
        this.bQ.a(0, new PathfinderGoalFloat(this));
        this.bQ.a(1, new EntityIllagerWizard.b());
        this.bQ.a(4, new b());
        this.bQ.a(5, new a());
        this.bQ.a(6, new PathfinderGoalBowShoot<EntityIllagerIllusioner>(this, 0.5, 20, 15.0f));
        this.bQ.a(8, new PathfinderGoalRandomStroll(this, 0.6));
        this.bQ.a(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.bQ.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bR.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bR.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true).c(300));
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false).c(300));
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, false).c(300));
    }

    public static AttributeProvider.Builder q() {
        return EntityMonster.fE().a(GenericAttributes.d, 0.5).a(GenericAttributes.b, 18.0).a(GenericAttributes.a, 32.0);
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a(EnumItemSlot.a, new ItemStack(Items.mg));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void a_() {
        super.a_();
    }

    @Override
    public AxisAlignedBB cx() {
        return this.cw().c(3.0, 0.0, 3.0);
    }

    @Override
    public void w_() {
        super.w_();
        if (this.s.x && this.bU()) {
            --this.bX;
            if (this.bX < 0) {
                this.bX = 0;
            }
            if (this.aK != 1 && this.S % 1200 != 0) {
                if (this.aK == this.aL - 1) {
                    this.bX = 3;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        this.bY[0][i2] = this.bY[1][i2];
                        this.bY[1][i2] = new Vec3D(0.0, 0.0, 0.0);
                    }
                }
            } else {
                int j2;
                this.bX = 3;
                float f2 = -6.0f;
                boolean flag = true;
                for (j2 = 0; j2 < 4; ++j2) {
                    this.bY[0][j2] = this.bY[1][j2];
                    this.bY[1][j2] = new Vec3D((double)(-6.0f + (float)this.R.nextInt(13)) * 0.5, Math.max(0, this.R.nextInt(6) - 4), (double)(-6.0f + (float)this.R.nextInt(13)) * 0.5);
                }
                for (j2 = 0; j2 < 16; ++j2) {
                    this.s.a(Particles.f, this.d(0.5), this.df(), this.f(0.5), 0.0, 0.0, 0.0);
                }
                this.s.a(this.dc(), this.de(), this.di(), SoundEffects.jb, this.cO(), 1.0f, 1.0f, false);
            }
        }
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.iX;
    }

    public Vec3D[] z(float f2) {
        if (this.bX <= 0) {
            return this.bY[1];
        }
        double d0 = ((float)this.bX - f2) / 3.0f;
        d0 = Math.pow(d0, 0.25);
        Vec3D[] avec3d = new Vec3D[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            avec3d[i2] = this.bY[1][i2].a(1.0 - d0).e(this.bY[0][i2].a(d0));
        }
        return avec3d;
    }

    @Override
    public boolean p(Entity other) {
        return super.p(other) ? true : (other instanceof EntityLiving && ((EntityLiving)other).er() == EnumMonsterType.d ? this.bW() == null && other.bW() == null : false);
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.iX;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.iZ;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.ja;
    }

    @Override
    protected SoundEffect fz() {
        return SoundEffects.iY;
    }

    @Override
    public void a(int wave, boolean unused) {
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        ItemStack itemstack = this.h(this.b(ProjectileHelper.a(this, Items.mg)));
        EntityArrow entityarrow = ProjectileHelper.a(this, itemstack, pullProgress);
        double d0 = target.dc() - this.dc();
        double d1 = target.e(0.3333333333333333) - entityarrow.de();
        double d2 = target.di() - this.di();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        entityarrow.c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.s.af().a() * 4);
        EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.es(), entityarrow.l(), entityarrow, target.eN(), 0.8f, true);
        if (event.isCancelled()) {
            event.getProjectile().remove();
            return;
        }
        if (event.getProjectile() == entityarrow.getBukkitEntity()) {
            this.s.b(entityarrow);
        }
        this.a(SoundEffects.rj, 1.0f, 1.0f / (this.dL().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public EntityIllagerAbstract.a n() {
        return this.fJ() ? EntityIllagerAbstract.a.c : (this.fu() ? EntityIllagerAbstract.a.d : EntityIllagerAbstract.a.a);
    }

    private class b
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        b() {
        }

        @Override
        public boolean a() {
            return !super.a() ? false : !EntityIllagerIllusioner.this.a(MobEffects.n);
        }

        @Override
        protected int h() {
            return 20;
        }

        @Override
        protected int i() {
            return 340;
        }

        @Override
        protected void k() {
            EntityIllagerIllusioner.this.addEffect(new MobEffect(MobEffects.n, 1200), EntityPotionEffectEvent.Cause.ILLUSION);
        }

        @Override
        @Nullable
        protected SoundEffect l() {
            return SoundEffects.jd;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.e;
        }
    }

    private class a
    extends EntityIllagerWizard.PathfinderGoalCastSpell {
        private int e;

        a() {
        }

        @Override
        public boolean a() {
            return !super.a() ? false : (EntityIllagerIllusioner.this.G() == null ? false : (EntityIllagerIllusioner.this.G().ae() == this.e ? false : EntityIllagerIllusioner.this.s.d_(EntityIllagerIllusioner.this.cW()).a(EnumDifficulty.c.ordinal())));
        }

        @Override
        public void c() {
            super.c();
            EntityLiving entityliving = EntityIllagerIllusioner.this.G();
            if (entityliving != null) {
                this.e = entityliving.ae();
            }
        }

        @Override
        protected int h() {
            return 20;
        }

        @Override
        protected int i() {
            return 180;
        }

        @Override
        protected void k() {
            EntityIllagerIllusioner.this.G().addEffect(new MobEffect(MobEffects.o, 400), EntityIllagerIllusioner.this, EntityPotionEffectEvent.Cause.ATTACK);
        }

        @Override
        protected SoundEffect l() {
            return SoundEffects.jc;
        }

        @Override
        protected EntityIllagerWizard.Spell m() {
            return EntityIllagerWizard.Spell.f;
        }
    }
}

