/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityGhast
extends EntityFlying
implements IMonster {
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityGhast.class, DataWatcherRegistry.i);
    private int c = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> type, World world) {
        super((EntityTypes<? extends EntityFlying>)type, world);
        this.bL = 5;
        this.bN = new ControllerGhast(this);
    }

    @Override
    protected void u() {
        this.bQ.a(5, new PathfinderGoalGhastIdleMove(this));
        this.bQ.a(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.bQ.a(7, new PathfinderGoalGhastAttackTarget(this));
        this.bR.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, entityliving -> Math.abs(entityliving.de() - this.de()) <= 4.0));
    }

    public boolean n() {
        return this.Y.a(b);
    }

    public void v(boolean shooting) {
        this.Y.b(b, shooting);
    }

    public int q() {
        return this.c;
    }

    public void setExplosionPower(int explosionPower) {
        this.c = explosionPower;
    }

    @Override
    protected boolean P() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source.k() instanceof EntityLargeFireball && source.l() instanceof EntityHuman) {
            super.a(source, 1000.0f);
            return true;
        }
        return super.a(source, amount);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(b, false);
    }

    public static AttributeProvider.Builder t() {
        return EntityInsentient.w().a(GenericAttributes.a, 10.0).a(GenericAttributes.b, 100.0);
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.gS;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.gU;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.gT;
    }

    @Override
    public float ev() {
        return 5.0f;
    }

    public static boolean b(EntityTypes<EntityGhast> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.af() != EnumDifficulty.a && random.nextInt(20) == 0 && EntityGhast.a(type, world, spawnReason, pos, random);
    }

    @Override
    public int ff() {
        return 1;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("ExplosionPower", (byte)this.c);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("ExplosionPower", 99)) {
            this.c = nbt.f("ExplosionPower");
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 2.6f;
    }

    private static class ControllerGhast
    extends ControllerMove {
        private final EntityGhast l;
        private int m;

        public ControllerGhast(EntityGhast ghast) {
            super(ghast);
            this.l = ghast;
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && this.m-- <= 0) {
                this.m += this.l.dL().nextInt(5) + 2;
                Vec3D vec3d = new Vec3D(this.e - this.l.dc(), this.f - this.l.de(), this.g - this.l.di());
                double d0 = vec3d.f();
                if (this.a(vec3d = vec3d.d(), MathHelper.e(d0))) {
                    this.l.g(this.l.da().e(vec3d.a(0.1)));
                } else {
                    this.k = ControllerMove.Operation.a;
                }
            }
        }

        private boolean a(Vec3D direction, int steps) {
            AxisAlignedBB axisalignedbb = this.l.cw();
            for (int j2 = 1; j2 < steps; ++j2) {
                if (this.l.s.a((Entity)this.l, axisalignedbb = axisalignedbb.c(direction))) continue;
                return false;
            }
            return true;
        }
    }

    private static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastIdleMove(EntityGhast ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            double d2;
            double d1;
            ControllerMove controllermove = this.a.A();
            if (!controllermove.b()) {
                return true;
            }
            double d0 = controllermove.d() - this.a.dc();
            double d3 = d0 * d0 + (d1 = controllermove.e() - this.a.de()) * d1 + (d2 = controllermove.f() - this.a.di()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public void c() {
            Random random = this.a.dL();
            double d0 = this.a.dc() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.a.de() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.a.di() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.a.A().a(d0, d1, d2, 1.0);
        }
    }

    private static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastMoveTowardsTarget(EntityGhast ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return true;
        }

        @Override
        public boolean E_() {
            return true;
        }

        @Override
        public void e() {
            if (this.a.G() == null) {
                Vec3D vec3d = this.a.da();
                this.a.o(-((float)MathHelper.d(vec3d.b, vec3d.d)) * 57.295776f);
                this.a.aX = this.a.dn();
            } else {
                EntityLiving entityliving = this.a.G();
                double d0 = 64.0;
                if (entityliving.f((Entity)this.a) < 4096.0) {
                    double d1 = entityliving.dc() - this.a.dc();
                    double d2 = entityliving.di() - this.a.di();
                    this.a.o(-((float)MathHelper.d(d1, d2)) * 57.295776f);
                    this.a.aX = this.a.dn();
                }
            }
        }
    }

    private static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast b;
        public int a;

        public PathfinderGoalGhastAttackTarget(EntityGhast ghast) {
            this.b = ghast;
        }

        @Override
        public boolean a() {
            return this.b.G() != null;
        }

        @Override
        public void c() {
            this.a = 0;
        }

        @Override
        public void d() {
            this.b.v(false);
        }

        @Override
        public boolean E_() {
            return true;
        }

        @Override
        public void e() {
            EntityLiving entityliving = this.b.G();
            if (entityliving != null) {
                double d0 = 64.0;
                if (entityliving.f((Entity)this.b) < 4096.0 && this.b.B(entityliving)) {
                    World world = this.b.s;
                    ++this.a;
                    if (this.a == 10 && !this.b.aL()) {
                        world.a((EntityHuman)null, 1015, this.b.cW(), 0);
                    }
                    if (this.a == 20) {
                        double d1 = 4.0;
                        Vec3D vec3d = this.b.e(1.0f);
                        double d2 = entityliving.dc() - (this.b.dc() + vec3d.b * 4.0);
                        double d3 = entityliving.e(0.5) - (0.5 + this.b.e(0.5));
                        double d4 = entityliving.di() - (this.b.di() + vec3d.d * 4.0);
                        if (!this.b.aL()) {
                            world.a((EntityHuman)null, 1016, this.b.cW(), 0);
                        }
                        EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLiving)this.b, d2, d3, d4, this.b.q());
                        entitylargefireball.e = this.b.q();
                        entitylargefireball.bukkitYield = entitylargefireball.e;
                        entitylargefireball.e(this.b.dc() + vec3d.b * 4.0, this.b.e(0.5) + 0.5, entitylargefireball.di() + vec3d.d * 4.0);
                        world.b(entitylargefireball);
                        this.a = -40;
                    }
                } else if (this.a > 0) {
                    --this.a;
                }
                this.b.v(this.a > 10);
            }
        }
    }
}

