/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EndermanAttackPlayerEvent;
import com.destroystokyo.paper.event.entity.EndermanEscapeEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSourceIndirect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityEnderman
extends EntityMonster
implements IEntityAngerable {
    private static final UUID c = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier d = new AttributeModifier(c, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.a);
    private static final int e = 400;
    private static final int bV = 600;
    private static final DataWatcherObject<Optional<IBlockData>> bW = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.h);
    private static final DataWatcherObject<Boolean> bX = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityEnderman.class, DataWatcherRegistry.i);
    private int bZ = Integer.MIN_VALUE;
    private int ca;
    private static final UniformInt cb = TimeRange.a(20, 39);
    private int cc;
    @Nullable
    private UUID cd;

    public EntityEnderman(EntityTypes<? extends EntityEnderman> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.P = 1.0f;
        this.a(PathType.j, -1.0f);
    }

    @Override
    protected void u() {
        this.bQ.a(0, new PathfinderGoalFloat(this));
        this.bQ.a(1, new a(this));
        this.bQ.a(2, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bQ.a(7, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 0.0f));
        this.bQ.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bQ.a(8, new PathfinderGoalRandomLookaround(this));
        this.bQ.a(10, new PathfinderGoalEndermanPlaceBlock(this));
        this.bQ.a(11, new PathfinderGoalEndermanPickupBlock(this));
        this.bR.a(1, new PathfinderGoalPlayerWhoLookedAtTarget(this, this::a_));
        this.bR.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityEndermite>((EntityInsentient)this, EntityEndermite.class, true, false));
        this.bR.a(4, new PathfinderGoalUniversalAngerReset<EntityEnderman>(this, false));
    }

    public static AttributeProvider.Builder n() {
        return EntityMonster.fE().a(GenericAttributes.a, 40.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.f, 7.0).a(GenericAttributes.b, 64.0);
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    private boolean tryEscape(EndermanEscapeEvent.Reason reason) {
        return new EndermanEscapeEvent((Enderman)((CraftEnderman)this.getBukkitEntity()), reason).callEvent();
    }

    @Override
    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (!super.setTarget(entityliving, reason, fireEvent)) {
            return false;
        }
        entityliving = this.G();
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        if (entityliving == null) {
            this.ca = 0;
            this.Y.b(bX, false);
            this.Y.b(bY, false);
            attributemodifiable.d(d);
        } else {
            this.ca = this.S;
            this.Y.b(bX, true);
            if (!attributemodifiable.a(d)) {
                attributemodifiable.b(d);
            }
        }
        return true;
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bW, Optional.empty());
        this.Y.a(bX, false);
        this.Y.a(bY, false);
    }

    @Override
    public void c() {
        this.a(cb.a(this.R));
    }

    @Override
    public void a(int angerTime) {
        this.cc = angerTime;
    }

    @Override
    public int a() {
        return this.cc;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cd = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cd;
    }

    public void q() {
        if (this.S >= this.bZ + 400) {
            this.bZ = this.S;
            if (!this.aL()) {
                this.s.a(this.dc(), this.dg(), this.di(), SoundEffects.fy, this.cO(), 2.5f, 1.0f, false);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bX.equals(data) && this.fB() && this.s.x) {
            this.q();
        }
        super.a(data);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        IBlockData iblockdata = this.fz();
        if (iblockdata != null) {
            nbt.a("carriedBlockState", GameProfileSerializer.a(iblockdata));
        }
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        IBlockData iblockdata = null;
        if (nbt.b("carriedBlockState", 10) && (iblockdata = GameProfileSerializer.c(nbt.p("carriedBlockState"))).g()) {
            iblockdata = null;
        }
        this.c(iblockdata);
        this.a(this.s, nbt);
    }

    private boolean g(EntityHuman player) {
        boolean shouldAttack = this.isLookingAtMe_check(player);
        EndermanAttackPlayerEvent event = new EndermanAttackPlayerEvent((Enderman)this.getBukkitEntity(), (Player)player.getBukkitEntity());
        event.setCancelled(!shouldAttack);
        return event.callEvent();
    }

    private boolean isLookingAtMe_check(EntityHuman player) {
        ItemStack itemstack = player.fr().i.get(3);
        if (itemstack.a(Blocks.dc.l())) {
            return false;
        }
        Vec3D vec3d = player.e(1.0f).d();
        Vec3D vec3d1 = new Vec3D(this.dc() - player.dc(), this.dg() - player.dg(), this.di() - player.di());
        double d0 = vec3d1.f();
        double d1 = vec3d.b(vec3d1 = vec3d1.d());
        return d1 > 1.0 - 0.025 / d0 ? player.B(this) : false;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 2.55f;
    }

    @Override
    public void w_() {
        if (this.s.x) {
            for (int i2 = 0; i2 < 2; ++i2) {
                this.s.a(Particles.S, this.d(0.5), this.df() - 0.25, this.g(0.5), (this.R.nextDouble() - 0.5) * 2.0, -this.R.nextDouble(), (this.R.nextDouble() - 0.5) * 2.0);
            }
        }
        this.bn = false;
        if (!this.s.x) {
            this.a((WorldServer)this.s, true);
        }
        super.w_();
    }

    @Override
    public boolean eE() {
        return true;
    }

    @Override
    protected void R() {
        float f2;
        if (this.s.O() && this.S >= this.ca + 600 && (f2 = this.bd()) > 0.5f && this.s.g(this.cW()) && this.R.nextFloat() * 30.0f < (f2 - 0.4f) * 2.0f && this.tryEscape(EndermanEscapeEvent.Reason.RUNAWAY)) {
            this.h((EntityLiving)null);
            this.t();
        }
        super.R();
    }

    public boolean t() {
        if (!this.s.k_() && this.bl()) {
            double d0 = this.dc() + (this.R.nextDouble() - 0.5) * 64.0;
            double d1 = this.de() + (double)(this.R.nextInt(64) - 32);
            double d2 = this.di() + (this.R.nextDouble() - 0.5) * 64.0;
            return this.q(d0, d1, d2);
        }
        return false;
    }

    boolean a(Entity entity) {
        Vec3D vec3d = new Vec3D(this.dc() - entity.dc(), this.e(0.5) - entity.dg(), this.di() - entity.di());
        vec3d = vec3d.d();
        double d0 = 16.0;
        double d1 = this.dc() + (this.R.nextDouble() - 0.5) * 8.0 - vec3d.b * 16.0;
        double d2 = this.de() + (double)(this.R.nextInt(16) - 8) - vec3d.c * 16.0;
        double d3 = this.di() + (this.R.nextDouble() - 0.5) * 8.0 - vec3d.d * 16.0;
        return this.q(d1, d2, d3);
    }

    private boolean q(double x2, double y2, double z2) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(x2, y2, z2);
        while (blockposition_mutableblockposition.v() > this.s.u_() && !this.s.a_(blockposition_mutableblockposition).c().c()) {
            blockposition_mutableblockposition.c(EnumDirection.a);
        }
        IBlockData iblockdata = this.s.a_(blockposition_mutableblockposition);
        boolean flag = iblockdata.c().c();
        boolean flag1 = iblockdata.o().a(TagsFluid.a);
        if (flag && !flag1) {
            boolean flag2 = this.a(x2, y2, z2, true);
            if (flag2 && !this.aL()) {
                this.s.a((EntityHuman)null, this.t, this.u, this.v, SoundEffects.fz, this.cO(), 1.0f, 1.0f);
                this.a(SoundEffects.fz, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    @Override
    protected SoundEffect r() {
        return this.fA() ? SoundEffects.fx : SoundEffects.fu;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.fw;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.fv;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        IBlockData iblockdata = this.fz();
        if (iblockdata != null) {
            this.a(iblockdata.b());
        }
    }

    public void c(@Nullable IBlockData state) {
        this.Y.b(bW, Optional.ofNullable(state));
    }

    @Nullable
    public IBlockData fz() {
        return this.Y.a(bW).orElse(null);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            Entity entity = source.k();
            boolean flag = entity instanceof EntityPotion ? this.a(source, (EntityPotion)entity, amount) : false;
            if (this.tryEscape(EndermanEscapeEvent.Reason.INDIRECT)) {
                for (int i2 = 0; i2 < 64; ++i2) {
                    if (!this.t()) continue;
                    return true;
                }
            }
            return flag;
        }
        boolean flag1 = super.a(source, amount);
        if (!this.s.k_() && !(source.l() instanceof EntityLiving) && this.R.nextInt(10) != 0 && this.tryEscape(source == DamageSource.h ? EndermanEscapeEvent.Reason.DROWN : EndermanEscapeEvent.Reason.INDIRECT)) {
            this.t();
        }
        return flag1;
    }

    private boolean a(DamageSource source, EntityPotion potion, float amount) {
        ItemStack itemstack = potion.h();
        PotionRegistry potionregistry = PotionUtil.d(itemstack);
        List<MobEffect> list = PotionUtil.a(itemstack);
        boolean flag = potionregistry == Potions.b && list.isEmpty();
        return flag ? super.a(source, amount) : false;
    }

    public boolean fA() {
        return this.Y.a(bX);
    }

    public boolean fB() {
        return this.Y.a(bY);
    }

    public void fC() {
        this.Y.b(bY, true);
    }

    public void setCreepy(boolean creepy) {
        this.Y.b(bX, creepy);
    }

    public void setHasBeenStaredAt(boolean hasBeenStaredAt) {
        this.Y.b(bY, hasBeenStaredAt);
    }

    @Override
    public boolean O() {
        return super.O() || this.fz() != null;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityEnderman a;
        @Nullable
        private EntityLiving b;

        public a(EntityEnderman enderman) {
            this.a = enderman;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            this.b = this.a.G();
            if (!(this.b instanceof EntityHuman)) {
                return false;
            }
            double d0 = this.b.f((Entity)this.a);
            return d0 > 256.0 ? false : this.a.g((EntityHuman)this.b);
        }

        @Override
        public void c() {
            this.a.D().n();
        }

        @Override
        public void e() {
            this.a.z().a(this.b.dc(), this.b.dg(), this.b.di());
        }
    }

    private static class PathfinderGoalEndermanPlaceBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPlaceBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean a() {
            return this.a.fz() == null ? false : (!this.a.s.W().b(GameRules.c) ? false : this.a.dL().nextInt(PathfinderGoalEndermanPlaceBlock.b(2000)) == 0);
        }

        @Override
        public void e() {
            int k2;
            int j2;
            Random random = this.a.dL();
            World world = this.a.s;
            int i2 = MathHelper.b(this.a.dc() - 1.0 + random.nextDouble() * 2.0);
            BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.b(this.a.de() + random.nextDouble() * 2.0), k2 = MathHelper.b(this.a.di() - 1.0 + random.nextDouble() * 2.0));
            IBlockData iblockdata = world.getBlockStateIfLoaded(blockposition);
            if (iblockdata == null) {
                return;
            }
            BlockPosition blockposition1 = blockposition.c();
            IBlockData iblockdata1 = world.a_(blockposition1);
            IBlockData iblockdata2 = this.a.fz();
            if (iblockdata2 != null && this.a(world, blockposition, iblockdata2 = Block.b(iblockdata2, this.a.s, blockposition), iblockdata, iblockdata1, blockposition1) && !CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, iblockdata2).isCancelled()) {
                world.a(blockposition, iblockdata2, 3);
                world.a((Entity)this.a, GameEvent.g, blockposition);
                this.a.c((IBlockData)null);
            }
        }

        private boolean a(World world, BlockPosition posAbove, IBlockData carriedState, IBlockData stateAbove, IBlockData state, BlockPosition pos) {
            return stateAbove.g() && !state.g() && !state.a(Blocks.z) && state.r(world, pos) && carriedState.a((IWorldReader)world, posAbove) && world.a_(this.a, AxisAlignedBB.a(Vec3D.b(posAbove))).isEmpty();
        }
    }

    private static class PathfinderGoalEndermanPickupBlock
    extends PathfinderGoal {
        private final EntityEnderman a;

        public PathfinderGoalEndermanPickupBlock(EntityEnderman enderman) {
            this.a = enderman;
        }

        @Override
        public boolean a() {
            return this.a.fz() != null ? false : (!this.a.s.W().b(GameRules.c) ? false : this.a.dL().nextInt(PathfinderGoalEndermanPickupBlock.b(20)) == 0);
        }

        @Override
        public void e() {
            int k2;
            int j2;
            Random random = this.a.dL();
            World world = this.a.s;
            int i2 = MathHelper.b(this.a.dc() - 2.0 + random.nextDouble() * 4.0);
            BlockPosition blockposition = new BlockPosition(i2, j2 = MathHelper.b(this.a.de() + random.nextDouble() * 3.0), k2 = MathHelper.b(this.a.di() - 2.0 + random.nextDouble() * 4.0));
            IBlockData iblockdata = world.getBlockStateIfLoaded(blockposition);
            if (iblockdata == null) {
                return;
            }
            Vec3D vec3d = new Vec3D((double)this.a.db() + 0.5, (double)j2 + 0.5, (double)this.a.dh() + 0.5);
            Vec3D vec3d1 = new Vec3D((double)i2 + 0.5, (double)j2 + 0.5, (double)k2 + 0.5);
            MovingObjectPositionBlock movingobjectpositionblock = world.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.a));
            boolean flag = movingobjectpositionblock.a().equals(blockposition);
            if (iblockdata.a(TagsBlock.ac) && flag && !CraftEventFactory.callEntityChangeBlockEvent(this.a, blockposition, Blocks.a.n()).isCancelled()) {
                world.a(blockposition, false);
                world.a((Entity)this.a, GameEvent.d, blockposition);
                this.a.c(iblockdata.b().n());
            }
        }
    }

    private static class PathfinderGoalPlayerWhoLookedAtTarget
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        private final EntityEnderman i;
        @Nullable
        private EntityHuman j;
        private int k;
        private int l;
        private final PathfinderTargetCondition m;
        private final PathfinderTargetCondition n = PathfinderTargetCondition.a().d();

        public PathfinderGoalPlayerWhoLookedAtTarget(EntityEnderman enderman, @Nullable Predicate<EntityLiving> targetPredicate) {
            super(enderman, EntityHuman.class, 10, false, false, targetPredicate);
            this.i = enderman;
            this.m = PathfinderTargetCondition.a().a(this.l()).a((EntityLiving entityliving) -> enderman.g((EntityHuman)entityliving));
        }

        @Override
        public boolean a() {
            this.j = this.i.s.a(this.m, this.i);
            return this.j != null;
        }

        @Override
        public void c() {
            this.k = this.a(5);
            this.l = 0;
            this.i.fC();
        }

        @Override
        public void d() {
            this.j = null;
            super.d();
        }

        @Override
        public boolean b() {
            if (this.j != null) {
                if (!this.i.g(this.j)) {
                    return false;
                }
                this.i.a((Entity)this.j, 10.0f, 10.0f);
                return true;
            }
            return this.c != null && this.n.a(this.i, this.c) ? true : super.b();
        }

        @Override
        public void e() {
            if (this.i.G() == null) {
                super.a((EntityLiving)null);
            }
            if (this.j != null) {
                if (--this.k <= 0) {
                    this.c = this.j;
                    this.j = null;
                    super.c();
                }
            } else {
                if (this.c != null && !this.i.bF()) {
                    if (this.i.g((EntityHuman)this.c)) {
                        if (this.c.f((Entity)this.i) < 16.0 && this.i.tryEscape(EndermanEscapeEvent.Reason.STARE)) {
                            this.i.t();
                        }
                        this.l = 0;
                    } else if (this.c.f((Entity)this.i) > 256.0 && this.l++ >= this.a(30) && this.i.a((Entity)this.c)) {
                        this.l = 0;
                    }
                }
                super.e();
            }
        }
    }
}

