/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger f = LogUtils.getLogger();
    private IBlockData ao = Blocks.C.n();
    public int b;
    public boolean c = true;
    private boolean ap;
    public boolean aq;
    private int ar = 40;
    private float as;
    @Nullable
    public NBTTagCompound d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.l);

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> type, World world) {
        super(type, world);
    }

    public EntityFallingBlock(World world, double x2, double y2, double z2, IBlockData block) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.C, world);
        this.ao = block;
        this.q = true;
        this.e(x2, y2, z2);
        this.g(Vec3D.a);
        this.t = x2;
        this.u = y2;
        this.v = z2;
        this.a(this.cW());
    }

    public static EntityFallingBlock a(World world, BlockPosition pos, IBlockData state) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, state.b(BlockProperties.C) ? (IBlockData)state.a(BlockProperties.C, false) : state);
        if (CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, pos, state.o().g()).isCancelled()) {
            return entityfallingblock;
        }
        world.a(pos, state.o().g(), 3);
        world.b(entityfallingblock);
        return entityfallingblock;
    }

    @Override
    public boolean cf() {
        return false;
    }

    public void a(BlockPosition pos) {
        this.Y.b(e, pos);
    }

    public BlockPosition h() {
        return this.Y.a(e);
    }

    @Override
    protected Entity.MovementEmission aN() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.Y.a(e, BlockPosition.b);
    }

    @Override
    public boolean bh() {
        return !this.dp();
    }

    @Override
    public void k() {
        if (this.dp()) {
            return;
        }
        if (this.ao.g()) {
            this.ah();
        } else {
            Block block = this.ao.b();
            ++this.b;
            if (!this.aM()) {
                this.g(this.da().b(0.0, -0.04, 0.0));
            }
            this.a(EnumMoveType.a, this.da());
            if (this.dp()) {
                return;
            }
            if (this.s.paperConfig.fallingBlockHeightNerf != 0 && this.de() > (double)this.s.paperConfig.fallingBlockHeightNerf) {
                if (this.c && this.s.W().b(GameRules.h)) {
                    this.a(block);
                }
                this.ah();
                return;
            }
            if (!this.s.x) {
                MovingObjectPositionBlock movingobjectpositionblock;
                BlockPosition blockposition = this.cW();
                boolean flag = this.ao.b() instanceof BlockConcretePowder;
                boolean flag1 = flag && this.s.b_(blockposition).a(TagsFluid.a);
                double d0 = this.da().g();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.s.a(new RayTrace(new Vec3D(this.t, this.u, this.v), this.cV(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).c() != MovingObjectPosition.EnumMovingObjectType.a && this.s.b_(movingobjectpositionblock.a()).a(TagsFluid.a)) {
                    blockposition = movingobjectpositionblock.a();
                    flag1 = true;
                }
                if (!this.y && !flag1) {
                    if (!(this.s.x || (this.b <= 100 || blockposition.v() > this.s.u_() && blockposition.v() <= this.s.ag()) && this.b <= 600)) {
                        if (this.c && this.s.W().b(GameRules.h)) {
                            this.a(block);
                        }
                        this.ah();
                    }
                } else {
                    IBlockData iblockdata = this.s.a_(blockposition);
                    this.g(this.da().d(0.7, -0.5, 0.7));
                    if (!iblockdata.a(Blocks.bu)) {
                        if (!this.ap) {
                            boolean flag4;
                            boolean flag2 = iblockdata.a(new BlockActionContextDirectional(this.s, blockposition, EnumDirection.a, ItemStack.b, EnumDirection.b));
                            boolean flag3 = BlockFalling.h(this.s.a_(blockposition.c())) && (!flag || !flag1);
                            boolean bl = flag4 = this.ao.a((IWorldReader)this.s, blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.ao.b(BlockProperties.C) && this.s.b_(blockposition).a() == FluidTypes.c) {
                                    this.ao = (IBlockData)this.ao.a(BlockProperties.C, true);
                                }
                                if (CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.ao).isCancelled()) {
                                    this.ah();
                                    return;
                                }
                                if (this.s.a(blockposition, this.ao, 3)) {
                                    TileEntity tileentity;
                                    ((WorldServer)this.s).k().a.a(this, new PacketPlayOutBlockChange(blockposition, this.s.a_(blockposition)));
                                    this.ah();
                                    if (block instanceof Fallable) {
                                        ((Fallable)((Object)block)).a(this.s, blockposition, this.ao, iblockdata, this);
                                    }
                                    if (this.d != null && this.ao.n() && (tileentity = this.s.c_(blockposition)) != null) {
                                        NBTTagCompound nbttagcompound = tileentity.o();
                                        for (String s2 : this.d.d()) {
                                            nbttagcompound.a(s2, this.d.c(s2).c());
                                        }
                                        try {
                                            tileentity.a(nbttagcompound);
                                        }
                                        catch (Exception exception) {
                                            f.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.e();
                                    }
                                } else if (this.c && this.s.W().b(GameRules.h)) {
                                    this.ah();
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            } else {
                                this.ah();
                                if (this.c && this.s.W().b(GameRules.h)) {
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            }
                        } else {
                            this.ah();
                            this.a(block, blockposition);
                        }
                    }
                }
            }
            this.g(this.da().a(0.98));
        }
    }

    public void a(Block block, BlockPosition pos) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.s, pos, this);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        DamageSource damagesource1;
        Predicate<Entity> predicate;
        if (!this.aq) {
            return false;
        }
        int i2 = MathHelper.f(fallDistance - 1.0f);
        if (i2 < 0) {
            return false;
        }
        if (this.ao.b() instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)this.ao.b());
            predicate = fallable.V_();
            damagesource1 = fallable.b();
        } else {
            predicate = IEntitySelector.f;
            damagesource1 = DamageSource.r;
        }
        float f2 = Math.min(MathHelper.d((float)i2 * this.as), this.ar);
        this.s.a((Entity)this, this.cw(), predicate).forEach(entity -> {
            CraftEventFactory.entityDamage = this;
            entity.a(damagesource1, f2);
            CraftEventFactory.entityDamage = null;
        });
        boolean flag = this.ao.a(TagsBlock.F);
        if (flag && f2 > 0.0f && this.R.nextFloat() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.e(this.ao);
            if (iblockdata == null) {
                this.ap = true;
            } else {
                this.ao = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        nbt.a("BlockState", GameProfileSerializer.a(this.ao));
        nbt.a("Time", this.b);
        nbt.a("DropItem", this.c);
        nbt.a("HurtEntities", this.aq);
        nbt.a("FallHurtAmount", this.as);
        nbt.a("FallHurtMax", this.ar);
        if (this.d != null) {
            nbt.a("TileEntityData", this.d);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        this.ao = GameProfileSerializer.c(nbt.p("BlockState"));
        Block b2 = this.ao.b();
        if (this.s.paperConfig.filterNBTFromSpawnEgg && (b2 == Blocks.eE || b2 == Blocks.iU || b2 == Blocks.iV || b2 == Blocks.nn || b2 == Blocks.nm || b2 instanceof GameMasterBlock)) {
            this.ao = Blocks.b.n();
        }
        this.b = nbt.h("Time");
        if (nbt.b("HurtEntities", 99)) {
            this.aq = nbt.q("HurtEntities");
            this.as = nbt.j("FallHurtAmount");
            this.ar = nbt.h("FallHurtMax");
        } else if (this.ao.a(TagsBlock.F)) {
            this.aq = true;
        }
        if (nbt.b("DropItem", 99)) {
            this.c = nbt.q("DropItem");
        }
        if (nbt.b("TileEntityData", 10)) {
            this.d = nbt.p("TileEntityData");
        }
        if (this.ao.g()) {
            this.ao = Blocks.C.n();
        }
        if (nbt.e("SourceLoc_x")) {
            int srcX = nbt.h("SourceLoc_x");
            int srcY = nbt.h("SourceLoc_y");
            int srcZ = nbt.h("SourceLoc_z");
            this.setOrigin(new Location((org.bukkit.World)this.s.getWorld(), (double)srcX, (double)srcY, (double)srcZ));
        }
    }

    public void b(float fallHurtAmount, int fallHurtMax) {
        this.aq = true;
        this.as = fallHurtAmount;
        this.ar = fallHurtMax;
    }

    @Override
    public boolean cl() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails section) {
        super.a(section);
        section.a("Immitating BlockState", this.ao.toString());
    }

    public IBlockData i() {
        return this.ao;
    }

    @Override
    public boolean cD() {
        return true;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this, Block.i(this.i()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.ao = Block.a(packet.m());
        this.q = true;
        double d0 = packet.d();
        double d1 = packet.e();
        double d2 = packet.f();
        this.e(d0, d1, d2);
        this.a(this.cW());
    }
}

