/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.slf4j.Logger;

public class EntityItemFrame
extends EntityHanging {
    private static final Logger f = LogUtils.getLogger();
    private static final DataWatcherObject<ItemStack> ao = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Integer> ap = DataWatcher.a(EntityItemFrame.class, DataWatcherRegistry.b);
    public static final int e = 8;
    public float aq = 1.0f;
    public boolean ar;

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World world) {
        super((EntityTypes<? extends EntityHanging>)type, world);
    }

    public EntityItemFrame(World world, BlockPosition pos, EnumDirection facing) {
        this(EntityTypes.R, world, pos, facing);
    }

    public EntityItemFrame(EntityTypes<? extends EntityItemFrame> type, World world, BlockPosition pos, EnumDirection facing) {
        super(type, world, pos);
        this.a(facing);
    }

    @Override
    protected float a(EntityPose pose, EntitySize dimensions) {
        return 0.0f;
    }

    @Override
    protected void a_() {
        this.ai().a(ao, ItemStack.b);
        this.ai().a(ap, 0);
    }

    @Override
    public void a(EnumDirection facing) {
        Validate.notNull((Object)facing);
        this.d = facing;
        if (facing.n().d()) {
            this.p(0.0f);
            this.o(this.d.d() * 90);
        } else {
            this.p(-90 * facing.e().a());
            this.o(0.0f);
        }
        this.x = this.do();
        this.w = this.dn();
        this.q();
    }

    @Override
    protected void q() {
        if (this.d != null) {
            this.a(EntityItemFrame.calculateBoundingBox(this, this.c, this.d, this.s(), this.t()));
        }
    }

    public static AxisAlignedBB calculateBoundingBox(@Nullable Entity entity, BlockPosition blockPosition, EnumDirection direction, int width, int height) {
        double d0 = 0.46875;
        double d1 = (double)blockPosition.u() + 0.5 - (double)direction.i() * 0.46875;
        double d2 = (double)blockPosition.v() + 0.5 - (double)direction.j() * 0.46875;
        double d3 = (double)blockPosition.w() + 0.5 - (double)direction.k() * 0.46875;
        if (entity != null) {
            entity.o(d1, d2, d3);
        }
        double d4 = width;
        double d5 = height;
        double d6 = width;
        EnumDirection.EnumAxis enumdirection_enumaxis = direction.n();
        switch (enumdirection_enumaxis) {
            case a: {
                d4 = 1.0;
                break;
            }
            case b: {
                d5 = 1.0;
                break;
            }
            case c: {
                d6 = 1.0;
            }
        }
        return new AxisAlignedBB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6);
    }

    @Override
    public boolean r() {
        if (this.ar) {
            return true;
        }
        if (!this.s.g(this)) {
            return false;
        }
        IBlockData iblockdata = this.s.a_(this.c.a(this.d.f()));
        return !iblockdata.c().b() && (!this.d.n().d() || !BlockDiodeAbstract.n(iblockdata)) ? false : this.s.a((Entity)this, this.cw(), EntityHanging.b).isEmpty();
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (!this.ar) {
            super.a(movementType, movement);
        }
    }

    @Override
    public void i(double deltaX, double deltaY, double deltaZ) {
        if (!this.ar) {
            super.i(deltaX, deltaY, deltaZ);
        }
    }

    @Override
    public float bu() {
        return 0.0f;
    }

    @Override
    public void ag() {
        this.c(this.x());
        super.ag();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.ar) {
            return source != DamageSource.m && !source.B() ? false : super.a(source, amount);
        }
        if (this.b(source)) {
            return false;
        }
        if (!source.d() && !this.x().b()) {
            if (!this.s.x) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false) || this.dp()) {
                    return true;
                }
                Entity entity = source.l();
                if (entity instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.x().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.REMOVE);
                    if (!event.callEvent()) {
                        return false;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()), false);
                }
                this.b(source.l(), false);
                this.a(this.h(), 1.0f, 1.0f);
            }
            return true;
        }
        return super.a(source, amount);
    }

    public SoundEffect h() {
        return SoundEffects.js;
    }

    @Override
    public int s() {
        return 12;
    }

    @Override
    public int t() {
        return 12;
    }

    @Override
    public boolean a(double distance) {
        double d1 = 16.0;
        return distance < (d1 *= 64.0 * EntityItemFrame.cq()) * d1;
    }

    @Override
    public void a(@Nullable Entity entity) {
        this.a(this.i(), 1.0f, 1.0f);
        this.b(entity, true);
    }

    public SoundEffect i() {
        return SoundEffects.jq;
    }

    @Override
    public void u() {
        this.a(this.j(), 1.0f, 1.0f);
    }

    public SoundEffect j() {
        return SoundEffects.jr;
    }

    private void b(@Nullable Entity entity, boolean alwaysDrop) {
        if (!this.ar) {
            ItemStack itemstack = this.x();
            this.a(ItemStack.b);
            if (!this.s.W().b(GameRules.h)) {
                if (entity == null) {
                    this.c(itemstack);
                }
            } else {
                if (entity instanceof EntityHuman) {
                    EntityHuman entityhuman = (EntityHuman)entity;
                    if (entityhuman.fs().d) {
                        this.c(itemstack);
                        return;
                    }
                }
                if (alwaysDrop) {
                    this.b(this.o());
                }
                if (!itemstack.b()) {
                    itemstack = itemstack.n();
                    this.c(itemstack);
                    if (this.R.nextFloat() < this.aq) {
                        this.b(itemstack);
                    }
                }
            }
        }
    }

    private void c(ItemStack map) {
        WorldMap worldmap;
        if (map.a(Items.pp) && (worldmap = ItemWorldMap.a(map, this.s)) != null) {
            worldmap.a(this.c, this.ae());
            worldmap.a(true);
        }
        map.a((Entity)null);
    }

    public ItemStack x() {
        return this.ai().a(ao);
    }

    public void a(ItemStack stack) {
        this.a(stack, true);
    }

    public void a(ItemStack value, boolean update) {
        this.setItem(value, update, true);
    }

    public void setItem(ItemStack itemstack, boolean flag, boolean playSound) {
        if (!itemstack.b()) {
            itemstack = itemstack.n();
            itemstack.e(1);
            itemstack.a(this);
        }
        this.ai().b(ao, itemstack);
        if (!itemstack.b() && flag && playSound) {
            this.a(this.l(), 1.0f, 1.0f);
        }
        if (flag && this.c != null) {
            this.s.c(this.c, Blocks.a);
        }
    }

    public SoundEffect l() {
        return SoundEffects.jp;
    }

    @Override
    public SlotAccess k(int mappedIndex) {
        return mappedIndex == 0 ? new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityItemFrame.this.x();
            }

            @Override
            public boolean a(ItemStack stack) {
                EntityItemFrame.this.a(stack);
                return true;
            }
        } : super.k(mappedIndex);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        ItemStack itemstack;
        if (data.equals(ao) && !(itemstack = this.x()).b() && itemstack.E() != this) {
            itemstack.a(this);
        }
    }

    public int y() {
        return this.ai().a(ap);
    }

    public void a(int value) {
        this.a(value, true);
    }

    private void a(int value, boolean updateComparators) {
        this.ai().b(ap, value % 8);
        if (updateComparators && this.c != null) {
            this.s.c(this.c, Blocks.a);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (!this.x().b()) {
            nbt.a("Item", this.x().b(new NBTTagCompound()));
            nbt.a("ItemRotation", (byte)this.y());
            nbt.a("ItemDropChance", this.aq);
        }
        nbt.a("Facing", (byte)this.d.b());
        nbt.a("Invisible", this.bU());
        nbt.a("Fixed", this.ar);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagCompound nbttagcompound1 = nbt.p("Item");
        if (nbttagcompound1 != null && !nbttagcompound1.f()) {
            ItemStack itemstack1;
            ItemStack itemstack = ItemStack.a(nbttagcompound1);
            if (itemstack.b()) {
                f.warn("Unable to load item from: {}", (Object)nbttagcompound1);
            }
            if (!(itemstack1 = this.x()).b() && !ItemStack.b(itemstack, itemstack1)) {
                this.c(itemstack1);
            }
            this.a(itemstack, false);
            this.a(nbt.f("ItemRotation"), false);
            if (nbt.b("ItemDropChance", 99)) {
                this.aq = nbt.j("ItemDropChance");
            }
        }
        this.a(EnumDirection.a(nbt.f("Facing")));
        this.j(nbt.q("Invisible"));
        this.ar = nbt.q("Fixed");
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        boolean flag1;
        ItemStack itemstack = player.b(hand);
        boolean flag = !this.x().b();
        boolean bl = flag1 = !itemstack.b();
        if (this.ar) {
            return EnumInteractionResult.d;
        }
        if (!this.s.x) {
            if (!flag) {
                if (flag1 && !this.dp()) {
                    WorldMap worldmap;
                    if (itemstack.a(Items.pp) && (worldmap = ItemWorldMap.a(itemstack, this.s)) != null && worldmap.b(256)) {
                        return EnumInteractionResult.e;
                    }
                    PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), itemstack.asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.PLACE);
                    if (!event.callEvent()) {
                        return EnumInteractionResult.e;
                    }
                    this.a(ItemStack.fromBukkitCopy(event.getItemStack()));
                    if (!player.fs().d) {
                        itemstack.g(1);
                    }
                }
            } else {
                PlayerItemFrameChangeEvent event = new PlayerItemFrameChangeEvent((Player)player.getBukkitEntity(), (ItemFrame)this.getBukkitEntity(), this.x().asBukkitCopy(), PlayerItemFrameChangeEvent.ItemFrameChangeAction.ROTATE);
                if (!event.callEvent()) {
                    return EnumInteractionResult.e;
                }
                this.setItem(ItemStack.fromBukkitCopy(event.getItemStack()), false, false);
                this.a(this.n(), 1.0f, 1.0f);
                this.a(this.y() + 1);
            }
            return EnumInteractionResult.b;
        }
        return !flag && !flag1 ? EnumInteractionResult.d : EnumInteractionResult.a;
    }

    public SoundEffect n() {
        return SoundEffects.jt;
    }

    public int z() {
        return this.x().b() ? 0 : this.y() % 8 + 1;
    }

    @Override
    public Packet<?> S() {
        return new PacketPlayOutSpawnEntity(this, this.ad(), this.d.b(), this.w());
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.m()));
    }

    @Override
    public ItemStack dk() {
        ItemStack itemstack = this.x();
        return itemstack.b() ? this.o() : itemstack.n();
    }

    protected ItemStack o() {
        return new ItemStack(Items.ri);
    }
}

