/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSourceIndirect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

public abstract class EntityHanging
extends Entity {
    protected static final Predicate<Entity> b = entity -> entity instanceof EntityHanging;
    private int e;
    public BlockPosition c;
    protected EnumDirection d;

    protected EntityHanging(EntityTypes<? extends EntityHanging> type, World world) {
        super(type, world);
        this.e = this.ae() % this.s.spigotConfig.hangingTickFrequency;
        this.d = EnumDirection.d;
    }

    protected EntityHanging(EntityTypes<? extends EntityHanging> type, World world, BlockPosition pos) {
        this(type, world);
        this.c = pos;
    }

    @Override
    protected void a_() {
    }

    public void a(EnumDirection facing) {
        Validate.notNull((Object)facing);
        Validate.isTrue((boolean)facing.n().d());
        this.d = facing;
        this.o(this.d.d() * 90);
        this.w = this.dn();
        this.q();
    }

    protected void q() {
        if (this.d != null) {
            this.a(EntityHanging.calculateBoundingBox(this, this.c, this.d, this.s(), this.t()));
        }
    }

    public static AxisAlignedBB calculateBoundingBox(@Nullable Entity entity, BlockPosition blockPosition, EnumDirection direction, int width, int height) {
        double d0 = (double)blockPosition.u() + 0.5;
        double d1 = (double)blockPosition.v() + 0.5;
        double d2 = (double)blockPosition.w() + 0.5;
        double d3 = 0.46875;
        double d4 = EntityHanging.a(width);
        double d5 = EntityHanging.a(height);
        d0 -= (double)direction.i() * 0.46875;
        d2 -= (double)direction.k() * 0.46875;
        d1 += d5;
        EnumDirection enumdirection = direction.h();
        d0 += d4 * (double)enumdirection.i();
        d2 += d4 * (double)enumdirection.k();
        if (entity != null) {
            entity.o(d0, d1, d2);
        }
        double d6 = width;
        double d7 = height;
        double d8 = width;
        if (direction.n() == EnumDirection.EnumAxis.c) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        return new AxisAlignedBB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8);
    }

    private static double a(int i2) {
        return i2 % 32 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void k() {
        if (!this.s.x) {
            this.ao();
            if (this.e++ == this.s.spigotConfig.hangingTickFrequency) {
                this.e = 0;
                if (!this.dp() && !this.r()) {
                    Material material = this.s.a_(this.cW()).c();
                    HangingBreakEvent.RemoveCause cause = !material.equals(Material.a) ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.s.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.dp() || event.isCancelled()) {
                        return;
                    }
                    this.ah();
                    this.a((Entity)null);
                }
            }
        }
    }

    public boolean r() {
        if (!this.s.g(this)) {
            return false;
        }
        int i2 = Math.max(1, this.s() / 16);
        int j2 = Math.max(1, this.t() / 16);
        BlockPosition blockposition = this.c.a(this.d.f());
        EnumDirection enumdirection = this.d.h();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k2 = 0; k2 < i2; ++k2) {
            for (int l2 = 0; l2 < j2; ++l2) {
                int i1 = (i2 - 1) / -2;
                int j1 = (j2 - 1) / -2;
                blockposition_mutableblockposition.g(blockposition).c(enumdirection, k2 + i1).c(EnumDirection.b, l2 + j1);
                IBlockData iblockdata = this.s.a_(blockposition_mutableblockposition);
                if (iblockdata.c().b() || BlockDiodeAbstract.n(iblockdata)) continue;
                return false;
            }
        }
        return this.s.a((Entity)this, this.cw(), b).isEmpty();
    }

    @Override
    public boolean bh() {
        return true;
    }

    @Override
    public boolean r(Entity attacker) {
        if (attacker instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)attacker;
            return !this.s.a(entityhuman, this.c) ? true : this.a(DamageSource.a(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public EnumDirection ct() {
        return this.d;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.dp() && !this.s.x) {
            Entity damager;
            Entity entity = damager = source instanceof EntityDamageSourceIndirect ? ((EntityDamageSourceIndirect)source).getProximateDamageSource() : source.l();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), source.d() ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), source.d() ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dp() || event.isCancelled()) {
                return true;
            }
            this.ag();
            this.bf();
            this.a(source.l());
        }
        return true;
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (!this.s.x && !this.dp() && movement.g() > 0.0) {
            if (this.dp()) {
                return;
            }
            HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
            this.s.getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dp() || event.isCancelled()) {
                return;
            }
            this.ag();
            this.a((Entity)null);
        }
    }

    @Override
    public void i(double deltaX, double deltaY, double deltaZ) {
    }

    @Override
    public void b(NBTTagCompound nbt) {
        BlockPosition blockposition = this.w();
        nbt.a("TileX", blockposition.u());
        nbt.a("TileY", blockposition.v());
        nbt.a("TileZ", blockposition.w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.c = new BlockPosition(nbt.h("TileX"), nbt.h("TileY"), nbt.h("TileZ"));
    }

    public abstract int s();

    public abstract int t();

    public abstract void a(@Nullable Entity var1);

    public abstract void u();

    @Override
    public EntityItem a(ItemStack stack, float yOffset) {
        EntityItem entityitem = new EntityItem(this.s, this.dc() + (double)((float)this.d.i() * 0.15f), this.de() + (double)yOffset, this.di() + (double)((float)this.d.k() * 0.15f), stack);
        entityitem.n();
        this.s.b(entityitem);
        return entityitem;
    }

    @Override
    protected boolean bj() {
        return false;
    }

    @Override
    public void e(double x2, double y2, double z2) {
        this.c = new BlockPosition(x2, y2, z2);
        this.q();
        this.af = true;
    }

    public BlockPosition w() {
        return this.c;
    }

    @Override
    public float a(EnumBlockRotation rotation) {
        if (this.d.n() != EnumDirection.EnumAxis.b) {
            switch (rotation) {
                case c: {
                    this.d = this.d.f();
                    break;
                }
                case d: {
                    this.d = this.d.h();
                    break;
                }
                case b: {
                    this.d = this.d.g();
                }
            }
        }
        float f2 = MathHelper.g(this.dn());
        switch (rotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 90.0f;
            }
            case b: {
                return f2 + 270.0f;
            }
        }
        return f2;
    }

    @Override
    public float a(EnumBlockMirror mirror) {
        return this.a(mirror.a(this.d));
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public void z_() {
    }
}

