/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class EntityArmorStand
extends EntityLiving {
    public static final int b = 5;
    private static final boolean bO = true;
    private static final Vector3f bP = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bQ = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bR = new Vector3f(-10.0f, 0.0f, -10.0f);
    private static final Vector3f bS = new Vector3f(-15.0f, 0.0f, 10.0f);
    private static final Vector3f bT = new Vector3f(-1.0f, 0.0f, -1.0f);
    private static final Vector3f bU = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize bV = new EntitySize(0.0f, 0.0f, true);
    private static final EntitySize bW = EntityTypes.c.m().a(0.5f);
    private static final double bX = 0.1;
    private static final double bY = 0.9;
    private static final double bZ = 0.4;
    private static final double ca = 1.6;
    public static final int c = 8;
    public static final int d = 16;
    public static final int e = 1;
    public static final int f = 4;
    public static final int bE = 8;
    public static final int bF = 16;
    public static final DataWatcherObject<Byte> bG = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> bH = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Vector3f> bI = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Vector3f> bJ = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Vector3f> bK = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Vector3f> bL = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Vector3f> bM = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.k);
    private static final Predicate<Entity> cb = entity -> entity instanceof EntityMinecartAbstract && ((EntityMinecartAbstract)entity).q() == EntityMinecartAbstract.EnumMinecartType.a;
    private final NonNullList<net.minecraft.world.item.ItemStack> cc;
    private final NonNullList<net.minecraft.world.item.ItemStack> cd;
    private boolean ce;
    public long bN;
    public int cf;
    public Vector3f cg;
    public Vector3f ch;
    public Vector3f ci;
    public Vector3f cj;
    public Vector3f ck;
    public Vector3f cl;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        if (world != null) {
            this.canTick = world.paperConfig.armorStandTick;
        }
        this.cc = NonNullList.a(2, net.minecraft.world.item.ItemStack.b);
        this.cd = NonNullList.a(4, net.minecraft.world.item.ItemStack.b);
        this.cg = bP;
        this.ch = bQ;
        this.ci = bR;
        this.cj = bS;
        this.ck = bT;
        this.cl = bU;
        this.P = 0.0f;
    }

    public EntityArmorStand(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.c, world);
        this.e(x2, y2, z2);
    }

    @Override
    public float getBukkitYaw() {
        return this.dn();
    }

    @Override
    public void z_() {
        double d0 = this.dc();
        double d1 = this.de();
        double d2 = this.di();
        super.z_();
        this.e(d0, d1, d2);
    }

    private boolean C() {
        return !this.t() && !this.aM();
    }

    @Override
    public boolean eI() {
        return super.eI() && this.C();
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bG, (byte)0);
        this.Y.a(bH, bP);
        this.Y.a(bI, bQ);
        this.Y.a(bJ, bR);
        this.Y.a(bK, bS);
        this.Y.a(bL, bT);
        this.Y.a(bM, bU);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bB() {
        return this.cc;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bC() {
        return this.cd;
    }

    @Override
    public net.minecraft.world.item.ItemStack b(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.cc.get(slot.b());
            }
            case b: {
                return this.cd.get(slot.b());
            }
        }
        return net.minecraft.world.item.ItemStack.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.f(itemstack);
        switch (enumitemslot.a()) {
            case a: {
                this.equipEventAndSound(itemstack, silent);
                this.cc.set(enumitemslot.b(), itemstack);
                break;
            }
            case b: {
                this.equipEventAndSound(itemstack, silent);
                this.cd.set(enumitemslot.b(), itemstack);
            }
        }
        this.noTickEquipmentDirty = true;
    }

    @Override
    public boolean g(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.i(stack);
        return this.b(enumitemslot).b() && !this.d(enumitemslot);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack : this.cd) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack1 : this.cc) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbt.a("HandItems", nbttaglist1);
        nbt.a("Invisible", this.bU());
        nbt.a("Small", this.n());
        nbt.a("ShowArms", this.q());
        nbt.a("DisabledSlots", this.cf);
        nbt.a("NoBasePlate", this.r());
        if (this.t()) {
            nbt.a("Marker", this.t());
        }
        nbt.a("Pose", this.D());
        if (this.canTickSetByAPI) {
            nbt.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist;
        super.a(nbt);
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.cd.size(); ++i2) {
                this.cd.set(i2, net.minecraft.world.item.ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.cc.size(); ++i2) {
                this.cc.set(i2, net.minecraft.world.item.ItemStack.a(nbttaglist.a(i2)));
            }
        }
        this.j(nbt.q("Invisible"));
        this.a(nbt.q("Small"));
        this.r(nbt.q("ShowArms"));
        this.cf = nbt.h("DisabledSlots");
        this.s(nbt.q("NoBasePlate"));
        this.t(nbt.q("Marker"));
        boolean bl = this.Q = !this.C();
        if (nbt.e("Paper.CanTickOverride")) {
            this.canTick = nbt.q("Paper.CanTickOverride");
            this.canTickSetByAPI = true;
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Pose");
        this.c(nbttagcompound1);
    }

    private void c(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.c("Head", 5);
        this.a(nbttaglist.isEmpty() ? bP : new Vector3f(nbttaglist));
        NBTTagList nbttaglist1 = nbt.c("Body", 5);
        this.b(nbttaglist1.isEmpty() ? bQ : new Vector3f(nbttaglist1));
        NBTTagList nbttaglist2 = nbt.c("LeftArm", 5);
        this.c(nbttaglist2.isEmpty() ? bR : new Vector3f(nbttaglist2));
        NBTTagList nbttaglist3 = nbt.c("RightArm", 5);
        this.d(nbttaglist3.isEmpty() ? bS : new Vector3f(nbttaglist3));
        NBTTagList nbttaglist4 = nbt.c("LeftLeg", 5);
        this.e(nbttaglist4.isEmpty() ? bT : new Vector3f(nbttaglist4));
        NBTTagList nbttaglist5 = nbt.c("RightLeg", 5);
        this.f(nbttaglist5.isEmpty() ? bU : new Vector3f(nbttaglist5));
    }

    private NBTTagCompound D() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!bP.equals(this.cg)) {
            nbttagcompound.a("Head", this.cg.a());
        }
        if (!bQ.equals(this.ch)) {
            nbttagcompound.a("Body", this.ch.a());
        }
        if (!bR.equals(this.ci)) {
            nbttagcompound.a("LeftArm", this.ci.a());
        }
        if (!bS.equals(this.cj)) {
            nbttagcompound.a("RightArm", this.cj.a());
        }
        if (!bT.equals(this.ck)) {
            nbttagcompound.a("LeftLeg", this.ck.a());
        }
        if (!bU.equals(this.cl)) {
            nbttagcompound.a("RightLeg", this.cl.a());
        }
        return nbttagcompound;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void A(Entity entity) {
    }

    @Override
    protected void eG() {
        if (!this.s.paperConfig.armorStandEntityLookups) {
            return;
        }
        List<Entity> list = this.s.a((Entity)this, this.cw(), cb);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Entity entity = list.get(i2);
            if (!(this.f(entity) <= 0.2)) continue;
            entity.g(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack = player.b(hand);
        if (!this.t() && !itemstack.a(Items.rQ)) {
            if (player.B_()) {
                return EnumInteractionResult.a;
            }
            if (player.s.x) {
                return EnumInteractionResult.b;
            }
            EnumItemSlot enumitemslot = EntityInsentient.i(itemstack);
            if (itemstack.b()) {
                EnumItemSlot enumitemslot2;
                EnumItemSlot enumitemslot1 = this.j(hitPos);
                EnumItemSlot enumItemSlot = enumitemslot2 = this.d(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.a(enumitemslot2) && this.a(player, enumitemslot2, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            } else {
                if (this.d(enumitemslot)) {
                    return EnumInteractionResult.e;
                }
                if (enumitemslot.a() == EnumItemSlot.Function.a && !this.q()) {
                    return EnumInteractionResult.e;
                }
                if (this.a(player, enumitemslot, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot j(Vec3D hitPos) {
        EnumItemSlot enumitemslot = EnumItemSlot.a;
        boolean flag = this.n();
        double d0 = flag ? hitPos.c * 2.0 : hitPos.c;
        EnumItemSlot enumitemslot1 = EnumItemSlot.c;
        if (d0 >= 0.1) {
            double d2 = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d2 && this.a(enumitemslot1)) {
                return EnumItemSlot.c;
            }
        }
        double d3 = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d3) {
            double d4 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d4 && this.a(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d0 >= 0.4) {
            double d5 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d5 && this.a(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d0 >= 1.6 && this.a(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.a(EnumItemSlot.a)) return enumitemslot;
        if (!this.a(EnumItemSlot.b)) return enumitemslot;
        return EnumItemSlot.b;
    }

    public boolean d(EnumItemSlot slot) {
        return (this.cf & 1 << slot.c()) != 0 || slot.a() == EnumItemSlot.Function.a && !this.q();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.b(slot);
        if (!itemstack1.b() && (this.cf & 1 << slot.c() + 8) != 0) {
            return false;
        }
        if (itemstack1.b() && (this.cf & 1 << slot.c() + 16) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1);
        this.s.getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.fs().d && itemstack1.b() && !stack.b()) {
            net.minecraft.world.item.ItemStack itemstack2 = stack.n();
            itemstack2.e(1);
            this.a(slot, itemstack2);
            return true;
        }
        if (!stack.b() && stack.J() > 1) {
            if (!itemstack1.b()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack2 = stack.n();
            itemstack2.e(1);
            this.a(slot, itemstack2);
            stack.g(1);
            return true;
        }
        this.a(slot, stack);
        player.a(hand, itemstack1);
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!this.s.x && !this.dp()) {
            if (DamageSource.m.equals(source)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
                    return false;
                }
                this.ag();
                return false;
            }
            if (!this.b(source) && !this.t()) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, true, this.ce)) {
                    return false;
                }
                if (source.d()) {
                    this.h(source);
                    this.ag();
                    return false;
                }
                if (DamageSource.a.equals(source)) {
                    if (this.bE()) {
                        this.g(source, 0.15f);
                    } else {
                        this.f(5);
                    }
                    return false;
                }
                if (DamageSource.c.equals(source) && this.ea() > 0.5f) {
                    this.g(source, 4.0f);
                    return false;
                }
                boolean flag = source.k() instanceof EntityArrow;
                boolean flag1 = flag && ((EntityArrow)source.k()).s() > 0;
                boolean flag2 = "player".equals(source.u());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.l() instanceof EntityHuman && !((EntityHuman)source.l()).fs().e) {
                    return false;
                }
                if (source.B()) {
                    this.G();
                    this.E();
                    this.ag();
                    return flag1;
                }
                long i2 = this.s.U();
                if (i2 - this.bN > 5L && !flag) {
                    this.s.a((Entity)this, (byte)32);
                    this.a(GameEvent.r, source.l());
                    this.bN = i2;
                } else {
                    this.g(source);
                    this.E();
                    this.ah();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void a(byte status) {
        if (status == 32) {
            if (this.s.x) {
                this.s.a(this.dc(), this.de(), this.di(), SoundEffects.af, this.cO(), 0.3f, 1.0f, false);
                this.bN = this.s.U();
            }
        } else {
            super.a(status);
        }
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cw().a() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    private void E() {
        if (this.s instanceof WorldServer) {
            ((WorldServer)this.s).a(new ParticleParamBlock(Particles.c, Blocks.n.n()), this.dc(), this.e(0.6666666666666666), this.di(), 10, (double)(this.cT() / 4.0f), (double)(this.cU() / 4.0f), this.cT() / 4.0f, 0.05);
        }
    }

    private void g(DamageSource damageSource, float amount) {
        float f1 = this.ea();
        if ((f1 -= amount) <= 0.5f) {
            this.h(damageSource);
            this.ag();
        } else {
            this.c(f1);
            this.a(GameEvent.r, damageSource.l());
        }
    }

    private void g(DamageSource damageSource) {
        this.drops.add(CraftItemStack.asBukkitCopy(new net.minecraft.world.item.ItemStack(Items.rK)));
        this.h(damageSource);
    }

    private void h(DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack;
        int i2;
        this.G();
        for (i2 = 0; i2 < this.cc.size(); ++i2) {
            itemstack = this.cc.get(i2);
            if (itemstack.b()) continue;
            this.drops.add(CraftItemStack.asCraftMirror(itemstack));
            this.cc.set(i2, net.minecraft.world.item.ItemStack.b);
        }
        for (i2 = 0; i2 < this.cd.size(); ++i2) {
            itemstack = this.cd.get(i2);
            if (itemstack.b()) continue;
            this.drops.add(CraftItemStack.asCraftMirror(itemstack));
            this.cd.set(i2, net.minecraft.world.item.ItemStack.b);
        }
        this.dropAllDeathLoot(damageSource);
    }

    private void G() {
        this.s.a((EntityHuman)null, this.dc(), this.de(), this.di(), SoundEffects.ad, this.cO(), 1.0f, 1.0f);
    }

    @Override
    protected float e(float bodyRotation, float headRotation) {
        this.aY = this.w;
        this.aX = this.dn();
        return 0.0f;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * (this.y_() ? 0.5f : 0.9f);
    }

    @Override
    public double bp() {
        return this.t() ? 0.0 : (double)0.1f;
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.C()) {
            super.h(movementInput);
        }
    }

    @Override
    public void m(float bodyYaw) {
        this.aY = this.w = bodyYaw;
        this.ba = this.aZ = bodyYaw;
    }

    @Override
    public void l(float headYaw) {
        this.aY = this.w = headYaw;
        this.ba = this.aZ = headYaw;
    }

    @Override
    public void k() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.x();
            }
            return;
        }
        super.k();
        this.updatePose();
    }

    public void updatePose() {
        Vector3f vector3f5;
        Vector3f vector3f4;
        Vector3f vector3f3;
        Vector3f vector3f2;
        Vector3f vector3f1;
        Vector3f vector3f = this.Y.a(bH);
        if (!this.cg.equals(vector3f)) {
            this.a(vector3f);
        }
        if (!this.ch.equals(vector3f1 = this.Y.a(bI))) {
            this.b(vector3f1);
        }
        if (!this.ci.equals(vector3f2 = this.Y.a(bJ))) {
            this.c(vector3f2);
        }
        if (!this.cj.equals(vector3f3 = this.Y.a(bK))) {
            this.d(vector3f3);
        }
        if (!this.ck.equals(vector3f4 = this.Y.a(bL))) {
            this.e(vector3f4);
        }
        if (!this.cl.equals(vector3f5 = this.Y.a(bM))) {
            this.f(vector3f5);
        }
    }

    @Override
    protected void F() {
        this.j(this.ce);
    }

    @Override
    public void j(boolean invisible) {
        this.ce = invisible;
        super.j(invisible);
    }

    @Override
    public boolean y_() {
        return this.n();
    }

    @Override
    protected boolean dI() {
        return true;
    }

    @Override
    public void ag() {
        EntityDeathEvent event = CraftEventFactory.callEntityDeathEvent(this, this.drops);
        if (event.isCancelled()) {
            return;
        }
        this.a(Entity.RemovalReason.a);
    }

    @Override
    public boolean cC() {
        return this.bU();
    }

    @Override
    public EnumPistonReaction c_() {
        return this.t() ? EnumPistonReaction.d : super.c_();
    }

    public void a(boolean small) {
        this.Y.b(bG, this.a(this.Y.a(bG), 1, small));
    }

    public boolean n() {
        return (this.Y.a(bG) & 1) != 0;
    }

    public void r(boolean showArms) {
        this.Y.b(bG, this.a(this.Y.a(bG), 4, showArms));
    }

    public boolean q() {
        return (this.Y.a(bG) & 4) != 0;
    }

    public void s(boolean hideBasePlate) {
        this.Y.b(bG, this.a(this.Y.a(bG), 8, hideBasePlate));
    }

    public boolean r() {
        return (this.Y.a(bG) & 8) != 0;
    }

    public void t(boolean marker) {
        this.Y.b(bG, this.a(this.Y.a(bG), 16, marker));
    }

    public boolean t() {
        return (this.Y.a(bG) & 0x10) != 0;
    }

    private byte a(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public void a(Vector3f angle) {
        this.cg = angle;
        this.Y.b(bH, angle);
        this.noTickPoseDirty = true;
    }

    public void b(Vector3f angle) {
        this.ch = angle;
        this.Y.b(bI, angle);
        this.noTickPoseDirty = true;
    }

    public void c(Vector3f angle) {
        this.ci = angle;
        this.Y.b(bJ, angle);
        this.noTickPoseDirty = true;
    }

    public void d(Vector3f angle) {
        this.cj = angle;
        this.Y.b(bK, angle);
        this.noTickPoseDirty = true;
    }

    public void e(Vector3f angle) {
        this.ck = angle;
        this.Y.b(bL, angle);
        this.noTickPoseDirty = true;
    }

    public void f(Vector3f angle) {
        this.cl = angle;
        this.Y.b(bM, angle);
        this.noTickPoseDirty = true;
    }

    public Vector3f u() {
        return this.cg;
    }

    public Vector3f w() {
        return this.ch;
    }

    public Vector3f x() {
        return this.ci;
    }

    public Vector3f y() {
        return this.cj;
    }

    public Vector3f z() {
        return this.ck;
    }

    public Vector3f A() {
        return this.cl;
    }

    @Override
    public boolean bh() {
        return super.bh() && !this.t();
    }

    @Override
    public boolean r(Entity attacker) {
        return attacker instanceof EntityHuman && !this.s.a((EntityHuman)attacker, this.cW());
    }

    @Override
    public EnumMainHand eL() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a eg() {
        return new EntityLiving.a(SoundEffects.ae, SoundEffects.ae);
    }

    @Override
    @Nullable
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.af;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.ad;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public boolean eX() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bG.equals(data)) {
            this.z_();
            this.q = !this.t();
        }
        super.a(data);
    }

    @Override
    public boolean eY() {
        return false;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return this.u(this.t());
    }

    private EntitySize u(boolean marker) {
        return marker ? bV : (this.y_() ? bW : this.ad().m());
    }

    @Override
    public Vec3D j(float tickDelta) {
        if (this.t()) {
            AxisAlignedBB axisalignedbb = this.u(false).a(this.cV());
            BlockPosition blockposition = this.cW();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockposition1 : BlockPosition.a(new BlockPosition(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c), new BlockPosition(axisalignedbb.d, axisalignedbb.e, axisalignedbb.f))) {
                int j2 = Math.max(this.s.a(EnumSkyBlock.b, blockposition1), this.s.a(EnumSkyBlock.a, blockposition1));
                if (j2 == 15) {
                    return Vec3D.a(blockposition1);
                }
                if (j2 <= i2) continue;
                i2 = j2;
                blockposition = blockposition1.h();
            }
            return Vec3D.a(blockposition);
        }
        return super.j(tickDelta);
    }

    @Override
    public net.minecraft.world.item.ItemStack dk() {
        return new net.minecraft.world.item.ItemStack(Items.rK);
    }

    @Override
    public boolean dU() {
        return !this.bU() && !this.t();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }

    @Override
    public boolean dx() {
        return true;
    }
}

