/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.PlayerChunkLoader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.slf4j.Logger;

public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger ca = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> b = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition cb = PathfinderTargetCondition.a().a(64.0);
    private static final int cc = 200;
    private static final int cd = 400;
    private static final float ce = 0.25f;
    private static final String cf = "DragonDeathTime";
    private static final String cg = "DragonPhase";
    public final double[][] c = new double[64][3];
    public int d = -1;
    public final EntityComplexPart[] ch;
    public final EntityComplexPart e = new EntityComplexPart(this, "head", 1.0f, 1.0f);
    private final EntityComplexPart ci = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
    private final EntityComplexPart cj = new EntityComplexPart(this, "body", 5.0f, 3.0f);
    private final EntityComplexPart ck = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart cl = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart cm = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
    private final EntityComplexPart cn = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
    private final EntityComplexPart co = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
    public float bU;
    public float bV;
    public boolean bW;
    public int bX;
    public float bY;
    @Nullable
    public EntityEnderCrystal bZ;
    @Nullable
    private final EnderDragonBattle cp;
    private final DragonControllerManager cq;
    private int cr = 100;
    private float cs;
    private final PathPoint[] ct = new PathPoint[24];
    private final int[] cu = new int[24];
    private final Path cv = new Path();
    private Explosion explosionSource = new Explosion(null, this, null, null, Double.NaN, Double.NaN, Double.NaN, Float.NaN, true, Explosion.Effect.c);

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.v, world);
        this.ch = new EntityComplexPart[]{this.e, this.ci, this.cj, this.ck, this.cl, this.cm, this.cn, this.co};
        this.c(this.em());
        this.Q = true;
        this.ae = true;
        this.cp = world instanceof WorldServer ? ((WorldServer)world).E() : null;
        this.cq = new DragonControllerManager(this);
    }

    public static AttributeProvider.Builder n() {
        return EntityInsentient.w().a(GenericAttributes.a, 200.0);
    }

    @Override
    public boolean aK() {
        float f2 = MathHelper.b(this.bV * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.bU * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void aJ() {
        if (this.s.x && !this.aL()) {
            this.s.a(this.dc(), this.de(), this.di(), SoundEffects.fo, this.cO(), 5.0f, 0.8f + this.R.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void a_() {
        super.a_();
        this.ai().a(b, DragonControllerPhase.k.b());
    }

    public double[] a(int segmentNumber, float tickDelta) {
        if (this.eb()) {
            tickDelta = 0.0f;
        }
        tickDelta = 1.0f - tickDelta;
        int j2 = this.d - segmentNumber & 0x3F;
        int k2 = this.d - segmentNumber - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.c[j2][0];
        double d1 = MathHelper.f(this.c[k2][0] - d0);
        adouble[0] = d0 + d1 * (double)tickDelta;
        d0 = this.c[j2][1];
        d1 = this.c[k2][1] - d0;
        adouble[1] = d0 + d1 * (double)tickDelta;
        adouble[2] = MathHelper.d((double)tickDelta, this.c[j2][2], this.c[k2][2]);
        return adouble;
    }

    @Override
    public void w_() {
        this.az();
        if (this.s.x) {
            this.c(this.ea());
            if (!this.aL() && !this.cq.a().a() && --this.cr < 0) {
                this.s.a(this.dc(), this.de(), this.di(), SoundEffects.fp, this.cO(), 2.5f, 0.8f + this.R.nextFloat() * 0.3f, false);
                this.cr = 200 + this.R.nextInt(200);
            }
        }
        this.bU = this.bV;
        if (this.eb()) {
            float f1 = (this.R.nextFloat() - 0.5f) * 8.0f;
            float f2 = (this.R.nextFloat() - 0.5f) * 4.0f;
            float f22 = (this.R.nextFloat() - 0.5f) * 8.0f;
            this.s.a(Particles.x, this.dc() + (double)f1, this.de() + 2.0 + (double)f2, this.di() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.fA();
            Vec3D vec3d = this.da();
            float f3 = 0.2f / ((float)vec3d.h() * 10.0f + 1.0f);
            this.bV = this.cq.a().a() ? (this.bV += 0.1f) : (this.bW ? (this.bV += f3 * 0.5f) : (this.bV += (f3 *= (float)Math.pow(2.0, vec3d.c))));
            this.o(MathHelper.g(this.dn()));
            if (this.fs()) {
                this.bV = 0.5f;
            } else {
                int k2;
                float f5;
                float f4;
                float f32;
                if (this.d < 0) {
                    for (int i2 = 0; i2 < this.c.length; ++i2) {
                        this.c[i2][0] = this.dn();
                        this.c[i2][1] = this.de();
                    }
                }
                if (++this.d == this.c.length) {
                    this.d = 0;
                }
                this.c[this.d][0] = this.dn();
                this.c[this.d][1] = this.de();
                if (this.s.x) {
                    if (this.br > 0) {
                        double d3 = this.dc() + (this.bs - this.dc()) / (double)this.br;
                        double d0 = this.de() + (this.bt - this.de()) / (double)this.br;
                        d1 = this.di() + (this.bu - this.di()) / (double)this.br;
                        d2 = MathHelper.f(this.bv - (double)this.dn());
                        this.o(this.dn() + (float)d2 / (float)this.br);
                        this.p(this.do() + (float)(this.bw - (double)this.do()) / (float)this.br);
                        --this.br;
                        this.e(d3, d0, d1);
                        this.a(this.dn(), this.do());
                    }
                    this.cq.a().b();
                } else {
                    Vec3D vec3d1;
                    IDragonController idragoncontroller = this.cq.a();
                    idragoncontroller.c();
                    if (this.cq.a() != idragoncontroller) {
                        idragoncontroller = this.cq.a();
                        idragoncontroller.c();
                    }
                    if ((vec3d1 = idragoncontroller.g()) != null && idragoncontroller.i() != DragonControllerPhase.k) {
                        double d0 = vec3d1.b - this.dc();
                        d1 = vec3d1.c - this.de();
                        d2 = vec3d1.d - this.di();
                        double d4 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f6 = idragoncontroller.f();
                        double d5 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d5 > 0.0) {
                            d1 = MathHelper.a(d1 / d5, (double)(-f6), (double)f6);
                        }
                        this.g(this.da().b(0.0, d1 * 0.01, 0.0));
                        this.o(MathHelper.g(this.dn()));
                        Vec3D vec3d2 = vec3d1.a(this.dc(), this.de(), this.di()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dn() * ((float)Math.PI / 180)), this.da().c, -MathHelper.b(this.dn() * ((float)Math.PI / 180))).d();
                        f32 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            f4 = MathHelper.a(MathHelper.g(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.dn()), -50.0f, 50.0f);
                            this.bY *= 0.8f;
                            this.bY += f4 * idragoncontroller.h();
                            this.o(this.dn() + this.bY * 0.1f);
                        }
                        f4 = (float)(2.0 / (d4 + 1.0));
                        f5 = 0.06f;
                        this.a(0.06f * (f32 * f4 + (1.0f - f4)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.bW) {
                            this.a(EnumMoveType.a, this.da().a((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.da());
                        }
                        Vec3D vec3d4 = this.da().d();
                        double d6 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.g(this.da().d(d6, 0.91f, d6));
                    }
                }
                this.aX = this.dn();
                Vec3D[] avec3d = new Vec3D[this.ch.length];
                for (int j2 = 0; j2 < this.ch.length; ++j2) {
                    avec3d[j2] = new Vec3D(this.ch[j2].dc(), this.ch[j2].de(), this.ch[j2].di());
                }
                float f7 = (float)(this.a(5, 1.0f)[1] - this.a(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f8 = MathHelper.b(f7);
                float f9 = MathHelper.a(f7);
                float f10 = this.dn() * ((float)Math.PI / 180);
                float f11 = MathHelper.a(f10);
                float f12 = MathHelper.b(f10);
                this.a(this.cj, (double)(f11 * 0.5f), 0.0, (double)(-f12 * 0.5f));
                this.a(this.cn, (double)(f12 * 4.5f), 2.0, (double)(f11 * 4.5f));
                this.a(this.co, (double)(f12 * -4.5f), 2.0, (double)(f11 * -4.5f));
                if (!this.s.x && this.aK == 0) {
                    this.a(this.s.a((Entity)this, this.cn.cw().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.a(this.s.a((Entity)this, this.co.cw().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                    this.b(this.s.a((Entity)this, this.e.cw().g(1.0), IEntitySelector.e));
                    this.b(this.s.a((Entity)this, this.ci.cw().g(1.0), IEntitySelector.e));
                }
                float f13 = MathHelper.a(this.dn() * ((float)Math.PI / 180) - this.bY * 0.01f);
                float f14 = MathHelper.b(this.dn() * ((float)Math.PI / 180) - this.bY * 0.01f);
                float f15 = this.fz();
                this.a(this.e, (double)(f13 * 6.5f * f8), (double)(f15 + f9 * 6.5f), (double)(-f14 * 6.5f * f8));
                this.a(this.ci, (double)(f13 * 5.5f * f8), (double)(f15 + f9 * 5.5f), (double)(-f14 * 5.5f * f8));
                double[] adouble = this.a(5, 1.0f);
                for (k2 = 0; k2 < 3; ++k2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (k2 == 0) {
                        entitycomplexpart = this.ck;
                    }
                    if (k2 == 1) {
                        entitycomplexpart = this.cl;
                    }
                    if (k2 == 2) {
                        entitycomplexpart = this.cm;
                    }
                    double[] adouble1 = this.a(12 + k2 * 2, 1.0f);
                    float f16 = this.dn() * ((float)Math.PI / 180) + this.i(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    f32 = MathHelper.a(f16);
                    f4 = MathHelper.b(f16);
                    f5 = 1.5f;
                    float f17 = (float)(k2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f11 * 1.5f + f32 * f17) * f8), adouble1[1] - adouble[1] - (double)((f17 + 1.5f) * f9) + 1.5, (double)((f12 * 1.5f + f4 * f17) * f8));
                }
                if (!this.s.x) {
                    this.bW = this.b(this.e.cw()) | this.b(this.ci.cw()) | this.b(this.cj.cw());
                    if (this.cp != null) {
                        this.cp.b(this);
                    }
                }
                for (k2 = 0; k2 < this.ch.length; ++k2) {
                    this.ch[k2].t = avec3d[k2].b;
                    this.ch[k2].u = avec3d[k2].c;
                    this.ch[k2].v = avec3d[k2].d;
                    this.ch[k2].M = avec3d[k2].b;
                    this.ch[k2].N = avec3d[k2].c;
                    this.ch[k2].O = avec3d[k2].d;
                }
            }
        }
    }

    private void a(EntityComplexPart enderDragonPart, double dx, double dy, double dz) {
        enderDragonPart.e(this.dc() + dx, this.de() + dy, this.di() + dz);
    }

    private float fz() {
        if (this.cq.a().a()) {
            return -1.0f;
        }
        double[] adouble = this.a(5, 1.0f);
        double[] adouble1 = this.a(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void fA() {
        if (this.bZ != null) {
            if (this.bZ.dp()) {
                this.bZ = null;
            } else if (this.S % 10 == 0 && this.ea() < this.em()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.s.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.c((float)((double)this.ea() + event.getAmount()));
                }
            }
        }
        if (this.R.nextInt(10) == 0) {
            List<EntityEnderCrystal> list = this.s.a(EntityEnderCrystal.class, this.cw().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.f(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.bZ = entityendercrystal;
        }
    }

    private void a(List<Entity> entities) {
        double d0 = (this.cj.cw().a + this.cj.cw().d) / 2.0;
        double d1 = (this.cj.cw().c + this.cj.cw().f) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            double d2 = entity.dc() - d0;
            double d3 = entity.di() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.i(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.cq.a().a() || ((EntityLiving)entity).dN() >= entity.S - 2) continue;
            entity.a(DamageSource.c(this), 5.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private void b(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLiving)) continue;
            entity.a(DamageSource.c(this), 10.0f);
            this.a((EntityLiving)this, entity);
        }
    }

    private float i(double yawDegrees) {
        return (float)MathHelper.f(yawDegrees);
    }

    private boolean b(AxisAlignedBB box) {
        int i2 = MathHelper.b(box.a);
        int j2 = MathHelper.b(box.b);
        int k2 = MathHelper.b(box.c);
        int l2 = MathHelper.b(box.d);
        int i1 = MathHelper.b(box.e);
        int j1 = MathHelper.b(box.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<CraftBlock> destroyedBlocks = new ArrayList<CraftBlock>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = this.s.a_(blockposition);
                    if (iblockdata.g() || iblockdata.c() == net.minecraft.world.level.material.Material.n) continue;
                    if (this.s.W().b(GameRules.c) && !iblockdata.a(TagsBlock.ap)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(this.s, blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        CraftEntity bukkitEntity = this.getBukkitEntity();
        EntityExplodeEvent event = new EntityExplodeEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), destroyedBlocks, 0.0f);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.s.a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                org.bukkit.block.Block tntBlock;
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().n() ? this.s.c_(blockposition) : null;
                    LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.s).a(this.s.v).a(LootContextParameters.f, Vec3D.a(blockposition)).a(LootContextParameters.i, ItemStack.b).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.s, blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.s, blockposition, ItemStack.b);
                }
                if (!new TNTPrimeEvent(tntBlock = this.s.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), TNTPrimeEvent.PrimeReason.EXPLOSION, (org.bukkit.entity.Entity)this.explosionSource.d().getBukkitEntity()).callEvent()) continue;
                nmsBlock.a(this.s, blockposition, this.explosionSource);
                this.s.a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.R.nextInt(l2 - i2 + 1), j2 + this.R.nextInt(i1 - j2 + 1), k2 + this.R.nextInt(j1 - k2 + 1));
            this.s.c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(EntityComplexPart part, DamageSource source, float amount) {
        if (this.cq.a().i() == DragonControllerPhase.j) {
            return false;
        }
        amount = this.cq.a().a(source, amount);
        if (part != this.e) {
            amount = amount / 4.0f + Math.min(amount, 1.0f);
        }
        if (amount < 0.01f) {
            return false;
        }
        if (source.l() instanceof EntityHuman || source.d()) {
            float f1 = this.ea();
            this.g(source, amount);
            if (this.eb() && !this.cq.a().a()) {
                this.c(1.0f);
                this.cq.a(DragonControllerPhase.j);
            }
            if (this.cq.a().a()) {
                this.cs = this.cs + f1 - this.ea();
                if (this.cs > 0.25f * this.em()) {
                    this.cs = 0.0f;
                    this.cq.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).E() && !this.s.x) {
            this.a(this.cj, source, amount);
        }
        return false;
    }

    protected boolean g(DamageSource source, float amount) {
        return super.a(source, amount);
    }

    @Override
    public void ag() {
        this.a(Entity.RemovalReason.a);
        if (this.cp != null) {
            this.cp.b(this);
            this.cp.a(this);
        }
    }

    @Override
    protected void dH() {
        if (this.cp != null) {
            this.cp.b(this);
        }
        ++this.bX;
        if (this.bX >= 180 && this.bX <= 200) {
            float f2 = (this.R.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.R.nextFloat() - 0.5f) * 4.0f;
            float f22 = (this.R.nextFloat() - 0.5f) * 8.0f;
            this.s.a(Particles.w, this.dc() + (double)f2, this.de() + 2.0 + (double)f1, this.di() + (double)f22, 0.0, 0.0, 0.0);
        }
        boolean flag = this.s.W().b(GameRules.f);
        int short0 = 500;
        if (this.cp != null && !this.cp.d()) {
            short0 = 12000;
        }
        if (this.s instanceof WorldServer) {
            if (this.bX > 150 && this.bX % 5 == 0 && flag) {
                EntityExperienceOrb.award((WorldServer)this.s, this.cV(), MathHelper.d((float)short0 * 0.08f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.bc, this);
            }
            if (this.bX == 1 && !this.aL()) {
                for (EntityPlayer player : ((WorldServer)this.s).y()) {
                    int viewDistance = PlayerChunkLoader.getSendViewDistance(player);
                    double deltaX = this.dc() - player.dc();
                    double deltaZ = this.di() - player.di();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (this.s.spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(this.s.spigotConfig.dragonDeathSoundRadius * this.s.spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dc() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.di() + deltaZ / deltaLength * (double)viewDistance;
                        player.b.a(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.de(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.b.a(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dc(), (int)this.de(), (int)this.di()), 0, true));
                }
            }
        }
        this.a(EnumMoveType.a, new Vec3D(0.0, 0.1f, 0.0));
        this.o(this.dn() + 20.0f);
        this.aX = this.dn();
        if (this.bX == 200 && this.s instanceof WorldServer) {
            if (flag) {
                EntityExperienceOrb.award((WorldServer)this.s, this.cV(), MathHelper.d((float)short0 * 0.2f), ExperienceOrb.SpawnReason.ENTITY_DEATH, this.bc, this);
            }
            if (this.cp != null) {
                this.cp.a(this);
            }
            this.a(Entity.RemovalReason.a);
        }
    }

    public int q() {
        if (this.ct[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    i1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)i1)));
                }
                int j1 = Math.max(this.s.m_() + 10, this.s.a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.ct[i2] = new PathPoint(k2, j1, l2);
            }
            this.cu[0] = 6146;
            this.cu[1] = 8197;
            this.cu[2] = 8202;
            this.cu[3] = 16404;
            this.cu[4] = 32808;
            this.cu[5] = 32848;
            this.cu[6] = 65696;
            this.cu[7] = 131392;
            this.cu[8] = 131712;
            this.cu[9] = 263424;
            this.cu[10] = 526848;
            this.cu[11] = 525313;
            this.cu[12] = 1581057;
            this.cu[13] = 3166214;
            this.cu[14] = 2138120;
            this.cu[15] = 6373424;
            this.cu[16] = 4358208;
            this.cu[17] = 12910976;
            this.cu[18] = 9044480;
            this.cu[19] = 9706496;
            this.cu[20] = 15216640;
            this.cu[21] = 0xD0E000;
            this.cu[22] = 11763712;
            this.cu[23] = 0x7E0000;
        }
        return this.q(this.dc(), this.de(), this.di());
    }

    public int q(double x2, double y2, double z2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.b(x2), MathHelper.b(y2), MathHelper.b(z2));
        int b0 = 0;
        if (this.cp == null || this.cp.c() == 0) {
            b0 = 12;
        }
        for (int j2 = b0; j2 < 24; ++j2) {
            float f1;
            if (this.ct[j2] == null || !((f1 = this.ct[j2].b(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = j2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int from, int to, @Nullable PathPoint pathNode) {
        PathPoint pathpoint1;
        for (int k2 = 0; k2 < 24; ++k2) {
            pathpoint1 = this.ct[k2];
            pathpoint1.i = false;
            pathpoint1.f = 0.0f;
            pathpoint1.g = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.ct[from];
        pathpoint1 = this.ct[to];
        pathpoint2.g = 0.0f;
        pathpoint2.f = pathpoint2.f = pathpoint2.a(pathpoint1);
        this.cv.a();
        this.cv.a(pathpoint2);
        PathPoint pathpoint3 = pathpoint2;
        int b0 = 0;
        if (this.cp == null || this.cp.c() == 0) {
            b0 = 12;
        }
        while (!this.cv.e()) {
            int i1;
            PathPoint pathpoint4 = this.cv.c();
            if (pathpoint4.equals(pathpoint1)) {
                if (pathNode != null) {
                    pathNode.h = pathpoint1;
                    pathpoint1 = pathNode;
                }
                return this.a(pathpoint2, pathpoint1);
            }
            if (pathpoint4.a(pathpoint1) < pathpoint3.a(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.i = true;
            int l2 = 0;
            for (i1 = 0; i1 < 24; ++i1) {
                if (this.ct[i1] != pathpoint4) {
                    continue;
                }
                l2 = i1;
                break;
            }
            for (i1 = b0; i1 < 24; ++i1) {
                if ((this.cu[l2] & 1 << i1) <= 0) continue;
                PathPoint pathpoint5 = this.ct[i1];
                if (pathpoint5.i) continue;
                float f2 = pathpoint4.g + pathpoint4.a(pathpoint5);
                if (pathpoint5.c() && !(f2 < pathpoint5.g)) continue;
                pathpoint5.h = pathpoint4;
                pathpoint5.g = f2;
                pathpoint5.f = pathpoint5.a(pathpoint1);
                if (pathpoint5.c()) {
                    this.cv.a(pathpoint5, pathpoint5.g + pathpoint5.f);
                    continue;
                }
                pathpoint5.f = pathpoint5.g + pathpoint5.f;
                this.cv.a(pathpoint5);
            }
        }
        if (pathpoint3 == pathpoint2) {
            return null;
        }
        ca.debug("Failed to find path from {} to {}", (Object)from, (Object)to);
        if (pathNode != null) {
            pathNode.h = pathpoint3;
            pathpoint3 = pathNode;
        }
        return this.a(pathpoint2, pathpoint3);
    }

    private PathEntity a(PathPoint unused, PathPoint node) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = node;
        list.add(0, node);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(node.a, node.b, node.c), true);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(cg, this.cq.a().i().b());
        nbt.a(cf, this.bX);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e(cg)) {
            this.cq.a(DragonControllerPhase.a(nbt.h(cg)));
        }
        if (nbt.e(cf)) {
            this.bX = nbt.h(cf);
        }
    }

    @Override
    public void dj() {
    }

    public EntityComplexPart[] t() {
        return this.ch;
    }

    @Override
    public boolean bh() {
        return false;
    }

    @Override
    public SoundCategory cO() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.fl;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.fq;
    }

    @Override
    public float ev() {
        return 5.0f;
    }

    public float a(int segmentOffset, double[] segment1, double[] segment2) {
        double d0;
        IDragonController idragoncontroller = this.cq.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            d0 = idragoncontroller.a() ? (double)segmentOffset : (segmentOffset == 6 ? 0.0 : segment2[1] - segment1[1]);
        } else {
            BlockPosition blockposition = this.s.a(HeightMap.Type.f, WorldGenEndTrophy.e);
            double d1 = Math.max(Math.sqrt(blockposition.a(this.cV())) / 4.0, 1.0);
            d0 = (double)segmentOffset / d1;
        }
        return (float)d0;
    }

    public Vec3D y(float tickDelta) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cq.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.i();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f2 = this.do();
                float f1 = 1.5f;
                this.p(-45.0f);
                vec3d = this.e(tickDelta);
                this.p(f2);
            } else {
                vec3d = this.e(tickDelta);
            }
        } else {
            BlockPosition blockposition = this.s.a(HeightMap.Type.f, WorldGenEndTrophy.e);
            float f1 = Math.max((float)Math.sqrt(blockposition.a(this.cV())) / 4.0f, 1.0f);
            float f3 = 6.0f / f1;
            float f4 = this.do();
            float f5 = 1.5f;
            this.p(-f3 * 1.5f * 5.0f);
            vec3d = this.e(tickDelta);
            this.p(f4);
        }
        return vec3d;
    }

    public void a(EntityEnderCrystal crystal, BlockPosition pos, DamageSource source) {
        EntityHuman entityhuman = source.l() instanceof EntityHuman ? (EntityHuman)source.l() : this.s.a(cb, (double)pos.u(), (double)pos.v(), (double)pos.w());
        if (crystal == this.bZ) {
            this.a(this.e, DamageSource.d(entityhuman), 10.0f);
        }
        this.cq.a().a(crystal, pos, source, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (b.equals(data) && this.s.x) {
            this.cq.a(DragonControllerPhase.a(this.ai().a(b)));
        }
        super.a(data);
    }

    public DragonControllerManager fx() {
        return this.cq;
    }

    @Nullable
    public EnderDragonBattle fy() {
        return this.cp;
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    @Override
    protected boolean l(Entity entity) {
        return false;
    }

    @Override
    public boolean ci() {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntityLiving packet) {
        super.a(packet);
        EntityComplexPart[] aentitycomplexpart = this.t();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packet.b());
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return target.dT();
    }
}

