/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
IJumpable,
ISaddleable {
    public static final int bW = 400;
    public static final int bY = 499;
    public static final int bZ = 500;
    private static final Predicate<EntityLiving> bV = entityliving -> entityliving instanceof EntityHorseAbstract && ((EntityHorseAbstract)entityliving).fO();
    private static final PathfinderTargetCondition cl = PathfinderTargetCondition.b().a(16.0).d().a(bV);
    private static final RecipeItemStack cm = RecipeItemStack.a(Items.ni, Items.oW, Blocks.gO.l(), Items.mf, Items.rq, Items.nM, Items.nN);
    private static final DataWatcherObject<Byte> cn = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Optional<UUID>> co = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.o);
    private static final int cp = 2;
    private static final int cq = 4;
    private static final int cr = 8;
    private static final int cs = 16;
    private static final int ct = 32;
    private static final int cu = 64;
    public static final int ca = 0;
    public static final int cb = 1;
    public static final int cc = 2;
    private int cv;
    private int cw;
    private int cx;
    public int cd;
    public int ce;
    protected boolean cf;
    public InventorySubcontainer cg;
    protected int ch;
    protected float ci;
    private boolean cy;
    private float cz;
    private float cA;
    private float cB;
    private float cC;
    private float cD;
    private float cE;
    protected boolean cj = true;
    protected int ck;
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.P = 1.0f;
        this.fQ();
    }

    @Override
    protected void u() {
        this.bQ.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bQ.a(1, new PathfinderGoalTame(this, 1.2));
        this.bQ.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bQ.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bQ.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bQ.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bQ.a(8, new PathfinderGoalRandomLookaround(this));
        this.fI();
    }

    protected void fI() {
        this.bQ.a(0, new PathfinderGoalFloat(this));
        this.bQ.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.rq, Items.nM, Items.nN), false));
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(cn, (byte)0);
        this.Y.a(co, Optional.empty());
    }

    protected boolean s(int bitmask) {
        return (this.Y.a(cn) & bitmask) != 0;
    }

    protected void d(int bitmask, boolean flag) {
        byte b0 = this.Y.a(cn);
        if (flag) {
            this.Y.b(cn, (byte)(b0 | bitmask));
        } else {
            this.Y.b(cn, (byte)(b0 & ~bitmask));
        }
    }

    public boolean fJ() {
        return this.s(2);
    }

    @Nullable
    public UUID fK() {
        return this.Y.a(co).orElse(null);
    }

    public void b(@Nullable UUID uuid) {
        this.Y.b(co, Optional.ofNullable(uuid));
    }

    public boolean fL() {
        return this.cf;
    }

    public void w(boolean tame) {
        this.d(2, tame);
    }

    public void x(boolean inAir) {
        this.cf = inAir;
    }

    @Override
    protected void y(float leashLength) {
        if (leashLength > 6.0f && this.fM()) {
            this.z(false);
        }
    }

    public boolean fM() {
        return this.s(16);
    }

    public boolean fN() {
        return this.s(32);
    }

    public boolean fO() {
        return this.s(8);
    }

    public void y(boolean bred) {
        this.d(8, bred);
    }

    @Override
    public boolean c() {
        return this.bl() && !this.y_() && this.fJ();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.cg.a(0, new ItemStack(Items.lL));
        if (sound != null) {
            this.s.a((EntityHuman)null, this, SoundEffects.iJ, sound, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean d() {
        return this.s(4);
    }

    public int fP() {
        return this.ch;
    }

    public void t(int temper) {
        this.ch = temper;
    }

    public int u(int difference) {
        int j2 = MathHelper.a(this.fP() + difference, 0, this.fW());
        this.t(j2);
        return j2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.bG();
    }

    private void t() {
        SoundEffect soundeffect;
        this.fB();
        if (!this.aL() && (soundeffect = this.fT()) != null) {
            this.s.a((EntityHuman)null, this.dc(), this.de(), this.di(), soundeffect, this.cO(), 1.0f, 1.0f + (this.R.nextFloat() - this.R.nextFloat()) * 0.2f);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0f) {
            this.a(SoundEffects.iI, 0.4f, 1.0f);
        }
        if ((i2 = this.d(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        if (this.bG()) {
            for (Entity entity : this.cJ()) {
                entity.a(damageSource, (float)i2);
            }
        }
        this.ei();
        return true;
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return MathHelper.f((fallDistance * 0.5f - 3.0f) * damageMultiplier);
    }

    protected int fA() {
        return 2;
    }

    public void fQ() {
        InventorySubcontainer inventorysubcontainer = this.cg;
        this.cg = new InventorySubcontainer(this.fA(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (inventorysubcontainer != null) {
            inventorysubcontainer.b(this);
            int i2 = Math.min(inventorysubcontainer.b(), this.cg.b());
            for (int j2 = 0; j2 < i2; ++j2) {
                ItemStack itemstack = inventorysubcontainer.a(j2);
                if (itemstack.b()) continue;
                this.cg.a(j2, itemstack.n());
            }
        }
        this.cg.a(this);
        this.fR();
    }

    protected void fR() {
        if (!this.s.x) {
            this.d(4, !this.cg.a(0).b());
        }
    }

    @Override
    public void a(IInventory sender) {
        boolean flag = this.d();
        this.fR();
        if (this.S > 20 && !flag && this.d()) {
            this.a(SoundEffects.iJ, 0.5f, 1.0f);
        }
    }

    public double fS() {
        return this.b(GenericAttributes.m);
    }

    @Nullable
    protected SoundEffect fT() {
        return null;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect c(DamageSource source) {
        if (this.R.nextInt(3) == 0) {
            this.fH();
        }
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        if (this.R.nextInt(10) == 0 && !this.ex()) {
            this.fH();
        }
        return null;
    }

    @Nullable
    protected SoundEffect fU() {
        this.fH();
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (!state.c().a()) {
            IBlockData iblockdata1 = this.s.a_(pos.b());
            SoundEffectType soundeffecttype = state.q();
            if (iblockdata1.a(Blocks.cK)) {
                soundeffecttype = iblockdata1.q();
            }
            if (this.bG() && this.cj) {
                ++this.ck;
                if (this.ck > 5 && this.ck % 3 == 0) {
                    this.a(soundeffecttype);
                } else if (this.ck <= 5) {
                    this.a(SoundEffects.iL, soundeffecttype.a() * 0.15f, soundeffecttype.b());
                }
            } else if (soundeffecttype == SoundEffectType.a) {
                this.a(SoundEffects.iL, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            } else {
                this.a(SoundEffects.iK, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            }
        }
    }

    protected void a(SoundEffectType group) {
        this.a(SoundEffects.iF, group.a() * 0.15f, group.b());
    }

    public static AttributeProvider.Builder fV() {
        return EntityInsentient.w().a(GenericAttributes.m).a(GenericAttributes.a, 53.0).a(GenericAttributes.d, 0.225f);
    }

    @Override
    public int ff() {
        return 6;
    }

    public int fW() {
        return this.maxDomestication;
    }

    @Override
    public float ev() {
        return 0.8f;
    }

    @Override
    public int J() {
        return 400;
    }

    public void f(EntityHuman player) {
        if (!this.s.x && (!this.bG() || this.u(player)) && this.fJ()) {
            player.a(this, this.cg);
        }
    }

    public EnumInteractionResult a(EntityHuman player, ItemStack stack) {
        boolean flag = this.b(player, stack);
        if (!player.fs().d) {
            stack.g(1);
        }
        return this.s.x ? EnumInteractionResult.b : (flag ? EnumInteractionResult.a : EnumInteractionResult.d);
    }

    protected boolean b(EntityHuman player, ItemStack item) {
        boolean flag = false;
        float f2 = 0.0f;
        int short0 = 0;
        int b0 = 0;
        if (item.a(Items.ni)) {
            f2 = 2.0f;
            short0 = 20;
            b0 = 3;
        } else if (item.a(Items.oW)) {
            f2 = 1.0f;
            short0 = 30;
            b0 = 3;
        } else if (item.a(Blocks.gO.l())) {
            f2 = 20.0f;
            short0 = 180;
        } else if (item.a(Items.mf)) {
            f2 = 3.0f;
            short0 = 60;
            b0 = 3;
        } else if (item.a(Items.rq)) {
            f2 = 4.0f;
            short0 = 60;
            b0 = 5;
            if (!this.s.x && this.fJ() && this.j() == 0 && !this.fF()) {
                flag = true;
                this.g(player);
            }
        } else if (item.a(Items.nM) || item.a(Items.nN)) {
            f2 = 10.0f;
            short0 = 240;
            b0 = 10;
            if (!this.s.x && this.fJ() && this.j() == 0 && !this.fF()) {
                flag = true;
                this.g(player);
            }
        }
        if (this.ea() < this.em() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.y_() && short0 > 0) {
            this.s.a(Particles.F, this.d(1.0), this.df() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.s.x) {
                this.a_(short0);
            }
            flag = true;
        }
        if (b0 > 0 && (flag || !this.fJ()) && this.fP() < this.fW()) {
            flag = true;
            if (!this.s.x) {
                this.u(b0);
            }
        }
        if (flag) {
            this.t();
            this.a(GameEvent.p, this.cY());
        }
        return flag;
    }

    protected void h(EntityHuman player) {
        this.z(false);
        this.A(false);
        if (!this.s.x) {
            player.o(this.dn());
            player.p(this.do());
            player.k(this);
        }
    }

    @Override
    protected boolean ex() {
        return super.ex() && this.bG() && this.d() || this.fM() || this.fN();
    }

    @Override
    public boolean n(ItemStack stack) {
        return cm.a(stack);
    }

    private void fz() {
        this.cd = 1;
    }

    @Override
    protected void ed() {
        super.ed();
        if (this.cg != null) {
            for (int i2 = 0; i2 < this.cg.b(); ++i2) {
                ItemStack itemstack = this.cg.a(i2);
                if (itemstack.b() || EnchantmentManager.e(itemstack)) continue;
                this.b(itemstack);
            }
        }
    }

    @Override
    public void w_() {
        if (this.R.nextInt(200) == 0) {
            this.fz();
        }
        super.w_();
        if (!this.s.x && this.bl()) {
            if (this.R.nextInt(900) == 0 && this.aN == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.fY()) {
                if (!this.fM() && !this.bG() && this.R.nextInt(300) == 0 && this.s.a_(this.cW().c()).a(Blocks.i)) {
                    this.z(true);
                }
                if (this.fM() && ++this.cv > 50) {
                    this.cv = 0;
                    this.z(false);
                }
            }
            this.fX();
        }
    }

    protected void fX() {
        EntityHorseAbstract entityliving;
        if (this.fO() && this.y_() && !this.fM() && (entityliving = this.s.a(EntityHorseAbstract.class, cl, this, this.dc(), this.de(), this.di(), this.cw().g(16.0))) != null && this.f((Entity)entityliving) > 4.0) {
            this.bP.a((Entity)entityliving, 0);
        }
    }

    public boolean fY() {
        return true;
    }

    @Override
    public void k() {
        super.k();
        if (this.cw > 0 && ++this.cw > 30) {
            this.cw = 0;
            this.d(64, false);
        }
        if ((this.cM() || this.eI()) && this.cx > 0 && ++this.cx > 20) {
            this.cx = 0;
            this.A(false);
        }
        if (this.cd > 0 && ++this.cd > 8) {
            this.cd = 0;
        }
        if (this.ce > 0) {
            ++this.ce;
            if (this.ce > 300) {
                this.ce = 0;
            }
        }
        this.cA = this.cz;
        if (this.fM()) {
            this.cz += (1.0f - this.cz) * 0.4f + 0.05f;
            if (this.cz > 1.0f) {
                this.cz = 1.0f;
            }
        } else {
            this.cz += (0.0f - this.cz) * 0.4f - 0.05f;
            if (this.cz < 0.0f) {
                this.cz = 0.0f;
            }
        }
        this.cC = this.cB;
        if (this.fN()) {
            this.cA = this.cz = 0.0f;
            this.cB += (1.0f - this.cB) * 0.4f + 0.05f;
            if (this.cB > 1.0f) {
                this.cB = 1.0f;
            }
        } else {
            this.cy = false;
            this.cB += (0.8f * this.cB * this.cB * this.cB - this.cB) * 0.6f - 0.05f;
            if (this.cB < 0.0f) {
                this.cB = 0.0f;
            }
        }
        this.cE = this.cD;
        if (this.s(64)) {
            this.cD += (1.0f - this.cD) * 0.7f + 0.05f;
            if (this.cD > 1.0f) {
                this.cD = 1.0f;
            }
        } else {
            this.cD += (0.0f - this.cD) * 0.7f - 0.05f;
            if (this.cD < 0.0f) {
                this.cD = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.s(64);
    }

    private void fB() {
        if (!this.s.x) {
            this.cw = 1;
            this.d(64, true);
        }
    }

    public void z(boolean eatingGrass) {
        this.d(16, eatingGrass);
    }

    public void setForceStanding(boolean standing) {
        this.d(32, standing);
    }

    public void A(boolean angry) {
        if (angry) {
            this.z(false);
        }
        this.d(32, angry);
    }

    private void fH() {
        if (this.cM() || this.eI()) {
            this.cx = 1;
            this.A(true);
        }
    }

    public void fZ() {
        if (!this.fN()) {
            this.fH();
            SoundEffect soundeffect = this.fU();
            if (soundeffect != null) {
                this.a(soundeffect, this.ev(), this.ew());
            }
        }
    }

    public boolean i(EntityHuman player) {
        this.b(player.cm());
        this.w(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.x.a((EntityPlayer)player, this);
        }
        this.s.a((Entity)this, (byte)7);
        return true;
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.bl()) {
            if (this.bG() && this.fg() && this.d()) {
                EntityLiving entityliving = (EntityLiving)this.cE();
                this.o(entityliving.dn());
                this.w = this.dn();
                this.p(entityliving.do() * 0.5f);
                this.a(this.dn(), this.do());
                this.aZ = this.aX = this.dn();
                float f2 = entityliving.bo * 0.5f;
                float f1 = entityliving.bq;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                    this.ck = 0;
                }
                if (this.y && this.ci == 0.0f && this.fN() && !this.cy) {
                    f2 = 0.0f;
                    f1 = 0.0f;
                }
                if (this.ci > 0.0f && !this.fL() && this.y) {
                    double d0 = this.fS() * (double)this.ci * (double)this.aB();
                    double d1 = d0 + this.ez();
                    Vec3D vec3d1 = this.da();
                    this.n(vec3d1.b, d1, vec3d1.d);
                    this.x(true);
                    this.af = true;
                    if (f1 > 0.0f) {
                        float f22 = MathHelper.a(this.dn() * ((float)Math.PI / 180));
                        float f3 = MathHelper.b(this.dn() * ((float)Math.PI / 180));
                        this.g(this.da().b(-0.4f * f22 * this.ci, 0.0, 0.4f * f3 * this.ci));
                    }
                    this.ci = 0.0f;
                }
                this.bb = this.eD() * 0.1f;
                if (this.cM()) {
                    this.r((float)this.b(GenericAttributes.d));
                    super.h(new Vec3D(f2, movementInput.c, f1));
                } else if (entityliving instanceof EntityHuman) {
                    this.g(Vec3D.a);
                }
                if (this.y) {
                    this.ci = 0.0f;
                    this.x(false);
                }
                this.a((EntityLiving)this, false);
                this.ax();
            } else {
                this.bb = 0.02f;
                super.h(movementInput);
            }
        }
    }

    protected void ga() {
        this.a(SoundEffects.iH, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("EatingHaystack", this.fM());
        nbt.a("Bred", this.fO());
        nbt.a("Temper", this.fP());
        nbt.a("Tame", this.fJ());
        if (this.fK() != null) {
            nbt.a("Owner", this.fK());
        }
        nbt.a("Bukkit.MaxDomestication", this.maxDomestication);
        if (!this.cg.a(0).b()) {
            nbt.a("SaddleItem", this.cg.a(0).b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemstack;
        UUID uuid;
        super.a(nbt);
        this.z(nbt.q("EatingHaystack"));
        this.y(nbt.q("Bred"));
        this.t(nbt.h("Temper"));
        this.w(nbt.q("Tame"));
        if (nbt.b("Owner")) {
            uuid = nbt.a("Owner");
        } else {
            String s2 = nbt.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cB(), s2);
        }
        if (uuid != null) {
            this.b(uuid);
        }
        if (nbt.e("Bukkit.MaxDomestication")) {
            this.maxDomestication = nbt.h("Bukkit.MaxDomestication");
        }
        if (nbt.b("SaddleItem", 10) && (itemstack = ItemStack.a(nbt.p("SaddleItem"))).a(Items.lL)) {
            this.cg.a(0, itemstack);
        }
        this.fR();
    }

    @Override
    public boolean a(EntityAnimal other) {
        return false;
    }

    protected boolean gb() {
        return !this.bG() && !this.bF() && this.fJ() && !this.y_() && this.ea() >= this.em() && this.fF();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    protected void a(EntityAgeable mate, EntityHorseAbstract child) {
        double d0 = this.c(GenericAttributes.a) + mate.c(GenericAttributes.a) + (double)this.gc();
        child.a(GenericAttributes.a).a(d0 / 3.0);
        double d1 = this.c(GenericAttributes.m) + mate.c(GenericAttributes.m) + this.gd();
        child.a(GenericAttributes.m).a(d1 / 3.0);
        double d2 = this.c(GenericAttributes.d) + mate.c(GenericAttributes.d) + this.ge();
        child.a(GenericAttributes.d).a(d2 / 3.0);
    }

    @Override
    public boolean fg() {
        return this.cE() instanceof EntityLiving;
    }

    public float z(float tickDelta) {
        return MathHelper.i(tickDelta, this.cA, this.cz);
    }

    public float A(float tickDelta) {
        return MathHelper.i(tickDelta, this.cC, this.cB);
    }

    public float B(float tickDelta) {
        return MathHelper.i(tickDelta, this.cE, this.cD);
    }

    @Override
    public void a(int strength) {
        if (this.d()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.cy = true;
                this.fH();
            }
            this.ci = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.d();
    }

    @Override
    public void b(int height) {
        float power = height >= 90 ? 1.0f : 0.4f + 0.4f * (float)height / 90.0f;
        HorseJumpEvent event = CraftEventFactory.callHorseJumpEvent(this, power);
        if (event.isCancelled()) {
            return;
        }
        this.cy = true;
        this.fH();
        this.ga();
    }

    @Override
    public void b() {
    }

    protected void B(boolean positive) {
        ParticleType particletype = positive ? Particles.H : Particles.U;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.R.nextGaussian() * 0.02;
            double d1 = this.R.nextGaussian() * 0.02;
            double d2 = this.R.nextGaussian() * 0.02;
            this.s.a(particletype, this.d(1.0), this.df() + 0.5, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public void a(byte status) {
        if (status == 7) {
            this.B(true);
        } else if (status == 6) {
            this.B(false);
        } else {
            super.a(status);
        }
    }

    @Override
    public void i(Entity passenger) {
        super.i(passenger);
        if (passenger instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)passenger;
            this.aX = entityinsentient.aX;
        }
        if (this.cC > 0.0f) {
            float f2 = MathHelper.a(this.aX * ((float)Math.PI / 180));
            float f1 = MathHelper.b(this.aX * ((float)Math.PI / 180));
            float f22 = 0.7f * this.cC;
            float f3 = 0.15f * this.cC;
            passenger.e(this.dc() + (double)(f22 * f2), this.de() + this.bq() + passenger.bp() + (double)f3, this.di() - (double)(f22 * f1));
            if (passenger instanceof EntityLiving) {
                ((EntityLiving)passenger).aX = this.aX;
            }
        }
    }

    protected float gc() {
        return 15.0f + (float)this.R.nextInt(8) + (float)this.R.nextInt(9);
    }

    protected double gd() {
        return (double)0.4f + this.R.nextDouble() * 0.2 + this.R.nextDouble() * 0.2 + this.R.nextDouble() * 0.2;
    }

    protected double ge() {
        return ((double)0.45f + this.R.nextDouble() * 0.3 + this.R.nextDouble() * 0.3 + this.R.nextDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean b_() {
        return false;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.95f;
    }

    public boolean gf() {
        return false;
    }

    public boolean gg() {
        return !this.b(EnumItemSlot.e).b();
    }

    public boolean m(ItemStack item) {
        return false;
    }

    private SlotAccess a(final int slot, final Predicate<ItemStack> predicate) {
        return new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityHorseAbstract.this.cg.a(slot);
            }

            @Override
            public boolean a(ItemStack stack) {
                if (!predicate.test(stack)) {
                    return false;
                }
                EntityHorseAbstract.this.cg.a(slot, stack);
                EntityHorseAbstract.this.fR();
                return true;
            }
        };
    }

    @Override
    public SlotAccess k(int mappedIndex) {
        int k2;
        int j2 = mappedIndex - 400;
        if (j2 >= 0 && j2 < 2 && j2 < this.cg.b()) {
            if (j2 == 0) {
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || itemstack.a(Items.lL));
            }
            if (j2 == 1) {
                if (!this.gf()) {
                    return SlotAccess.a;
                }
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || this.m((ItemStack)itemstack));
            }
        }
        return (k2 = mappedIndex - 500 + 2) >= 2 && k2 < this.cg.b() ? SlotAccess.a(this.cg, k2) : super.k(mappedIndex);
    }

    @Override
    @Nullable
    public Entity cE() {
        return this.cG();
    }

    @Nullable
    private Vec3D a(Vec3D offset, EntityLiving passenger) {
        double d0 = this.dc() + offset.b;
        double d1 = this.cw().b;
        double d2 = this.di() + offset.d;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose entitypose : passenger.eZ()) {
            blockposition_mutableblockposition.c(d0, d1, d2);
            double d3 = this.cw().e + 0.75;
            do {
                Vec3D vec3d1;
                AxisAlignedBB axisalignedbb;
                double d4 = this.s.i(blockposition_mutableblockposition);
                if ((double)blockposition_mutableblockposition.v() + d4 > d3) continue block0;
                if (DismountUtil.a(d4) && DismountUtil.a(this.s, passenger, (axisalignedbb = passenger.f(entitypose)).c(vec3d1 = new Vec3D(d0, (double)blockposition_mutableblockposition.v() + d4, d2)))) {
                    passenger.b(entitypose);
                    return vec3d1;
                }
                blockposition_mutableblockposition.c(EnumDirection.b);
            } while (!((double)blockposition_mutableblockposition.v() >= d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = EntityHorseAbstract.a(this.cT(), (double)passenger.cT(), this.dn() + (passenger.eL() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D vec3d1 = this.a(vec3d, passenger);
        if (vec3d1 != null) {
            return vec3d1;
        }
        Vec3D vec3d2 = EntityHorseAbstract.a(this.cT(), (double)passenger.cT(), this.dn() + (passenger.eL() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D vec3d3 = this.a(vec3d2, passenger);
        return vec3d3 != null ? vec3d3 : this.cV();
    }

    protected void q() {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(0.2f);
        }
        this.q();
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean b(IInventory inventory) {
        return this.cg != inventory;
    }
}

