/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.animal.horse.HorseStyle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemHorseArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;

public class EntityHorse
extends EntityHorseAbstract {
    private static final UUID bV = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataWatcherObject<Integer> cl = DataWatcher.a(EntityHorse.class, DataWatcherRegistry.b);

    public EntityHorse(EntityTypes<? extends EntityHorse> type, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, world);
    }

    @Override
    @Override
    protected void q() {
        this.a(GenericAttributes.a).a(this.gc());
        this.a(GenericAttributes.d).a(this.ge());
        this.a(GenericAttributes.m).a(this.gd());
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
        this.Y.a(cl, 0);
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.fH());
        if (!this.cg.a(1).b()) {
            nbt.a("ArmorItem", this.cg.a(1).b(new NBTTagCompound()));
        }
    }

    public ItemStack t() {
        return this.b(EnumItemSlot.e);
    }

    private void o(ItemStack stack) {
        this.a(EnumItemSlot.e, stack);
        this.a(EnumItemSlot.e, 0.0f);
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemStack;
        super.a(nbt);
        this.v(nbt.h("Variant"));
        if (nbt.b("ArmorItem", 10) && !(itemStack = ItemStack.a(nbt.p("ArmorItem"))).b() && this.m(itemStack)) {
            this.cg.a(1, itemStack);
        }
        this.fR();
    }

    private void v(int variant) {
        this.Y.b(cl, variant);
    }

    private int fH() {
        return this.Y.a(cl);
    }

    public void a(HorseColor color, HorseStyle marking) {
        this.v(color.a() & 0xFF | marking.a() << 8 & 0xFF00);
    }

    public HorseColor fz() {
        return HorseColor.a(this.fH() & 0xFF);
    }

    public HorseStyle fB() {
        return HorseStyle.a((this.fH() & 0xFF00) >> 8);
    }

    @Override
    @Override
    protected void fR() {
        if (this.s.x) {
            return;
        }
        super.fR();
        this.p(this.cg.a(1));
        this.a(EnumItemSlot.e, 0.0f);
    }

    private void p(ItemStack stack) {
        this.o(stack);
        if (!this.s.x) {
            int i2;
            this.a(GenericAttributes.i).b(bV);
            if (this.m(stack) && (i2 = ((ItemHorseArmor)stack.c()).j()) != 0) {
                this.a(GenericAttributes.i).b(new AttributeModifier(bV, "Horse armor bonus", (double)i2, AttributeModifier.Operation.a));
            }
        }
    }

    @Override
    @Override
    public void a(IInventory sender) {
        ItemStack itemStack = this.t();
        super.a(sender);
        ItemStack itemStack2 = this.t();
        if (this.S > 20 && this.m(itemStack2) && itemStack != itemStack2) {
            this.a(SoundEffects.iB, 0.5f, 1.0f);
        }
    }

    @Override
    @Override
    protected void a(SoundEffectType group) {
        super.a(group);
        if (this.R.nextInt(10) == 0) {
            this.a(SoundEffects.iC, group.a() * 0.6f, group.b());
        }
    }

    @Override
    @Override
    protected SoundEffect r() {
        super.r();
        return SoundEffects.iz;
    }

    @Override
    @Override
    public SoundEffect x_() {
        super.x_();
        return SoundEffects.iD;
    }

    @Override
    @Nullable
    @Override
    protected SoundEffect fT() {
        return SoundEffects.iE;
    }

    @Override
    @Override
    protected SoundEffect c(DamageSource source) {
        super.c(source);
        return SoundEffects.iG;
    }

    @Override
    @Override
    protected SoundEffect fU() {
        super.fU();
        return SoundEffects.iA;
    }

    @Override
    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemStack = player.b(hand);
        if (!this.y_()) {
            if (this.fJ() && player.fg()) {
                this.f(player);
                return EnumInteractionResult.a(this.s.x);
            }
            if (this.bG()) {
                return super.b(player, hand);
            }
        }
        if (!itemStack.b()) {
            boolean bl;
            if (this.n(itemStack)) {
                return this.a(player, itemStack);
            }
            EnumInteractionResult interactionResult = itemStack.a(player, (EntityLiving)this, hand);
            if (interactionResult.a()) {
                return interactionResult;
            }
            if (!this.fJ()) {
                this.fZ();
                return EnumInteractionResult.a(this.s.x);
            }
            boolean bl2 = bl = !this.y_() && !this.d() && itemStack.a(Items.lL);
            if (this.m(itemStack) || bl) {
                this.f(player);
                return EnumInteractionResult.a(this.s.x);
            }
        }
        if (this.y_()) {
            return super.b(player, hand);
        }
        this.h(player);
        return EnumInteractionResult.a(this.s.x);
    }

    @Override
    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (other instanceof EntityHorseDonkey || other instanceof EntityHorse) {
            return this.gb() && ((EntityHorseAbstract)other).gb();
        }
        return false;
    }

    @Override
    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        EntityHorseAbstract abstractHorse2;
        if (entity instanceof EntityHorseDonkey) {
            EntityHorseAbstract abstractHorse = EntityTypes.ag.a(world);
        } else {
            HorseStyle markings3;
            HorseColor variant3;
            EntityHorse horse = (EntityHorse)entity;
            abstractHorse2 = EntityTypes.M.a(world);
            int i2 = this.R.nextInt(9);
            if (i2 < 4) {
                HorseColor variant = this.fz();
            } else if (i2 < 8) {
                HorseColor variant2 = horse.fz();
            } else {
                variant3 = SystemUtils.a(HorseColor.values(), this.R);
            }
            int j2 = this.R.nextInt(5);
            if (j2 < 2) {
                HorseStyle markings = this.fB();
            } else if (j2 < 4) {
                HorseStyle markings2 = horse.fB();
            } else {
                markings3 = SystemUtils.a(HorseStyle.values(), this.R);
            }
            ((EntityHorse)abstractHorse2).a(variant3, markings3);
        }
        this.a(entity, abstractHorse2);
        return abstractHorse2;
    }

    @Override
    @Override
    public boolean gf() {
        return true;
    }

    @Override
    @Override
    public boolean m(ItemStack item) {
        return item.c() instanceof ItemHorseArmor;
    }

    @Override
    @Nullable
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        HorseColor variant2;
        if (entityData instanceof a) {
            HorseColor variant = ((a)entityData).a;
        } else {
            variant2 = SystemUtils.a(HorseColor.values(), this.R);
            entityData = new a(variant2);
        }
        this.a(variant2, SystemUtils.a(HorseStyle.values(), this.R));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static class a
    extends EntityAgeable.a {
        public final HorseColor a;

        public a(HorseColor color) {
            super(true);
            this.a = color;
        }
    }
}

