/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bV = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cb = 2;
    private static final int cc = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bW = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.n, SensorType.f, SensorType.q);
    protected static final ImmutableList<MemoryModuleType<?>> bY = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.ap, MemoryModuleType.r, MemoryModuleType.Q, MemoryModuleType.R, MemoryModuleType.N, MemoryModuleType.J, MemoryModuleType.O, (Object[])new MemoryModuleType[]{MemoryModuleType.P, MemoryModuleType.T, MemoryModuleType.U});
    public static final int bZ = 10;
    public static final double ca = 0.02;
    private static final DataWatcherObject<Boolean> cd = DataWatcher.a(Goat.class, DataWatcherRegistry.i);
    private boolean ce;
    private int cf;

    public Goat(EntityTypes<? extends Goat> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.D().d(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    protected BehaviorController.b<Goat> dv() {
        return BehaviorController.a(bY, bW);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.dv().a(dynamic));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.w().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.2f).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected void n() {
        if (this.y_()) {
            this.a(GenericAttributes.f).a(1.0);
        } else {
            this.a(GenericAttributes.f).a(2.0);
        }
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return super.d(fallDistance, damageMultiplier) - 10;
    }

    @Override
    protected SoundEffect r() {
        return this.fz() ? SoundEffects.hA : SoundEffects.hs;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return this.fz() ? SoundEffects.hD : SoundEffects.hv;
    }

    @Override
    public SoundEffect x_() {
        return this.fz() ? SoundEffects.hB : SoundEffects.ht;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.hI, 0.15f, 1.0f);
    }

    protected SoundEffect t() {
        return this.fz() ? SoundEffects.hF : SoundEffects.hx;
    }

    public Goat b(WorldServer world, EntityAgeable entity) {
        Goat goat = EntityTypes.J.a(world);
        if (goat != null) {
            GoatAi.a(goat);
            boolean flag = entity instanceof Goat && ((Goat)entity).fz();
            goat.v(flag || world.r_().nextDouble() < 0.02);
        }
        return goat;
    }

    public BehaviorController<Goat> du() {
        return super.du();
    }

    @Override
    protected void R() {
        this.s.ab().a("goatBrain");
        this.du().a((WorldServer)this.s, this);
        this.s.ab().c();
        this.s.ab().a("goatActivityUpdate");
        GoatAi.b(this);
        this.s.ab().c();
        super.R();
    }

    @Override
    public int U() {
        return 15;
    }

    @Override
    public void l(float headYaw) {
        int i2 = this.U();
        float f1 = MathHelper.c(this.aX, headYaw);
        float f2 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.l(this.aX + f2);
    }

    @Override
    public SoundEffect e(ItemStack stack) {
        return this.fz() ? SoundEffects.hC : SoundEffects.hu;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.nW) && !this.y_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.s, player, this.cW(), this.cW(), null, itemstack, Items.oc, hand);
            if (event.isCancelled()) {
                return EnumInteractionResult.d;
            }
            player.a(this.t(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemstack1);
            return EnumInteractionResult.a(this.s.x);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && this.n(itemstack)) {
            this.s.a((EntityHuman)null, this, this.e(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.s.v, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        GoatAi.a(this);
        this.v(world.r_().nextDouble() < 0.02);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void Q() {
        super.Q();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.g ? bV.a(this.dF()) : super.a(pose);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsScreamingGoat", this.fz());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.v(nbt.q("IsScreamingGoat"));
    }

    @Override
    public void a(byte status) {
        if (status == 58) {
            this.ce = true;
        } else if (status == 59) {
            this.ce = false;
        } else {
            super.a(status);
        }
    }

    @Override
    public void w_() {
        this.cf = this.ce ? ++this.cf : (this.cf -= 2);
        this.cf = MathHelper.a(this.cf, 0, 20);
        super.w_();
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(cd, false);
    }

    public boolean fz() {
        return this.Y.a(cd);
    }

    public void v(boolean screaming) {
        this.Y.b(cd, screaming);
    }

    public float fA() {
        return (float)this.cf / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.bu) && Goat.a(world, pos);
    }

    public void ram(EntityLiving entity) {
        BehaviorController<Goat> brain = this.du();
        brain.a(MemoryModuleType.U, entity.cV());
        brain.b(MemoryModuleType.T);
        brain.b(MemoryModuleType.r);
        brain.b(MemoryModuleType.N);
        brain.a(Activity.r);
    }
}

