/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.math.Vector3fa;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.LerpingModel;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.slf4j.Logger;

public class Axolotl
extends EntityAnimal
implements LerpingModel,
Bucketable {
    private static final Logger cc = LogUtils.getLogger();
    public static final int bV = 200;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> bW = ImmutableList.of(SensorType.c, SensorType.n, SensorType.f, SensorType.o, SensorType.p);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bY = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.J, (Object[])new MemoryModuleType[]{MemoryModuleType.y, MemoryModuleType.M, MemoryModuleType.B, MemoryModuleType.N, MemoryModuleType.O, MemoryModuleType.P, MemoryModuleType.S});
    private static final DataWatcherObject<Integer> cd = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> ce = DataWatcher.a(Axolotl.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(Axolotl.class, DataWatcherRegistry.i);
    public static final double bZ = 20.0;
    public static final int ca = 1200;
    private static final int cg = 6000;
    public static final String cb = "Variant";
    private static final int ch = 1800;
    private static final int ci = 2400;
    private final Map<String, Vector3fa> cj = Maps.newHashMap();
    private static final int ck = 100;

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    public Axolotl(EntityTypes<? extends Axolotl> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
        this.bN = new c(this);
        this.bM = new b(this, 20);
        this.P = 1.0f;
    }

    @Override
    public Map<String, Vector3fa> a() {
        return this.cj;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(cd, 0);
        this.Y.a(ce, false);
        this.Y.a(cf, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(cb, this.fA().a());
        nbt.a("FromBucket", this.q());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Variant.f[nbt.h(cb)]);
        this.v(nbt.q("FromBucket"));
    }

    @Override
    public void K() {
        if (!this.fB()) {
            super.K();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        boolean flag = false;
        if (spawnReason == EnumMobSpawn.l) {
            return entityData;
        }
        if (entityData instanceof a) {
            if (((a)entityData).a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new a(Variant.a(this.s.v), Variant.a(this.s.v));
        }
        this.a(((a)entityData).a(this.s.v));
        if (flag) {
            this.b_(-24000);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void an() {
        int i2 = this.bY();
        super.an();
        if (!this.fs()) {
            this.s(i2);
        }
    }

    protected void s(int air) {
        if (this.bl() && !this.aS()) {
            this.i(air - 1);
            if (this.bY() == -20) {
                this.i(0);
                this.a(DamageSource.t, 2.0f);
            }
        } else {
            this.i(this.bX());
        }
    }

    public void fz() {
        int i2 = this.bY() + 1800;
        this.i(Math.min(i2, this.bX()));
    }

    @Override
    public int bX() {
        return this.maxAirTicks;
    }

    public Variant fA() {
        return Variant.f[this.Y.a(cd)];
    }

    public void a(Variant variant) {
        this.Y.b(cd, variant.a());
    }

    private static boolean a(Random random) {
        return random.nextInt(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    public boolean dx() {
        return true;
    }

    @Override
    public boolean cp() {
        return false;
    }

    @Override
    public EnumMonsterType er() {
        return EnumMonsterType.e;
    }

    public void w(boolean playingDead) {
        this.Y.b(ce, playingDead);
    }

    public boolean fB() {
        return this.Y.a(ce);
    }

    @Override
    public boolean q() {
        return this.Y.a(cf);
    }

    @Override
    public void v(boolean fromBucket) {
        this.Y.b(cf, fromBucket);
        this.setPersistenceRequired(fromBucket || this.fj());
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        Axolotl axolotl = EntityTypes.e.a(world);
        if (axolotl != null) {
            Variant axolotl_variant = Axolotl.a(this.R) ? Variant.b(this.R) : (this.R.nextBoolean() ? this.fA() : ((Axolotl)entity).fA());
            axolotl.a(axolotl_variant);
            axolotl.fh();
        }
        return axolotl;
    }

    @Override
    public double i(EntityLiving target) {
        return 1.5 + (double)target.cT() * 2.0;
    }

    @Override
    public boolean n(ItemStack stack) {
        return stack.a(TagsItem.aq);
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    @Override
    protected void R() {
        this.s.ab().a("axolotlBrain");
        this.du().a((WorldServer)this.s, this);
        this.s.ab().c();
        this.s.ab().a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        this.s.ab().c();
        if (!this.fs()) {
            Optional<Integer> optional = this.du().c(MemoryModuleType.M);
            this.w(optional.isPresent() && optional.get() > 0);
        }
    }

    public static AttributeProvider.Builder fH() {
        return EntityInsentient.w().a(GenericAttributes.a, 14.0).a(GenericAttributes.d, 1.0).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new d(this, world);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag = target.a(DamageSource.c(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
            this.a(SoundEffects.an, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        float f1 = this.ea();
        if (!(this.s.x || this.fs() || this.s.v.nextInt(3) != 0 || !((float)this.s.v.nextInt(3) < amount) && !(f1 / this.em() < 0.5f) || !(amount < f1) || !this.aQ() || source.l() == null && source.k() == null || this.fB())) {
            this.bD.a(MemoryModuleType.M, Integer.valueOf(200));
        }
        return super.a(source, amount);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.655f;
    }

    @Override
    public int T() {
        return 1;
    }

    @Override
    public int U() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void m(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        NBTTagCompound nbttagcompound = stack.u();
        nbttagcompound.a(cb, this.fA().a());
        nbttagcompound.a("Age", this.j());
        BehaviorController<Axolotl> behaviorcontroller = this.du();
        if (behaviorcontroller.a(MemoryModuleType.S)) {
            nbttagcompound.a("HuntingCooldown", behaviorcontroller.d(MemoryModuleType.S));
        }
    }

    @Override
    public void c(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
        int i2 = nbt.h(cb);
        if (i2 >= 0 && i2 < Variant.f.length) {
            this.a(Variant.f[i2]);
        } else {
            cc.error("Invalid variant: {}", (Object)i2);
        }
        if (nbt.e("Age")) {
            this.b_(nbt.h("Age"));
        }
        if (nbt.e("HuntingCooldown")) {
            this.du().a(MemoryModuleType.S, true, nbt.i("HuntingCooldown"));
        }
    }

    @Override
    public ItemStack b() {
        return new ItemStack(Items.oh);
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.bZ;
    }

    @Override
    public boolean dT() {
        return !this.fB() && super.dT();
    }

    public static void a(Axolotl axolotl) {
        Optional<EntityLiving> optional = axolotl.du().c(MemoryModuleType.o);
        if (optional.isPresent()) {
            Entity entity;
            DamageSource damagesource;
            World world = axolotl.s;
            EntityLiving entityliving = optional.get();
            if (entityliving.eb() && (damagesource = entityliving.ec()) != null && (entity = damagesource.l()) != null && entity.ad() == EntityTypes.bi) {
                EntityHuman entityhuman = (EntityHuman)entity;
                List<EntityHuman> list = world.a(EntityHuman.class, axolotl.cw().g(20.0));
                if (list.contains(entityhuman)) {
                    axolotl.f(entityhuman);
                }
            }
        }
    }

    public void f(EntityHuman player) {
        int i2;
        MobEffect mobeffect = player.b(MobEffects.j);
        int n2 = i2 = mobeffect != null ? mobeffect.b() : 0;
        if (i2 < 2400) {
            i2 = Math.min(2400, 100 + i2);
            player.addEffect(new MobEffect(MobEffects.j, i2, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        player.d(MobEffects.d);
    }

    @Override
    public boolean O() {
        return super.O() || this.q();
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.ap;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.ao;
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        return this.aQ() ? SoundEffects.ar : SoundEffects.aq;
    }

    @Override
    protected SoundEffect aG() {
        return SoundEffects.as;
    }

    @Override
    protected SoundEffect aF() {
        return SoundEffects.at;
    }

    protected BehaviorController.b<Axolotl> dv() {
        return BehaviorController.a(bY, bW);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.dv().a(dynamic));
    }

    public BehaviorController<Axolotl> du() {
        return super.du();
    }

    @Override
    protected void Q() {
        super.Q();
        PacketDebug.a(this);
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.eI() && this.aQ()) {
            this.a(this.eD(), movementInput);
            this.a(EnumMoveType.a, this.da());
            this.g(this.da().a(0.9));
        } else {
            super.h(movementInput);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(Items.og)) {
            player.a(hand, new ItemStack(Items.nX));
        } else {
            super.a(player, hand, stack);
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return true;
    }

    public static boolean a(EntityTypes<? extends EntityLiving> type, WorldAccess world, EnumMobSpawn reason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.bt);
    }

    private static class c
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public c(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.fB()) {
                super.a();
            }
        }
    }

    private class b
    extends SmoothSwimmingLookControl {
        public b(Axolotl axolotl, int i2) {
            super(axolotl, i2);
        }

        @Override
        public void a() {
            if (!Axolotl.this.fB()) {
                super.a();
            }
        }
    }

    public static enum Variant {
        a(0, "lucy", true),
        b(1, "wild", true),
        c(2, "gold", true),
        d(3, "cyan", true),
        e(4, "blue", false);

        public static final Variant[] f;
        private final int g;
        private final String h;
        private final boolean i;

        private Variant(int i2, String s2, boolean flag) {
            this.g = i2;
            this.h = s2;
            this.i = flag;
        }

        public int a() {
            return this.g;
        }

        public String b() {
            return this.h;
        }

        public static Variant a(Random random) {
            return Variant.a(random, true);
        }

        public static Variant b(Random random) {
            return Variant.a(random, false);
        }

        private static Variant a(Random random, boolean natural) {
            Variant[] aaxolotl_variant = (Variant[])Arrays.stream(f).filter(axolotl_variant -> axolotl_variant.i == natural).toArray(Variant[]::new);
            return (Variant)((Object)SystemUtils.a((Object[])aaxolotl_variant, random));
        }

        static {
            f = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::a)).toArray(Variant[]::new);
        }
    }

    public static class a
    extends EntityAgeable.a {
        public final Variant[] a;

        public a(Variant ... variants) {
            super(false);
            this.a = variants;
        }

        public Variant a(Random random) {
            return this.a[random.nextInt(this.a.length)];
        }
    }

    private static class d
    extends NavigationGuardian {
        d(Axolotl axolotl, World world) {
            super(axolotl, world);
        }

        @Override
        protected boolean a() {
            return true;
        }

        @Override
        protected Pathfinder a(int range) {
            this.o = new AmphibiousNodeEvaluator(false);
            return new Pathfinder(this.o, range);
        }

        @Override
        public boolean a(BlockPosition pos) {
            return !this.b.a_(pos.c()).g();
        }
    }
}

