/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;

public class EntityTropicalFish
extends EntityFishSchool {
    public static final String b = "BucketVariantTag";
    private static final DataWatcherObject<Integer> bV = DataWatcher.a(EntityTropicalFish.class, DataWatcherRegistry.b);
    public static final int c = 0;
    public static final int d = 1;
    private static final int bW = 2;
    private static final MinecraftKey[] bX = new MinecraftKey[]{new MinecraftKey("textures/entity/fish/tropical_a.png"), new MinecraftKey("textures/entity/fish/tropical_b.png")};
    private static final MinecraftKey[] bY = new MinecraftKey[]{new MinecraftKey("textures/entity/fish/tropical_a_pattern_1.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_2.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_3.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_4.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_5.png"), new MinecraftKey("textures/entity/fish/tropical_a_pattern_6.png")};
    private static final MinecraftKey[] bZ = new MinecraftKey[]{new MinecraftKey("textures/entity/fish/tropical_b_pattern_1.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_2.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_3.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_4.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_5.png"), new MinecraftKey("textures/entity/fish/tropical_b_pattern_6.png")};
    private static final int ca = 6;
    private static final int cb = 15;
    public static final int[] e = new int[]{EntityTropicalFish.a(Variant.h, EnumColor.b, EnumColor.h), EntityTropicalFish.a(Variant.g, EnumColor.h, EnumColor.h), EntityTropicalFish.a(Variant.g, EnumColor.h, EnumColor.l), EntityTropicalFish.a(Variant.l, EnumColor.a, EnumColor.h), EntityTropicalFish.a(Variant.b, EnumColor.l, EnumColor.h), EntityTropicalFish.a(Variant.a, EnumColor.b, EnumColor.a), EntityTropicalFish.a(Variant.f, EnumColor.g, EnumColor.d), EntityTropicalFish.a(Variant.j, EnumColor.k, EnumColor.e), EntityTropicalFish.a(Variant.l, EnumColor.a, EnumColor.o), EntityTropicalFish.a(Variant.f, EnumColor.a, EnumColor.e), EntityTropicalFish.a(Variant.i, EnumColor.a, EnumColor.h), EntityTropicalFish.a(Variant.l, EnumColor.a, EnumColor.b), EntityTropicalFish.a(Variant.d, EnumColor.j, EnumColor.g), EntityTropicalFish.a(Variant.e, EnumColor.f, EnumColor.d), EntityTropicalFish.a(Variant.k, EnumColor.o, EnumColor.a), EntityTropicalFish.a(Variant.c, EnumColor.h, EnumColor.o), EntityTropicalFish.a(Variant.j, EnumColor.o, EnumColor.a), EntityTropicalFish.a(Variant.g, EnumColor.a, EnumColor.e), EntityTropicalFish.a(Variant.a, EnumColor.o, EnumColor.a), EntityTropicalFish.a(Variant.b, EnumColor.h, EnumColor.a), EntityTropicalFish.a(Variant.d, EnumColor.j, EnumColor.e), EntityTropicalFish.a(Variant.g, EnumColor.e, EnumColor.e)};
    private boolean cc = true;

    private static int a(Variant variety, EnumColor baseColor, EnumColor patternColor) {
        return variety.a() & 0xFF | (variety.b() & 0xFF) << 8 | (baseColor.a() & 0xFF) << 16 | (patternColor.a() & 0xFF) << 24;
    }

    public EntityTropicalFish(EntityTypes<? extends EntityTropicalFish> type, World world) {
        super((EntityTypes<? extends EntityFishSchool>)type, world);
    }

    public static String b(int variant) {
        return "entity.minecraft.tropical_fish.predefined." + variant;
    }

    public static EnumColor r(int variant) {
        return EnumColor.a(EntityTropicalFish.w(variant));
    }

    public static EnumColor s(int variant) {
        return EnumColor.a(EntityTropicalFish.x(variant));
    }

    public static String t(int variant) {
        int i2 = EntityTropicalFish.v(variant);
        int j2 = EntityTropicalFish.y(variant);
        return "entity.minecraft.tropical_fish.type." + Variant.a(i2, j2);
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bV, 0);
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.fI());
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.u(nbt.h("Variant"));
    }

    public void u(int variant) {
        this.Y.b(bV, variant);
    }

    @Override
    @Override
    public boolean c(int count) {
        return !this.cc;
    }

    public int fI() {
        return this.Y.a(bV);
    }

    @Override
    @Override
    public void m(ItemStack stack) {
        super.m(stack);
        NBTTagCompound compoundTag = stack.u();
        compoundTag.a(b, this.fI());
    }

    @Override
    @Override
    public ItemStack b() {
        return new ItemStack(Items.og);
    }

    @Override
    @Override
    protected SoundEffect r() {
        return SoundEffects.tj;
    }

    @Override
    @Override
    public SoundEffect x_() {
        return SoundEffects.tk;
    }

    @Override
    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.tm;
    }

    @Override
    @Override
    protected SoundEffect fA() {
        return SoundEffects.tl;
    }

    private static int w(int variant) {
        return (variant & 0xFF0000) >> 16;
    }

    public float[] fJ() {
        return EnumColor.a(EntityTropicalFish.w(this.fI())).d();
    }

    private static int x(int variant) {
        return (variant & 0xFF000000) >> 24;
    }

    public float[] fK() {
        return EnumColor.a(EntityTropicalFish.x(this.fI())).d();
    }

    public static int v(int variant) {
        return Math.min(variant & 0xFF, 1);
    }

    public int fL() {
        return EntityTropicalFish.v(this.fI());
    }

    private static int y(int variant) {
        return Math.min((variant & 0xFF00) >> 8, 5);
    }

    public MinecraftKey fM() {
        if (EntityTropicalFish.v(this.fI()) == 0) {
            return bY[EntityTropicalFish.y(this.fI())];
        }
        return bZ[EntityTropicalFish.y(this.fI())];
    }

    public MinecraftKey fN() {
        return bX[EntityTropicalFish.v(this.fI())];
    }

    @Override
    @Nullable
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        int u2;
        int t2;
        int s2;
        int r2;
        entityData = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        if (spawnReason == EnumMobSpawn.l && entityNbt != null && entityNbt.b(b, 3)) {
            this.u(entityNbt.h(b));
            return entityData;
        }
        if (entityData instanceof b) {
            b tropicalFishGroupData = (b)entityData;
            int i2 = tropicalFishGroupData.b;
            int j2 = tropicalFishGroupData.c;
            int k2 = tropicalFishGroupData.d;
            int l2 = tropicalFishGroupData.e;
        } else if ((double)this.R.nextFloat() < 0.9) {
            int m2 = SystemUtils.a(e, this.R);
            int n2 = m2 & 0xFF;
            int o2 = (m2 & 0xFF00) >> 8;
            int p2 = (m2 & 0xFF0000) >> 16;
            int q2 = (m2 & 0xFF000000) >> 24;
            entityData = new b(this, n2, o2, p2, q2);
        } else {
            this.cc = false;
            r2 = this.R.nextInt(2);
            s2 = this.R.nextInt(6);
            t2 = this.R.nextInt(15);
            u2 = this.R.nextInt(15);
        }
        this.u(r2 | s2 << 8 | t2 << 16 | u2 << 24);
        return entityData;
    }

    public static boolean b(EntityTypes<EntityTropicalFish> type, GeneratorAccess world, EnumMobSpawn reason, BlockPosition pos, Random random) {
        return world.b_(pos.c()).a(TagsFluid.a) && world.a_(pos.b()).a(Blocks.A) && (world.v(pos).a(Biomes.Y) || EntityWaterAnimal.c(type, world, reason, pos, random));
    }

    static final class Variant
    extends Enum<Variant> {
        public static final /* enum */ Variant a = new Variant(0, 0);
        public static final /* enum */ Variant b = new Variant(0, 1);
        public static final /* enum */ Variant c = new Variant(0, 2);
        public static final /* enum */ Variant d = new Variant(0, 3);
        public static final /* enum */ Variant e = new Variant(0, 4);
        public static final /* enum */ Variant f = new Variant(0, 5);
        public static final /* enum */ Variant g = new Variant(1, 0);
        public static final /* enum */ Variant h = new Variant(1, 1);
        public static final /* enum */ Variant i = new Variant(1, 2);
        public static final /* enum */ Variant j = new Variant(1, 3);
        public static final /* enum */ Variant k = new Variant(1, 4);
        public static final /* enum */ Variant l = new Variant(1, 5);
        private final int m;
        private final int n;
        private static final Variant[] o;
        private static final /* synthetic */ Variant[] p;

        public static Variant[] values() {
            return (Variant[])p.clone();
        }

        public static Variant valueOf(String string) {
            return Enum.valueOf(Variant.class, string);
        }

        private Variant(int shape, int pattern) {
            this.m = shape;
            this.n = pattern;
        }

        public int a() {
            return this.m;
        }

        public int b() {
            return this.n;
        }

        public static String a(int shape, int pattern) {
            return o[pattern + 6 * shape].c();
        }

        public String c() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private static /* synthetic */ Variant[] d() {
            return new Variant[]{a, b, c, d, e, f, g, h, i, j, k, l};
        }

        static {
            p = Variant.d();
            o = Variant.values();
        }
    }

    static class b
    extends EntityFishSchool.a {
        final int b;
        final int c;
        final int d;
        final int e;

        b(EntityTropicalFish leader, int shape, int pattern, int baseColor, int patternColor) {
            super(leader);
            this.b = shape;
            this.c = pattern;
            this.d = baseColor;
            this.e = patternColor;
        }
    }
}

