/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.inventory.InventoryView;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int bV = 40;
    private static final DataWatcherObject<Byte> bW = DataWatcher.a(EntitySheep.class, DataWatcherRegistry.a);
    private static final Map<EnumColor, IMaterial> bY = SystemUtils.a(Maps.newEnumMap(EnumColor.class), (T enummap) -> {
        enummap.put(EnumColor.a, Blocks.be);
        enummap.put(EnumColor.b, Blocks.bf);
        enummap.put(EnumColor.c, Blocks.bg);
        enummap.put(EnumColor.d, Blocks.bh);
        enummap.put(EnumColor.e, Blocks.bi);
        enummap.put(EnumColor.f, Blocks.bj);
        enummap.put(EnumColor.g, Blocks.bk);
        enummap.put(EnumColor.h, Blocks.bl);
        enummap.put(EnumColor.i, Blocks.bm);
        enummap.put(EnumColor.j, Blocks.bn);
        enummap.put(EnumColor.k, Blocks.bo);
        enummap.put(EnumColor.l, Blocks.bp);
        enummap.put(EnumColor.m, Blocks.bq);
        enummap.put(EnumColor.n, Blocks.br);
        enummap.put(EnumColor.o, Blocks.bs);
        enummap.put(EnumColor.p, Blocks.bt);
    });
    private static final Map<EnumColor, float[]> bZ = Maps.newEnumMap(Arrays.stream(EnumColor.values()).collect(Collectors.toMap(enumcolor -> enumcolor, EntitySheep::c)));
    private int ca;
    private PathfinderGoalEatTile cb;

    private static float[] c(EnumColor color) {
        if (color == EnumColor.a) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = color.d();
        float f2 = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public static float[] a(EnumColor dyeColor) {
        return bZ.get(dyeColor);
    }

    public EntitySheep(EntityTypes<? extends EntitySheep> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    protected void u() {
        this.cb = new PathfinderGoalEatTile(this);
        this.bQ.a(0, new PathfinderGoalFloat(this));
        this.bQ.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bQ.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bQ.a(3, new PathfinderGoalTempt(this, 1.1, RecipeItemStack.a(Items.ni), false));
        this.bQ.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bQ.a(5, this.cb);
        this.bQ.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bQ.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bQ.a(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    protected void R() {
        this.ca = this.cb.h();
        super.R();
    }

    @Override
    public void w_() {
        if (this.s.x) {
            this.ca = Math.max(0, this.ca - 1);
        }
        super.w_();
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.w().a(GenericAttributes.a, 8.0).a(GenericAttributes.d, 0.23f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bW, (byte)0);
    }

    @Override
    public MinecraftKey N() {
        if (this.fz()) {
            return this.ad().j();
        }
        switch (this.t()) {
            default: {
                return LootTables.Q;
            }
            case b: {
                return LootTables.R;
            }
            case c: {
                return LootTables.S;
            }
            case d: {
                return LootTables.T;
            }
            case e: {
                return LootTables.U;
            }
            case f: {
                return LootTables.V;
            }
            case g: {
                return LootTables.W;
            }
            case h: {
                return LootTables.X;
            }
            case i: {
                return LootTables.Y;
            }
            case j: {
                return LootTables.Z;
            }
            case k: {
                return LootTables.aa;
            }
            case l: {
                return LootTables.ab;
            }
            case m: {
                return LootTables.ac;
            }
            case n: {
                return LootTables.ad;
            }
            case o: {
                return LootTables.ae;
            }
            case p: 
        }
        return LootTables.af;
    }

    @Override
    public void a(byte status) {
        if (status == 10) {
            this.ca = 40;
        } else {
            super.a(status);
        }
    }

    public float z(float delta) {
        return this.ca <= 0 ? 0.0f : (this.ca >= 4 && this.ca <= 36 ? 1.0f : (this.ca < 4 ? ((float)this.ca - delta) / 4.0f : -((float)(this.ca - 40) - delta) / 4.0f));
    }

    public float A(float delta) {
        if (this.ca > 4 && this.ca <= 36) {
            float f1 = ((float)(this.ca - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.a(f1 * 28.7f);
        }
        return this.ca > 0 ? 0.62831855f : this.do() * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.pq)) {
            if (!this.s.x && this.a()) {
                if (!CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand)) {
                    return EnumInteractionResult.d;
                }
                this.a(SoundCategory.h);
                this.a(GameEvent.M, (Entity)player);
                itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.b;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(SoundCategory shearedSoundCategory) {
        this.s.a((EntityHuman)null, this, SoundEffects.qx, shearedSoundCategory, 1.0f, 1.0f);
        this.v(true);
        int i2 = 1 + this.R.nextInt(3);
        for (int j2 = 0; j2 < i2; ++j2) {
            this.forceDrops = true;
            EntityItem entityitem = this.a(bY.get(this.t()), 1);
            this.forceDrops = false;
            if (entityitem == null) continue;
            entityitem.g(entityitem.da().b((this.R.nextFloat() - this.R.nextFloat()) * 0.1f, this.R.nextFloat() * 0.05f, (this.R.nextFloat() - this.R.nextFloat()) * 0.1f));
        }
    }

    @Override
    public boolean a() {
        return this.bl() && !this.fz() && !this.y_();
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Sheared", this.fz());
        nbt.a("Color", (byte)this.t().a());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.v(nbt.q("Sheared"));
        this.b(EnumColor.a(nbt.f("Color")));
    }

    @Override
    protected SoundEffect r() {
        return SoundEffects.qu;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.qw;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.qv;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.qy, 0.15f, 1.0f);
    }

    public EnumColor t() {
        return EnumColor.a(this.Y.a(bW) & 0xF);
    }

    public void b(EnumColor color) {
        byte b0 = this.Y.a(bW);
        this.Y.b(bW, (byte)(b0 & 0xF0 | color.a() & 0xF));
    }

    public boolean fz() {
        return (this.Y.a(bW) & 0x10) != 0;
    }

    public void v(boolean sheared) {
        byte b0 = this.Y.a(bW);
        if (sheared) {
            this.Y.b(bW, (byte)(b0 | 0x10));
        } else {
            this.Y.b(bW, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static EnumColor a(Random random) {
        int i2 = random.nextInt(100);
        return i2 < 5 ? EnumColor.p : (i2 < 10 ? EnumColor.h : (i2 < 15 ? EnumColor.i : (i2 < 18 ? EnumColor.m : (random.nextInt(500) == 0 ? EnumColor.g : EnumColor.a))));
    }

    public EntitySheep b(WorldServer world, EntityAgeable entity) {
        EntitySheep entitysheep = (EntitySheep)entity;
        EntitySheep entitysheep1 = EntityTypes.ax.a(world);
        entitysheep1.b(this.a(this, (EntityAnimal)entitysheep));
        return entitysheep1;
    }

    @Override
    public void I() {
        SheepRegrowWoolEvent event = new SheepRegrowWoolEvent((Sheep)this.getBukkitEntity());
        this.s.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.v(false);
        if (this.y_()) {
            this.a_(60);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.b(EntitySheep.a(world.r_()));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private EnumColor a(EntityAnimal firstParent, EntityAnimal secondParent) {
        EnumColor enumcolor = ((EntitySheep)firstParent).t();
        EnumColor enumcolor1 = ((EntitySheep)secondParent).t();
        InventoryCrafting inventorycrafting = EntitySheep.a(enumcolor, enumcolor1);
        Optional<Item> optional = this.s.q().a(Recipes.a, inventorycrafting, this.s).map(recipecrafting -> recipecrafting.a(inventorycrafting)).map(ItemStack::c);
        Objects.requireNonNull(ItemDye.class);
        optional = optional.filter(ItemDye.class::isInstance);
        Objects.requireNonNull(ItemDye.class);
        return optional.map(ItemDye.class::cast).map(ItemDye::d).orElseGet(() -> this.s.v.nextBoolean() ? enumcolor : enumcolor1);
    }

    private static InventoryCrafting a(EnumColor firstColor, EnumColor secondColor) {
        InventoryCrafting inventorycrafting = new InventoryCrafting(new Container((Containers)null, -1){

            @Override
            public boolean a(EntityHuman player) {
                return false;
            }

            @Override
            public InventoryView getBukkitView() {
                return null;
            }
        }, 2, 1);
        inventorycrafting.a(0, new ItemStack(ItemDye.a(firstColor)));
        inventorycrafting.a(1, new ItemStack(ItemDye.a(secondColor)));
        inventorycrafting.resultInventory = new InventoryCraftResult();
        return inventorycrafting;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.95f * dimensions.b;
    }
}

