/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.i);
    private static final float bW = 6.0f;
    private float bY;
    private float bZ;
    private int ca;
    private static final UniformInt cb = TimeRange.a(20, 39);
    private int cc;
    @Nullable
    private UUID cd;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.ar.a(world);
    }

    @Override
    @Override
    public boolean n(ItemStack stack) {
        return false;
    }

    @Override
    @Override
    protected void u() {
        super.u();
        this.bQ.a(0, new PathfinderGoalFloat(this));
        this.bQ.a(1, new c());
        this.bQ.a(1, new d());
        this.bQ.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bQ.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.bQ.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bQ.a(7, new PathfinderGoalRandomLookaround(this));
        this.bR.a(1, new b());
        this.bR.a(2, new a());
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bR.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.bR.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.w().a(GenericAttributes.a, 30.0).a(GenericAttributes.b, 20.0).a(GenericAttributes.d, 0.25).a(GenericAttributes.f, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        Holder<BiomeBase> holder = world.v(pos);
        if (holder.a(Biomes.U) || holder.a(Biomes.V)) {
            return EntityPolarBear.a(world, pos) && world.a_(pos.c()).a(TagsBlock.bx);
        }
        return EntityPolarBear.b(type, world, spawnReason, pos, random);
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(this.s, nbt);
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.c(nbt);
    }

    @Override
    @Override
    public void c() {
        this.a(cb.a(this.R));
    }

    @Override
    @Override
    public void a(int angerTime) {
        this.cc = angerTime;
    }

    @Override
    @Override
    public int a() {
        return this.cc;
    }

    @Override
    @Override
    public void a(@Nullable UUID angryAt) {
        this.cd = angryAt;
    }

    @Override
    @Nullable
    @Override
    public UUID b() {
        return this.cd;
    }

    @Override
    @Override
    protected SoundEffect r() {
        if (this.y_()) {
            return SoundEffects.oR;
        }
        return SoundEffects.oQ;
    }

    @Override
    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.oT;
    }

    @Override
    @Override
    public SoundEffect x_() {
        return SoundEffects.oS;
    }

    @Override
    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.oU, 0.15f, 1.0f);
    }

    protected void t() {
        if (this.ca <= 0) {
            this.a(SoundEffects.oV, 1.0f, this.ew());
            this.ca = 40;
        }
    }

    @Override
    @Override
    protected void a_() {
        super.a_();
        this.Y.a(bV, false);
    }

    @Override
    @Override
    public void k() {
        super.k();
        if (this.s.x) {
            if (this.bZ != this.bY) {
                this.z_();
            }
            this.bY = this.bZ;
            this.bZ = this.fz() ? MathHelper.a(this.bZ + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.bZ - 1.0f, 0.0f, 6.0f);
        }
        if (this.ca > 0) {
            --this.ca;
        }
        if (!this.s.x) {
            this.a((WorldServer)this.s, true);
        }
    }

    @Override
    @Override
    public EntitySize a(EntityPose pose) {
        if (this.bZ > 0.0f) {
            float f2 = this.bZ / 6.0f;
            float g2 = 1.0f + f2;
            return super.a(pose).a(1.0f, g2);
        }
        return super.a(pose);
    }

    @Override
    @Override
    public boolean z(Entity target) {
        boolean bl = target.a(DamageSource.c(this), (float)((int)this.b(GenericAttributes.f)));
        if (bl) {
            this.a((EntityLiving)this, target);
        }
        return bl;
    }

    public boolean fz() {
        return this.Y.a(bV);
    }

    public void v(boolean warning) {
        this.Y.b(bV, warning);
    }

    public float z(float tickDelta) {
        return MathHelper.i(tickDelta, this.bY, this.bZ) / 6.0f;
    }

    @Override
    @Override
    protected float eC() {
        return 0.98f;
    }

    @Override
    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        @Override
        protected void a(EntityLiving target, double squaredDistance) {
            double d2 = this.a(target);
            if (squaredDistance <= d2 && this.i()) {
                this.h();
                this.a.z(target);
                EntityPolarBear.this.v(false);
            } else if (squaredDistance <= d2 * 2.0) {
                if (this.i()) {
                    EntityPolarBear.this.v(false);
                    this.h();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.v(true);
                    EntityPolarBear.this.t();
                }
            } else {
                this.h();
                EntityPolarBear.this.v(false);
            }
        }

        @Override
        @Override
        public void d() {
            EntityPolarBear.this.v(false);
            super.d();
        }

        @Override
        @Override
        protected double a(EntityLiving entity) {
            return 4.0f + entity.cT();
        }
    }

    class d
    extends PathfinderGoalPanic {
        public d() {
            super(EntityPolarBear.this, 2.0);
        }

        @Override
        @Override
        protected boolean h() {
            return this.b.dM() != null && this.b.y_() || this.b.bE();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        @Override
        public void c() {
            super.c();
            if (EntityPolarBear.this.y_()) {
                this.h();
                this.d();
            }
        }

        @Override
        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPolarBear && !mob.y_()) {
                super.a(mob, target);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        @Override
        public boolean a() {
            if (EntityPolarBear.this.y_()) {
                return false;
            }
            if (super.a()) {
                List<EntityPolarBear> list = EntityPolarBear.this.s.a(EntityPolarBear.class, EntityPolarBear.this.cw().c(8.0, 4.0, 8.0));
                for (EntityPolarBear polarBear : list) {
                    if (!polarBear.y_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

