/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> c = DataWatcher.a(EntityIronGolem.class, DataWatcherRegistry.a);
    private static final int d = 25;
    private int e;
    private int bV;
    private static final UniformInt bW = TimeRange.a(20, 39);
    private int bX;
    @Nullable
    private UUID bY;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
        this.P = 1.0f;
    }

    @Override
    protected void u() {
        this.bQ.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bQ.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.bQ.a(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.bQ.a(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.bQ.a(5, new PathfinderGoalOfferFlower(this));
        this.bQ.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bQ.a(8, new PathfinderGoalRandomLookaround(this));
        this.bR.a(1, new PathfinderGoalDefendVillage(this));
        this.bR.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bR.a(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, entityliving -> entityliving instanceof IMonster && !(entityliving instanceof EntityCreeper)));
        this.bR.a(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(c, (byte)0);
    }

    public static AttributeProvider.Builder n() {
        return EntityInsentient.w().a(GenericAttributes.a, 100.0).a(GenericAttributes.d, 0.25).a(GenericAttributes.c, 1.0).a(GenericAttributes.f, 15.0);
    }

    @Override
    protected int m(int air) {
        return air;
    }

    @Override
    protected void A(Entity entity) {
        if (entity instanceof IMonster && !(entity instanceof EntityCreeper) && this.dL().nextInt(20) == 0) {
            this.setTarget((EntityLiving)entity, EntityTargetEvent.TargetReason.COLLISION, true);
        }
        super.A(entity);
    }

    @Override
    public void w_() {
        int k2;
        int j2;
        int i2;
        IBlockData iblockdata;
        super.w_();
        if (this.e > 0) {
            --this.e;
        }
        if (this.bV > 0) {
            --this.bV;
        }
        if (this.da().i() > 2.500000277905201E-7 && this.R.nextInt(5) == 0 && !(iblockdata = this.s.a_(new BlockPosition(i2 = MathHelper.b(this.dc()), j2 = MathHelper.b(this.de() - (double)0.2f), k2 = MathHelper.b(this.di())))).g()) {
            this.s.a(new ParticleParamBlock(Particles.c, iblockdata), this.dc() + ((double)this.R.nextFloat() - 0.5) * (double)this.cT(), this.de() + 0.1, this.di() + ((double)this.R.nextFloat() - 0.5) * (double)this.cT(), 4.0 * ((double)this.R.nextFloat() - 0.5), 0.5, ((double)this.R.nextFloat() - 0.5) * 4.0);
        }
        if (!this.s.x) {
            this.a((WorldServer)this.s, true);
        }
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return this.fA() && type == EntityTypes.bi ? false : (type == EntityTypes.o ? false : super.a(type));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("PlayerCreated", this.fA());
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.w(nbt.q("PlayerCreated"));
        this.a(this.s, nbt);
    }

    @Override
    public void c() {
        this.a(bW.a(this.R));
    }

    @Override
    public void a(int angerTime) {
        this.bX = angerTime;
    }

    @Override
    public int a() {
        return this.bX;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.bY = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.bY;
    }

    private float fB() {
        return (float)this.b(GenericAttributes.f);
    }

    @Override
    public boolean z(Entity target) {
        this.e = 10;
        this.s.a((Entity)this, (byte)4);
        float f2 = this.fB();
        float f1 = (int)f2 > 0 ? f2 / 2.0f + (float)this.R.nextInt((int)f2) : f2;
        boolean flag = target.a(DamageSource.c(this), f1);
        if (flag) {
            target.g(target.da().b(0.0, 0.4f, 0.0));
            this.a((EntityLiving)this, target);
        }
        this.a(SoundEffects.jh, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        CrackLevel entityirongolem_cracklevel = this.q();
        boolean flag = super.a(source, amount);
        if (flag && this.q() != entityirongolem_cracklevel) {
            this.a(SoundEffects.ji, 1.0f, 1.0f);
        }
        return flag;
    }

    public CrackLevel q() {
        return CrackLevel.a(this.ea() / this.em());
    }

    @Override
    public void a(byte status) {
        if (status == 4) {
            this.e = 10;
            this.a(SoundEffects.jh, 1.0f, 1.0f);
        } else if (status == 11) {
            this.bV = 400;
        } else if (status == 34) {
            this.bV = 0;
        } else {
            super.a(status);
        }
    }

    public int t() {
        return this.e;
    }

    public void v(boolean lookingAtVillager) {
        if (lookingAtVillager) {
            this.bV = 400;
            this.s.a((Entity)this, (byte)11);
        } else {
            this.bV = 0;
            this.s.a((Entity)this, (byte)34);
        }
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.jk;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.jj;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.a(Items.mq)) {
            return EnumInteractionResult.d;
        }
        float f2 = this.ea();
        this.b(25.0f);
        if (this.ea() == f2) {
            return EnumInteractionResult.d;
        }
        float f1 = 1.0f + (this.R.nextFloat() - this.R.nextFloat()) * 0.2f;
        this.a(SoundEffects.jl, 1.0f, f1);
        this.a(GameEvent.C, this.cY());
        if (!player.fs().d) {
            itemstack.g(1);
        }
        return EnumInteractionResult.a(this.s.x);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.jm, 1.0f, 1.0f);
    }

    public int fz() {
        return this.bV;
    }

    public boolean fA() {
        return (this.Y.a(c) & 1) != 0;
    }

    public void w(boolean playerCreated) {
        byte b0 = this.Y.a(c);
        if (playerCreated) {
            this.Y.b(c, (byte)(b0 | 1));
        } else {
            this.Y.b(c, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    public void a(DamageSource source) {
        super.a(source);
    }

    @Override
    public boolean a(IWorldReader world) {
        BlockPosition blockposition = this.cW();
        BlockPosition blockposition1 = blockposition.c();
        IBlockData iblockdata = world.a_(blockposition1);
        if (!iblockdata.a((IBlockAccess)world, blockposition1, (Entity)this) && !this.s.paperConfig.ironGolemsCanSpawnInAir) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            IBlockData iblockdata1;
            BlockPosition blockposition2 = blockposition.b(i2);
            if (SpawnerCreature.a(world, blockposition2, iblockdata1 = world.a_(blockposition2), iblockdata1.o(), EntityTypes.P)) continue;
            return false;
        }
        return SpawnerCreature.a(world, blockposition, world.a_(blockposition), FluidTypes.a.h(), EntityTypes.P) && world.f(this);
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.875f * this.cy(), this.cT() * 0.4f);
    }

    public static enum CrackLevel {
        a(1.0f),
        b(0.75f),
        c(0.5f),
        d(0.25f);

        private static final List<CrackLevel> e;
        private final float f;

        private CrackLevel(float f2) {
            this.f = f2;
        }

        public static CrackLevel a(float healthFraction) {
            CrackLevel entityirongolem_cracklevel;
            Iterator<CrackLevel> iterator = e.iterator();
            do {
                if (!iterator.hasNext()) {
                    return a;
                }
                entityirongolem_cracklevel = iterator.next();
            } while (healthFraction >= entityirongolem_cracklevel.f);
            return entityirongolem_cracklevel;
        }

        static {
            e = (List)Stream.of(CrackLevel.values()).sorted(Comparator.comparingDouble(entityirongolem_cracklevel -> entityirongolem_cracklevel.f)).collect(ImmutableList.toImmutableList());
        }
    }
}

