/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class EntityFox
extends EntityAnimal {
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> ca = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int cb = 1;
    public static final int bV = 4;
    public static final int bW = 8;
    public static final int bY = 16;
    private static final int cc = 32;
    private static final int cd = 64;
    private static final int ce = 128;
    public static final DataWatcherObject<Optional<UUID>> cf = DataWatcher.a(EntityFox.class, DataWatcherRegistry.o);
    public static final DataWatcherObject<Optional<UUID>> cg = DataWatcher.a(EntityFox.class, DataWatcherRegistry.o);
    static final Predicate<EntityItem> ch = entityitem -> !entityitem.r() && entityitem.bl();
    private static final Predicate<Entity> ci = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.dO() != null && entityliving.dP() < entityliving.S + 600;
    };
    static final Predicate<Entity> cj = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> ck = entity -> !entity.bL() && IEntitySelector.e.test((Entity)entity);
    private static final int cl = 600;
    private PathfinderGoal cm;
    private PathfinderGoal cn;
    private PathfinderGoal co;
    private float cp;
    private float cq;
    float cr;
    float cs;
    private int ct;

    public EntityFox(EntityTypes<? extends EntityFox> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bM = new k();
        this.bN = new m();
        this.a(PathType.r, 0.0f);
        this.a(PathType.s, 0.0f);
        this.r(true);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(cf, Optional.empty());
        this.Y.a(cg, Optional.empty());
        this.Y.a(bZ, 0);
        this.Y.a(ca, (byte)0);
    }

    @Override
    protected void u() {
        this.cm = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, entityliving -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.cn = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.bW);
        this.co = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, entityliving -> entityliving instanceof EntityFishSchool);
        this.bQ.a(0, new g());
        this.bQ.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.s));
        this.bQ.a(1, new b());
        this.bQ.a(2, new n(2.2));
        this.bQ.a(3, new e(1.0));
        this.bQ.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> ck.test((Entity)entityliving) && !this.c(entityliving.cm()) && !this.fM()));
        this.bQ.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).q() && !this.fM()));
        this.bQ.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.fM()));
        this.bQ.a(5, new u());
        this.bQ.a(6, new o());
        this.bQ.a(6, new s(1.25));
        this.bQ.a(7, new l((double)1.2f, true));
        this.bQ.a(7, new t());
        this.bQ.a(8, new h(this, 1.25));
        this.bQ.a(9, new q(32, 200));
        this.bQ.a(10, new f((double)1.2f, 12, 1));
        this.bQ.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bQ.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bQ.a(11, new p());
        this.bQ.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bQ.a(13, new r());
        this.bR.a(3, new a(EntityLiving.class, false, false, entityliving -> ci.test((Entity)entityliving) && !this.c(entityliving.cm())));
    }

    @Override
    public SoundEffect e(ItemStack stack) {
        return SoundEffects.gu;
    }

    @Override
    public void w_() {
        if (!this.s.x && this.bl() && this.eI()) {
            EntityLiving entityliving;
            ++this.ct;
            ItemStack itemstack = this.b(EnumItemSlot.a);
            if (this.m(itemstack)) {
                if (this.ct > 600) {
                    ItemStack itemstack1 = itemstack.a(this.s, this);
                    if (!itemstack1.b()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.ct = 0;
                } else if (this.ct > 560 && this.R.nextFloat() < 0.1f) {
                    this.a(this.e(itemstack), 1.0f, 1.0f);
                    this.s.a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.G()) == null || !entityliving.bl()) {
                this.x(false);
                this.y(false);
            }
        }
        if (this.fc() || this.ex()) {
            this.bn = false;
            this.bo = 0.0f;
            this.bq = 0.0f;
        }
        super.w_();
        if (this.fM() && this.R.nextFloat() < 0.05f) {
            this.a(SoundEffects.gq, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean ex() {
        return this.eb();
    }

    private boolean m(ItemStack stack) {
        return stack.c().v() && this.G() == null && this.y && !this.fc();
    }

    @Override
    protected void a(DifficultyDamageScaler difficulty) {
        if (this.R.nextFloat() < 0.2f) {
            float f2 = this.R.nextFloat();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.ml) : (f2 < 0.2f ? new ItemStack(Items.oo) : (f2 < 0.4f ? (this.R.nextBoolean() ? new ItemStack(Items.rI) : new ItemStack(Items.rJ)) : (f2 < 0.6f ? new ItemStack(Items.ni) : (f2 < 0.8f ? new ItemStack(Items.ob) : new ItemStack(Items.nf)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void a(byte status) {
        if (status == 45) {
            ItemStack itemstack = this.b(EnumItemSlot.a);
            if (!itemstack.b()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.R.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.do() * ((float)Math.PI / 180)).b(-this.dn() * ((float)Math.PI / 180));
                    this.s.a(new ParticleParamItem(Particles.J, itemstack), this.dc() + this.bv().b / 2.0, this.de(), this.di() + this.bv().d / 2.0, vec3d.b, vec3d.c + 0.05, vec3d.d);
                }
            }
        } else {
            super.a(status);
        }
    }

    public static AttributeProvider.Builder q() {
        return EntityInsentient.w().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 10.0).a(GenericAttributes.b, 32.0).a(GenericAttributes.f, 2.0);
    }

    public EntityFox b(WorldServer world, EntityAgeable entity) {
        EntityFox entityfox = EntityTypes.E.a(world);
        entityfox.a(this.R.nextBoolean() ? this.t() : ((EntityFox)entity).t());
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.bz) && EntityFox.a(world, pos);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        Holder<BiomeBase> holder = world.v(this.cW());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (entityData instanceof i) {
            entityfox_type = ((i)entityData).a;
            if (((i)entityData).a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.b_(-24000);
        }
        if (world instanceof WorldServer) {
            this.fK();
        }
        this.a(difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private void fK() {
        if (this.t() == Type.a) {
            this.bR.a(4, this.cm);
            this.bR.a(4, this.cn);
            this.bR.a(6, this.co);
        } else {
            this.bR.a(4, this.co);
            this.bR.a(6, this.cm);
            this.bR.a(6, this.cn);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (this.n(stack)) {
            this.a(this.e(stack), 1.0f, 1.0f);
        }
        super.a(player, hand, stack);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? dimensions.b * 0.85f : 0.4f;
    }

    public Type t() {
        return Type.a(this.Y.a(bZ));
    }

    public void a(Type type) {
        this.Y.b(bZ, type.b());
    }

    List<UUID> fL() {
        ArrayList list = Lists.newArrayList();
        list.add(this.Y.a(cf).orElse(null));
        list.add(this.Y.a(cg).orElse(null));
        return list;
    }

    void b(@Nullable UUID uuid) {
        if (this.Y.a(cf).isPresent()) {
            this.Y.b(cg, Optional.ofNullable(uuid));
        } else {
            this.Y.b(cf, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        List<UUID> list = this.fL();
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbt.a("Trusted", nbttaglist);
        nbt.a("Sleeping", this.fc());
        nbt.a("Type", this.t().a());
        nbt.a("Sitting", this.fz());
        nbt.a("Crouching", this.bN());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagList nbttaglist = nbt.c("Trusted", 11);
        for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
            this.b(GameProfileSerializer.a(nbttaglist.k(i2)));
        }
        this.B(nbt.q("Sleeping"));
        this.a(Type.a(nbt.l("Type")));
        this.v(nbt.q("Sitting"));
        this.x(nbt.q("Crouching"));
        if (this.s instanceof WorldServer) {
            this.fK();
        }
    }

    public boolean fz() {
        return this.s(1);
    }

    public void v(boolean sitting) {
        this.d(1, sitting);
    }

    public boolean fA() {
        return this.s(64);
    }

    public void z(boolean walking) {
        this.d(64, walking);
    }

    public boolean fM() {
        return this.s(128);
    }

    public void A(boolean aggressive) {
        this.d(128, aggressive);
    }

    @Override
    public boolean fc() {
        return this.s(32);
    }

    public void B(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int mask, boolean value) {
        if (value) {
            this.Y.b(ca, (byte)(this.Y.a(ca) | mask));
        } else {
            this.Y.b(ca, (byte)(this.Y.a(ca) & ~mask));
        }
    }

    private boolean s(int bitmask) {
        return (this.Y.a(ca) & bitmask) != 0;
    }

    @Override
    public boolean g(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.i(stack);
        return !this.b(enumitemslot).b() ? false : enumitemslot == EnumItemSlot.a && super.g(stack);
    }

    @Override
    public boolean k(ItemStack stack) {
        Item item = stack.c();
        ItemStack itemstack1 = this.b(EnumItemSlot.a);
        return itemstack1.b() || this.ct > 0 && item.v() && !itemstack1.c().v();
    }

    private void o(ItemStack stack) {
        if (!stack.b() && !this.s.x) {
            EntityItem entityitem = new EntityItem(this.s, this.dc() + this.bv().b, this.de() + 1.0, this.di() + this.bv().d, stack);
            entityitem.a(40);
            entityitem.c(this.cm());
            this.a(SoundEffects.gz, 1.0f, 1.0f);
            this.s.b(entityitem);
        }
    }

    private void p(ItemStack stack) {
        EntityItem entityitem = new EntityItem(this.s, this.dc(), this.de(), this.di(), stack);
        this.s.b(entityitem);
    }

    @Override
    protected void b(EntityItem item) {
        ItemStack itemstack = item.h();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, item, itemstack.J() - 1, !this.k(itemstack)).isCancelled()) {
            itemstack = item.h();
            int i2 = itemstack.J();
            if (i2 > 1) {
                this.p(itemstack.a(i2 - 1));
            }
            this.o(this.b(EnumItemSlot.a));
            this.a(item);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.bS[EnumItemSlot.a.b()] = 2.0f;
            this.a((Entity)item, itemstack.J());
            item.ah();
            this.ct = 0;
        }
    }

    @Override
    public void k() {
        super.k();
        if (this.eI()) {
            boolean flag = this.aQ();
            if (flag || this.G() != null || this.s.X()) {
                this.fN();
            }
            if (flag || this.fc()) {
                this.v(false);
            }
            if (this.fA() && this.s.v.nextFloat() < 0.2f) {
                BlockPosition blockposition = this.cW();
                IBlockData iblockdata = this.s.a_(blockposition);
                this.s.c(2001, blockposition, Block.i(iblockdata));
            }
        }
        this.cq = this.cp;
        this.cp = this.fJ() ? (this.cp += (1.0f - this.cp) * 0.4f) : (this.cp += (0.0f - this.cp) * 0.4f);
        this.cs = this.cr;
        if (this.bN()) {
            this.cr += 0.2f;
            if (this.cr > 3.0f) {
                this.cr = 3.0f;
            }
        } else {
            this.cr = 0.0f;
        }
    }

    @Override
    public boolean n(ItemStack stack) {
        return stack.a(TagsItem.Q);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).b(player.cm());
    }

    public boolean fB() {
        return this.s(16);
    }

    public void w(boolean chasing) {
        this.d(16, chasing);
    }

    public boolean fH() {
        return this.bn;
    }

    public boolean fI() {
        return this.cr == 3.0f;
    }

    public void x(boolean crouching) {
        this.d(4, crouching);
    }

    @Override
    public boolean bN() {
        return this.s(4);
    }

    public void y(boolean rollingHead) {
        this.d(8, rollingHead);
    }

    public boolean fJ() {
        return this.s(8);
    }

    public float z(float tickDelta) {
        return MathHelper.i(tickDelta, this.cq, this.cp) * 0.11f * (float)Math.PI;
    }

    public float A(float tickDelta) {
        return MathHelper.i(tickDelta, this.cs, this.cr);
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (this.fM() && target == null) {
            this.A(false);
        }
        super.h(target);
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return MathHelper.f((fallDistance - 5.0f) * damageMultiplier);
    }

    void fN() {
        this.B(false);
    }

    void fO() {
        this.y(false);
        this.x(false);
        this.v(false);
        this.B(false);
        this.A(false);
        this.z(false);
    }

    boolean fP() {
        return !this.fc() && !this.fz() && !this.fA();
    }

    @Override
    public void K() {
        SoundEffect soundeffect = this.r();
        if (soundeffect == SoundEffects.gw) {
            this.a(soundeffect, 2.0f, this.ew());
        } else {
            super.K();
        }
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        List<Entity> list;
        if (this.fc()) {
            return SoundEffects.gx;
        }
        if (!this.s.O() && this.R.nextFloat() < 0.1f && (list = this.s.a(EntityHuman.class, this.cw().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.gw;
        }
        return SoundEffects.gr;
    }

    @Override
    @Nullable
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.gv;
    }

    @Override
    @Nullable
    public SoundEffect x_() {
        return SoundEffects.gt;
    }

    boolean c(UUID uuid) {
        return this.fL().contains(uuid);
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(DamageSource source) {
        ItemStack itemstack = this.b(EnumItemSlot.a).n();
        EntityDeathEvent deathEvent = super.dropAllDeathLoot(source);
        if (deathEvent == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (!itemstack.b()) {
            this.b(itemstack);
            this.a(EnumItemSlot.a, ItemStack.b);
        }
        return deathEvent;
    }

    public static boolean a(EntityFox fox, EntityLiving chasedEntity) {
        double d0 = chasedEntity.di() - fox.di();
        double d1 = chasedEntity.dc() - fox.dc();
        double d2 = d0 / d1;
        boolean flag = true;
        for (int i2 = 0; i2 < 6; ++i2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i2 / 6.0f) : d3 / d2;
            for (int j2 = 1; j2 < 4; ++j2) {
                if (fox.s.a_(new BlockPosition(fox.dc() + d4, fox.de() + (double)j2, fox.di() + d3)).c().e()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.55f * this.cy(), this.cT() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fc()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.fB() && !EntityFox.this.bN() && !EntityFox.this.fJ() && !EntityFox.this.fA();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.fP()) {
                super.a();
            }
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void c() {
            super.c();
            EntityFox.this.fO();
        }

        @Override
        public boolean a() {
            return EntityFox.this.aQ() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bc();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityFox.this.fA();
        }

        @Override
        public boolean b() {
            return this.a() && this.a > 0;
        }

        @Override
        public void c() {
            this.a = this.a(40);
        }

        @Override
        public void d() {
            EntityFox.this.z(false);
        }

        @Override
        public void e() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.fM() && super.h();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public void c() {
            ((EntityFox)this.a).fO();
            ((EntityFox)this.c).fO();
            super.c();
        }

        @Override
        protected void g() {
            WorldServer worldserver = (WorldServer)this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.fE();
                EntityPlayer entityplayer1 = this.c.fE();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.b(entityplayer.cm());
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.b(entityplayer1.cm());
                }
                entityfox.b_(-24000);
                entityfox.b(this.a.dc(), this.a.de(), this.a.di(), 0.0f, 0.0f);
                int experience = this.a.dL().nextInt(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.P);
                    CriterionTriggers.o.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.b_(6000);
                this.c.b_(6000);
                this.a.fG();
                this.c.fG();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (this.b.W().b(GameRules.f) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dc(), this.a.de(), this.a.di(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityfox));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            if (EntityFox.this.fc()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.G();
            return entityliving != null && entityliving.bl() && cj.test(entityliving) && EntityFox.this.f((Entity)entityliving) > 36.0 && !EntityFox.this.bN() && !EntityFox.this.fJ() && !EntityFox.this.bn;
        }

        @Override
        public void c() {
            EntityFox.this.v(false);
            EntityFox.this.z(false);
        }

        @Override
        public void d() {
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.y(true);
                EntityFox.this.x(true);
                EntityFox.this.D().n();
                EntityFox.this.z().a(entityliving, (float)EntityFox.this.U(), (float)EntityFox.this.T());
            } else {
                EntityFox.this.y(false);
                EntityFox.this.x(false);
            }
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null) {
                EntityFox.this.z().a(entityliving, (float)EntityFox.this.U(), (float)EntityFox.this.T());
                if (EntityFox.this.f((Entity)entityliving) <= 36.0) {
                    EntityFox.this.y(true);
                    EntityFox.this.x(true);
                    EntityFox.this.D().n();
                } else {
                    EntityFox.this.D().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean a() {
            if (!EntityFox.this.fI()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null && entityliving.bl()) {
                if (entityliving.cu() != entityliving.ct()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.D().a((Entity)entityliving, 0);
                    EntityFox.this.x(false);
                    EntityFox.this.y(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null && entityliving.bl()) {
                double d0 = EntityFox.this.da().c;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.do()) >= 15.0f || !EntityFox.this.y) && !EntityFox.this.fA();
            }
            return false;
        }

        @Override
        public boolean D_() {
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.q(true);
            EntityFox.this.w(true);
            EntityFox.this.y(false);
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null) {
                EntityFox.this.z().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dc() - EntityFox.this.dc(), entityliving.de() - EntityFox.this.de(), entityliving.di() - EntityFox.this.di()).d();
                EntityFox.this.g(EntityFox.this.da().b(vec3d.b * 0.8, 0.9, vec3d.d * 0.8));
            }
            EntityFox.this.D().n();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.cr = 0.0f;
            EntityFox.this.cs = 0.0f;
            EntityFox.this.y(false);
            EntityFox.this.w(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.G();
            if (entityliving != null) {
                EntityFox.this.z().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.fA()) {
                Vec3D vec3d = EntityFox.this.da();
                if (vec3d.c * vec3d.c < (double)0.03f && EntityFox.this.do() != 0.0f) {
                    EntityFox.this.p(MathHelper.l(EntityFox.this.do(), 0.0f, 0.2f));
                } else {
                    double d0 = vec3d.h();
                    double d1 = Math.signum(-vec3d.c) * Math.acos(d0 / vec3d.f()) * 57.2957763671875;
                    EntityFox.this.p((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.e((Entity)entityliving) <= 2.0f) {
                EntityFox.this.z(entityliving);
            } else if (EntityFox.this.do() > 0.0f && EntityFox.this.y && (float)EntityFox.this.da().c != 0.0f && EntityFox.this.s.a_(EntityFox.this.cW()).a(Blocks.cK)) {
                EntityFox.this.p(60.0f);
                EntityFox.this.h((EntityLiving)null);
                EntityFox.this.z(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.fc() && this.a.G() == null) {
                if (EntityFox.this.s.X()) {
                    return true;
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.cW();
                return EntityFox.this.s.O() && EntityFox.this.s.g(blockposition) && !((WorldServer)EntityFox.this.s).b(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.fO();
            super.c();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving target, double squaredDistance) {
            double d1 = this.a(target);
            if (squaredDistance <= d1 && this.i()) {
                this.h();
                this.a.z(target);
                EntityFox.this.a(SoundEffects.gs, 1.0f, 1.0f);
            }
        }

        @Override
        public void c() {
            EntityFox.this.y(false);
            super.c();
        }

        @Override
        public boolean a() {
            return !EntityFox.this.fz() && !EntityFox.this.fc() && !EntityFox.this.bN() && !EntityFox.this.fA() && super.a();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.R.nextInt(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean a() {
            return EntityFox.this.bo == 0.0f && EntityFox.this.bp == 0.0f && EntityFox.this.bq == 0.0f ? this.k() || EntityFox.this.fc() : false;
        }

        @Override
        public boolean b() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.s.O() && this.h() && !this.i() && !EntityFox.this.al;
        }

        @Override
        public void d() {
            this.d = EntityFox.this.R.nextInt(c);
            EntityFox.this.fO();
        }

        @Override
        public void c() {
            EntityFox.this.v(false);
            EntityFox.this.x(false);
            EntityFox.this.y(false);
            EntityFox.this.q(false);
            EntityFox.this.B(true);
            EntityFox.this.D().n();
            EntityFox.this.A().a(EntityFox.this.dc(), EntityFox.this.de(), EntityFox.this.di(), 0.0);
        }
    }

    private class h
    extends PathfinderGoalFollowParent {
        private final EntityFox e;

        public h(EntityFox entityfox, double d0) {
            super(entityfox, d0);
            this.e = entityfox;
        }

        @Override
        public boolean a() {
            return !this.e.fM() && super.a();
        }

        @Override
        public boolean b() {
            return !this.e.fM() && super.b();
        }

        @Override
        public void c() {
            this.e.fO();
            super.c();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void c() {
            EntityFox.this.fO();
            super.c();
        }

        @Override
        public boolean a() {
            return super.a() && this.h();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fc() && !EntityFox.this.fz() && !EntityFox.this.fM() && EntityFox.this.G() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            IBlockData iblockdata = world.a_(pos);
            return iblockdata.a(Blocks.mu) && iblockdata.c(BlockSweetBerryBush.b) >= 2 || CaveVines.a(iblockdata);
        }

        @Override
        public void e() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.R.nextFloat() < 0.05f) {
                EntityFox.this.a(SoundEffects.gy, 1.0f, 1.0f);
            }
            super.e();
        }

        protected void o() {
            if (EntityFox.this.s.W().b(GameRules.c)) {
                IBlockData iblockdata = EntityFox.this.s.a_(this.e);
                if (iblockdata.a(Blocks.mu)) {
                    this.b(iblockdata);
                } else if (CaveVines.a(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.use(state, EntityFox.this.s, this.e, EntityFox.this);
        }

        private void b(IBlockData state) {
            int i2 = state.c(BlockSweetBerryBush.b);
            state.a(BlockSweetBerryBush.b, 1);
            if (CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.a(BlockSweetBerryBush.b, 1)).isCancelled()) {
                return;
            }
            int j2 = 1 + EntityFox.this.s.v.nextInt(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.b(EnumItemSlot.a);
            if (itemstack.b()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.to));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.s, this.e, new ItemStack(Items.to, j2));
            }
            EntityFox.this.a(SoundEffects.sT, 1.0f, 1.0f);
            EntityFox.this.s.a(this.e, (IBlockData)state.a(BlockSweetBerryBush.b, 1), 2);
        }

        @Override
        public boolean a() {
            return !EntityFox.this.fc() && super.a();
        }

        @Override
        public void c() {
            this.g = 0;
            EntityFox.this.v(false);
            super.c();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.b(EnumItemSlot.a).b()) {
                return false;
            }
            if (EntityFox.this.G() == null && EntityFox.this.dM() == null) {
                if (!EntityFox.this.fP()) {
                    return false;
                }
                if (EntityFox.this.dL().nextInt(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.s.a(EntityItem.class, EntityFox.this.cw().c(8.0, 8.0, 8.0), ch);
                return !list.isEmpty() && EntityFox.this.b(EnumItemSlot.a).b();
            }
            return false;
        }

        @Override
        public void e() {
            List<EntityItem> list = EntityFox.this.s.a(EntityItem.class, EntityFox.this.cw().c(8.0, 8.0, 8.0), ch);
            ItemStack itemstack = EntityFox.this.b(EnumItemSlot.a);
            if (itemstack.b() && !list.isEmpty()) {
                EntityFox.this.D().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void c() {
            List<EntityItem> list = EntityFox.this.s.a(EntityItem.class, EntityFox.this.cw().c(8.0, 8.0, 8.0), ch);
            if (!list.isEmpty()) {
                EntityFox.this.D().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class targetType, float range) {
            super(mob, targetType, range);
        }

        @Override
        public boolean a() {
            return super.a() && !EntityFox.this.fA() && !EntityFox.this.fJ();
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.fA() && !EntityFox.this.fJ();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityFox.this.dM() == null && EntityFox.this.dL().nextFloat() < 0.02f && !EntityFox.this.fc() && EntityFox.this.G() == null && EntityFox.this.D().l() && !this.i() && !EntityFox.this.fB() && !EntityFox.this.bN();
        }

        @Override
        public boolean b() {
            return this.f > 0;
        }

        @Override
        public void c() {
            this.k();
            this.f = 2 + EntityFox.this.dL().nextInt(3);
            EntityFox.this.v(true);
            EntityFox.this.D().n();
        }

        @Override
        public void d() {
            EntityFox.this.v(false);
        }

        @Override
        public void e() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.z().a(EntityFox.this.dc() + this.c, EntityFox.this.dg(), EntityFox.this.di() + this.d, EntityFox.this.U(), EntityFox.this.T());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.dL().nextDouble();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.dL().nextInt(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, Predicate<EntityLiving> predicate) {
            super(EntityFox.this, oclass, 10, flag, flag1, predicate);
        }

        @Override
        public boolean a() {
            if (this.b > 0 && this.e.dL().nextInt(this.b) != 0) {
                return false;
            }
            for (UUID uuid : EntityFox.this.fL()) {
                EntityLiving entityliving;
                Entity entity;
                if (uuid == null || !(EntityFox.this.s instanceof WorldServer) || !((entity = ((WorldServer)EntityFox.this.s).a(uuid)) instanceof EntityLiving)) continue;
                this.k = entityliving = (EntityLiving)entity;
                this.j = entityliving.dM();
                int i2 = entityliving.dN();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void c() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.dN();
            }
            EntityFox.this.a(SoundEffects.gq, 1.0f, 1.0f);
            EntityFox.this.A(true);
            EntityFox.this.fN();
            super.c();
        }
    }

    public static enum Type {
        a(0, "red"),
        b(1, "snow");

        private static final Type[] c;
        private static final Map<String, Type> d;
        private final int e;
        private final String f;

        private Type(int i2, String s2) {
            this.e = i2;
            this.f = s2;
        }

        public String a() {
            return this.f;
        }

        public int b() {
            return this.e;
        }

        public static Type a(String name) {
            return d.getOrDefault(name, a);
        }

        public static Type a(int id) {
            if (id < 0 || id > c.length) {
                id = 0;
            }
            return c[id];
        }

        public static Type a(Holder<BiomeBase> holder) {
            return holder.a().c() == BiomeBase.Precipitation.c ? b : a;
        }

        static {
            c = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::b)).toArray(Type[]::new);
            d = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::a, entityfox_type -> entityfox_type));
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type type) {
            super(false);
            this.a = type;
        }
    }

    public class c
    implements Predicate<EntityLiving> {
        public boolean a(EntityLiving entityliving) {
            return entityliving instanceof EntityFox ? false : (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster) ? (entityliving instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entityliving).q() : (entityliving instanceof EntityHuman && (entityliving.B_() || ((EntityHuman)entityliving).f()) ? false : (EntityFox.this.c(entityliving.cm()) ? false : !entityliving.fc() && !entityliving.bL()))) : true);
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = new BlockPosition(EntityFox.this.dc(), EntityFox.this.cw().e, EntityFox.this.di());
            return !EntityFox.this.s.g(blockposition) && EntityFox.this.f(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !EntityFox.this.s.a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cw().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

