/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomSwim;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityFish
extends EntityWaterAnimal
implements Bucketable {
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityFish.class, DataWatcherRegistry.i);

    public EntityFish(EntityTypes<? extends EntityFish> type, World world) {
        super((EntityTypes<? extends EntityWaterAnimal>)type, world);
        this.bN = new a(this);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.65f;
    }

    public static AttributeProvider.Builder n() {
        return EntityInsentient.w().a(GenericAttributes.a, 3.0);
    }

    @Override
    public boolean O() {
        return super.O() || this.q();
    }

    @Override
    public boolean h(double distanceSquared) {
        return true;
    }

    @Override
    public int ff() {
        return 8;
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(b, false);
    }

    @Override
    public boolean q() {
        return this.Y.a(b);
    }

    @Override
    public void v(boolean fromBucket) {
        this.Y.b(b, fromBucket);
        this.setPersistenceRequired(fromBucket || this.fj());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("FromBucket", this.q());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.v(nbt.q("FromBucket"));
    }

    @Override
    protected void u() {
        super.u();
        this.bQ.a(0, new PathfinderGoalPanic(this, 1.25));
        PathfinderGoalSelector pathfindergoalselector = this.bQ;
        Predicate<Entity> predicate = IEntitySelector.f;
        Objects.requireNonNull(predicate);
        pathfindergoalselector.a(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 1.6, 1.4, predicate::test));
        this.bQ.a(4, new b(this));
    }

    @Override
    protected NavigationAbstract a(World world) {
        return new NavigationGuardian(this, world);
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.eI() && this.aQ()) {
            this.a(0.01f, movementInput);
            this.a(EnumMoveType.a, this.da());
            this.g(this.da().a(0.9));
            if (this.G() == null) {
                this.g(this.da().b(0.0, -0.005, 0.0));
            }
        } else {
            super.h(movementInput);
        }
    }

    @Override
    public void w_() {
        if (!this.aQ() && this.y && this.A) {
            this.g(this.da().b((this.R.nextFloat() * 2.0f - 1.0f) * 0.05f, 0.4f, (this.R.nextFloat() * 2.0f - 1.0f) * 0.05f));
            this.y = false;
            this.af = true;
            this.a(this.fA(), this.ev(), this.ew());
        }
        super.w_();
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void m(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
    }

    @Override
    public void c(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
    }

    @Override
    public SoundEffect t() {
        return SoundEffects.ca;
    }

    protected boolean fz() {
        return true;
    }

    protected abstract SoundEffect fA();

    @Override
    protected SoundEffect aF() {
        return SoundEffects.gg;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    private static class a
    extends ControllerMove {
        private final EntityFish l;

        a(EntityFish owner) {
            super(owner);
            this.l = owner;
        }

        @Override
        public void a() {
            if (((Entity)this.l).a(TagsFluid.a)) {
                this.l.g(this.l.da().b(0.0, 0.005, 0.0));
            }
            if (this.k == ControllerMove.Operation.b && !this.l.D().l()) {
                float f2 = (float)(this.h * this.l.b(GenericAttributes.d));
                this.l.r(MathHelper.i(0.125f, this.l.eD(), f2));
                double d0 = this.e - this.l.dc();
                double d1 = this.f - this.l.de();
                double d2 = this.g - this.l.di();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.l.g(this.l.da().b(0.0, (double)this.l.eD() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f;
                    this.l.o(this.a(this.l.dn(), f1, 90.0f));
                    this.l.aX = this.l.dn();
                }
            } else {
                this.l.r(0.0f);
            }
        }
    }

    private static class b
    extends PathfinderGoalRandomSwim {
        private final EntityFish i;

        public b(EntityFish fish) {
            super(fish, 1.0, 40);
            this.i = fish;
        }

        @Override
        public boolean a() {
            return this.i.fz() && super.a();
        }
    }
}

