/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalCatSitOnBed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalJumpOnBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOcelotAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class EntityCat
extends EntityTameableAnimal {
    public static final double bY = 0.6;
    public static final double bZ = 0.8;
    public static final double ca = 1.33;
    private static final RecipeItemStack cn = RecipeItemStack.a(Items.ov, Items.ow);
    private static final DataWatcherObject<Integer> co = DataWatcher.a(EntityCat.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cp = DataWatcher.a(EntityCat.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Boolean> cq = DataWatcher.a(EntityCat.class, DataWatcherRegistry.i);
    private static final DataWatcherObject<Integer> cr = DataWatcher.a(EntityCat.class, DataWatcherRegistry.b);
    public static final int cb = 0;
    public static final int cc = 1;
    public static final int cd = 2;
    public static final int ce = 3;
    public static final int cf = 4;
    public static final int cg = 5;
    public static final int ch = 6;
    public static final int ci = 7;
    public static final int cj = 8;
    public static final int ck = 9;
    public static final int cl = 10;
    private static final int cs = 11;
    private static final int ct = 10;
    public static final Map<Integer, MinecraftKey> cm = SystemUtils.a(Maps.newHashMap(), (T hashmap) -> {
        hashmap.put(0, new MinecraftKey("textures/entity/cat/tabby.png"));
        hashmap.put(1, new MinecraftKey("textures/entity/cat/black.png"));
        hashmap.put(2, new MinecraftKey("textures/entity/cat/red.png"));
        hashmap.put(3, new MinecraftKey("textures/entity/cat/siamese.png"));
        hashmap.put(4, new MinecraftKey("textures/entity/cat/british_shorthair.png"));
        hashmap.put(5, new MinecraftKey("textures/entity/cat/calico.png"));
        hashmap.put(6, new MinecraftKey("textures/entity/cat/persian.png"));
        hashmap.put(7, new MinecraftKey("textures/entity/cat/ragdoll.png"));
        hashmap.put(8, new MinecraftKey("textures/entity/cat/white.png"));
        hashmap.put(9, new MinecraftKey("textures/entity/cat/jellie.png"));
        hashmap.put(10, new MinecraftKey("textures/entity/cat/all_black.png"));
    });
    private a<EntityHuman> cu;
    @Nullable
    private PathfinderGoalTempt cv;
    private float cw;
    private float cx;
    private float cy;
    private float cz;
    private float cA;
    private float cB;

    public EntityCat(EntityTypes<? extends EntityCat> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
    }

    public MinecraftKey fH() {
        return cm.getOrDefault(this.fI(), cm.get(0));
    }

    @Override
    protected void u() {
        this.cv = new PathfinderGoalTemptChance(this, 0.6, cn, true);
        this.bQ.a(1, new PathfinderGoalFloat(this));
        this.bQ.a(1, new PathfinderGoalSit(this));
        this.bQ.a(2, new b(this));
        this.bQ.a(3, this.cv);
        this.bQ.a(5, new PathfinderGoalCatSitOnBed(this, 1.1, 8));
        this.bQ.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 5.0f, false));
        this.bQ.a(7, new PathfinderGoalJumpOnBlock(this, 0.8));
        this.bQ.a(8, new PathfinderGoalLeapAtTarget(this, 0.3f));
        this.bQ.a(9, new PathfinderGoalOcelotAttack(this));
        this.bQ.a(10, new PathfinderGoalBreed(this, 0.8));
        this.bQ.a(11, new PathfinderGoalRandomStrollLand((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.bQ.a(12, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 10.0f));
        this.bR.a(1, new PathfinderGoalRandomTargetNonTamed<EntityRabbit>(this, EntityRabbit.class, false, (Predicate<EntityLiving>)null));
        this.bR.a(1, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bW));
    }

    public int fI() {
        return this.Y.a(co);
    }

    public void s(int type) {
        if (type < 0 || type >= 11) {
            type = this.R.nextInt(10);
        }
        this.Y.b(co, type);
    }

    public void z(boolean sleeping) {
        this.Y.b(cp, sleeping);
    }

    public boolean fJ() {
        return this.Y.a(cp);
    }

    public void A(boolean headDown) {
        this.Y.b(cq, headDown);
    }

    public boolean fK() {
        return this.Y.a(cq);
    }

    public EnumColor fL() {
        return EnumColor.a(this.Y.a(cr));
    }

    public void a(EnumColor color) {
        this.Y.b(cr, color.a());
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(co, 1);
        this.Y.a(cp, false);
        this.Y.a(cq, false);
        this.Y.a(cr, EnumColor.o.a());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("CatType", this.fI());
        nbt.a("CollarColor", (byte)this.fL().a());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.s(nbt.h("CatType"));
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
    }

    @Override
    public void R() {
        if (this.A().b()) {
            double d0 = this.A().c();
            if (d0 == 0.6) {
                this.b(EntityPose.f);
                this.g(false);
            } else if (d0 == 1.33) {
                this.b(EntityPose.a);
                this.g(true);
            } else {
                this.b(EntityPose.a);
                this.g(false);
            }
        } else {
            this.b(EntityPose.a);
            this.g(false);
        }
    }

    @Override
    @Nullable
    protected SoundEffect r() {
        return this.q() ? (this.fF() ? SoundEffects.cB : (this.R.nextInt(4) == 0 ? SoundEffects.cC : SoundEffects.cu)) : SoundEffects.cv;
    }

    @Override
    public int J() {
        return 120;
    }

    public void fM() {
        this.a(SoundEffects.cy, this.ev(), this.ew());
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.cA;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.cw;
    }

    public static AttributeProvider.Builder fN() {
        return EntityInsentient.w().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.f, 3.0);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (this.n(stack)) {
            this.a(SoundEffects.cx, 1.0f, 1.0f);
        }
        super.a(player, hand, stack);
    }

    private float fO() {
        return (float)this.b(GenericAttributes.f);
    }

    @Override
    public boolean z(Entity target) {
        return target.a(DamageSource.c(this), this.fO());
    }

    @Override
    public void k() {
        super.k();
        if (this.cv != null && this.cv.i() && !this.q() && this.S % 100 == 0) {
            this.a(SoundEffects.cz, 1.0f, 1.0f);
        }
        this.fP();
    }

    private void fP() {
        if ((this.fJ() || this.fK()) && this.S % 5 == 0) {
            this.a(SoundEffects.cB, 0.6f + 0.4f * (this.R.nextFloat() - this.R.nextFloat()), 1.0f);
        }
        this.fQ();
        this.fR();
    }

    private void fQ() {
        this.cx = this.cw;
        this.cz = this.cy;
        if (this.fJ()) {
            this.cw = Math.min(1.0f, this.cw + 0.15f);
            this.cy = Math.min(1.0f, this.cy + 0.08f);
        } else {
            this.cw = Math.max(0.0f, this.cw - 0.22f);
            this.cy = Math.max(0.0f, this.cy - 0.13f);
        }
    }

    private void fR() {
        this.cB = this.cA;
        this.cA = this.fK() ? Math.min(1.0f, this.cA + 0.1f) : Math.max(0.0f, this.cA - 0.13f);
    }

    public float z(float tickDelta) {
        return MathHelper.i(tickDelta, this.cx, this.cw);
    }

    public float A(float tickDelta) {
        return MathHelper.i(tickDelta, this.cz, this.cy);
    }

    public float B(float tickDelta) {
        return MathHelper.i(tickDelta, this.cB, this.cA);
    }

    public EntityCat b(WorldServer world, EntityAgeable entity) {
        EntityCat entitycat = EntityTypes.j.a(world);
        if (entity instanceof EntityCat) {
            if (this.R.nextBoolean()) {
                entitycat.s(this.fI());
            } else {
                entitycat.s(((EntityCat)entity).fI());
            }
            if (this.q()) {
                entitycat.b(this.d());
                entitycat.w(true);
                if (this.R.nextBoolean()) {
                    entitycat.a(this.fL());
                } else {
                    entitycat.a(((EntityCat)entity).fL());
                }
            }
        }
        return entitycat;
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (!this.q()) {
            return false;
        }
        if (!(other instanceof EntityCat)) {
            return false;
        }
        EntityCat entitycat = (EntityCat)other;
        return entitycat.q() && super.a(other);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        WorldServer worldserver1;
        IRegistry<StructureFeature<?, ?>> iregistry;
        entityData = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        if (world.ak() > 0.9f) {
            this.s(this.R.nextInt(11));
        } else {
            this.s(this.R.nextInt(10));
        }
        WorldServer worldserver = world.F();
        if (worldserver instanceof WorldServer && ChunkGenerator.a(iregistry = (worldserver1 = worldserver).s().d(IRegistry.aL), StructureGenerator.j).anyMatch(structurefeature -> worldserver1.a().getStructureWithPieceAt(this.cW(), (StructureFeature<?, ?>)structurefeature, world).b())) {
            this.s(10);
            this.fh();
        }
        return entityData;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.c();
        if (this.s.x) {
            return this.q() && this.j(player) ? EnumInteractionResult.a : (this.n(itemstack) && (this.ea() < this.em() || !this.q()) ? EnumInteractionResult.a : EnumInteractionResult.d);
        }
        if (this.q()) {
            if (this.j(player)) {
                if (!(item instanceof ItemDye)) {
                    if (item.v() && this.n(itemstack) && this.ea() < this.em()) {
                        this.a(player, hand, itemstack);
                        this.b(item.w().a());
                        return EnumInteractionResult.b;
                    }
                    EnumInteractionResult enuminteractionresult2 = super.b(player, hand);
                    if (!enuminteractionresult2.a() || this.y_()) {
                        this.y(!this.fB());
                    }
                    return enuminteractionresult2;
                }
                EnumColor enumcolor = ((ItemDye)item).d();
                if (enumcolor != this.fL()) {
                    this.a(enumcolor);
                    if (!player.fs().d) {
                        itemstack.g(1);
                    }
                    this.fh();
                    return EnumInteractionResult.b;
                }
            }
        } else if (this.n(itemstack)) {
            this.a(player, hand, itemstack);
            if (this.R.nextInt(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                this.f(player);
                this.y(true);
                this.s.a((Entity)this, (byte)7);
            } else {
                this.s.a((Entity)this, (byte)6);
            }
            this.fh();
            return EnumInteractionResult.b;
        }
        if ((enuminteractionresult = super.b(player, hand)).a()) {
            this.fh();
        }
        return enuminteractionresult;
    }

    @Override
    public boolean n(ItemStack stack) {
        return cn.a(stack);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.5f;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.q() && this.S > 2400;
    }

    @Override
    protected void t() {
        if (this.cu == null) {
            this.cu = new a<EntityHuman>(this, EntityHuman.class, 16.0f, 0.8, 1.33);
        }
        this.bQ.a(this.cu);
        if (!this.q()) {
            this.bQ.a(4, this.cu);
        }
    }

    @Override
    public boolean bJ() {
        return this.ak() == EntityPose.f || super.bJ();
    }

    private static class PathfinderGoalTemptChance
    extends PathfinderGoalTempt {
        @Nullable
        private EntityLiving selectedPlayer;
        private final EntityCat d;

        public PathfinderGoalTemptChance(EntityCat cat, double speed, RecipeItemStack food, boolean canBeScared) {
            super(cat, speed, food, canBeScared);
            this.d = cat;
        }

        @Override
        public void e() {
            super.e();
            if (this.selectedPlayer == null && this.a.dL().nextInt(this.a(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.a.dL().nextInt(this.a(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        @Override
        protected boolean h() {
            return this.selectedPlayer != null && this.selectedPlayer.equals(this.player) ? false : super.h();
        }

        @Override
        public boolean a() {
            return super.a() && !this.d.q();
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityCat a;
        @Nullable
        private EntityHuman b;
        @Nullable
        private BlockPosition c;
        private int d;

        public b(EntityCat cat) {
            this.a = cat;
        }

        @Override
        public boolean a() {
            if (!this.a.q()) {
                return false;
            }
            if (this.a.fB()) {
                return false;
            }
            EntityLiving entityliving = this.a.fA();
            if (entityliving instanceof EntityHuman) {
                this.b = (EntityHuman)entityliving;
                if (!entityliving.fc()) {
                    return false;
                }
                if (this.a.f((Entity)this.b) > 100.0) {
                    return false;
                }
                BlockPosition blockposition = this.b.cW();
                IBlockData iblockdata = this.a.s.a_(blockposition);
                if (iblockdata.a(TagsBlock.K)) {
                    this.c = iblockdata.d(BlockFacingHorizontal.aD).map(enumdirection -> blockposition.a(enumdirection.f())).orElseGet(() -> new BlockPosition(blockposition));
                    return !this.h();
                }
            }
            return false;
        }

        private boolean h() {
            EntityCat entitycat;
            List<EntityCat> list = this.a.s.a(EntityCat.class, new AxisAlignedBB(this.c).g(2.0));
            Iterator<EntityCat> iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((entitycat = iterator.next()) == this.a || !entitycat.fJ() && !entitycat.fK());
            return true;
        }

        @Override
        public boolean b() {
            return this.a.q() && !this.a.fB() && this.b != null && this.b.fc() && this.c != null && !this.h();
        }

        @Override
        public void c() {
            if (this.c != null) {
                this.a.x(false);
                this.a.D().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
            }
        }

        @Override
        public void d() {
            this.a.z(false);
            float f2 = this.a.s.f(1.0f);
            if (this.b.fu() >= 100 && (double)f2 > 0.77 && (double)f2 < 0.8 && (double)this.a.s.r_().nextFloat() < 0.7) {
                this.i();
            }
            this.d = 0;
            this.a.A(false);
            this.a.D().n();
        }

        private void i() {
            Random random = this.a.dL();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            blockposition_mutableblockposition.g(this.a.cW());
            this.a.a((double)(blockposition_mutableblockposition.u() + random.nextInt(11) - 5), (double)(blockposition_mutableblockposition.v() + random.nextInt(5) - 2), (double)(blockposition_mutableblockposition.w() + random.nextInt(11) - 5), false);
            blockposition_mutableblockposition.g(this.a.cW());
            LootTable loottable = this.a.s.n().aF().a(LootTables.ak);
            LootTableInfo.Builder loottableinfo_builder = new LootTableInfo.Builder((WorldServer)this.a.s).a(LootContextParameters.f, this.a.cV()).a(LootContextParameters.a, this.a).a(random);
            List<ItemStack> list = loottable.a(loottableinfo_builder.a(LootContextParameterSets.g));
            for (ItemStack itemstack : list) {
                EntityItem entityitem = new EntityItem(this.a.s, (double)blockposition_mutableblockposition.u() - (double)MathHelper.a(this.a.aX * ((float)Math.PI / 180)), blockposition_mutableblockposition.v(), (double)blockposition_mutableblockposition.w() + (double)MathHelper.b(this.a.aX * ((float)Math.PI / 180)), itemstack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), (org.bukkit.entity.Item)entityitem.getBukkitEntity());
                entityitem.s.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                this.a.s.b(entityitem);
            }
        }

        @Override
        public void e() {
            if (this.b != null && this.c != null) {
                this.a.x(false);
                this.a.D().a((double)this.c.u(), (double)this.c.v(), (double)this.c.w(), 1.1f);
                if (this.a.f((Entity)this.b) < 2.5) {
                    ++this.d;
                    if (this.d > this.a(16)) {
                        this.a.z(true);
                        this.a.A(false);
                    } else {
                        this.a.a((Entity)this.b, 45.0f, 45.0f);
                        this.a.A(true);
                    }
                } else {
                    this.a.z(false);
                }
            }
        }
    }

    private static class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityCat i;

        public a(EntityCat cat, Class<T> fleeFromType, float distance, double slowSpeed, double fastSpeed) {
            super(cat, fleeFromType, distance, slowSpeed, fastSpeed, IEntitySelector.e::test);
            this.i = cat;
        }

        @Override
        public boolean a() {
            return !this.i.q() && super.a();
        }

        @Override
        public boolean b() {
            return !this.i.q() && super.b();
        }
    }
}

