/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TimeRange;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityBee
extends EntityAnimal
implements IEntityAngerable,
EntityBird {
    public static final float bV = 120.32113f;
    public static final int bW = MathHelper.f(1.4959966f);
    private static final DataWatcherObject<Byte> cf = DataWatcher.a(EntityBee.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> cg = DataWatcher.a(EntityBee.class, DataWatcherRegistry.b);
    private static final int ch = 2;
    private static final int ci = 4;
    private static final int cj = 8;
    private static final int ck = 1200;
    private static final int cl = 2400;
    private static final int cm = 3600;
    private static final int cn = 4;
    private static final int co = 10;
    private static final int cp = 10;
    private static final int cq = 18;
    private static final int cr = 32;
    private static final int cs = 2;
    private static final int ct = 16;
    private static final int cu = 20;
    public static final String bY = "CropsGrownSincePollination";
    public static final String bZ = "CannotEnterHiveTicks";
    public static final String ca = "TicksSincePollination";
    public static final String cb = "HasStung";
    public static final String cc = "HasNectar";
    public static final String cd = "FlowerPos";
    public static final String ce = "HivePos";
    private static final UniformInt cv = TimeRange.a(20, 39);
    @Nullable
    private UUID cw;
    private float cx;
    private float cy;
    private int cz;
    int cA;
    public int cB;
    private int cC;
    private static final int cD = 200;
    int cE;
    private static final int cF = 200;
    int cG;
    @Nullable
    BlockPosition cH;
    @Nullable
    public BlockPosition cI;
    k cJ;
    e cK;
    private f cL;
    private int cM;
    public TriState rollingOverride = TriState.NOT_SET;

    public EntityBee(EntityTypes<? extends EntityBee> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.cG = MathHelper.a(this.R, 20, 60);
        class BeeFlyingMoveControl
        extends ControllerMoveFlying {
            public BeeFlyingMoveControl(EntityInsentient entity, int maxPitchChange, boolean noGravity) {
                super(entity, maxPitchChange, noGravity);
            }

            @Override
            public void a() {
                if (this.d.de() <= (double)EntityBee.this.s.u_()) {
                    this.d.e(false);
                }
                super.a();
            }
        }
        this.bN = new BeeFlyingMoveControl(this, 20, true);
        this.bM = new j(this);
        this.a(PathType.n, -1.0f);
        this.a(PathType.j, -1.0f);
        this.a(PathType.k, 16.0f);
        this.a(PathType.z, -1.0f);
        this.a(PathType.h, -1.0f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.Y.a(cf, (byte)0);
        this.Y.a(cg, 0);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos).g() ? 10.0f : 0.0f;
    }

    @Override
    protected void u() {
        this.bQ.a(0, new b(this, 1.4f, true));
        this.bQ.a(1, new d());
        this.bQ.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bQ.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(TagsItem.L), false));
        this.cJ = new k();
        this.bQ.a(4, this.cJ);
        this.bQ.a(5, new PathfinderGoalFollowParent(this, 1.25));
        this.bQ.a(5, new i());
        this.cK = new e();
        this.bQ.a(5, this.cK);
        this.cL = new f();
        this.bQ.a(6, this.cL);
        this.bQ.a(7, new g());
        this.bQ.a(8, new l());
        this.bQ.a(9, new PathfinderGoalFloat(this));
        this.bR.a(1, new h(this).a(new Class[0]));
        this.bR.a(2, new c(this));
        this.bR.a(3, new PathfinderGoalUniversalAngerReset<EntityBee>(this, true));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.fH()) {
            nbt.a(ce, GameProfileSerializer.a(this.fI()));
        }
        if (this.t()) {
            nbt.a(cd, GameProfileSerializer.a(this.q()));
        }
        nbt.a(cc, this.fK());
        nbt.a(cb, this.fL());
        nbt.a(ca, this.cA);
        nbt.a(bZ, this.cB);
        nbt.a(bY, this.cC);
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.cI = null;
        if (nbt.e(ce)) {
            this.cI = GameProfileSerializer.b(nbt.p(ce));
        }
        this.cH = null;
        if (nbt.e(cd)) {
            this.cH = GameProfileSerializer.b(nbt.p(cd));
        }
        super.a(nbt);
        this.v(nbt.q(cc));
        this.w(nbt.q(cb));
        this.cA = nbt.h(ca);
        this.cB = nbt.h(bZ);
        this.cC = nbt.h(bY);
        this.a(this.s, nbt);
    }

    @Override
    public boolean z(Entity target) {
        boolean flag = target.a(DamageSource.b(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
            if (target instanceof EntityLiving) {
                ((EntityLiving)target).q(((EntityLiving)target).eo() + 1);
                int b0 = 0;
                if (this.s.af() == EnumDifficulty.c) {
                    b0 = 10;
                } else if (this.s.af() == EnumDifficulty.d) {
                    b0 = 18;
                }
                if (b0 > 0) {
                    ((EntityLiving)target).addEffect(new MobEffect(MobEffects.s, b0 * 20, 0), this, EntityPotionEffectEvent.Cause.ATTACK);
                }
            }
            this.w(true);
            this.H_();
            this.a(SoundEffects.bg, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void k() {
        super.k();
        if (this.fK() && this.fT() < 10 && this.R.nextFloat() < 0.05f) {
            for (int i2 = 0; i2 < this.R.nextInt(2) + 1; ++i2) {
                this.a(this.s, this.dc() - (double)0.3f, this.dc() + (double)0.3f, this.di() - (double)0.3f, this.di() + (double)0.3f, this.e(0.5), Particles.an);
            }
        }
        this.fR();
    }

    private void a(World world, double lastX, double x2, double lastZ, double z2, double y2, ParticleParam effect) {
        world.a(effect, MathHelper.d(world.v.nextDouble(), lastX, x2), y2, MathHelper.d(world.v.nextDouble(), lastZ, z2), 0.0, 0.0, 0.0);
    }

    void h(BlockPosition pos) {
        Vec3D vec3d1;
        Vec3D vec3d = Vec3D.c(pos);
        int b0 = 0;
        BlockPosition blockposition1 = this.cW();
        int i2 = (int)vec3d.c - blockposition1.v();
        if (i2 > 2) {
            b0 = 4;
        } else if (i2 < -2) {
            b0 = -4;
        }
        int j2 = 6;
        int k2 = 8;
        int l2 = blockposition1.k(pos);
        if (l2 < 15) {
            j2 = l2 / 2;
            k2 = l2 / 2;
        }
        if ((vec3d1 = AirRandomPos.a(this, j2, k2, b0, vec3d, 0.3141592741012573)) != null) {
            this.bP.a(0.5f);
            this.bP.a(vec3d1.b, vec3d1.c, vec3d1.d, 1.0);
        }
    }

    @Nullable
    public BlockPosition q() {
        return this.cH;
    }

    public boolean t() {
        return this.cH != null;
    }

    public void g(BlockPosition flowerPos) {
        this.cH = flowerPos;
    }

    @VisibleForDebug
    public int fz() {
        return Math.max(this.cK.d, this.cL.d);
    }

    @VisibleForDebug
    public List<BlockPosition> fA() {
        return this.cK.f;
    }

    private boolean fP() {
        return this.cA > 3600;
    }

    boolean fQ() {
        if (this.cB <= 0 && !this.cJ.l() && !this.fL() && this.G() == null) {
            boolean flag = this.fP() || this.s.Y() || this.s.P() || this.fK();
            return flag && !this.fS();
        }
        return false;
    }

    public void s(int cannotEnterHiveTicks) {
        this.cB = cannotEnterHiveTicks;
    }

    public float z(float tickDelta) {
        return MathHelper.i(tickDelta, this.cy, this.cx);
    }

    private void fR() {
        this.cy = this.cx;
        this.cx = this.fX() ? Math.min(1.0f, this.cx + 0.2f) : Math.max(0.0f, this.cx - 0.24f);
    }

    @Override
    protected void R() {
        boolean flag = this.fL();
        this.cM = this.aT() ? ++this.cM : 0;
        if (this.cM > 20) {
            this.a(DamageSource.h, 1.0f);
        }
        if (flag) {
            ++this.cz;
            if (this.cz % 5 == 0 && this.R.nextInt(MathHelper.a(1200 - this.cz, 1, 1200)) == 0) {
                this.a(DamageSource.n, this.ea());
            }
        }
        if (!this.fK()) {
            ++this.cA;
        }
        if (!this.s.x) {
            this.a((WorldServer)this.s, false);
        }
    }

    public void fB() {
        this.cA = 0;
    }

    private boolean fS() {
        if (this.cI == null) {
            return false;
        }
        if (!this.s.isLoadedAndInBounds(this.cI)) {
            return false;
        }
        TileEntity tileentity = this.s.c_(this.cI);
        return tileentity instanceof TileEntityBeehive && ((TileEntityBeehive)tileentity).c();
    }

    @Override
    public int a() {
        return this.Y.a(cg);
    }

    @Override
    public void a(int angerTime) {
        this.Y.b(cg, angerTime);
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cw;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cw = angryAt;
    }

    @Override
    public void c() {
        this.a(cv.a(this.R));
    }

    private boolean i(BlockPosition pos) {
        if (!this.s.isLoadedAndInBounds(pos)) {
            return false;
        }
        TileEntity tileentity = this.s.c_(pos);
        return tileentity instanceof TileEntityBeehive ? !((TileEntityBeehive)tileentity).f() : false;
    }

    @VisibleForDebug
    public boolean fH() {
        return this.cI != null;
    }

    @Nullable
    @VisibleForDebug
    public BlockPosition fI() {
        return this.cI;
    }

    @VisibleForDebug
    public PathfinderGoalSelector fJ() {
        return this.bQ;
    }

    @Override
    protected void Q() {
        super.Q();
        PacketDebug.a(this);
    }

    int fT() {
        return this.cC;
    }

    private void fU() {
        this.cC = 0;
    }

    void fV() {
        ++this.cC;
    }

    @Override
    public void w_() {
        super.w_();
        if (!this.s.x) {
            if (this.cB > 0) {
                --this.cB;
            }
            if (this.cE > 0) {
                --this.cE;
            }
            if (this.cG > 0) {
                --this.cG;
            }
            boolean flag = this.I_() && !this.fL() && this.G() != null && this.G().f((Entity)this) < 4.0;
            this.x(flag);
            if (this.S % 20 == 0 && !this.fW()) {
                this.cI = null;
            }
        }
    }

    boolean fW() {
        if (!this.fH()) {
            return false;
        }
        if (this.s.getChunkIfLoadedImmediately(this.cI.u() >> 4, this.cI.w() >> 4) == null) {
            return true;
        }
        TileEntity tileentity = this.s.c_(this.cI);
        return tileentity != null && tileentity.u() == TileEntityTypes.G;
    }

    public boolean fK() {
        return this.t(8);
    }

    public void v(boolean hasNectar) {
        if (hasNectar) {
            this.fB();
        }
        this.d(8, hasNectar);
    }

    public boolean fL() {
        return this.t(4);
    }

    public void w(boolean hasStung) {
        this.d(4, hasStung);
    }

    public boolean fX() {
        return this.t(2);
    }

    public void x(boolean nearTarget) {
        nearTarget = this.rollingOverride.toBooleanOrElse(nearTarget);
        this.d(2, nearTarget);
    }

    boolean j(BlockPosition pos) {
        return !this.b(pos, 32);
    }

    private void d(int bit, boolean value) {
        if (value) {
            this.Y.b(cf, (byte)(this.Y.a(cf) | bit));
        } else {
            this.Y.b(cf, (byte)(this.Y.a(cf) & ~bit));
        }
    }

    private boolean t(int location) {
        return (this.Y.a(cf) & location) != 0;
    }

    public static AttributeProvider.Builder fM() {
        return EntityInsentient.w().a(GenericAttributes.a, 10.0).a(GenericAttributes.e, 0.6f).a(GenericAttributes.d, 0.3f).a(GenericAttributes.f, 2.0).a(GenericAttributes.b, 48.0);
    }

    @Override
    protected NavigationAbstract a(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world){

            @Override
            public boolean a(BlockPosition pos) {
                return !this.b.a_(pos.c()).g();
            }

            @Override
            public void c() {
                if (!EntityBee.this.cJ.l()) {
                    super.c();
                }
            }
        };
        navigationflying.a(false);
        navigationflying.d(false);
        navigationflying.b(true);
        return navigationflying;
    }

    @Override
    public boolean n(ItemStack stack) {
        return stack.a(TagsItem.L);
    }

    boolean k(BlockPosition pos) {
        return this.s.n(pos) && this.s.a_(pos).a(TagsBlock.N);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    protected SoundEffect r() {
        return null;
    }

    @Override
    protected SoundEffect c(DamageSource source) {
        return SoundEffects.bd;
    }

    @Override
    public SoundEffect x_() {
        return SoundEffects.bc;
    }

    @Override
    public float ev() {
        return 0.4f;
    }

    public EntityBee b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.g.a(world);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.y_() ? dimensions.b * 0.5f : dimensions.b * 0.5f;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData landedState, BlockPosition landedPosition) {
    }

    @Override
    public boolean aK() {
        return this.fN() && this.S % bW == 0;
    }

    @Override
    public boolean fN() {
        return !this.y;
    }

    public void fO() {
        this.v(false);
        this.fU();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        boolean result = super.a(source, amount);
        if (result && !this.s.x) {
            this.cJ.m();
        }
        return result;
    }

    @Override
    public EnumMonsterType er() {
        return EnumMonsterType.c;
    }

    @Override
    protected void c(TagKey<FluidType> fluid) {
        this.g(this.da().b(0.0, 0.01, 0.0));
    }

    @Override
    public Vec3D cz() {
        return new Vec3D(0.0, 0.5f * this.cy(), this.cT() * 0.2f);
    }

    boolean b(BlockPosition pos, int distance) {
        return pos.a(this.cW(), (double)distance);
    }

    private class j
    extends ControllerLook {
        j(EntityInsentient entity) {
            super(entity);
        }

        @Override
        public void a() {
            if (!EntityBee.this.I_()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityBee.this.cJ.l();
        }
    }

    private class b
    extends PathfinderGoalMeleeAttack {
        b(EntityCreature mob, double speed, boolean pauseWhenMobIdle) {
            super(mob, speed, pauseWhenMobIdle);
        }

        @Override
        public boolean a() {
            return super.a() && EntityBee.this.I_() && !EntityBee.this.fL();
        }

        @Override
        public boolean b() {
            return super.b() && EntityBee.this.I_() && !EntityBee.this.fL();
        }
    }

    private class d
    extends a {
        d() {
        }

        @Override
        public boolean h() {
            if (EntityBee.this.fH() && EntityBee.this.fQ() && EntityBee.this.cI.a(EntityBee.this.cV(), 2.0)) {
                if (!EntityBee.this.s.isLoadedAndInBounds(EntityBee.this.cI)) {
                    return false;
                }
                TileEntity tileentity = EntityBee.this.s.c_(EntityBee.this.cI);
                if (tileentity instanceof TileEntityBeehive) {
                    TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                    if (!tileentitybeehive.f()) {
                        return true;
                    }
                    EntityBee.this.cI = null;
                }
            }
            return false;
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void c() {
            if (!EntityBee.this.s.isLoadedAndInBounds(EntityBee.this.cI)) {
                return;
            }
            TileEntity tileentity = EntityBee.this.s.c_(EntityBee.this.cI);
            if (tileentity instanceof TileEntityBeehive) {
                TileEntityBeehive tileentitybeehive = (TileEntityBeehive)tileentity;
                tileentitybeehive.a(EntityBee.this, EntityBee.this.fK());
            }
        }
    }

    private class k
    extends a {
        private static final int c = 400;
        private static final int d = 20;
        private static final int e = 60;
        private final Predicate<IBlockData> f;
        private static final double g = 0.1;
        private static final int h = 25;
        private static final float i = 0.35f;
        private static final float j = 0.6f;
        private static final float k = 0.33333334f;
        private int l;
        private int m;
        private boolean n;
        @Nullable
        private Vec3D o;
        private int p;
        private static final int q = 600;

        k() {
            this.f = iblockdata -> iblockdata.a(TagsBlock.N) ? (iblockdata.a(Blocks.hi) ? iblockdata.c(BlockTallPlant.a) == BlockPropertyDoubleBlockHalf.a : true) : false;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            if (EntityBee.this.cG > 0) {
                return false;
            }
            if (EntityBee.this.fK()) {
                return false;
            }
            if (EntityBee.this.s.Y()) {
                return false;
            }
            Optional<BlockPosition> optional = this.p();
            if (optional.isPresent()) {
                EntityBee.this.cH = optional.get();
                EntityBee.this.bP.a((double)EntityBee.this.cH.u() + 0.5, (double)EntityBee.this.cH.v() + 0.5, (double)EntityBee.this.cH.w() + 0.5, 1.2f);
                return true;
            }
            EntityBee.this.cG = MathHelper.a(EntityBee.this.R, 20, 60);
            return false;
        }

        @Override
        public boolean i() {
            if (!this.n) {
                return false;
            }
            if (!EntityBee.this.t()) {
                return false;
            }
            if (EntityBee.this.s.Y()) {
                return false;
            }
            if (this.k()) {
                return EntityBee.this.R.nextFloat() < 0.2f;
            }
            if (EntityBee.this.S % 20 == 0 && !EntityBee.this.k(EntityBee.this.cH)) {
                EntityBee.this.cH = null;
                return false;
            }
            return true;
        }

        private boolean k() {
            return this.l > 400;
        }

        boolean l() {
            return this.n;
        }

        void m() {
            this.n = false;
        }

        @Override
        public void c() {
            this.l = 0;
            this.p = 0;
            this.m = 0;
            this.n = true;
            EntityBee.this.fB();
        }

        @Override
        public void d() {
            if (this.k()) {
                EntityBee.this.v(true);
            }
            this.n = false;
            EntityBee.this.bP.n();
            EntityBee.this.cG = 200;
        }

        @Override
        public boolean E_() {
            return true;
        }

        @Override
        public void e() {
            ++this.p;
            if (this.p > 600) {
                EntityBee.this.cH = null;
            } else {
                Vec3D vec3d = Vec3D.c(EntityBee.this.cH).b(0.0, 0.6f, 0.0);
                if (vec3d.f(EntityBee.this.cV()) > 1.0) {
                    this.o = vec3d;
                    this.n();
                } else {
                    if (this.o == null) {
                        this.o = vec3d;
                    }
                    boolean flag = EntityBee.this.cV().f(this.o) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.p > 600) {
                        EntityBee.this.cH = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = EntityBee.this.R.nextInt(25) == 0;
                            if (flag2) {
                                this.o = new Vec3D(vec3d.a() + (double)this.o(), vec3d.b(), vec3d.c() + (double)this.o());
                                EntityBee.this.bP.n();
                            } else {
                                flag1 = false;
                            }
                            EntityBee.this.z().a(vec3d.a(), vec3d.b(), vec3d.c());
                        }
                        if (flag1) {
                            this.n();
                        }
                        ++this.l;
                        if (EntityBee.this.R.nextFloat() < 0.05f && this.l > this.m + 60) {
                            this.m = this.l;
                            EntityBee.this.a(SoundEffects.bh, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void n() {
            EntityBee.this.A().a(this.o.a(), this.o.b(), this.o.c(), 0.35f);
        }

        private float o() {
            return (EntityBee.this.R.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPosition> p() {
            return this.a(this.f, 5.0);
        }

        private Optional<BlockPosition> a(Predicate<IBlockData> predicate, double searchDistance) {
            BlockPosition blockposition = EntityBee.this.cW();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            int i2 = 0;
            while ((double)i2 <= searchDistance) {
                int j2 = 0;
                while ((double)j2 < searchDistance) {
                    int k2 = 0;
                    while (k2 <= j2) {
                        int l2;
                        int n2 = l2 = k2 < j2 && k2 > -j2 ? j2 : 0;
                        while (l2 <= j2) {
                            blockposition_mutableblockposition.a(blockposition, k2, i2 - 1, l2);
                            if (blockposition.a(blockposition_mutableblockposition, searchDistance) && predicate.test(EntityBee.this.s.a_(blockposition_mutableblockposition))) {
                                return Optional.of(blockposition_mutableblockposition);
                            }
                            l2 = l2 > 0 ? -l2 : 1 - l2;
                        }
                        k2 = k2 > 0 ? -k2 : 1 - k2;
                    }
                    ++j2;
                }
                i2 = i2 > 0 ? -i2 : 1 - i2;
            }
            return Optional.empty();
        }
    }

    private class i
    extends a {
        i() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.cE == 0 && !EntityBee.this.fH() && EntityBee.this.fQ();
        }

        @Override
        public boolean i() {
            return false;
        }

        @Override
        public void c() {
            EntityBee.this.cE = 200;
            List<BlockPosition> list = this.k();
            if (!list.isEmpty()) {
                BlockPosition blockposition;
                Iterator<BlockPosition> iterator = list.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    EntityBee.this.cK.k();
                    EntityBee.this.cI = list.get(0);
                    return;
                } while (EntityBee.this.cK.b(blockposition = iterator.next()));
                EntityBee.this.cI = blockposition;
            }
        }

        private List<BlockPosition> k() {
            BlockPosition blockposition = EntityBee.this.cW();
            VillagePlace villageplace = ((WorldServer)EntityBee.this.s).z();
            Stream<VillagePlaceRecord> stream = villageplace.c(villageplacetype -> villageplacetype == VillagePlaceType.t || villageplacetype == VillagePlaceType.u, blockposition, 20, VillagePlace.Occupancy.c);
            return stream.map(VillagePlaceRecord::f).filter(EntityBee.this::i).sorted(Comparator.comparingDouble(blockposition1 -> blockposition1.j(blockposition))).collect(Collectors.toList());
        }
    }

    @VisibleForDebug
    public class e
    extends a {
        public static final int b = 600;
        int d;
        private static final int e = 3;
        final List<BlockPosition> f;
        @Nullable
        private PathEntity g;
        private static final int h = 60;
        private int i;

        e() {
            this.d = EntityBee.this.s.v.nextInt(10);
            this.f = Lists.newArrayList();
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cI != null && !EntityBee.this.fo() && EntityBee.this.fQ() && !this.d(EntityBee.this.cI) && EntityBee.this.s.a_(EntityBee.this.cI).a(TagsBlock.as);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void c() {
            this.d = 0;
            this.i = 0;
            super.c();
        }

        @Override
        public void d() {
            this.d = 0;
            this.i = 0;
            EntityBee.this.bP.n();
            EntityBee.this.bP.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.cI != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    this.l();
                } else if (!EntityBee.this.bP.m()) {
                    if (!EntityBee.this.b(EntityBee.this.cI, 16)) {
                        if (EntityBee.this.j(EntityBee.this.cI)) {
                            this.m();
                        } else {
                            EntityBee.this.h(EntityBee.this.cI);
                        }
                    } else {
                        boolean flag = this.a(EntityBee.this.cI);
                        if (!flag) {
                            this.l();
                        } else if (this.g != null && EntityBee.this.bP.j().a(this.g)) {
                            ++this.i;
                            if (this.i > 60) {
                                this.m();
                                this.i = 0;
                            }
                        } else {
                            this.g = EntityBee.this.bP.j();
                        }
                    }
                }
            }
        }

        private boolean a(BlockPosition pos) {
            EntityBee.this.bP.a(10.0f);
            EntityBee.this.bP.a((double)pos.u(), (double)pos.v(), (double)pos.w(), 1.0);
            return EntityBee.this.bP.j() != null && EntityBee.this.bP.j().j();
        }

        boolean b(BlockPosition pos) {
            return this.f.contains(pos);
        }

        private void c(BlockPosition pos) {
            this.f.add(pos);
            while (this.f.size() > 3) {
                this.f.remove(0);
            }
        }

        void k() {
            this.f.clear();
        }

        private void l() {
            if (EntityBee.this.cI != null) {
                this.c(EntityBee.this.cI);
            }
            this.m();
        }

        private void m() {
            EntityBee.this.cI = null;
            EntityBee.this.cE = 200;
        }

        private boolean d(BlockPosition pos) {
            if (EntityBee.this.b(pos, 2)) {
                return true;
            }
            PathEntity pathentity = EntityBee.this.bP.j();
            return pathentity != null && pathentity.m().equals(pos) && pathentity.j() && pathentity.c();
        }
    }

    public class f
    extends a {
        private static final int c = 600;
        int d;

        f() {
            this.d = EntityBee.this.s.v.nextInt(10);
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean h() {
            return EntityBee.this.cH != null && !EntityBee.this.fo() && this.k() && EntityBee.this.k(EntityBee.this.cH) && !EntityBee.this.b(EntityBee.this.cH, 2);
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void c() {
            this.d = 0;
            super.c();
        }

        @Override
        public void d() {
            this.d = 0;
            EntityBee.this.bP.n();
            EntityBee.this.bP.g();
        }

        @Override
        public void e() {
            if (EntityBee.this.cH != null) {
                ++this.d;
                if (this.d > this.a(600)) {
                    EntityBee.this.cH = null;
                } else if (!EntityBee.this.bP.m()) {
                    if (EntityBee.this.j(EntityBee.this.cH)) {
                        EntityBee.this.cH = null;
                    } else {
                        EntityBee.this.h(EntityBee.this.cH);
                    }
                }
            }
        }

        private boolean k() {
            return EntityBee.this.cA > 2400;
        }
    }

    private class g
    extends a {
        static final int b = 30;

        g() {
        }

        @Override
        public boolean h() {
            return EntityBee.this.fT() >= 10 ? false : (EntityBee.this.R.nextFloat() < 0.3f ? false : EntityBee.this.fK() && EntityBee.this.fW());
        }

        @Override
        public boolean i() {
            return this.h();
        }

        @Override
        public void e() {
            if (EntityBee.this.R.nextInt(this.a(30)) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    BlockPosition blockposition = EntityBee.this.cW().c(i2);
                    IBlockData iblockdata = EntityBee.this.s.a_(blockposition);
                    Block block = iblockdata.b();
                    boolean flag = false;
                    BlockStateInteger blockstateinteger = null;
                    if (!iblockdata.a(TagsBlock.au)) continue;
                    if (block instanceof BlockCrops) {
                        BlockCrops blockcrops = (BlockCrops)block;
                        if (!blockcrops.h(iblockdata)) {
                            flag = true;
                            blockstateinteger = blockcrops.c();
                        }
                    } else if (block instanceof BlockStem) {
                        int j2 = iblockdata.c(BlockStem.b);
                        if (j2 < 7) {
                            flag = true;
                            blockstateinteger = BlockStem.b;
                        }
                    } else if (iblockdata.a(Blocks.mu)) {
                        int j3 = iblockdata.c(BlockSweetBerryBush.b);
                        if (j3 < 3) {
                            flag = true;
                            blockstateinteger = BlockSweetBerryBush.b;
                        }
                    } else if (iblockdata.a(Blocks.pB) || iblockdata.a(Blocks.pC)) {
                        ((IBlockFragilePlantElement)((Object)iblockdata.b())).a((WorldServer)EntityBee.this.s, EntityBee.this.R, blockposition, iblockdata);
                    }
                    if (!flag || CraftEventFactory.callEntityChangeBlockEvent(EntityBee.this, blockposition, (IBlockData)iblockdata.a(blockstateinteger, iblockdata.c(blockstateinteger) + 1)).isCancelled()) continue;
                    EntityBee.this.s.c(2005, blockposition, 0);
                    EntityBee.this.s.b(blockposition, (IBlockData)iblockdata.a(blockstateinteger, iblockdata.c(blockstateinteger) + 1));
                    EntityBee.this.fV();
                }
            }
        }
    }

    private class l
    extends PathfinderGoal {
        private static final int b = 22;

        l() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityBee.this.bP.l() && EntityBee.this.R.nextInt(10) == 0;
        }

        @Override
        public boolean b() {
            return EntityBee.this.bP.m();
        }

        @Override
        public void c() {
            Vec3D vec3d = this.h();
            if (vec3d != null) {
                EntityBee.this.bP.a(EntityBee.this.bP.a(new BlockPosition(vec3d), 1), 1.0);
            }
        }

        @Nullable
        private Vec3D h() {
            Vec3D vec3d;
            if (EntityBee.this.fW() && !EntityBee.this.b(EntityBee.this.cI, 22)) {
                Vec3D vec3d1 = Vec3D.a(EntityBee.this.cI);
                vec3d = vec3d1.d(EntityBee.this.cV()).d();
            } else {
                vec3d = EntityBee.this.e(0.0f);
            }
            boolean flag = true;
            Vec3D vec3d2 = HoverRandomPos.a(EntityBee.this, 8, 7, vec3d.b, vec3d.d, 1.5707964f, 3, 1);
            return vec3d2 != null ? vec3d2 : AirAndWaterRandomPos.a(EntityBee.this, 8, 4, -2, vec3d.b, vec3d.d, 1.5707963705062866);
        }
    }

    private class h
    extends PathfinderGoalHurtByTarget {
        h(EntityBee entitybee) {
            super(entitybee, new Class[0]);
        }

        @Override
        public boolean b() {
            return EntityBee.this.I_() && super.b();
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityBee && this.e.B(target)) {
                mob.setTarget(target, EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY, true);
            }
        }
    }

    private static class c
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        c(EntityBee bee) {
            super(bee, EntityHuman.class, 10, true, false, bee::a_);
        }

        @Override
        public boolean a() {
            return this.i() && super.a();
        }

        @Override
        public boolean b() {
            boolean flag = this.i();
            if (flag && this.e.G() != null) {
                return super.b();
            }
            this.g = null;
            return false;
        }

        private boolean i() {
            EntityBee entitybee = (EntityBee)this.e;
            return entitybee.I_() && !entitybee.fL();
        }
    }

    private abstract class a
    extends PathfinderGoal {
        a() {
        }

        public abstract boolean h();

        public abstract boolean i();

        @Override
        public boolean a() {
            return this.h() && !EntityBee.this.I_();
        }

        @Override
        public boolean b() {
            return this.i() && !EntityBee.this.I_();
        }
    }
}

