/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    static final int bX = 6000;
    public int bV;
    @Nullable
    public UUID bW;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    protected void R() {
        if (this.j() != 0) {
            this.bV = 0;
        }
        super.R();
    }

    @Override
    public void w_() {
        super.w_();
        if (this.j() != 0) {
            this.bV = 0;
        }
        if (this.bV > 0) {
            --this.bV;
            if (this.bV % 10 == 0) {
                double d0 = this.R.nextGaussian() * 0.02;
                double d1 = this.R.nextGaussian() * 0.02;
                double d2 = this.R.nextGaussian() * 0.02;
                this.s.a(Particles.H, this.d(1.0), this.df() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos.c()).a(Blocks.i) ? 10.0f : world.y(pos) - 0.5f;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("InLove", this.bV);
        if (this.bW != null) {
            nbt.a("LoveCause", this.bW);
        }
    }

    @Override
    public double bp() {
        return 0.14;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.bV = nbt.h("InLove");
        this.bW = nbt.b("LoveCause") ? nbt.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, Random random) {
        return world.a_(pos.c()).a(TagsBlock.bs) && EntityAnimal.a(world, pos);
    }

    protected static boolean a(IBlockLightAccess world, BlockPosition pos) {
        return world.b(pos, 0) > 8;
    }

    @Override
    public int J() {
        return 120;
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    protected int d(EntityHuman player) {
        return 1 + this.s.v.nextInt(3);
    }

    public boolean n(ItemStack stack) {
        return stack.a(Items.ni);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.n(itemstack)) {
            int i2 = this.j();
            if (!this.s.x && i2 == 0 && this.fC()) {
                this.a(player, hand, itemstack);
                this.g(player);
                this.a(GameEvent.C, this.cY());
                return EnumInteractionResult.a;
            }
            if (this.y_()) {
                this.a(player, hand, itemstack);
                this.a((int)((float)(-i2 / 20) * 0.1f), true);
                this.a(GameEvent.C, this.cY());
                return EnumInteractionResult.a(this.s.x);
            }
            if (this.s.x) {
                return EnumInteractionResult.b;
            }
        }
        return super.b(player, hand);
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (!player.fs().d) {
            stack.g(1);
        }
    }

    public boolean fC() {
        return this.bV <= 0;
    }

    public void g(@Nullable EntityHuman player) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.bV = entityEnterLoveModeEvent.getTicksInLove();
        if (player != null) {
            this.bW = player.cm();
        }
        this.breedItem = player.fr().f();
        this.s.a((Entity)this, (byte)18);
    }

    public void r(int loveTicks) {
        this.bV = loveTicks;
    }

    public int fD() {
        return this.bV;
    }

    @Nullable
    public EntityPlayer fE() {
        if (this.bW == null) {
            return null;
        }
        EntityHuman entityhuman = this.s.b(this.bW);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean fF() {
        return this.bV > 0;
    }

    public void fG() {
        this.bV = 0;
    }

    public boolean a(EntityAnimal other) {
        return other == this ? false : (other.getClass() != this.getClass() ? false : this.fF() && other.fF());
    }

    public void a(WorldServer world, EntityAnimal other) {
        EntityAgeable entityageable = this.a(world, (EntityAgeable)other);
        if (entityageable != null) {
            EntityPlayer entityplayer;
            if (entityageable instanceof EntityTameableAnimal && ((EntityTameableAnimal)entityageable).q()) {
                entityageable.setPersistenceRequired(true);
            }
            if ((entityplayer = this.fE()) == null && other.fE() != null) {
                entityplayer = other.fE();
            }
            entityageable.a(true);
            entityageable.b(this.dc(), this.de(), this.di(), 0.0f, 0.0f);
            int experience = this.dL().nextInt(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, other, entityplayer, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            if (entityplayer != null) {
                entityplayer.a(StatisticList.P);
                CriterionTriggers.o.a(entityplayer, this, other, entityageable);
            }
            this.b_(6000);
            other.b_(6000);
            this.fG();
            other.fG();
            world.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
            world.a((Entity)this, (byte)18);
            if (world.W().b(GameRules.f) && experience > 0) {
                world.b(new EntityExperienceOrb(world, this.dc(), this.de(), this.di(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityageable));
            }
        }
    }

    @Override
    public void a(byte status) {
        if (status == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.R.nextGaussian() * 0.02;
                double d1 = this.R.nextGaussian() * 0.02;
                double d2 = this.R.nextGaussian() * 0.02;
                this.s.a(Particles.H, this.d(1.0), this.df() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.a(status);
        }
    }
}

