/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import org.slf4j.Logger;

public class VillagePlaceSection {
    private static final Logger a = LogUtils.getLogger();
    private final Short2ObjectMap<VillagePlaceRecord> b = new Short2ObjectOpenHashMap();
    private final Map<VillagePlaceType, Set<VillagePlaceRecord>> c = Maps.newHashMap();
    private final Runnable d;
    private boolean e;

    public final Map<VillagePlaceType, Set<VillagePlaceRecord>> getData() {
        return this.c;
    }

    public static Codec<VillagePlaceSection> a(Runnable updateListener) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)updateListener), (App)Codec.BOOL.optionalFieldOf("Valid", (Object)false).forGetter(poiSet -> poiSet.e), (App)VillagePlaceRecord.a(updateListener).listOf().fieldOf("Records").forGetter(poiSet -> ImmutableList.copyOf((Collection)poiSet.b.values()))).apply((Applicative)instance, VillagePlaceSection::new)).orElseGet(SystemUtils.a("Failed to read POI section: ", arg_0 -> ((Logger)a).error(arg_0)), () -> new VillagePlaceSection(updateListener, false, (List<VillagePlaceRecord>)ImmutableList.of()));
    }

    public VillagePlaceSection(Runnable updateListener) {
        this(updateListener, true, (List<VillagePlaceRecord>)ImmutableList.of());
    }

    private VillagePlaceSection(Runnable updateListener, boolean valid, List<VillagePlaceRecord> pois) {
        this.d = updateListener;
        this.e = valid;
        pois.forEach(this::a);
    }

    public Stream<VillagePlaceRecord> a(Predicate<VillagePlaceType> predicate, VillagePlace.Occupancy occupationStatus) {
        return this.c.entrySet().stream().filter(entry -> predicate.test((VillagePlaceType)entry.getKey())).flatMap(entry -> ((Set)entry.getValue()).stream()).filter(occupationStatus.a());
    }

    public void a(BlockPosition pos, VillagePlaceType type) {
        if (this.a(new VillagePlaceRecord(pos, type, this.d))) {
            a.debug("Added POI of type {} @ {}", (Object)type, (Object)pos);
            this.d.run();
        }
    }

    private boolean a(VillagePlaceRecord poi) {
        BlockPosition blockPos = poi.f();
        VillagePlaceType poiType = poi.g();
        short s2 = SectionPosition.b(blockPos);
        VillagePlaceRecord poiRecord = (VillagePlaceRecord)this.b.get(s2);
        if (poiRecord != null) {
            if (poiType.equals(poiRecord.g())) {
                return false;
            }
            SystemUtils.a("POI data mismatch: already registered at " + blockPos);
        }
        this.b.put(s2, (Object)poi);
        this.c.computeIfAbsent(poiType, poiTypex -> Sets.newHashSet()).add(poi);
        return true;
    }

    public void a(BlockPosition pos) {
        VillagePlaceRecord poiRecord = (VillagePlaceRecord)this.b.remove(SectionPosition.b(pos));
        if (poiRecord == null) {
            a.error("POI data mismatch: never registered at {}", (Object)pos);
        } else {
            this.c.get(poiRecord.g()).remove(poiRecord);
            a.debug("Removed POI of type {} @ {}", LogUtils.defer(poiRecord::g), LogUtils.defer(poiRecord::f));
            this.d.run();
        }
    }

    @Deprecated
    @VisibleForDebug
    public int b(BlockPosition pos) {
        return this.e(pos).map(VillagePlaceRecord::a).orElse(0);
    }

    public boolean c(BlockPosition pos) {
        VillagePlaceRecord poiRecord = (VillagePlaceRecord)this.b.get(SectionPosition.b(pos));
        if (poiRecord == null) {
            throw SystemUtils.c(new IllegalStateException("POI never registered at " + pos));
        }
        boolean bl = poiRecord.c();
        this.d.run();
        return bl;
    }

    public boolean a(BlockPosition pos, Predicate<VillagePlaceType> predicate) {
        return this.d(pos).filter(predicate).isPresent();
    }

    public Optional<VillagePlaceType> d(BlockPosition pos) {
        return this.e(pos).map(VillagePlaceRecord::g);
    }

    private Optional<VillagePlaceRecord> e(BlockPosition pos) {
        return Optional.ofNullable((VillagePlaceRecord)this.b.get(SectionPosition.b(pos)));
    }

    public void a(Consumer<BiConsumer<BlockPosition, VillagePlaceType>> consumer) {
        if (!this.e) {
            Short2ObjectOpenHashMap short2ObjectMap = new Short2ObjectOpenHashMap(this.b);
            this.b();
            consumer.accept((arg_0, arg_1) -> this.a((Short2ObjectMap)short2ObjectMap, arg_0, arg_1));
            this.e = true;
            this.d.run();
        }
    }

    private void b() {
        this.b.clear();
        this.c.clear();
    }

    boolean a() {
        return this.e;
    }

    private /* synthetic */ void a(Short2ObjectMap short2ObjectMap, BlockPosition pos, VillagePlaceType poiType) {
        short s2 = SectionPosition.b(pos);
        VillagePlaceRecord poiRecord = (VillagePlaceRecord)short2ObjectMap.computeIfAbsent(s2, sx -> new VillagePlaceRecord(pos, poiType, this.d));
        this.a(poiRecord);
    }
}

