/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import co.aikar.timings.Timing;
import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.PoiAccess;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.misc.Delayed26WayDistancePropagator3D;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineGraphSection;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceSection;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionFileSection;

public class VillagePlace
extends RegionFileSection<VillagePlaceSection> {
    public static final int a = 6;
    public static final int b = 1;
    private final Delayed26WayDistancePropagator3D villageDistanceTracker = new Delayed26WayDistancePropagator3D();
    static final int POI_DATA_SOURCE = 7;
    private final LongSet e = new LongOpenHashSet();
    public final WorldServer world;
    private final TreeSet<QueuedUnload> queuedUnloads = new TreeSet();
    private final Long2ObjectOpenHashMap<QueuedUnload> queuedUnloadsByCoordinate = new Long2ObjectOpenHashMap();

    public static int convertBetweenLevels(int level) {
        return 7 - level;
    }

    protected void updateDistanceTracking(long section) {
        if (this.g(section)) {
            this.villageDistanceTracker.setSource(section, 7);
        } else {
            this.villageDistanceTracker.removeSource(section);
        }
    }

    public VillagePlace(Path path, DataFixer dataFixer, boolean dsync, LevelHeightAccessor world) {
        super(path, VillagePlaceSection::a, VillagePlaceSection::new, dataFixer, DataFixTypes.j, dsync, world);
        if (world == null) {
            throw new IllegalStateException("world must be non-null");
        }
        this.world = (WorldServer)world;
    }

    long determineDelay(long coordinate) {
        if (this.isEmpty(coordinate)) {
            return 6000L;
        }
        return 1200L;
    }

    public void queueUnload(long coordinate, long minTarget) {
        TickThread.softEnsureTickThread("async poi unload queue");
        QueuedUnload unload = new QueuedUnload(minTarget + this.determineDelay(coordinate), coordinate);
        QueuedUnload existing = (QueuedUnload)this.queuedUnloadsByCoordinate.put(coordinate, (Object)unload);
        if (existing != null) {
            this.queuedUnloads.remove(existing);
        }
        this.queuedUnloads.add(unload);
    }

    public void dequeueUnload(long coordinate) {
        TickThread.softEnsureTickThread("async poi unload dequeue");
        QueuedUnload unload = (QueuedUnload)this.queuedUnloadsByCoordinate.remove(coordinate);
        if (unload != null) {
            this.queuedUnloads.remove(unload);
        }
    }

    public void pollUnloads(BooleanSupplier canSleepForTick) {
        TickThread.softEnsureTickThread("async poi unload");
        long currentTick = MinecraftServer.currentTickLong;
        ChunkProviderServer chunkProvider = this.world.k();
        PlayerChunkMap playerChunkMap = chunkProvider.a;
        Iterator<QueuedUnload> iterator = this.queuedUnloads.iterator();
        for (int i2 = 0; iterator.hasNext() && (i2 < 200 || this.queuedUnloads.size() > 2000 || canSleepForTick.getAsBoolean()); ++i2) {
            QueuedUnload unload = iterator.next();
            if (unload.unloadTick > currentTick) break;
            long coordinate = unload.coordinate;
            iterator.remove();
            this.queuedUnloadsByCoordinate.remove(coordinate);
            if (playerChunkMap.getUnloadingChunkHolder(MCUtil.getCoordinateX(coordinate), MCUtil.getCoordinateZ(coordinate)) != null || playerChunkMap.a(coordinate) != null) continue;
            this.unloadData(coordinate);
        }
    }

    @Override
    public void unloadData(long coordinate) {
        TickThread.softEnsureTickThread("async unloading poi data");
        super.unloadData(coordinate);
    }

    @Override
    protected void onUnload(long coordinate) {
        TickThread.softEnsureTickThread("async poi unload callback");
        this.e.remove(coordinate);
        int chunkX = MCUtil.getCoordinateX(coordinate);
        int chunkZ = MCUtil.getCoordinateZ(coordinate);
        for (int section = this.c.ai(); section < this.c.aj(); ++section) {
            long sectionPos = SectionPosition.b(chunkX, section, chunkZ);
            this.updateDistanceTracking(sectionPos);
        }
    }

    public void a(BlockPosition pos, VillagePlaceType type) {
        ((VillagePlaceSection)this.f(SectionPosition.c(pos))).a(pos, type);
    }

    public void a(BlockPosition pos) {
        this.d(SectionPosition.c(pos)).ifPresent(poiSet -> poiSet.a(pos));
    }

    public long a(Predicate<VillagePlaceType> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        return this.c(typePredicate, pos, radius, occupationStatus).count();
    }

    public boolean a(VillagePlaceType type, BlockPosition pos) {
        return this.a(pos, type::equals);
    }

    public Stream<VillagePlaceRecord> b(Predicate<VillagePlaceType> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        int i2 = Math.floorDiv(radius, 16) + 1;
        return ChunkCoordIntPair.a(new ChunkCoordIntPair(pos), i2).flatMap(chunkPos -> this.a(typePredicate, (ChunkCoordIntPair)chunkPos, occupationStatus)).filter(poi -> {
            BlockPosition blockPos2 = poi.f();
            return Math.abs(blockPos2.u() - pos.u()) <= radius && Math.abs(blockPos2.w() - pos.w()) <= radius;
        });
    }

    public Stream<VillagePlaceRecord> c(Predicate<VillagePlaceType> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        int i2 = radius * radius;
        return this.b(typePredicate, pos, radius, occupationStatus).filter(poi -> poi.f().j(pos) <= (double)i2);
    }

    @VisibleForDebug
    public Stream<VillagePlaceRecord> a(Predicate<VillagePlaceType> typePredicate, ChunkCoordIntPair chunkPos, Occupancy occupationStatus) {
        return IntStream.range(this.c.ai(), this.c.aj()).boxed().map(integer -> this.d(SectionPosition.a(chunkPos, (int)integer).s())).filter(Optional::isPresent).flatMap(optional -> ((VillagePlaceSection)optional.get()).a(typePredicate, occupationStatus));
    }

    public Stream<BlockPosition> a(Predicate<VillagePlaceType> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        return this.c(typePredicate, pos, radius, occupationStatus).map(VillagePlaceRecord::f).filter(posPredicate);
    }

    public Stream<BlockPosition> b(Predicate<VillagePlaceType> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        return this.a(typePredicate, posPredicate, pos, radius, occupationStatus).sorted(Comparator.comparingDouble(blockPos2 -> blockPos2.j(pos)));
    }

    public Optional<BlockPosition> c(Predicate<VillagePlaceType> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        BlockPosition ret = PoiAccess.findAnyPoiPosition(this, typePredicate, posPredicate, pos, radius, occupationStatus, false);
        return Optional.ofNullable(ret);
    }

    public Optional<BlockPosition> d(Predicate<VillagePlaceType> typePredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        BlockPosition ret = PoiAccess.findClosestPoiDataPosition(this, typePredicate, null, pos, radius, radius * radius, occupationStatus, false);
        return Optional.ofNullable(ret);
    }

    public Optional<BlockPosition> d(Predicate<VillagePlaceType> typePredicate, Predicate<BlockPosition> posPredicate, BlockPosition pos, int radius, Occupancy occupationStatus) {
        BlockPosition ret = PoiAccess.findClosestPoiDataPosition(this, typePredicate, posPredicate, pos, radius, radius * radius, occupationStatus, false);
        return Optional.ofNullable(ret);
    }

    public Optional<BlockPosition> a(Predicate<VillagePlaceType> typePredicate, Predicate<BlockPosition> positionPredicate, BlockPosition pos, int radius) {
        VillagePlaceRecord ret = PoiAccess.findAnyPoiRecord(this, typePredicate, positionPredicate, pos, radius, Occupancy.a, false);
        if (ret == null) {
            return Optional.empty();
        }
        ret.b();
        return Optional.of(ret.f());
    }

    public Optional<BlockPosition> a(Predicate<VillagePlaceType> typePredicate, Predicate<BlockPosition> positionPredicate, Occupancy occupationStatus, BlockPosition pos, int radius, Random random) {
        ArrayList<VillagePlaceRecord> list = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findAnyPoiRecords(this, typePredicate, positionPredicate, pos, radius, occupationStatus, false, Integer.MAX_VALUE, list);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((VillagePlaceRecord)list.get(random.nextInt(list.size()))).f());
    }

    public boolean b(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).map(poiSet -> poiSet.c(pos)).orElseThrow(() -> SystemUtils.c(new IllegalStateException("POI never registered at " + pos)));
    }

    public boolean a(BlockPosition pos, Predicate<VillagePlaceType> predicate) {
        return this.d(SectionPosition.c(pos)).map(poiSet -> poiSet.a(pos, predicate)).orElse(false);
    }

    public Optional<VillagePlaceType> c(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).flatMap(poiSet -> poiSet.d(pos));
    }

    @Deprecated
    @VisibleForDebug
    public int d(BlockPosition pos) {
        return this.d(SectionPosition.c(pos)).map(poiSet -> poiSet.b(pos)).orElse(0);
    }

    public int a(SectionPosition pos) {
        this.villageDistanceTracker.propagateUpdates();
        return VillagePlace.convertBetweenLevels(this.villageDistanceTracker.getLevel(CoordinateUtils.getChunkSectionKey(pos)));
    }

    boolean g(long pos) {
        Optional optional = this.c(pos);
        return optional == null ? false : optional.map(poiSet -> poiSet.a(VillagePlaceType.b, Occupancy.b).count() > 0L).orElse(false);
    }

    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        while (!this.f.isEmpty() && shouldKeepTicking.getAsBoolean() && !this.world.r()) {
            NBTTagCompound data;
            ChunkCoordIntPair chunkcoordintpair = SectionPosition.a(this.f.firstLong()).r();
            try (Timing ignored1 = this.world.timings.poiSaveDataSerialization.startTiming();){
                data = this.getData(chunkcoordintpair);
            }
            PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.world, chunkcoordintpair.c, chunkcoordintpair.d, data, null, 3);
        }
        if (!this.world.r()) {
            this.pollUnloads(shouldKeepTicking);
        }
        this.villageDistanceTracker.propagateUpdates();
    }

    @Override
    protected void a(long pos) {
        super.a(pos);
        this.updateDistanceTracking(pos);
    }

    @Override
    protected void b(long pos) {
        this.updateDistanceTracking(pos);
    }

    public void a(ChunkCoordIntPair chunkPos, ChunkSection chunkSection) {
        SectionPosition sectionPos = SectionPosition.a(chunkPos, SectionPosition.a(chunkSection.g()));
        SystemUtils.a(this.d(sectionPos.s()), (T poiSet) -> poiSet.a((BiConsumer<BlockPosition, VillagePlaceType> biConsumer) -> {
            if (VillagePlace.a(chunkSection)) {
                this.a(chunkSection, sectionPos, (BiConsumer<BlockPosition, VillagePlaceType>)biConsumer);
            }
        }), () -> {
            if (VillagePlace.a(chunkSection)) {
                VillagePlaceSection poiSection = (VillagePlaceSection)this.f(sectionPos.s());
                this.a(chunkSection, sectionPos, poiSection::a);
            }
        });
    }

    private static boolean a(ChunkSection chunkSection) {
        return chunkSection.a(VillagePlaceType.y::contains);
    }

    private void a(ChunkSection chunkSection, SectionPosition sectionPos, BiConsumer<BlockPosition, VillagePlaceType> biConsumer) {
        sectionPos.t().forEach(pos -> {
            IBlockData blockState = chunkSection.a(SectionPosition.b(pos.u()), SectionPosition.b(pos.v()), SectionPosition.b(pos.w()));
            VillagePlaceType.b(blockState).ifPresent(poiType -> biConsumer.accept((BlockPosition)pos, (VillagePlaceType)poiType));
        });
    }

    public void a(IWorldReader world, BlockPosition pos, int radius) {
        SectionPosition.a(new ChunkCoordIntPair(pos), Math.floorDiv(radius, 16), this.c.ai(), this.c.aj()).map(sectionPos -> Pair.of((Object)sectionPos, this.d(sectionPos.s()))).filter(pair -> ((Optional)pair.getSecond()).map(VillagePlaceSection::a).orElse(false) == false).map(pair -> ((SectionPosition)pair.getFirst()).r()).filter(chunkPos -> this.e.add(chunkPos.a())).forEach(chunkPos -> world.a(chunkPos.c, chunkPos.d, ChunkStatus.c));
    }

    @Override
    @Nullable
    public NBTTagCompound a(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        if (this.world != null && Thread.currentThread() != PaperFileIOThread.Holder.INSTANCE) {
            NBTTagCompound ret = PaperFileIOThread.Holder.INSTANCE.loadChunkDataAsyncFuture((WorldServer)this.world, (int)chunkcoordintpair.c, (int)chunkcoordintpair.d, (int)IOUtil.getPriorityForCurrentThread(), (boolean)true, (boolean)false, (boolean)true).join().poiData;
            if (ret == PaperFileIOThread.FAILURE_VALUE) {
                throw new IOException("See logs for further detail");
            }
            return ret;
        }
        return super.a(chunkcoordintpair);
    }

    @Override
    public void a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) throws IOException {
        if (this.world != null && Thread.currentThread() != PaperFileIOThread.Holder.INSTANCE) {
            PaperFileIOThread.Holder.INSTANCE.scheduleSave(this.world, chunkcoordintpair.c, chunkcoordintpair.d, nbttagcompound, null, IOUtil.getPriorityForCurrentThread());
            return;
        }
        super.a(chunkcoordintpair, nbttagcompound);
    }

    static final class QueuedUnload
    implements Comparable<QueuedUnload> {
        private final long unloadTick;
        private final long coordinate;

        public QueuedUnload(long unloadTick, long coordinate) {
            this.unloadTick = unloadTick;
            this.coordinate = coordinate;
        }

        @Override
        public int compareTo(QueuedUnload other) {
            if (other.unloadTick == this.unloadTick) {
                return Long.compare(this.coordinate, other.coordinate);
            }
            return Long.compare(this.unloadTick, other.unloadTick);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + Long.hashCode(this.unloadTick);
            hash = hash * 31 + Long.hashCode(this.coordinate);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != QueuedUnload.class) {
                return false;
            }
            QueuedUnload other = (QueuedUnload)obj;
            return other.unloadTick == this.unloadTick && other.coordinate == this.coordinate;
        }
    }

    public static final class Occupancy
    extends Enum<Occupancy> {
        public static final /* enum */ Occupancy a = new Occupancy(VillagePlaceRecord::d);
        public static final /* enum */ Occupancy b = new Occupancy(VillagePlaceRecord::e);
        public static final /* enum */ Occupancy c = new Occupancy(poiRecord -> true);
        private final Predicate<? super VillagePlaceRecord> d;
        private static final /* synthetic */ Occupancy[] e;

        public static Occupancy[] values() {
            return (Occupancy[])e.clone();
        }

        public static Occupancy valueOf(String name) {
            return Enum.valueOf(Occupancy.class, name);
        }

        private Occupancy(Predicate<? super VillagePlaceRecord> predicate) {
            this.d = predicate;
        }

        public Predicate<? super VillagePlaceRecord> a() {
            return this.d;
        }

        private static /* synthetic */ Occupancy[] b() {
            return new Occupancy[]{a, b, c};
        }

        static {
            e = Occupancy.b();
        }
    }

    final class a
    extends LightEngineGraphSection {
        private final Long2ByteMap b;

        protected a() {
            super(7, 16, 256);
            this.b = new Long2ByteOpenHashMap();
            this.b.defaultReturnValue((byte)7);
        }

        @Override
        protected int b(long id) {
            return VillagePlace.this.g(id) ? 0 : 7;
        }

        @Override
        protected int c(long id) {
            return this.b.get(id);
        }

        @Override
        protected void a(long id, int level) {
            if (level > 6) {
                this.b.remove(id);
            } else {
                this.b.put(id, (byte)level);
            }
        }

        public void a() {
            super.b(Integer.MAX_VALUE);
        }
    }
}

