/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.targeting;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;

public class PathfinderTargetCondition {
    public static final PathfinderTargetCondition a = PathfinderTargetCondition.a();
    private static final double b = 2.0;
    private final boolean c;
    private double d = -1.0;
    private boolean e = true;
    private boolean f = true;
    @Nullable
    private Predicate<EntityLiving> g;
    private boolean useFollowRange = false;

    private PathfinderTargetCondition(boolean attackable) {
        this.c = attackable;
    }

    public static PathfinderTargetCondition a() {
        return new PathfinderTargetCondition(true);
    }

    public static PathfinderTargetCondition b() {
        return new PathfinderTargetCondition(false);
    }

    public PathfinderTargetCondition c() {
        PathfinderTargetCondition targetingConditions = this.c ? PathfinderTargetCondition.a() : PathfinderTargetCondition.b();
        targetingConditions.d = this.d;
        targetingConditions.e = this.e;
        targetingConditions.f = this.f;
        targetingConditions.g = this.g;
        return targetingConditions;
    }

    public PathfinderTargetCondition a(double baseMaxDistance) {
        this.d = baseMaxDistance;
        return this;
    }

    public PathfinderTargetCondition d() {
        this.e = false;
        return this;
    }

    public PathfinderTargetCondition e() {
        this.f = false;
        return this;
    }

    public PathfinderTargetCondition a(@Nullable Predicate<EntityLiving> predicate) {
        this.g = predicate;
        return this;
    }

    public boolean a(@Nullable EntityLiving baseEntity, EntityLiving targetEntity) {
        if (baseEntity == targetEntity) {
            return false;
        }
        if (!targetEntity.dU()) {
            return false;
        }
        if (this.g != null && !this.g.test(targetEntity)) {
            return false;
        }
        if (baseEntity == null) {
            if (this.c && (!targetEntity.dT() || targetEntity.s.af() == EnumDifficulty.a)) {
                return false;
            }
        } else {
            EntityInsentient mob;
            if (this.c && (!baseEntity.c(targetEntity) || !baseEntity.a(targetEntity.ad()) || baseEntity.p(targetEntity))) {
                return false;
            }
            if (this.d > 0.0) {
                double d2 = this.f ? targetEntity.y(baseEntity) : 1.0;
                double e2 = Math.max((this.useFollowRange ? this.getFollowRange(baseEntity) : this.d) * d2, 2.0);
                double f2 = baseEntity.h(targetEntity.dc(), targetEntity.de(), targetEntity.di());
                if (f2 > e2 * e2) {
                    return false;
                }
            }
            if (this.e && baseEntity instanceof EntityInsentient && !(mob = (EntityInsentient)baseEntity).E().a(targetEntity)) {
                return false;
            }
        }
        return true;
    }

    public PathfinderTargetCondition useFollowRange() {
        this.useFollowRange = true;
        return this;
    }

    private double getFollowRange(EntityLiving entityliving) {
        AttributeModifiable attributeinstance = entityliving.a(GenericAttributes.b);
        return attributeinstance == null ? 16.0 : attributeinstance.f();
    }
}

